/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring;

import com.intellij.openapi.project.Project;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.util.messages.MessageBusConnection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringEventListener;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\fH\u0014J\u0006\u0010\u000e\u001a\u00020\fJ\b\u0010\u000f\u001a\u00020\fH$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/CompositeRefactoringRunner;", "", "project", "Lcom/intellij/openapi/project/Project;", "refactoringId", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRefactoringId", "()Ljava/lang/String;", "onExit", "", "onRefactoringDone", "run", "runRefactoring", "idea"})
public abstract class CompositeRefactoringRunner {
    @NotNull
    private final Project project;
    @NotNull
    private final String refactoringId;

    protected abstract void runRefactoring();

    protected void onRefactoringDone() {
    }

    protected void onExit() {
    }

    public final void run() {
        MessageBusConnection connection = this.project.getMessageBus().connect();
        connection.subscribe(RefactoringEventListener.REFACTORING_EVENT_TOPIC, (Object)new RefactoringEventListener(this){
            final /* synthetic */ CompositeRefactoringRunner this$0;

            public void undoRefactoring(@NotNull String refactoringId) {
                Intrinsics.checkParameterIsNotNull((Object)refactoringId, (String)"refactoringId");
            }

            public void refactoringStarted(@NotNull String refactoringId, @Nullable RefactoringEventData beforeData) {
                Intrinsics.checkParameterIsNotNull((Object)refactoringId, (String)"refactoringId");
            }

            public void conflictsDetected(@NotNull String refactoringId, @NotNull RefactoringEventData conflictsData) {
                Intrinsics.checkParameterIsNotNull((Object)refactoringId, (String)"refactoringId");
                Intrinsics.checkParameterIsNotNull((Object)conflictsData, (String)"conflictsData");
            }

            public void refactoringDone(@NotNull String refactoringId, @Nullable RefactoringEventData afterData) {
                Intrinsics.checkParameterIsNotNull((Object)refactoringId, (String)"refactoringId");
                if (Intrinsics.areEqual((Object)refactoringId, (Object)this.this$0.getRefactoringId())) {
                    this.this$0.onRefactoringDone();
                }
            }
            {
                this.this$0 = $outer;
            }
        });
        connection.subscribe(KotlinRefactoringEventListener.Companion.getEVENT_TOPIC(), (Object)new KotlinRefactoringEventListener(this, connection){
            final /* synthetic */ CompositeRefactoringRunner this$0;
            final /* synthetic */ MessageBusConnection $connection;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onRefactoringExit(@NotNull String refactoringId) {
                Intrinsics.checkParameterIsNotNull((Object)refactoringId, (String)"refactoringId");
                if (Intrinsics.areEqual((Object)refactoringId, (Object)this.this$0.getRefactoringId())) {
                    try {
                        this.this$0.onExit();
                    }
                    finally {
                        this.$connection.disconnect();
                    }
                }
            }
            {
                this.this$0 = $outer;
                this.$connection = $captured_local_variable$1;
            }
        });
        this.runRefactoring();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final String getRefactoringId() {
        return this.refactoringId;
    }

    public CompositeRefactoringRunner(@NotNull Project project, @NotNull String refactoringId) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)refactoringId, (String)"refactoringId");
        this.project = project;
        this.refactoringId = refactoringId;
    }
}

