/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.move.DeferredKotlinMoveUsage;
import org.jetbrains.kotlin.idea.refactoring.move.QualifiableMoveRenameUsageInfo;
import org.jetbrains.kotlin.idea.refactoring.move.UnqualifiableMoveRenameUsageInfo;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u0004H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\u0004H\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\f\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/CallableReferenceMoveRenameUsageInfo;", "Lcom/intellij/refactoring/util/MoveRenameUsageInfo;", "Lorg/jetbrains/kotlin/idea/refactoring/move/DeferredKotlinMoveUsage;", "element", "Lcom/intellij/psi/PsiElement;", "reference", "Lcom/intellij/psi/PsiReference;", "referencedElement", "originalFile", "Lcom/intellij/psi/PsiFile;", "addImportToOriginalFile", "", "isInternal", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiReference;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiFile;ZZ)V", "getAddImportToOriginalFile", "()Z", "getOriginalFile", "()Lcom/intellij/psi/PsiFile;", "refresh", "Lcom/intellij/usageView/UsageInfo;", "refExpr", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "resolve", "newElement", "idea"})
public final class CallableReferenceMoveRenameUsageInfo
extends MoveRenameUsageInfo
implements DeferredKotlinMoveUsage {
    @NotNull
    private final PsiFile originalFile;
    private final boolean addImportToOriginalFile;
    private final boolean isInternal;

    @Override
    @Nullable
    public UsageInfo refresh(@NotNull KtSimpleNameExpression refExpr, @NotNull PsiElement referencedElement) {
        Intrinsics.checkParameterIsNotNull((Object)refExpr, (String)"refExpr");
        Intrinsics.checkParameterIsNotNull((Object)referencedElement, (String)"referencedElement");
        return (UsageInfo)new CallableReferenceMoveRenameUsageInfo((PsiElement)refExpr, (PsiReference)ReferenceUtilKt.getMainReference(refExpr), referencedElement, this.originalFile, this.addImportToOriginalFile, this.isInternal());
    }

    @Override
    @Nullable
    public UsageInfo resolve(@NotNull PsiElement newElement) {
        Intrinsics.checkParameterIsNotNull((Object)newElement, (String)"newElement");
        PsiElement target = LightClassUtilsKt.getUnwrapped(newElement);
        PsiElement psiElement2 = this.getElement();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement element3 = psiElement2;
        PsiReference psiReference = this.getReference();
        if (psiReference == null) {
            return null;
        }
        PsiReference reference2 = psiReference;
        PsiElement psiElement3 = this.getReferencedElement();
        if (psiElement3 == null) {
            return null;
        }
        PsiElement referencedElement = psiElement3;
        if (target != null && KtPsiUtilKt.isTopLevelKtOrJavaMember(target)) {
            PsiElement psiElement4 = element3;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"element");
            PsiElement $receiver$iv = psiElement4;
            KtExpression ktExpression = (KtCallableReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtCallableReferenceExpression.class, (boolean)true);
            if (ktExpression != null && (ktExpression = ktExpression.getReceiverExpression()) != null) {
                ktExpression.delete();
            }
            PsiReference psiReference2 = reference2;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiReference2, (String)"reference");
            PsiElement psiElement5 = referencedElement;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement5, (String)"referencedElement");
            PsiFile psiFile = element3.getContainingFile();
            if (psiFile == null) {
                Intrinsics.throwNpe();
            }
            return (UsageInfo)new UnqualifiableMoveRenameUsageInfo(element3, psiReference2, psiElement5, psiFile, this.addImportToOriginalFile, this.isInternal());
        }
        PsiElement psiElement6 = element3;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement6, (String)"element");
        PsiReference psiReference3 = reference2;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiReference3, (String)"reference");
        PsiElement psiElement7 = referencedElement;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement7, (String)"referencedElement");
        return (UsageInfo)new QualifiableMoveRenameUsageInfo(psiElement6, psiReference3, psiElement7, this.isInternal());
    }

    @NotNull
    public final PsiFile getOriginalFile() {
        return this.originalFile;
    }

    public final boolean getAddImportToOriginalFile() {
        return this.addImportToOriginalFile;
    }

    @Override
    public boolean isInternal() {
        return this.isInternal;
    }

    public CallableReferenceMoveRenameUsageInfo(@NotNull PsiElement element3, @NotNull PsiReference reference2, @NotNull PsiElement referencedElement, @NotNull PsiFile originalFile, boolean addImportToOriginalFile, boolean isInternal) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)reference2, (String)"reference");
        Intrinsics.checkParameterIsNotNull((Object)referencedElement, (String)"referencedElement");
        Intrinsics.checkParameterIsNotNull((Object)originalFile, (String)"originalFile");
        TextRange textRange = reference2.getRangeInElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"reference.rangeInElement");
        int n = textRange.getStartOffset();
        TextRange textRange2 = reference2.getRangeInElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"reference.rangeInElement");
        super(element3, reference2, n, textRange2.getEndOffset(), referencedElement, false);
        this.originalFile = originalFile;
        this.addImportToOriginalFile = addImportToOriginalFile;
        this.isInternal = isInternal;
    }
}

