/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.safeDelete;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.util.Query;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.RenderingUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\b\u001a\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u0006\u001a\n\u0010\u000f\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u0010\u001a\u00020\u0001*\u00020\u0006\u00a8\u0006\u0011"}, d2={"addParameter", "", "method", "Lcom/intellij/psi/PsiMethod;", "result", "", "Lcom/intellij/psi/PsiElement;", "parameter", "Lcom/intellij/psi/PsiParameter;", "checkParametersInMethodHierarchy", "", "collectParametersHierarchy", "", "canDeleteElement", "", "cleanUpOverrides", "removeOverrideModifier", "idea"})
public final class UtilsKt {
    public static final boolean canDeleteElement(@NotNull PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof KtObjectDeclaration && ((KtObjectDeclaration)$receiver).isObjectLiteral()) {
            return false;
        }
        if ($receiver instanceof KtParameter) {
            PsiElement psiElement2 = ((KtParameter)$receiver).getParent();
            if (!(psiElement2 instanceof KtParameterList)) {
                psiElement2 = null;
            }
            KtParameterList ktParameterList = (KtParameterList)psiElement2;
            if (ktParameterList == null) {
                return false;
            }
            KtParameterList parameterList = ktParameterList;
            PsiElement psiElement3 = parameterList.getParent();
            if (!(psiElement3 instanceof KtDeclaration)) {
                psiElement3 = null;
            }
            KtDeclaration ktDeclaration = (KtDeclaration)psiElement3;
            if (ktDeclaration == null) {
                return false;
            }
            KtDeclaration declaration2 = ktDeclaration;
            return !(declaration2 instanceof KtPropertyAccessor);
        }
        return $receiver instanceof KtClassOrObject || $receiver instanceof KtSecondaryConstructor || $receiver instanceof KtNamedFunction || $receiver instanceof PsiMethod || $receiver instanceof PsiClass || $receiver instanceof KtProperty || $receiver instanceof KtTypeParameter || $receiver instanceof KtTypeAlias;
    }

    public static final void removeOverrideModifier(@NotNull PsiElement $receiver) {
        block4: {
            PsiAnnotation psiAnnotation;
            block2: {
                PsiElement psiElement2;
                block3: {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    psiElement2 = $receiver;
                    if (!(psiElement2 instanceof KtNamedFunction) && !(psiElement2 instanceof KtProperty)) break block3;
                    KtModifierList ktModifierList = ((KtModifierListOwner)$receiver).getModifierList();
                    if (ktModifierList == null || (ktModifierList = ktModifierList.getModifier(KtTokens.OVERRIDE_KEYWORD)) == null) break block4;
                    ktModifierList.delete();
                    break block4;
                }
                if (!(psiElement2 instanceof PsiMethod)) break block4;
                PsiModifierList psiModifierList = ((PsiMethod)$receiver).getModifierList();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiModifierList, (String)"modifierList");
                PsiAnnotation[] psiAnnotationArray = psiModifierList.getAnnotations();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotationArray, (String)"modifierList.annotations");
                PsiAnnotation[] $receiver$iv = psiAnnotationArray;
                int n = $receiver$iv.length;
                for (int i = 0; i < n; ++i) {
                    PsiAnnotation element$iv;
                    PsiAnnotation annotation2;
                    PsiAnnotation psiAnnotation2 = annotation2 = (element$iv = $receiver$iv[i]);
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiAnnotation2, (String)"annotation");
                    if (!Intrinsics.areEqual((Object)psiAnnotation2.getQualifiedName(), (Object)"java.lang.Override")) continue;
                    psiAnnotation = element$iv;
                    break block2;
                }
                psiAnnotation = null;
            }
            if (psiAnnotation != null) {
                psiAnnotation.delete();
            }
        }
    }

    public static final void cleanUpOverrides(@NotNull PsiMethod $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Object[] superMethods = $receiver.findSuperMethods(true);
        for (PsiMethod overridingMethod : OverridingMethodsSearch.search((PsiMethod)$receiver, (boolean)true).findAll()) {
            boolean bl;
            block2: {
                Sequence currentSuperMethods;
                Object[] objectArray = overridingMethod.findSuperMethods(true);
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"overridingMethod.findSuperMethods(true)");
                Sequence sequence2 = ArraysKt.asSequence((Object[])objectArray);
                Intrinsics.checkExpressionValueIsNotNull((Object)superMethods, (String)"superMethods");
                Sequence $receiver$iv = currentSuperMethods = SequencesKt.plus((Sequence)sequence2, (Sequence)ArraysKt.asSequence((Object[])superMethods));
                for (Object element$iv : $receiver$iv) {
                    PsiMethod superMethod;
                    PsiMethod psiMethod = superMethod = (PsiMethod)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"superMethod");
                    if (Intrinsics.areEqual((Object)LightClassUtilsKt.getUnwrapped((PsiElement)psiMethod), (Object)LightClassUtilsKt.getUnwrapped((PsiElement)$receiver))) continue;
                    bl = false;
                    break block2;
                }
                bl = true;
            }
            if (!bl) continue;
            PsiMethod psiMethod = overridingMethod;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"overridingMethod");
            PsiElement psiElement2 = LightClassUtilsKt.getUnwrapped((PsiElement)psiMethod);
            if (psiElement2 == null) continue;
            UtilsKt.removeOverrideModifier(psiElement2);
        }
    }

    @Nullable
    public static final Collection<PsiElement> checkParametersInMethodHierarchy(@NotNull PsiParameter parameter) {
        Set<PsiElement> parametersToDelete;
        PsiMethod method;
        block5: {
            block4: {
                Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
                PsiElement psiElement2 = parameter.getDeclarationScope();
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiMethod");
                }
                method = (PsiMethod)psiElement2;
                parametersToDelete = UtilsKt.collectParametersHierarchy(method, parameter);
                if (parametersToDelete.size() <= 1) break block4;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (!application.isUnitTestMode()) break block5;
            }
            return parametersToDelete;
        }
        String message2 = KotlinBundle.message("delete.param.in.method.hierarchy", RenderingUtilsKt.formatJavaOrLightMethod(method));
        int exitCode = Messages.showOkCancelDialog((Project)parameter.getProject(), (String)message2, (String)IdeBundle.message((String)"title.warning", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        return exitCode == 0 ? (Collection)parametersToDelete : null;
    }

    private static final Set<PsiElement> collectParametersHierarchy(PsiMethod method, PsiParameter parameter) {
        ArrayDeque<PsiMethod> queue = new ArrayDeque<PsiMethod>();
        HashSet visited2 = new HashSet();
        HashSet parametersToDelete = new HashSet();
        queue.add(method);
        while (!queue.isEmpty()) {
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            PsiMethod currentMethod = (PsiMethod)queue.poll();
            PsiMethod[] psiMethodArray = (PsiMethod[])visited2;
            psiMethodArray.add(currentMethod);
            PsiMethod psiMethod = currentMethod;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethod, (String)"currentMethod");
            UtilsKt.addParameter(psiMethod, parametersToDelete, parameter);
            PsiMethod[] psiMethodArray2 = currentMethod.findSuperMethods(true);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiMethodArray2, (String)"currentMethod.findSuperMethods(true)");
            psiMethodArray = psiMethodArray2;
            Iterator iterator2 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (void element$iv$iv : $receiver$iv$iv) {
                void it = element$iv$iv;
                if (!(!visited2.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                PsiMethod it = (PsiMethod)element$iv;
                queue.offer(it);
            }
            Query query = OverridingMethodsSearch.search((PsiMethod)currentMethod);
            Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"OverridingMethodsSearch.search(currentMethod)");
            $receiver$iv = (Iterable)query;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            PsiMethod it = $receiver$iv$iv.iterator();
            while (it.hasNext()) {
                Object element$iv$iv = it.next();
                PsiMethod it2 = (PsiMethod)element$iv$iv;
                if (!(!visited2.contains(it2))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                it = (PsiMethod)element$iv;
                queue.offer(it);
            }
        }
        return parametersToDelete;
    }

    private static final void addParameter(PsiMethod method, Set<PsiElement> result2, PsiParameter parameter) {
        PsiElement psiElement2 = LightClassUtilsKt.getUnwrapped((PsiElement)parameter);
        if (psiElement2 == null) {
            Intrinsics.throwNpe();
        }
        int parameterIndex2 = KtPsiUtilKt.parameterIndex(psiElement2);
        if (method instanceof KtLightMethod) {
            KtDeclaration declaration2 = (KtDeclaration)((KtLightMethod)method).getKotlinOrigin();
            if (declaration2 instanceof KtFunction) {
                KtParameter ktParameter = ((KtFunction)declaration2).getValueParameters().get(parameterIndex2);
                Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"declaration.valueParameters[parameterIndex]");
                result2.add(ktParameter);
            }
        } else {
            PsiParameterList psiParameterList = method.getParameterList();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiParameterList, (String)"method.parameterList");
            PsiParameter psiParameter = psiParameterList.getParameters()[parameterIndex2];
            Intrinsics.checkExpressionValueIsNotNull((Object)psiParameter, (String)"method.parameterList.parameters[parameterIndex]");
            result2.add((PsiElement)psiParameter);
        }
    }
}

