/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.references;

import com.google.common.collect.ImmutableSet;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.intentions.OperatorToFunctionIntention;
import org.jetbrains.kotlin.idea.kdoc.KDocReference;
import org.jetbrains.kotlin.idea.references.AbstractKtReference;
import org.jetbrains.kotlin.idea.references.KtDestructuringDeclarationReference;
import org.jetbrains.kotlin.idea.references.KtInvokeFunctionReference;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.references.ReferenceAccess;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.util.CallTypeAndReceiver;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocName;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtLabelReferenceExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000z\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\u001a\n\u0010\u0013\u001a\u00020\u0014*\u00020\n\u001a\u0012\u0010\u0015\u001a\u00020\u0014*\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u000f\u001a\u001a\u0010\u0017\u001a\u00020\u0014*\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b\u001a\f\u0010\u001c\u001a\u0004\u0018\u00010\u000b*\u00020\u001d\u001a\u0014\u0010\u001e\u001a\u00020\u0014*\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000fH\u0002\u001a\u0012\u0010 \u001a\u00020\u0014*\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u000f\u001a\u0012\u0010!\u001a\u00020\"*\u00020#2\u0006\u0010$\u001a\u00020\u0014\u001a\u001e\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0&*\u00020#2\u0006\u0010$\u001a\u00020\u0014\u001a\u001c\u0010'\u001a\u00020#*\n\u0012\u0006\b\u0001\u0012\u00020#0(2\b\u0010)\u001a\u0004\u0018\u00010*\u001a\u0010\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00190,*\u00020\u0006\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0007\"\u0015\u0010\u0000\u001a\u00020\u0005*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\t\"\u0015\u0010\u0000\u001a\u00020\n*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\f\"\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006-"}, d2={"mainReference", "Lorg/jetbrains/kotlin/idea/kdoc/KDocReference;", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocName;", "getMainReference", "(Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocName;)Lorg/jetbrains/kotlin/idea/kdoc/KDocReference;", "Lorg/jetbrains/kotlin/idea/references/KtReference;", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/psi/KtElement;)Lorg/jetbrains/kotlin/idea/references/KtReference;", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "(Lorg/jetbrains/kotlin/psi/KtReferenceExpression;)Lorg/jetbrains/kotlin/idea/references/KtReference;", "Lorg/jetbrains/kotlin/idea/references/KtSimpleNameReference;", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;)Lorg/jetbrains/kotlin/idea/references/KtSimpleNameReference;", "unwrappedTargets", "", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/psi/PsiReference;", "getUnwrappedTargets", "(Lcom/intellij/psi/PsiReference;)Ljava/util/Set;", "canBePsiMethodReference", "", "canBeReferenceTo", "candidateTarget", "canBeResolvedViaImport", "target", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getCalleeByLambdaArgument", "Lorg/jetbrains/kotlin/psi/KtFunction;", "isConstructorOf", "unwrappedCandidate", "matchesTarget", "readWriteAccess", "Lorg/jetbrains/kotlin/idea/references/ReferenceAccess;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "useResolveForReadWrite", "readWriteAccessWithFullExpression", "Lkotlin/Pair;", "renameImplicitConventionalCall", "Lorg/jetbrains/kotlin/idea/references/AbstractKtReference;", "newName", "", "resolveMainReferenceToDescriptors", "", "idea-core"})
public final class ReferenceUtilKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<PsiElement> getUnwrappedTargets(@NotNull PsiReference $receiver) {
        Set set2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        unwrappedTargets.1 adjust$ = unwrappedTargets.1.INSTANCE;
        PsiReference psiReference = $receiver;
        if (psiReference instanceof PsiPolyVariantReference) {
            void $receiver$iv;
            ResolveResult[] resolveResultArray = ((PsiPolyVariantReference)$receiver).multiResolve(false);
            Intrinsics.checkExpressionValueIsNotNull((Object)resolveResultArray, (String)"multiResolve(false)");
            ResolveResult[] resolveResultArray2 = resolveResultArray;
            Collection destination$iv = new HashSet();
            void $receiver$iv$iv = $receiver$iv;
            int n = ((void)$receiver$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                PsiElement psiElement2;
                void element$iv$iv;
                void element$iv;
                void it;
                void v1 = it = (element$iv = (element$iv$iv = $receiver$iv$iv[i]));
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                PsiElement psiElement3 = v1.getElement();
                PsiElement psiElement4 = psiElement3 != null ? unwrappedTargets.1.INSTANCE.invoke(psiElement3) : null;
                if (psiElement4 == null) continue;
                PsiElement it$iv = psiElement2 = psiElement4;
                destination$iv.add(it$iv);
            }
            set2 = (Set)destination$iv;
        } else {
            PsiElement psiElement5 = $receiver.resolve();
            set2 = CollectionsKt.toSet((Iterable)CollectionsKt.listOfNotNull((Object)(psiElement5 != null ? adjust$.invoke(psiElement5) : null)));
        }
        return set2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean canBeReferenceTo(@NotNull PsiReference $receiver, @NotNull PsiElement candidateTarget) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)candidateTarget, (String)"candidateTarget");
        PsiElement psiElement2 = $receiver.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element");
        if (Intrinsics.areEqual((Object)psiElement2.getContainingFile(), (Object)candidateTarget.getContainingFile())) return true;
        PsiElement psiElement3 = $receiver.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"element");
        if (ProjectRootsUtil.isInProjectOrLibSource(psiElement3)) return true;
        PsiElement psiElement4 = $receiver.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"element");
        PsiFile psiFile = psiElement4.getContainingFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"element.containingFile");
        if (!ScratchUtil.isScratch((VirtualFile)psiFile.getVirtualFile())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean matchesTarget(@NotNull PsiReference $receiver, @NotNull PsiElement candidateTarget) {
        boolean bl;
        boolean bl2;
        PsiElement it;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)candidateTarget, (String)"candidateTarget");
        if (!ReferenceUtilKt.canBeReferenceTo($receiver, candidateTarget)) {
            return false;
        }
        PsiElement psiElement3 = LightClassUtilsKt.getUnwrapped(candidateTarget);
        psiElement3 = psiElement3;
        if (psiElement2 == null) return false;
        PsiElement psiElement3 = psiElement3.getOriginalElement();
        psiElement3 = psiElement3;
        if (psiElement4 == null) return false;
        PsiElement unwrappedCandidate = psiElement3;
        PsiReference psiReference = $receiver;
        if (psiReference instanceof KtInvokeFunctionReference) {
            if (!(candidateTarget instanceof KtNamedFunction) && !(candidateTarget instanceof PsiMethod)) {
                return false;
            }
            if (Intrinsics.areEqual((Object)((PsiNamedElement)candidateTarget).getName(), (Object)OperatorNameConventions.INVOKE.asString()) ^ true) {
                return false;
            }
        } else if (psiReference instanceof KtDestructuringDeclarationReference ? !(candidateTarget instanceof KtNamedFunction) && !(candidateTarget instanceof KtParameter) && !(candidateTarget instanceof PsiMethod) : psiReference instanceof KtSimpleNameReference && unwrappedCandidate instanceof PsiMethod && !ReferenceUtilKt.canBePsiMethodReference((KtSimpleNameReference)$receiver)) {
            return false;
        }
        PsiElement element3 = $receiver.getElement();
        if (candidateTarget instanceof KtImportAlias && element3 instanceof KtSimpleNameExpression && Intrinsics.areEqual((Object)((KtSimpleNameExpression)element3).getReferencedName(), (Object)((KtImportAlias)candidateTarget).getName())) {
            DeclarationDescriptor declarationDescriptor;
            Object object;
            Iterable iterable;
            Iterator $receiver$iv$iv;
            Iterable $receiver$iv2;
            KtImportDirective ktImportDirective = ((KtImportAlias)candidateTarget).getImportDirective();
            if (ktImportDirective == null) return false;
            KtImportDirective ktImportDirective2 = ktImportDirective;
            FqName fqName2 = ktImportDirective2.getImportedFqName();
            if (fqName2 == null) return false;
            FqName importedFqName = fqName2;
            KtFile ktFile = ktImportDirective2.getContainingKtFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"importDirective.containingKtFile");
            FqName fqName3 = importedFqName;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName3, (String)"importedFqName");
            Collection<DeclarationDescriptor> importedDescriptors = ResolutionUtils.resolveImportReference(ktFile, fqName3);
            Iterable iterable2 = $receiver$iv2 = (Iterable)ReferenceUtilKt.getUnwrappedTargets($receiver);
            Collection collection = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                PsiElement psiElement5;
                Object element$iv$iv = element$iv$iv$iv;
                PsiElement it2 = (PsiElement)element$iv$iv;
                PsiElement psiElement6 = it2 instanceof KtConstructor ? (PsiElement)KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)it2) : it2;
                if (psiElement6 == null) continue;
                PsiElement it$iv$iv = psiElement5 = psiElement6;
                collection.add(it$iv$iv);
            }
            List importableTargets = (List)collection;
            $receiver$iv2 = importedDescriptors;
            if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                return false;
            }
            $receiver$iv$iv = $receiver$iv2.iterator();
            do {
                if (!$receiver$iv$iv.hasNext()) return false;
                Object t = $receiver$iv$iv.next();
                DeclarationDescriptor it3 = (DeclarationDescriptor)t;
                iterable = importableTargets;
                declarationDescriptor = it3;
                if (declarationDescriptor instanceof DeclarationDescriptorWithSource) continue;
                declarationDescriptor = null;
            } while (!CollectionsKt.contains((Iterable)iterable, (object = (DeclarationDescriptorWithSource)declarationDescriptor) != null && (object = object.getSource()) != null ? KotlinSourceElementKt.getPsi((SourceElement)object) : null));
            return true;
        }
        if (element3 instanceof KtLabelReferenceExpression) {
            PsiElement psiElement7 = ((KtLabelReferenceExpression)element3).getParent();
            if (!(psiElement7 instanceof KtContainerNode)) {
                psiElement7 = null;
            }
            KtContainerNode ktContainerNode = (KtContainerNode)psiElement7;
            Object object = ktContainerNode != null ? ktContainerNode.getParent() : null;
            PsiElement importedFqName = object;
            if (importedFqName instanceof KtReturnExpression) {
                $receiver$iv = ReferenceUtilKt.getUnwrappedTargets($receiver);
                for (Object element$iv : $receiver$iv) {
                    CharSequence charSequence;
                    it = (PsiElement)element$iv;
                    if (!(it instanceof KtFunctionLiteral) && (!(it instanceof KtNamedFunction) || !((charSequence = (CharSequence)((KtNamedFunction)it).getName()) == null || charSequence.length() == 0))) continue;
                    KtFunction cfr_ignored_0 = (KtFunction)it;
                    KtLabeledExpression ktLabeledExpression = KtPsiUtilKt.getLabeledParent((KtExpression)it, ((KtLabelReferenceExpression)element3).getReferencedName());
                    if (ktLabeledExpression != null) {
                        if (!Intrinsics.areEqual((Object)candidateTarget, (Object)ktLabeledExpression)) continue;
                        return true;
                    }
                    Object object2 = ReferenceUtilKt.getCalleeByLambdaArgument((KtFunction)it);
                    if (object2 == null || (object2 = ReferenceUtilKt.getMainReference((KtSimpleNameExpression)object2)) == null) {
                        continue;
                    }
                    Object calleeReference = object2;
                    if (!ReferenceUtilKt.matchesTarget((PsiReference)calleeReference, candidateTarget)) continue;
                    return true;
                }
            } else if (importedFqName instanceof KtBreakExpression || importedFqName instanceof KtContinueExpression) {
                $receiver$iv = ReferenceUtilKt.getUnwrappedTargets($receiver);
                for (Object element$iv : $receiver$iv) {
                    KtExpression ktExpression;
                    it = (PsiElement)element$iv;
                    PsiElement psiElement8 = it;
                    if (!(psiElement8 instanceof KtExpression)) {
                        psiElement8 = null;
                    }
                    if ((ktExpression = (KtExpression)psiElement8) == null || (ktExpression = KtPsiUtilKt.getLabeledParent(ktExpression, ((KtLabelReferenceExpression)element3).getReferencedName())) == null) {
                        continue;
                    }
                    KtExpression ktExpression2 = ktExpression;
                    if (!Intrinsics.areEqual((Object)candidateTarget, (Object)ktExpression2)) continue;
                    return true;
                }
            }
        }
        Set<PsiElement> set2 = ReferenceUtilKt.getUnwrappedTargets($receiver);
        PsiManager manager = candidateTarget.getManager();
        $receiver$iv = set2;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            bl2 = false;
        } else {
            for (Object element$iv : $receiver$iv) {
                it = (PsiElement)element$iv;
                if (!manager.areElementsEquivalent(unwrappedCandidate, it)) continue;
                return true;
            }
            bl2 = false;
        }
        if (bl2) {
            return true;
        }
        if ($receiver instanceof KtReference) {
            boolean bl3;
            $receiver$iv = set2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                return false;
            }
            Iterator importableTargets = $receiver$iv.iterator();
            do {
                PsiElement psiElement9;
                Object element$iv;
                if (!importableTargets.hasNext()) return false;
                element$iv = importableTargets.next();
                it = (PsiElement)element$iv;
                if (ReferenceUtilKt.isConstructorOf(it, unwrappedCandidate)) return true;
                if (it instanceof KtObjectDeclaration && ((KtObjectDeclaration)it).isCompanion() && Intrinsics.areEqual((Object)((KtClass)PsiTreeUtil.getParentOfType((PsiElement)(psiElement9 = it), KtClass.class, (boolean)false)), (Object)unwrappedCandidate)) {
                    return true;
                }
                bl3 = false;
            } while (!bl3);
            return true;
        }
        if ($receiver instanceof PsiJavaCodeReferenceElement && unwrappedCandidate instanceof KtConstructor) {
            PsiNewExpression psiNewExpression;
            PsiElement psiElement10;
            PsiElement psiElement11 = $receiver.getElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement11, (String)"getElement()");
            PsiElement parent2 = psiElement11.getParent();
            if (parent2 instanceof PsiAnonymousClass) {
                parent2 = parent2.getParent();
            }
            if (!((psiElement10 = parent2) instanceof PsiNewExpression)) {
                psiElement10 = null;
            }
            if (Intrinsics.areEqual((psiNewExpression = (PsiNewExpression)psiElement10) != null && (psiNewExpression = psiNewExpression.resolveConstructor()) != null ? LightClassUtilsKt.getUnwrapped((PsiElement)psiNewExpression) : null, (Object)unwrappedCandidate)) {
                return true;
            }
        }
        if (!($receiver instanceof PsiJavaCodeReferenceElement)) return false;
        if (!(candidateTarget instanceof KtObjectDeclaration)) return false;
        if (ReferenceUtilKt.getUnwrappedTargets($receiver).size() != 1) return false;
        PsiElement referredClass = (PsiElement)CollectionsKt.first((Iterable)ReferenceUtilKt.getUnwrappedTargets($receiver));
        if (!(referredClass instanceof KtClass)) return false;
        if (!((KtClass)referredClass).getCompanionObjects().contains(candidateTarget)) return false;
        if (((PsiJavaCodeReferenceElement)$receiver).getParent() instanceof PsiImportStaticStatement) {
            return true;
        }
        PsiElement psiElement12 = ((PsiJavaCodeReferenceElement)$receiver).getParent();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement12, (String)"parent");
        PsiReference psiReference2 = psiElement12.getReference();
        Object object = psiReference2;
        if (psiReference2 == null) return false;
        Set<PsiElement> set3 = ReferenceUtilKt.getUnwrappedTargets(object);
        object = set3;
        if (set3 == null) return false;
        Iterable $receiver$iv3 = (Iterable)object;
        if ($receiver$iv3 instanceof Collection && ((Collection)$receiver$iv3).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $receiver$iv3.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            PsiElement psiElement13 = (PsiElement)element$iv;
            if (psiElement13 instanceof KtProperty || psiElement13 instanceof KtNamedFunction) {
                PsiElement psiElement14 = psiElement13.getParent();
                if (Intrinsics.areEqual((Object)(psiElement14 != null ? psiElement14.getParent() : null), (Object)candidateTarget)) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean canBePsiMethodReference(@NotNull KtSimpleNameReference $receiver) {
        PsiElement $receiver$iv;
        void $receiver$iv2;
        void $receiver$iv3;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)$receiver.getElement();
        KtSimpleNameExpression ktSimpleNameExpression2 = (KtSimpleNameExpression)$receiver.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression2, (String)"element");
        PsiElement psiElement2 = ktSimpleNameExpression2.getParent();
        if (!(psiElement2 instanceof KtCallExpression)) {
            psiElement2 = null;
        }
        KtCallExpression ktCallExpression = (KtCallExpression)psiElement2;
        if (Intrinsics.areEqual((Object)ktSimpleNameExpression, (Object)(ktCallExpression != null ? ktCallExpression.getCalleeExpression() : null))) {
            return true;
        }
        KtSimpleNameExpression ktSimpleNameExpression3 = (KtSimpleNameExpression)$receiver.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression3, (String)"element");
        PsiElement psiElement3 = (PsiElement)ktSimpleNameExpression3;
        Function1 branch$iv = canBePsiMethodReference.callableReference.1.INSTANCE;
        boolean strict$iv22 = false;
        void $receiver$iv$iv = $receiver$iv3;
        PsiElement psiElement4 = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv$iv, KtCallableReferenceExpression.class, (boolean)strict$iv22);
        KtCallableReferenceExpression callableReference2 = (KtCallableReferenceExpression)(psiElement4 != null ? PsiUtilsKt.getIfChildIsInBranch(psiElement4, (PsiElement)$receiver$iv3, branch$iv) : null);
        if (callableReference2 != null) {
            return true;
        }
        KtSimpleNameExpression ktSimpleNameExpression4 = (KtSimpleNameExpression)$receiver.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression4, (String)"element");
        PsiElement strict$iv22 = (PsiElement)ktSimpleNameExpression4;
        Function1 branch$iv2 = canBePsiMethodReference.binaryOperator.1.INSTANCE;
        boolean strict$iv32 = false;
        void $receiver$iv$iv2 = $receiver$iv2;
        PsiElement psiElement5 = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv$iv2, KtBinaryExpression.class, (boolean)strict$iv32);
        KtBinaryExpression binaryOperator2 = (KtBinaryExpression)(psiElement5 != null ? PsiUtilsKt.getIfChildIsInBranch(psiElement5, (PsiElement)$receiver$iv2, branch$iv2) : null);
        if (binaryOperator2 != null) {
            return true;
        }
        KtSimpleNameExpression ktSimpleNameExpression5 = (KtSimpleNameExpression)$receiver.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression5, (String)"element");
        PsiElement strict$iv32 = (PsiElement)ktSimpleNameExpression5;
        Function1 branch$iv3 = canBePsiMethodReference.unaryOperator.1.INSTANCE;
        boolean strict$iv = false;
        void $receiver$iv$iv3 = $receiver$iv;
        PsiElement psiElement6 = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv$iv3, KtUnaryExpression.class, (boolean)strict$iv);
        KtUnaryExpression unaryOperator2 = (KtUnaryExpression)(psiElement6 != null ? PsiUtilsKt.getIfChildIsInBranch(psiElement6, $receiver$iv, branch$iv3) : null);
        if (unaryOperator2 != null) {
            return true;
        }
        KtSimpleNameExpression ktSimpleNameExpression6 = (KtSimpleNameExpression)$receiver.getElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression6, (String)"element");
        $receiver$iv = (PsiElement)ktSimpleNameExpression6;
        return PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtImportDirective.class, (boolean)false) != null;
    }

    private static final boolean isConstructorOf(@NotNull PsiElement $receiver, PsiElement unwrappedCandidate) {
        return $receiver instanceof PsiMethod && ((PsiMethod)$receiver).isConstructor() && Intrinsics.areEqual((Object)((PsiMethod)$receiver).getContainingClass(), (Object)unwrappedCandidate) || $receiver instanceof KtConstructor && Intrinsics.areEqual((Object)((KtConstructor)$receiver).getContainingClassOrObject(), (Object)unwrappedCandidate);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KtExpression renameImplicitConventionalCall(@NotNull AbstractKtReference<? extends KtExpression> $receiver, @Nullable String newName2) {
        void newExpression2;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if (newName2 == null) {
            return $receiver.getExpression();
        }
        Pair<KtExpression, KtSimpleNameExpression> pair2 = OperatorToFunctionIntention.Companion.convert($receiver.getExpression());
        KtExpression ktExpression = (KtExpression)pair2.component1();
        KtSimpleNameExpression newNameElement = (KtSimpleNameExpression)pair2.component2();
        ReferenceUtilKt.getMainReference(newNameElement).handleElementRename(newName2);
        return newExpression2;
    }

    @NotNull
    public static final KtSimpleNameReference getMainReference(@NotNull KtSimpleNameExpression $receiver) {
        PsiReference element$iv2;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            PsiReference[] psiReferenceArray = $receiver.getReferences();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceArray, (String)"references");
            for (PsiReference element$iv2 : psiReferenceArray) {
                if (!(element$iv2 instanceof KtSimpleNameReference)) {
                    continue;
                }
                break block2;
            }
            throw (Throwable)new NoSuchElementException("No element of given type found");
        }
        return (KtSimpleNameReference)element$iv2;
    }

    @NotNull
    public static final KtReference getMainReference(@NotNull KtReferenceExpression $receiver) {
        KtReference ktReference;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof KtSimpleNameExpression) {
            ktReference = ReferenceUtilKt.getMainReference((KtSimpleNameExpression)$receiver);
        } else {
            PsiReference element$iv2;
            block4: {
                PsiReference[] psiReferenceArray = $receiver.getReferences();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceArray, (String)"references");
                for (PsiReference element$iv2 : psiReferenceArray) {
                    if (!(element$iv2 instanceof KtReference)) {
                        continue;
                    }
                    break block4;
                }
                throw (Throwable)new NoSuchElementException("No element of given type found");
            }
            ktReference = (KtReference)element$iv2;
        }
        return ktReference;
    }

    @NotNull
    public static final KDocReference getMainReference(@NotNull KDocName $receiver) {
        PsiReference element$iv2;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            PsiReference[] psiReferenceArray = $receiver.getReferences();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceArray, (String)"references");
            for (PsiReference element$iv2 : psiReferenceArray) {
                if (!(element$iv2 instanceof KDocReference)) {
                    continue;
                }
                break block2;
            }
            throw (Throwable)new NoSuchElementException("No element of given type found");
        }
        return (KDocReference)element$iv2;
    }

    @Nullable
    public static final KtReference getMainReference(@NotNull KtElement $receiver) {
        KtReference ktReference;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof KtReferenceExpression) {
            ktReference = ReferenceUtilKt.getMainReference((KtReferenceExpression)$receiver);
        } else if ($receiver instanceof KDocName) {
            ktReference = ReferenceUtilKt.getMainReference((KDocName)$receiver);
        } else {
            PsiReference psiReference;
            block5: {
                PsiReference[] psiReferenceArray = $receiver.getReferences();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceArray, (String)"references");
                for (PsiReference element$iv : psiReferenceArray) {
                    if (!(element$iv instanceof KtReference)) continue;
                    psiReference = element$iv;
                    break block5;
                }
                psiReference = null;
            }
            ktReference = (KtReference)psiReference;
        }
        return ktReference;
    }

    @NotNull
    public static final Collection<DeclarationDescriptor> resolveMainReferenceToDescriptors(@NotNull KtElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        BindingContext bindingContext2 = ResolutionUtils.analyze($receiver, BodyResolveMode.PARTIAL);
        Object object = ReferenceUtilKt.getMainReference($receiver);
        if (object == null || (object = object.resolveToDescriptors(bindingContext2)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public static final ReferenceAccess readWriteAccess(@NotNull KtExpression $receiver, boolean useResolveForReadWrite) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return (ReferenceAccess)((Object)ReferenceUtilKt.readWriteAccessWithFullExpression($receiver, useResolveForReadWrite).getFirst());
    }

    @NotNull
    public static final Pair<ReferenceAccess, KtExpression> readWriteAccessWithFullExpression(@NotNull KtExpression $receiver, boolean useResolveForReadWrite) {
        KtUnaryExpression unaryExpression;
        PsiElement parent2;
        PsiElement psiElement2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtExpression expression2 = KtPsiUtilKt.getQualifiedExpressionForSelectorOrThis($receiver);
        while ((psiElement2 = (parent2 = expression2.getParent())) instanceof KtParenthesizedExpression || psiElement2 instanceof KtAnnotatedExpression || psiElement2 instanceof KtLabeledExpression) {
            PsiElement psiElement3 = parent2;
            if (psiElement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            expression2 = (KtExpression)psiElement3;
        }
        KtBinaryExpression assignment = KtPsiUtilKt.getAssignmentByLHS(expression2);
        if (assignment != null) {
            psiElement2 = assignment.getOperationToken();
            if (Intrinsics.areEqual((Object)psiElement2, (Object)((Object)KtTokens.EQ))) {
                return TuplesKt.to((Object)((Object)ReferenceAccess.WRITE), (Object)assignment);
            }
            if (!useResolveForReadWrite) {
                return TuplesKt.to((Object)((Object)ReferenceAccess.READ_WRITE), (Object)assignment);
            }
            ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default(assignment, null, 1, null);
            if (resolvedCall2 == null) {
                return TuplesKt.to((Object)((Object)ReferenceAccess.READ_WRITE), (Object)assignment);
            }
            ResolvedCall resolvedCall3 = resolvedCall2;
            if (!ArgumentMappingKt.isReallySuccess(resolvedCall3)) {
                return TuplesKt.to((Object)((Object)ReferenceAccess.READ_WRITE), (Object)assignment);
            }
            return ((ImmutableSet)OperatorConventions.ASSIGNMENT_OPERATIONS.values()).contains((Object)resolvedCall3.getResultingDescriptor().getName()) ? TuplesKt.to((Object)((Object)ReferenceAccess.READ), (Object)assignment) : TuplesKt.to((Object)((Object)ReferenceAccess.READ_WRITE), (Object)assignment);
        }
        PsiElement psiElement4 = expression2.getParent();
        if (!(psiElement4 instanceof KtUnaryExpression)) {
            psiElement4 = null;
        }
        return (unaryExpression = (KtUnaryExpression)psiElement4) != null && CollectionsKt.contains((Iterable)((Iterable)AddToStdlibKt.constant(readWriteAccessWithFullExpression.1.INSTANCE)), (Object)unaryExpression.getOperationToken()) ? TuplesKt.to((Object)((Object)ReferenceAccess.READ_WRITE), (Object)unaryExpression) : TuplesKt.to((Object)((Object)ReferenceAccess.READ), (Object)expression2);
    }

    public static final boolean canBeResolvedViaImport(@NotNull KtReference $receiver, @NotNull DeclarationDescriptor target, @NotNull BindingContext bindingContext2) {
        block12: {
            CallTypeAndReceiver<?, ?> callTypeAndReceiver;
            KtNameReferenceExpression referenceExpression;
            block14: {
                block13: {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
                    Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
                    if (!ImportsUtils.canBeReferencedViaImport(target)) {
                        return false;
                    }
                    if ($receiver instanceof KDocReference) {
                        return ((KDocName)((KDocReference)$receiver).getElement()).getQualifiedName().size() == 1;
                    }
                    if (DescriptorUtilsKt.isExtension(target)) {
                        return true;
                    }
                    KtElement ktElement = $receiver.getElement();
                    if (!(ktElement instanceof KtNameReferenceExpression)) {
                        ktElement = null;
                    }
                    KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktElement;
                    if (ktNameReferenceExpression == null) {
                        return false;
                    }
                    referenceExpression = ktNameReferenceExpression;
                    callTypeAndReceiver = CallTypeAndReceiver.Companion.detect(referenceExpression);
                    if (callTypeAndReceiver.getReceiver() == null) break block12;
                    if (!(target instanceof PropertyDescriptor)) break block13;
                    KotlinType kotlinType = ((PropertyDescriptor)target).getType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"target.type");
                    if (FunctionTypesKt.isExtensionFunctionType(kotlinType)) break block14;
                }
                return false;
            }
            if (!(callTypeAndReceiver instanceof CallTypeAndReceiver.DOT) && !(callTypeAndReceiver instanceof CallTypeAndReceiver.SAFE)) {
                return false;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall((Call)bindingContext2.get(BindingContext.CALL, referenceExpression), bindingContext2);
            if (!(resolvedCall2 instanceof VariableAsFunctionResolvedCall)) {
                resolvedCall2 = null;
            }
            VariableAsFunctionResolvedCall variableAsFunctionResolvedCall = (VariableAsFunctionResolvedCall)((Object)resolvedCall2);
            if (variableAsFunctionResolvedCall == null) {
                return false;
            }
            VariableAsFunctionResolvedCall resolvedCall3 = variableAsFunctionResolvedCall;
            ExplicitReceiverKind explicitReceiverKind = resolvedCall3.getVariableCall().getExplicitReceiverKind();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)explicitReceiverKind), (String)"resolvedCall.variableCall.explicitReceiverKind");
            if (explicitReceiverKind.isDispatchReceiver()) {
                return false;
            }
        }
        return !($receiver.getElement().getParent() instanceof KtThisExpression) && !($receiver.getElement().getParent() instanceof KtSuperExpression);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final KtSimpleNameExpression getCalleeByLambdaArgument(@NotNull KtFunction $receiver) {
        KtCallExpression ktCallExpression;
        KtValueArgument argument2;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiElement psiElement2 = $receiver;
        Function1 branch$iv = getCalleeByLambdaArgument.argument.1.INSTANCE;
        boolean strict$iv = false;
        void $receiver$iv$iv = $receiver$iv;
        PsiElement psiElement3 = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv$iv, KtValueArgument.class, (boolean)strict$iv);
        KtValueArgument ktValueArgument = (KtValueArgument)(psiElement3 != null ? PsiUtilsKt.getIfChildIsInBranch(psiElement3, (PsiElement)$receiver$iv, branch$iv) : null);
        if (ktValueArgument == null) {
            return null;
        }
        KtValueArgument ktValueArgument2 = argument2 = ktValueArgument;
        if (ktValueArgument2 instanceof KtLambdaArgument) {
            PsiElement psiElement4 = ((KtLambdaArgument)argument2).getParent();
            if (!(psiElement4 instanceof KtCallExpression)) {
                psiElement4 = null;
            }
            ktCallExpression = (KtCallExpression)psiElement4;
        } else {
            PsiElement psiElement5 = argument2.getParent();
            if (!(psiElement5 instanceof KtValueArgumentList)) {
                psiElement5 = null;
            }
            KtValueArgumentList ktValueArgumentList = (KtValueArgumentList)psiElement5;
            Object object = ktValueArgumentList != null ? ktValueArgumentList.getParent() : null;
            if (!(object instanceof KtCallExpression)) {
                object = null;
            }
            ktCallExpression = (KtCallExpression)object;
        }
        if (ktCallExpression == null) {
            return null;
        }
        KtCallExpression callExpression2 = ktCallExpression;
        KtExpression ktExpression = callExpression2.getCalleeExpression();
        if (!(ktExpression instanceof KtSimpleNameExpression)) {
            ktExpression = null;
        }
        return (KtSimpleNameExpression)ktExpression;
    }
}

