/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util.attachment;

import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u001b\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006\u001a#\u0010\u0007\u001a\u00020\u00012\u0016\u0010\b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0005\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"attachmentByPsiFile", "Lcom/intellij/openapi/diagnostic/Attachment;", "file", "Lcom/intellij/psi/PsiFile;", "attachmentByPsiFileAsArray", "", "(Lcom/intellij/psi/PsiFile;)[Lcom/intellij/openapi/diagnostic/Attachment;", "mergeAttachments", "attachments", "([Lcom/intellij/openapi/diagnostic/Attachment;)Lcom/intellij/openapi/diagnostic/Attachment;", "idea"})
public final class AttachmentUtilsKt {
    @NotNull
    public static final Attachment[] attachmentByPsiFileAsArray(@Nullable PsiFile file) {
        Attachment attachment = AttachmentUtilsKt.attachmentByPsiFile(file);
        if (attachment == null) {
            return new Attachment[0];
        }
        return new Attachment[]{attachment};
    }

    @Nullable
    public static final Attachment attachmentByPsiFile(@Nullable PsiFile file) {
        String string;
        String string2;
        if (file == null) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null) {
            return AttachmentFactory.createAttachment((VirtualFile)virtualFile);
        }
        try {
            string2 = file.getText();
        }
        catch (Exception e) {
            string2 = null;
        }
        String text2 = string2;
        try {
            string = file.getName();
        }
        catch (Exception e) {
            string = null;
        }
        String name2 = string;
        if (text2 != null && name2 != null) {
            return new Attachment(name2, text2);
        }
        return null;
    }

    @NotNull
    public static final Attachment mergeAttachments(Attachment ... attachments) {
        Intrinsics.checkParameterIsNotNull((Object)attachments, (String)"attachments");
        StringBuilder builder = new StringBuilder();
        for (Attachment element$iv : attachments) {
            Attachment it = element$iv;
            if (it == null) continue;
            builder.append("----- START " + it.getPath() + " -----\n");
            builder.append(it.getDisplayText());
            builder.append("\n----- END " + it.getPath() + " -----\n\n");
        }
        return new Attachment("message.txt", builder.toString());
    }
}

