/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmBytecodeBinaryVersion;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001aB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0016\u001a\u00020\u0007J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0018R\u0016\u0010\r\u001a\u0004\u0018\u00010\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/incremental/CacheVersion;", "", "ownVersion", "", "versionFile", "Ljava/io/File;", "whenVersionChanged", "Lorg/jetbrains/kotlin/incremental/CacheVersion$Action;", "whenTurnedOn", "whenTurnedOff", "isEnabled", "", "(ILjava/io/File;Lorg/jetbrains/kotlin/incremental/CacheVersion$Action;Lorg/jetbrains/kotlin/incremental/CacheVersion$Action;Lorg/jetbrains/kotlin/incremental/CacheVersion$Action;Z)V", "actualVersion", "getActualVersion", "()Ljava/lang/Integer;", "expectedVersion", "getExpectedVersion", "()I", "formatVersionFile", "getFormatVersionFile", "()Ljava/io/File;", "checkVersion", "clean", "", "saveIfNeeded", "Action", "kotlin-build-common"})
public final class CacheVersion {
    private final int ownVersion;
    private final File versionFile;
    private final Action whenVersionChanged;
    private final Action whenTurnedOn;
    private final Action whenTurnedOff;
    private final boolean isEnabled;

    private final Integer getActualVersion() {
        Object object;
        try {
            object = FilesKt.readText$default((File)this.versionFile, null, (int)1, null);
            object = Integer.parseInt((String)object);
        }
        catch (NumberFormatException e) {
            object = null;
        }
        catch (IOException e) {
            object = null;
        }
        return object;
    }

    private final int getExpectedVersion() {
        JvmMetadataVersion metadata = JvmMetadataVersion.INSTANCE;
        JvmBytecodeBinaryVersion bytecode2 = JvmBytecodeBinaryVersion.INSTANCE;
        return this.ownVersion * 1000000 + bytecode2.getMajor() * 10000 + bytecode2.getMinor() * 100 + metadata.getMajor() * 1000 + metadata.getMinor();
    }

    @NotNull
    public final Action checkVersion() {
        Action action2;
        Pair pair2 = TuplesKt.to((Object)this.versionFile.exists(), (Object)this.isEnabled);
        if (Intrinsics.areEqual((Object)pair2, (Object)TuplesKt.to((Object)true, (Object)true))) {
            Integer n = this.getActualVersion();
            int n2 = this.getExpectedVersion();
            action2 = n == null || n != n2 ? this.whenVersionChanged : Action.DO_NOTHING;
        } else {
            action2 = Intrinsics.areEqual((Object)pair2, (Object)TuplesKt.to((Object)false, (Object)true)) ? this.whenTurnedOn : (Intrinsics.areEqual((Object)pair2, (Object)TuplesKt.to((Object)true, (Object)false)) ? this.whenTurnedOff : Action.DO_NOTHING);
        }
        return action2;
    }

    public final void saveIfNeeded() {
        if (!this.isEnabled) {
            return;
        }
        if (!this.versionFile.getParentFile().exists()) {
            this.versionFile.getParentFile().mkdirs();
        }
        FilesKt.writeText$default((File)this.versionFile, (String)String.valueOf(this.getExpectedVersion()), null, (int)2, null);
    }

    public final void clean() {
        this.versionFile.delete();
    }

    @NotNull
    public final File getFormatVersionFile() {
        return this.versionFile;
    }

    public CacheVersion(int ownVersion, @NotNull File versionFile, @NotNull Action whenVersionChanged, @NotNull Action whenTurnedOn, @NotNull Action whenTurnedOff, boolean isEnabled) {
        Intrinsics.checkParameterIsNotNull((Object)versionFile, (String)"versionFile");
        Intrinsics.checkParameterIsNotNull((Object)((Object)whenVersionChanged), (String)"whenVersionChanged");
        Intrinsics.checkParameterIsNotNull((Object)((Object)whenTurnedOn), (String)"whenTurnedOn");
        Intrinsics.checkParameterIsNotNull((Object)((Object)whenTurnedOff), (String)"whenTurnedOff");
        this.ownVersion = ownVersion;
        this.versionFile = versionFile;
        this.whenVersionChanged = whenVersionChanged;
        this.whenTurnedOn = whenTurnedOn;
        this.whenTurnedOff = whenTurnedOff;
        this.isEnabled = isEnabled;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/incremental/CacheVersion$Action;", "", "(Ljava/lang/String;I)V", "REBUILD_ALL_KOTLIN", "REBUILD_CHUNK", "CLEAN_NORMAL_CACHES", "CLEAN_DATA_CONTAINER", "DO_NOTHING", "kotlin-build-common"})
    public static final class Action
    extends Enum<Action> {
        public static final /* enum */ Action REBUILD_ALL_KOTLIN;
        public static final /* enum */ Action REBUILD_CHUNK;
        public static final /* enum */ Action CLEAN_NORMAL_CACHES;
        public static final /* enum */ Action CLEAN_DATA_CONTAINER;
        public static final /* enum */ Action DO_NOTHING;
        private static final /* synthetic */ Action[] $VALUES;

        static {
            Action[] actionArray = new Action[5];
            Action[] actionArray2 = actionArray;
            actionArray[0] = REBUILD_ALL_KOTLIN = new Action();
            actionArray[1] = REBUILD_CHUNK = new Action();
            actionArray[2] = CLEAN_NORMAL_CACHES = new Action();
            actionArray[3] = CLEAN_DATA_CONTAINER = new Action();
            actionArray[4] = DO_NOTHING = new Action();
            $VALUES = actionArray;
        }

        public static Action[] values() {
            return (Action[])$VALUES.clone();
        }

        public static Action valueOf(String string) {
            return Enum.valueOf(Action.class, string);
        }
    }
}

