/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.analyze;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.context.ContextKt;
import org.jetbrains.kotlin.context.ModuleContext;
import org.jetbrains.kotlin.context.MutableModuleContext;
import org.jetbrains.kotlin.context.ProjectContext;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.frontend.js.di.InjectionKt;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.incremental.js.TranslationResultValue;
import org.jetbrains.kotlin.js.analyzer.JsAnalysisResult;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.config.JsConfig;
import org.jetbrains.kotlin.js.resolve.BindingContextSlicesJsKt;
import org.jetbrains.kotlin.js.resolve.JsPlatform;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.CompilerDeserializationConfiguration;
import org.jetbrains.kotlin.resolve.LazyTopDownAnalyzer;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.lazy.declarations.DeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationConfiguration;
import org.jetbrains.kotlin.serialization.js.JsModuleDescriptor;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.serialization.js.PackagesWithHeaderMetadata;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JL\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rJ\u001e\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J,\u0010\u0013\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0007\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/js/analyze/TopDownAnalyzerFacadeForJS;", "", "()V", "analyzeFiles", "Lorg/jetbrains/kotlin/js/analyzer/JsAnalysisResult;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "project", "Lcom/intellij/openapi/project/Project;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "moduleDescriptors", "", "Lorg/jetbrains/kotlin/serialization/js/JsModuleDescriptor;", "Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "friendModuleDescriptors", "config", "Lorg/jetbrains/kotlin/js/config/JsConfig;", "analyzeFilesWithGivenTrace", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "moduleContext", "Lorg/jetbrains/kotlin/context/ModuleContext;", "checkForErrors", "", "allFiles", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "js.frontend"})
public final class TopDownAnalyzerFacadeForJS {
    public static final TopDownAnalyzerFacadeForJS INSTANCE;

    @JvmStatic
    @NotNull
    public static final JsAnalysisResult analyzeFiles(@NotNull Collection<? extends KtFile> files2, @NotNull JsConfig config2) {
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)config2, (String)"config");
        config2.init();
        Project project = config2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"config.project");
        CompilerConfiguration compilerConfiguration = config2.getConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)compilerConfiguration, (String)"config.configuration");
        List<JsModuleDescriptor<ModuleDescriptorImpl>> list2 = config2.getModuleDescriptors();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"config.moduleDescriptors");
        List<JsModuleDescriptor<ModuleDescriptorImpl>> list3 = config2.getFriendModuleDescriptors();
        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"config.friendModuleDescriptors");
        return INSTANCE.analyzeFiles(files2, project, compilerConfiguration, list2, list3);
    }

    @NotNull
    public final JsAnalysisResult analyzeFiles(@NotNull Collection<? extends KtFile> files2, @NotNull Project project, @NotNull CompilerConfiguration configuration2, @NotNull List<JsModuleDescriptor<ModuleDescriptorImpl>> moduleDescriptors, @NotNull List<JsModuleDescriptor<ModuleDescriptorImpl>> friendModuleDescriptors) {
        ModuleDescriptorImpl moduleDescriptorImpl;
        JsModuleDescriptor it;
        Collection<ModuleDescriptorImpl> collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)configuration2, (String)"configuration");
        Intrinsics.checkParameterIsNotNull(moduleDescriptors, (String)"moduleDescriptors");
        Intrinsics.checkParameterIsNotNull(friendModuleDescriptors, (String)"friendModuleDescriptors");
        String string = configuration2.get(CommonConfigurationKeys.MODULE_NAME);
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String moduleName = string;
        ProjectContext projectContext = ContextKt.ProjectContext(project);
        Name name2 = Name.special('<' + moduleName + '>');
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.special(\"<$moduleName>\")");
        MutableModuleContext context2 = ContextKt.ContextForNewModule(projectContext, name2, JsPlatform.INSTANCE.getBuiltIns(), null);
        Iterable iterable = moduleDescriptors;
        Collection collection2 = CollectionsKt.listOf((Object)context2.getModule());
        ModuleDescriptorImpl moduleDescriptorImpl2 = context2.getModule();
        void var9_11 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            JsModuleDescriptor jsModuleDescriptor = (JsModuleDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            moduleDescriptorImpl = (ModuleDescriptorImpl)it.getData();
            collection.add(moduleDescriptorImpl);
        }
        collection = (List)destination$iv$iv;
        $receiver$iv = friendModuleDescriptors;
        collection2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection2, (Iterable)collection), (Iterable)CollectionsKt.listOf((Object)JsPlatform.INSTANCE.getBuiltIns().getBuiltInsModule()));
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (JsModuleDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            moduleDescriptorImpl = (ModuleDescriptorImpl)it.getData();
            collection.add(moduleDescriptorImpl);
        }
        collection = (List)destination$iv$iv;
        moduleDescriptorImpl2.setDependencies((List<ModuleDescriptorImpl>)collection2, CollectionsKt.toSet((Iterable)collection));
        ModuleKind moduleKind = configuration2.get(JSConfigurationKeys.MODULE_KIND, ModuleKind.PLAIN);
        BindingTraceContext trace = new BindingTraceContext();
        trace.record(BindingContextSlicesJsKt.MODULE_KIND, context2.getModule(), moduleKind);
        return this.analyzeFilesWithGivenTrace(files2, trace, context2, configuration2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JsAnalysisResult analyzeFilesWithGivenTrace(@NotNull Collection<? extends KtFile> files2, @NotNull BindingTrace trace, @NotNull ModuleContext moduleContext, @NotNull CompilerConfiguration configuration2) {
        PackageFragmentProvider packageFragmentProvider2;
        ExpectActualTracker expectActualTracker;
        LookupTracker lookupTracker;
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)moduleContext, (String)"moduleContext");
        Intrinsics.checkParameterIsNotNull((Object)configuration2, (String)"configuration");
        LookupTracker lookupTracker2 = configuration2.get(CommonConfigurationKeys.LOOKUP_TRACKER);
        if (lookupTracker2 == null) {
            lookupTracker2 = lookupTracker = (LookupTracker)LookupTracker.DO_NOTHING.INSTANCE;
        }
        if ((expectActualTracker = configuration2.get(CommonConfigurationKeys.EXPECT_ACTUAL_TRACKER)) == null) {
            expectActualTracker = ExpectActualTracker.DoNothing.INSTANCE;
        }
        ExpectActualTracker expectActualTracker2 = expectActualTracker;
        LanguageVersionSettings languageVersionSettings = CommonConfigurationKeysKt.getLanguageVersionSettings(configuration2);
        IncrementalDataProvider incrementalDataProvider = configuration2.get(JSConfigurationKeys.INCREMENTAL_DATA_PROVIDER);
        if (incrementalDataProvider != null) {
            Collection<byte[]> collection;
            void $receiver$iv$iv;
            void $receiver$iv;
            IncrementalDataProvider incrementalDataProvider2;
            IncrementalDataProvider it = incrementalDataProvider2 = incrementalDataProvider;
            Iterable iterable = it.getCompiledPackageParts().values();
            byte[] byArray = it.getHeaderMetadata();
            void var15_12 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it2;
                TranslationResultValue translationResultValue = (TranslationResultValue)item$iv$iv;
                collection = destination$iv$iv;
                byte[] byArray2 = it2.getMetadata();
                collection.add(byArray2);
            }
            collection = (List)destination$iv$iv;
            List list2 = collection;
            byte[] byArray3 = byArray;
            PackagesWithHeaderMetadata metadata = new PackagesWithHeaderMetadata(byArray3, list2);
            StorageManager storageManager = moduleContext.getStorageManager();
            ModuleDescriptor moduleDescriptor = moduleContext.getModule();
            DeserializationConfiguration deserializationConfiguration = new CompilerDeserializationConfiguration(languageVersionSettings);
            LookupTracker lookupTracker3 = lookupTracker;
            Intrinsics.checkExpressionValueIsNotNull((Object)lookupTracker3, (String)"lookupTracker");
            packageFragmentProvider2 = KotlinJavascriptSerializationUtil.INSTANCE.readDescriptors(metadata, storageManager, moduleDescriptor, deserializationConfiguration, lookupTracker3);
        } else {
            packageFragmentProvider2 = null;
        }
        PackageFragmentProvider packageFragment = packageFragmentProvider2;
        DeclarationProviderFactory declarationProviderFactory2 = new FileBasedDeclarationProviderFactory(moduleContext.getStorageManager(), files2);
        LookupTracker lookupTracker4 = lookupTracker;
        Intrinsics.checkExpressionValueIsNotNull((Object)lookupTracker4, (String)"lookupTracker");
        ExpectActualTracker expectActualTracker3 = expectActualTracker2;
        Intrinsics.checkExpressionValueIsNotNull((Object)expectActualTracker3, (String)"expectActualTracker");
        LazyTopDownAnalyzer analyzerForJs = InjectionKt.createTopDownAnalyzerForJs(moduleContext, trace, declarationProviderFactory2, languageVersionSettings, lookupTracker4, expectActualTracker3, packageFragment);
        LazyTopDownAnalyzer.analyzeDeclarations$default(analyzerForJs, TopDownAnalysisMode.TopLevelDeclarations, files2, null, 4, null);
        return JsAnalysisResult.Companion.success(trace, moduleContext.getModule());
    }

    @JvmStatic
    public static final void checkForErrors(@NotNull Collection<? extends KtFile> allFiles2, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull(allFiles2, (String)"allFiles");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        AnalyzingUtils.throwExceptionOnErrors(bindingContext2);
        for (KtFile ktFile : allFiles2) {
            AnalyzingUtils.checkForSyntacticErrors((PsiElement)ktFile);
        }
    }

    private TopDownAnalyzerFacadeForJS() {
    }

    static {
        TopDownAnalyzerFacadeForJS topDownAnalyzerFacadeForJS;
        INSTANCE = topDownAnalyzerFacadeForJS = new TopDownAnalyzerFacadeForJS();
    }
}

