/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import com.intellij.openapi.util.Ref;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kotlin.jvm.functions.Function4;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.load.kotlin.header.ReadKotlinClassHeaderAnnotationVisitor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public abstract class FileBasedKotlinClass
implements KotlinJvmBinaryClass {
    private final ClassId classId;
    private final int classVersion;
    private final KotlinClassHeader classHeader;
    private final InnerClassesInfo innerClasses;

    protected FileBasedKotlinClass(@NotNull ClassId classId, int classVersion, @NotNull KotlinClassHeader classHeader, @NotNull InnerClassesInfo innerClasses) {
        this.classId = classId;
        this.classVersion = classVersion;
        this.classHeader = classHeader;
        this.innerClasses = innerClasses;
    }

    @NotNull
    protected abstract byte[] getFileContents();

    @Nullable
    public static <T extends FileBasedKotlinClass> T create(@NotNull byte[] fileContents, @NotNull Function4<ClassId, Integer, KotlinClassHeader, InnerClassesInfo, T> factory2) {
        final ReadKotlinClassHeaderAnnotationVisitor readHeaderVisitor = new ReadKotlinClassHeaderAnnotationVisitor();
        final Ref classNameRef = Ref.create();
        final Ref classVersion = Ref.create();
        final InnerClassesInfo innerClasses = new InnerClassesInfo();
        new ClassReader(fileContents).accept(new ClassVisitor(327680){

            public void visit(int version, int access, @NotNull String name2, String signature, String superName, String[] interfaces) {
                classNameRef.set((Object)name2);
                classVersion.set((Object)version);
            }

            public void visitInnerClass(@NotNull String name2, String outerName, String innerName, int access) {
                innerClasses.add(name2, outerName, innerName);
            }

            public AnnotationVisitor visitAnnotation(@NotNull String desc, boolean visible) {
                return FileBasedKotlinClass.convertAnnotationVisitor(readHeaderVisitor, desc, innerClasses);
            }

            public void visitEnd() {
                readHeaderVisitor.visitEnd();
            }
        }, 7);
        String className2 = (String)classNameRef.get();
        if (className2 == null) {
            return null;
        }
        KotlinClassHeader header = readHeaderVisitor.createHeader();
        if (header == null) {
            return null;
        }
        ClassId id = FileBasedKotlinClass.resolveNameByInternalName(className2, innerClasses);
        return (T)((FileBasedKotlinClass)factory2.invoke((Object)id, classVersion.get(), (Object)header, (Object)innerClasses));
    }

    @Override
    @NotNull
    public ClassId getClassId() {
        return this.classId;
    }

    public int getClassVersion() {
        return this.classVersion;
    }

    @Override
    @NotNull
    public KotlinClassHeader getClassHeader() {
        return this.classHeader;
    }

    @Override
    public void loadClassAnnotations(final @NotNull KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor, @Nullable byte[] cachedContents) {
        byte[] fileContents = cachedContents != null ? cachedContents : this.getFileContents();
        new ClassReader(fileContents).accept(new ClassVisitor(327680){

            public AnnotationVisitor visitAnnotation(@NotNull String desc, boolean visible) {
                return FileBasedKotlinClass.convertAnnotationVisitor(annotationVisitor, desc, FileBasedKotlinClass.this.innerClasses);
            }

            public void visitEnd() {
                annotationVisitor.visitEnd();
            }
        }, 7);
    }

    @Nullable
    public static AnnotationVisitor convertAnnotationVisitor(@NotNull KotlinJvmBinaryClass.AnnotationVisitor visitor2, @NotNull String desc, @NotNull InnerClassesInfo innerClasses) {
        KotlinJvmBinaryClass.AnnotationArgumentVisitor v = visitor2.visitAnnotation(FileBasedKotlinClass.resolveNameByDesc(desc, innerClasses), SourceElement.NO_SOURCE);
        return v == null ? null : FileBasedKotlinClass.convertAnnotationVisitor(v, innerClasses);
    }

    @NotNull
    private static AnnotationVisitor convertAnnotationVisitor(final @NotNull KotlinJvmBinaryClass.AnnotationArgumentVisitor v, final @NotNull InnerClassesInfo innerClasses) {
        return new AnnotationVisitor(327680){

            public void visit(String name2, @NotNull Object value) {
                v.visit(name2 == null ? null : Name.identifier(name2), value);
            }

            public AnnotationVisitor visitArray(String name2) {
                final KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor arv = v.visitArray(Name.identifier(name2));
                return arv == null ? null : new AnnotationVisitor(327680){

                    public void visit(String name2, @NotNull Object value) {
                        arv.visit(value);
                    }

                    public void visitEnum(String name2, @NotNull String desc, @NotNull String value) {
                        arv.visitEnum(FileBasedKotlinClass.resolveNameByDesc(desc, innerClasses), Name.identifier(value));
                    }

                    public void visitEnd() {
                        arv.visitEnd();
                    }
                };
            }

            public AnnotationVisitor visitAnnotation(String name2, @NotNull String desc) {
                KotlinJvmBinaryClass.AnnotationArgumentVisitor arv = v.visitAnnotation(Name.identifier(name2), FileBasedKotlinClass.resolveNameByDesc(desc, innerClasses));
                return arv == null ? null : FileBasedKotlinClass.convertAnnotationVisitor(arv, innerClasses);
            }

            public void visitEnum(String name2, @NotNull String desc, @NotNull String value) {
                v.visitEnum(Name.identifier(name2), FileBasedKotlinClass.resolveNameByDesc(desc, innerClasses), Name.identifier(value));
            }

            public void visitEnd() {
                v.visitEnd();
            }
        };
    }

    @Override
    public void visitMembers(final @NotNull KotlinJvmBinaryClass.MemberVisitor memberVisitor, @Nullable byte[] cachedContents) {
        byte[] fileContents = cachedContents != null ? cachedContents : this.getFileContents();
        new ClassReader(fileContents).accept(new ClassVisitor(327680){

            public FieldVisitor visitField(int access, @NotNull String name2, @NotNull String desc, String signature, Object value) {
                final KotlinJvmBinaryClass.AnnotationVisitor v = memberVisitor.visitField(Name.identifier(name2), desc, value);
                if (v == null) {
                    return null;
                }
                return new FieldVisitor(327680){

                    public AnnotationVisitor visitAnnotation(@NotNull String desc, boolean visible) {
                        return FileBasedKotlinClass.convertAnnotationVisitor(v, desc, FileBasedKotlinClass.this.innerClasses);
                    }

                    public void visitEnd() {
                        v.visitEnd();
                    }
                };
            }

            public MethodVisitor visitMethod(int access, @NotNull String name2, @NotNull String desc, String signature, String[] exceptions) {
                final KotlinJvmBinaryClass.MethodAnnotationVisitor v = memberVisitor.visitMethod(Name.identifier(name2), desc);
                if (v == null) {
                    return null;
                }
                return new MethodVisitor(327680){

                    public AnnotationVisitor visitAnnotation(@NotNull String desc, boolean visible) {
                        return FileBasedKotlinClass.convertAnnotationVisitor(v, desc, FileBasedKotlinClass.this.innerClasses);
                    }

                    public AnnotationVisitor visitParameterAnnotation(int parameter, @NotNull String desc, boolean visible) {
                        KotlinJvmBinaryClass.AnnotationArgumentVisitor av = v.visitParameterAnnotation(parameter, FileBasedKotlinClass.resolveNameByDesc(desc, FileBasedKotlinClass.this.innerClasses), SourceElement.NO_SOURCE);
                        return av == null ? null : FileBasedKotlinClass.convertAnnotationVisitor(av, FileBasedKotlinClass.this.innerClasses);
                    }

                    public void visitEnd() {
                        v.visitEnd();
                    }
                };
            }
        }, 7);
    }

    @NotNull
    private static ClassId resolveNameByDesc(@NotNull String desc, @NotNull InnerClassesInfo innerClasses) {
        assert (desc.startsWith("L") && desc.endsWith(";")) : "Not a JVM descriptor: " + desc;
        String name2 = desc.substring(1, desc.length() - 1);
        return FileBasedKotlinClass.resolveNameByInternalName(name2, innerClasses);
    }

    @NotNull
    private static ClassId resolveNameByInternalName(@NotNull String name2, @NotNull InnerClassesInfo innerClasses) {
        OuterAndInnerName outer;
        if (!name2.contains("$")) {
            return ClassId.topLevel(new FqName(name2.replace('/', '.')));
        }
        ArrayList<String> classes2 = new ArrayList<String>(1);
        boolean local = false;
        while ((outer = innerClasses.get(name2)) != null) {
            if (outer.outerInternalName == null) {
                local = true;
                break;
            }
            classes2.add(outer.innerSimpleName);
            name2 = outer.outerInternalName;
        }
        FqName outermostClassFqName = new FqName(name2.replace('/', '.'));
        classes2.add(outermostClassFqName.shortName().asString());
        Collections.reverse(classes2);
        FqName packageFqName = outermostClassFqName.parent();
        FqName relativeClassName2 = FqName.fromSegments(classes2);
        return new ClassId(packageFqName, relativeClassName2, local);
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String toString();

    public static class InnerClassesInfo {
        private Map<String, OuterAndInnerName> map = null;

        public void add(@NotNull String name2, @Nullable String outerName, @Nullable String innerName) {
            if (this.map == null) {
                this.map = new HashMap<String, OuterAndInnerName>();
            }
            this.map.put(name2, new OuterAndInnerName(outerName, innerName));
        }

        @Nullable
        public OuterAndInnerName get(@NotNull String name2) {
            return this.map == null ? null : this.map.get(name2);
        }
    }

    public static class OuterAndInnerName {
        public final String outerInternalName;
        public final String innerSimpleName;

        private OuterAndInnerName(@Nullable String outerInternalName, @Nullable String innerSimpleName) {
            this.outerInternalName = outerInternalName;
            this.innerSimpleName = innerSimpleName;
        }
    }
}

