/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.SupertypeLoopChecker;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationSplitter;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.annotations.CompositeAnnotations;
import org.jetbrains.kotlin.descriptors.impl.ClassConstructorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertySetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DeclarationReturnTypeSanitizer;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.OverloadChecker;
import org.jetbrains.kotlin.resolve.TypeAliasExpansionReportStrategy;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.VariableAsPropertyInfo;
import org.jetbrains.kotlin.resolve.VariableTypeAndInitializerResolver;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfoFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;
import org.jetbrains.kotlin.resolve.extensions.SyntheticResolveExtension;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyTypeAliasDescriptor;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.LocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.ScopeUtils;
import org.jetbrains.kotlin.resolve.scopes.TraceBasedLocalRedeclarationChecker;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.SpecialTypesKt;
import org.jetbrains.kotlin.types.TypeApproximator;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.WrappedTypeFactory;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.DestructuringDeclarationResolver;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.FunctionsTypingVisitor;
import org.jetbrains.kotlin.types.expressions.PreliminaryDeclarationVisitor;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public class DescriptorResolver {
    private final TypeResolver typeResolver;
    private final AnnotationResolver annotationResolver;
    private final StorageManager storageManager;
    private final KotlinBuiltIns builtIns;
    private final SupertypeLoopChecker supertypeLoopsResolver;
    private final VariableTypeAndInitializerResolver variableTypeAndInitializerResolver;
    private final ExpressionTypingServices expressionTypingServices;
    private final OverloadChecker overloadChecker;
    private final LanguageVersionSettings languageVersionSettings;
    private final FunctionsTypingVisitor functionsTypingVisitor;
    private final DestructuringDeclarationResolver destructuringDeclarationResolver;
    private final ModifiersChecker modifiersChecker;
    private final WrappedTypeFactory wrappedTypeFactory;
    private final SyntheticResolveExtension syntheticResolveExtension;
    private final TypeApproximator typeApproximator;
    private final DeclarationReturnTypeSanitizer declarationReturnTypeSanitizer;
    private final DataFlowValueFactory dataFlowValueFactory;

    public DescriptorResolver(@NotNull AnnotationResolver annotationResolver, @NotNull KotlinBuiltIns builtIns, @NotNull StorageManager storageManager, @NotNull TypeResolver typeResolver, @NotNull SupertypeLoopChecker supertypeLoopsResolver, @NotNull VariableTypeAndInitializerResolver variableTypeAndInitializerResolver, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull OverloadChecker overloadChecker, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull FunctionsTypingVisitor functionsTypingVisitor, @NotNull DestructuringDeclarationResolver destructuringDeclarationResolver, @NotNull ModifiersChecker modifiersChecker, @NotNull WrappedTypeFactory wrappedTypeFactory, @NotNull Project project, @NotNull TypeApproximator approximator, @NotNull DeclarationReturnTypeSanitizer declarationReturnTypeSanitizer, @NotNull DataFlowValueFactory dataFlowValueFactory) {
        this.annotationResolver = annotationResolver;
        this.builtIns = builtIns;
        this.storageManager = storageManager;
        this.typeResolver = typeResolver;
        this.supertypeLoopsResolver = supertypeLoopsResolver;
        this.variableTypeAndInitializerResolver = variableTypeAndInitializerResolver;
        this.expressionTypingServices = expressionTypingServices;
        this.overloadChecker = overloadChecker;
        this.languageVersionSettings = languageVersionSettings;
        this.functionsTypingVisitor = functionsTypingVisitor;
        this.destructuringDeclarationResolver = destructuringDeclarationResolver;
        this.modifiersChecker = modifiersChecker;
        this.wrappedTypeFactory = wrappedTypeFactory;
        this.syntheticResolveExtension = SyntheticResolveExtension.Companion.getInstance(project);
        this.typeApproximator = approximator;
        this.declarationReturnTypeSanitizer = declarationReturnTypeSanitizer;
        this.dataFlowValueFactory = dataFlowValueFactory;
    }

    public List<KotlinType> resolveSupertypes(@NotNull LexicalScope scope2, @NotNull ClassDescriptor classDescriptor, @Nullable KtPureClassOrObject correspondingClassOrObject, BindingTrace trace) {
        ArrayList supertypes2 = Lists.newArrayList();
        List<KtSuperTypeListEntry> delegationSpecifiers = correspondingClassOrObject == null ? Collections.emptyList() : correspondingClassOrObject.getSuperTypeListEntries();
        Collection<KotlinType> declaredSupertypes = DescriptorResolver.resolveSuperTypeListEntries(scope2, delegationSpecifiers, this.typeResolver, trace, false);
        for (KotlinType declaredSupertype : declaredSupertypes) {
            DescriptorResolver.addValidSupertype(supertypes2, declaredSupertype);
        }
        if (classDescriptor.getKind() == ClassKind.ENUM_CLASS && !DescriptorResolver.containsClass(supertypes2)) {
            supertypes2.add(0, this.builtIns.getEnumType(classDescriptor.getDefaultType()));
        }
        this.syntheticResolveExtension.addSyntheticSupertypes(classDescriptor, supertypes2);
        if (supertypes2.isEmpty()) {
            DescriptorResolver.addValidSupertype(supertypes2, this.getDefaultSupertype(classDescriptor));
        }
        return supertypes2;
    }

    private static void addValidSupertype(List<KotlinType> supertypes2, KotlinType declaredSupertype) {
        if (!KotlinTypeKt.isError(declaredSupertype)) {
            supertypes2.add(declaredSupertype);
        }
    }

    private static boolean containsClass(Collection<KotlinType> result2) {
        for (KotlinType type2 : result2) {
            ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
            if (!(descriptor2 instanceof ClassDescriptor) || ((ClassDescriptor)descriptor2).getKind() == ClassKind.INTERFACE) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private KotlinType getDefaultSupertype(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor.getKind() == ClassKind.ENUM_ENTRY) {
            return ((ClassDescriptor)classDescriptor.getContainingDeclaration()).getDefaultType();
        }
        if (classDescriptor.getKind() == ClassKind.ANNOTATION_CLASS) {
            return this.builtIns.getAnnotationType();
        }
        return this.builtIns.getAnyType();
    }

    private static Collection<KotlinType> resolveSuperTypeListEntries(LexicalScope extensibleScope, List<KtSuperTypeListEntry> delegationSpecifiers, @NotNull TypeResolver resolver2, BindingTrace trace, boolean checkBounds) {
        if (delegationSpecifiers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result2 = Lists.newArrayList();
        for (KtSuperTypeListEntry delegationSpecifier : delegationSpecifiers) {
            KtTypeReference typeReference = delegationSpecifier.getTypeReference();
            if (typeReference != null) {
                KotlinType supertype = resolver2.resolveType(extensibleScope, typeReference, trace, checkBounds);
                if (DynamicTypesKt.isDynamic(supertype)) {
                    trace.report(Errors.DYNAMIC_SUPERTYPE.on(typeReference));
                    continue;
                }
                result2.add(supertype);
                KtTypeElement bareSuperType = DescriptorResolver.checkNullableSupertypeAndStripQuestionMarks(trace, typeReference.getTypeElement());
                DescriptorResolver.checkProjectionsInImmediateArguments(trace, bareSuperType, supertype);
                continue;
            }
            result2.add(ErrorUtils.createErrorType("No type reference"));
        }
        return result2;
    }

    @Nullable
    private static KtTypeElement checkNullableSupertypeAndStripQuestionMarks(@NotNull BindingTrace trace, @Nullable KtTypeElement typeElement) {
        while (typeElement instanceof KtNullableType) {
            KtNullableType nullableType = (KtNullableType)typeElement;
            if ((typeElement = nullableType.getInnerType()) instanceof KtNullableType || typeElement == null) continue;
            trace.report(Errors.NULLABLE_SUPERTYPE.on(nullableType));
        }
        return typeElement;
    }

    private static void checkProjectionsInImmediateArguments(@NotNull BindingTrace trace, @Nullable KtTypeElement typeElement, @NotNull KotlinType type2) {
        if (typeElement == null) {
            return;
        }
        boolean hasProjectionsInWrittenArguments = false;
        if (typeElement instanceof KtUserType) {
            KtUserType userType2 = (KtUserType)typeElement;
            List<KtTypeProjection> typeArguments2 = userType2.getTypeArguments();
            for (KtTypeProjection typeArgument : typeArguments2) {
                if (typeArgument.getProjectionKind() == KtProjectionKind.NONE) continue;
                trace.report(Errors.PROJECTION_IN_IMMEDIATE_ARGUMENT_TO_SUPERTYPE.on(typeArgument));
                hasProjectionsInWrittenArguments = true;
            }
        }
        if (!KotlinTypeKt.isError(type2) && SpecialTypesKt.getAbbreviatedType(type2) != null && !hasProjectionsInWrittenArguments && TypeUtilsKt.isInterface(type2) && TypeUtilsKt.containsTypeProjectionsInTopLevelArguments(type2)) {
            trace.report(Errors.EXPANDED_TYPE_CANNOT_BE_INHERITED.on(typeElement, type2));
        }
    }

    public static Visibility getDefaultVisibility(KtModifierListOwner modifierListOwner, DeclarationDescriptor containingDescriptor) {
        KtModifierList modifierList;
        Visibility defaultVisibility = containingDescriptor instanceof ClassDescriptor ? ((modifierList = modifierListOwner.getModifierList()) != null && modifierList.hasModifier(KtTokens.OVERRIDE_KEYWORD) ? Visibilities.INHERITED : Visibilities.DEFAULT_VISIBILITY) : (containingDescriptor instanceof FunctionDescriptor || containingDescriptor instanceof PropertyDescriptor ? Visibilities.LOCAL : Visibilities.DEFAULT_VISIBILITY);
        return defaultVisibility;
    }

    public static Modality getDefaultModality(DeclarationDescriptor containingDescriptor, Visibility visibility, boolean isBodyPresent) {
        Modality defaultModality;
        if (containingDescriptor instanceof ClassDescriptor) {
            boolean isTrait = ((ClassDescriptor)containingDescriptor).getKind() == ClassKind.INTERFACE;
            boolean isDefinitelyAbstract = isTrait && !isBodyPresent;
            Modality basicModality = isTrait && !Visibilities.isPrivate(visibility) ? Modality.OPEN : Modality.FINAL;
            defaultModality = isDefinitelyAbstract ? Modality.ABSTRACT : basicModality;
        } else {
            defaultModality = Modality.FINAL;
        }
        return defaultModality;
    }

    @NotNull
    public ValueParameterDescriptorImpl resolveValueParameterDescriptor(@NotNull LexicalScope scope2, @NotNull FunctionDescriptor owner, @NotNull KtParameter valueParameter, int index2, @NotNull KotlinType type2, @NotNull BindingTrace trace) {
        Function0 destructuringVariables;
        KtDestructuringDeclaration destructuringDeclaration;
        KotlinType varargElementType = null;
        KotlinType variableType = type2;
        if (valueParameter.hasModifier(KtTokens.VARARG_KEYWORD)) {
            varargElementType = type2;
            variableType = this.getVarargParameterType(type2);
        }
        KtModifierList modifierList = valueParameter.getModifierList();
        Annotations allAnnotations = this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, valueParameter.getModifierList(), trace);
        Annotations valueParameterAnnotations = Annotations.Companion.getEMPTY();
        if (modifierList != null) {
            if (valueParameter.hasValOrVar()) {
                AnnotationSplitter annotationSplitter = AnnotationSplitter.create(this.storageManager, allAnnotations, SetsKt.setOf((Object)((Object)AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER)));
                valueParameterAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.CONSTRUCTOR_PARAMETER);
            } else {
                valueParameterAnnotations = allAnnotations;
            }
        }
        if ((destructuringDeclaration = valueParameter.getDestructuringDeclaration()) != null) {
            if (!this.languageVersionSettings.supportsFeature(LanguageFeature.DestructuringLambdaParameters)) {
                trace.report(Errors.UNSUPPORTED_FEATURE.on(valueParameter, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.DestructuringLambdaParameters), (Object)this.languageVersionSettings)));
            }
            destructuringVariables = () -> {
                assert (owner.getDispatchReceiverParameter() == null) : "Destructuring declarations are only be parsed for lambdas, and they must not have a dispatch receiver";
                LexicalScope scopeForDestructuring = ScopeUtilsKt.createScopeForDestructuring(scope2, owner.getExtensionReceiverParameter());
                List<VariableDescriptor> result2 = this.destructuringDeclarationResolver.resolveLocalVariablesFromDestructuringDeclaration(scope2, destructuringDeclaration, new TransientReceiver(type2), null, ExpressionTypingContext.newContext(trace, scopeForDestructuring, DataFlowInfoFactory.EMPTY, TypeUtils.NO_EXPECTED_TYPE, this.languageVersionSettings, this.dataFlowValueFactory));
                this.modifiersChecker.withTrace(trace).checkModifiersForDestructuringDeclaration(destructuringDeclaration);
                return result2;
            };
        } else {
            destructuringVariables = null;
        }
        Name parameterName = destructuringDeclaration == null ? (!valueParameter.hasValOrVar() && UnderscoreUtilKt.isSingleUnderscore(valueParameter) ? Name.special("<anonymous parameter " + index2 + ">") : KtPsiUtil.safeName(valueParameter.getName())) : Name.special("<name for destructuring parameter " + index2 + ">");
        ValueParameterDescriptorImpl valueParameterDescriptor = ValueParameterDescriptorImpl.createWithDestructuringDeclarations(owner, null, index2, valueParameterAnnotations, parameterName, variableType, valueParameter.hasDefaultValue(), valueParameter.hasModifier(KtTokens.CROSSINLINE_KEYWORD), valueParameter.hasModifier(KtTokens.NOINLINE_KEYWORD), varargElementType, KotlinSourceElementKt.toSourceElement(valueParameter), (Function0<? extends List<? extends VariableDescriptor>>)destructuringVariables);
        trace.record(BindingContext.VALUE_PARAMETER, valueParameter, valueParameterDescriptor);
        return valueParameterDescriptor;
    }

    @NotNull
    private KotlinType getVarargParameterType(@NotNull KotlinType elementType) {
        SimpleType primitiveArrayType = this.builtIns.getPrimitiveArrayKotlinTypeByPrimitiveKotlinType(elementType);
        if (primitiveArrayType != null) {
            return primitiveArrayType;
        }
        return this.builtIns.getArrayType(Variance.OUT_VARIANCE, elementType);
    }

    public List<TypeParameterDescriptorImpl> resolveTypeParametersForDescriptor(DeclarationDescriptor containingDescriptor, LexicalWritableScope extensibleScope, LexicalScope scopeForAnnotationsResolve, List<KtTypeParameter> typeParameters, BindingTrace trace) {
        List<TypeParameterDescriptorImpl> descriptors2 = this.resolveTypeParametersForDescriptor(containingDescriptor, scopeForAnnotationsResolve, typeParameters, trace);
        for (TypeParameterDescriptorImpl descriptor2 : descriptors2) {
            extensibleScope.addClassifierDescriptor(descriptor2);
        }
        return descriptors2;
    }

    private List<TypeParameterDescriptorImpl> resolveTypeParametersForDescriptor(DeclarationDescriptor containingDescriptor, LexicalScope scopeForAnnotationsResolve, List<KtTypeParameter> typeParameters, BindingTrace trace) {
        assert (containingDescriptor instanceof FunctionDescriptor || containingDescriptor instanceof PropertyDescriptor || containingDescriptor instanceof TypeAliasDescriptor) : "This method should be called for functions, properties, or type aliases, got " + containingDescriptor;
        ArrayList<TypeParameterDescriptorImpl> result2 = new ArrayList<TypeParameterDescriptorImpl>();
        int typeParametersSize = typeParameters.size();
        for (int i = 0; i < typeParametersSize; ++i) {
            KtTypeParameter typeParameter = typeParameters.get(i);
            result2.add(this.resolveTypeParameterForDescriptor(containingDescriptor, scopeForAnnotationsResolve, typeParameter, i, trace));
        }
        return result2;
    }

    private TypeParameterDescriptorImpl resolveTypeParameterForDescriptor(DeclarationDescriptor containingDescriptor, LexicalScope scopeForAnnotationsResolve, KtTypeParameter typeParameter, int index2, BindingTrace trace) {
        if (typeParameter.getVariance() != Variance.INVARIANT) {
            trace.report(Errors.VARIANCE_ON_TYPE_PARAMETER_NOT_ALLOWED.on(typeParameter));
        }
        Annotations annotations2 = this.annotationResolver.resolveAnnotationsWithArguments(scopeForAnnotationsResolve, typeParameter.getModifierList(), trace);
        TypeParameterDescriptorImpl typeParameterDescriptor = TypeParameterDescriptorImpl.createForFurtherModification(containingDescriptor, annotations2, typeParameter.hasModifier(KtTokens.REIFIED_KEYWORD), typeParameter.getVariance(), KtPsiUtil.safeName(typeParameter.getName()), index2, KotlinSourceElementKt.toSourceElement(typeParameter), (Function1<KotlinType, Void>)((Function1)type2 -> {
            if (!(containingDescriptor instanceof TypeAliasDescriptor)) {
                trace.report(Errors.CYCLIC_GENERIC_UPPER_BOUND.on(typeParameter));
            }
            return null;
        }), this.supertypeLoopsResolver);
        trace.record(BindingContext.TYPE_PARAMETER, typeParameter, typeParameterDescriptor);
        return typeParameterDescriptor;
    }

    @NotNull
    public static ClassConstructorDescriptorImpl createAndRecordPrimaryConstructorForObject(@Nullable KtPureClassOrObject object, @NotNull ClassDescriptor classDescriptor, @NotNull BindingTrace trace) {
        ClassConstructorDescriptorImpl constructorDescriptor = DescriptorFactory.createPrimaryConstructorForObject(classDescriptor, KotlinSourceElementKt.toSourceElement(object));
        if (object instanceof PsiElement) {
            KtPrimaryConstructor primaryConstructor2 = object.getPrimaryConstructor();
            trace.record(BindingContext.CONSTRUCTOR, primaryConstructor2 != null ? primaryConstructor2 : (PsiElement)object, constructorDescriptor);
        }
        return constructorDescriptor;
    }

    public void resolveGenericBounds(@NotNull KtTypeParameterListOwner declaration2, @NotNull DeclarationDescriptor descriptor2, LexicalScope scope2, List<TypeParameterDescriptorImpl> parameters2, BindingTrace trace) {
        ArrayList upperBoundCheckRequests = Lists.newArrayList();
        List<KtTypeParameter> typeParameters = declaration2.getTypeParameters();
        HashMap<Name, TypeParameterDescriptorImpl> parameterByName = new HashMap<Name, TypeParameterDescriptorImpl>();
        for (int i = 0; i < typeParameters.size(); ++i) {
            KtTypeParameter ktTypeParameter = typeParameters.get(i);
            TypeParameterDescriptorImpl typeParameterDescriptor = parameters2.get(i);
            parameterByName.put(typeParameterDescriptor.getName(), typeParameterDescriptor);
            KtTypeReference extendsBound = ktTypeParameter.getExtendsBound();
            if (extendsBound == null) continue;
            KotlinType type2 = this.typeResolver.resolveType(scope2, extendsBound, trace, false);
            typeParameterDescriptor.addUpperBound(type2);
            upperBoundCheckRequests.add(new UpperBoundCheckRequest(ktTypeParameter.getNameAsName(), extendsBound, type2));
        }
        for (KtTypeConstraint constraint : declaration2.getTypeConstraints()) {
            KtSimpleNameExpression subjectTypeParameterName = constraint.getSubjectTypeParameterName();
            if (subjectTypeParameterName == null) continue;
            Name referencedName = subjectTypeParameterName.getReferencedNameAsName();
            TypeParameterDescriptorImpl typeParameterDescriptor = (TypeParameterDescriptorImpl)parameterByName.get(referencedName);
            KtTypeReference boundTypeReference = constraint.getBoundTypeReference();
            KotlinType bound = null;
            if (boundTypeReference != null) {
                bound = this.typeResolver.resolveType(scope2, boundTypeReference, trace, false);
                upperBoundCheckRequests.add(new UpperBoundCheckRequest(referencedName, boundTypeReference, bound));
            }
            if (typeParameterDescriptor == null) continue;
            trace.record(BindingContext.REFERENCE_TARGET, subjectTypeParameterName, typeParameterDescriptor);
            if (bound == null) continue;
            typeParameterDescriptor.addUpperBound(bound);
        }
        for (TypeParameterDescriptorImpl parameter : parameters2) {
            parameter.addDefaultUpperBound();
            parameter.setInitialized();
        }
        for (TypeParameterDescriptorImpl parameter : parameters2) {
            DescriptorResolver.checkConflictingUpperBounds(trace, parameter, typeParameters.get(parameter.getIndex()));
        }
        if (!(declaration2 instanceof KtClass)) {
            DescriptorResolver.checkUpperBoundTypes(trace, upperBoundCheckRequests);
            this.checkNamesInConstraints(declaration2, descriptor2, scope2, trace);
        }
    }

    public static void checkUpperBoundTypes(@NotNull BindingTrace trace, @NotNull List<UpperBoundCheckRequest> requests) {
        if (requests.isEmpty()) {
            return;
        }
        HashSet<Name> classBoundEncountered = new HashSet<Name>();
        HashSet<Pair> allBounds = new HashSet<Pair>();
        for (UpperBoundCheckRequest request : requests) {
            Name typeParameterName = request.typeParameterName;
            KotlinType upperBound = request.upperBoundType;
            KtTypeReference upperBoundElement = request.upperBound;
            if (!KotlinTypeKt.isError(upperBound)) {
                if (!allBounds.add(new Pair((Object)typeParameterName, (Object)upperBound.getConstructor()))) {
                    trace.report(Errors.REPEATED_BOUND.on(upperBoundElement));
                } else {
                    ClassKind kind;
                    ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(upperBound);
                    if (!(classDescriptor == null || (kind = classDescriptor.getKind()) != ClassKind.CLASS && kind != ClassKind.ENUM_CLASS && kind != ClassKind.OBJECT || classBoundEncountered.add(typeParameterName))) {
                        trace.report(Errors.ONLY_ONE_CLASS_BOUND_ALLOWED.on(upperBoundElement));
                    }
                }
            }
            DescriptorResolver.checkUpperBoundType(upperBoundElement, upperBound, trace);
        }
    }

    public static void checkConflictingUpperBounds(@NotNull BindingTrace trace, @NotNull TypeParameterDescriptor parameter, @NotNull KtTypeParameter typeParameter) {
        if (KotlinBuiltIns.isNothing(TypeIntersector.getUpperBoundsAsType(parameter))) {
            trace.report(Errors.CONFLICTING_UPPER_BOUNDS.on(typeParameter, parameter));
        }
    }

    public void checkNamesInConstraints(@NotNull KtTypeParameterListOwner declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull LexicalScope scope2, @NotNull BindingTrace trace) {
        for (KtTypeConstraint constraint : declaration2.getTypeConstraints()) {
            KtTypeReference boundTypeReference;
            Name name2;
            ClassifierDescriptor classifier;
            KtSimpleNameExpression nameExpression2 = constraint.getSubjectTypeParameterName();
            if (nameExpression2 == null || (classifier = ScopeUtilsKt.findClassifier(scope2, name2 = nameExpression2.getReferencedNameAsName(), NoLookupLocation.FOR_NON_TRACKED_SCOPE)) instanceof TypeParameterDescriptor && classifier.getContainingDeclaration() == descriptor2) continue;
            if (classifier != null) {
                trace.report(Errors.NAME_IN_CONSTRAINT_IS_NOT_A_TYPE_PARAMETER.on(nameExpression2, constraint, declaration2));
                trace.record(BindingContext.REFERENCE_TARGET, nameExpression2, classifier);
            } else {
                trace.report(Errors.UNRESOLVED_REFERENCE.on(nameExpression2, nameExpression2));
            }
            if ((boundTypeReference = constraint.getBoundTypeReference()) == null) continue;
            this.typeResolver.resolveType(scope2, boundTypeReference, trace, true);
        }
    }

    public static void checkUpperBoundType(KtTypeReference upperBound, @NotNull KotlinType upperBoundType, BindingTrace trace) {
        if (!TypeUtils.canHaveSubtypes(KotlinTypeChecker.DEFAULT, upperBoundType)) {
            trace.report(Errors.FINAL_UPPER_BOUND.on(upperBound, upperBoundType));
        }
        if (DynamicTypesKt.isDynamic(upperBoundType)) {
            trace.report(Errors.DYNAMIC_UPPER_BOUND.on(upperBound));
        }
        if (FunctionTypesKt.isExtensionFunctionType(upperBoundType)) {
            trace.report(Errors.UPPER_BOUND_IS_EXTENSION_FUNCTION_TYPE.on(upperBound));
        }
    }

    @NotNull
    public VariableDescriptor resolveLocalVariableDescriptor(@NotNull LexicalScope scope2, @NotNull KtParameter parameter, BindingTrace trace) {
        KotlinType type2 = this.resolveParameterType(scope2, parameter, trace);
        return this.resolveLocalVariableDescriptor(parameter, type2, trace, scope2);
    }

    private KotlinType resolveParameterType(LexicalScope scope2, KtParameter parameter, BindingTrace trace) {
        KtTypeReference typeReference = parameter.getTypeReference();
        KotlinType type2 = typeReference != null ? this.typeResolver.resolveType(scope2, typeReference, trace, true) : ErrorUtils.createErrorType("Annotation is absent");
        if (parameter.hasModifier(KtTokens.VARARG_KEYWORD)) {
            return this.getVarargParameterType(type2);
        }
        return type2;
    }

    public VariableDescriptor resolveLocalVariableDescriptor(@NotNull KtParameter parameter, @NotNull KotlinType type2, BindingTrace trace, @NotNull LexicalScope scope2) {
        UnwrappedType approximatedType = this.typeApproximator.approximateDeclarationType(type2, true, this.languageVersionSettings);
        LocalVariableDescriptor variableDescriptor = new LocalVariableDescriptor(scope2.getOwnerDescriptor(), this.annotationResolver.resolveAnnotationsWithArguments(scope2, parameter.getModifierList(), trace), KtPsiUtil.safeName(parameter.getName()), approximatedType, KotlinSourceElementKt.toSourceElement(parameter));
        trace.record(BindingContext.VALUE_PARAMETER, parameter, variableDescriptor);
        ForceResolveUtil.forceResolveAllContents(type2.getAnnotations());
        return variableDescriptor;
    }

    @NotNull
    public TypeAliasDescriptor resolveTypeAliasDescriptor(@NotNull DeclarationDescriptor containingDeclaration2, @NotNull LexicalScope scope2, @NotNull KtTypeAlias typeAlias2, @NotNull BindingTrace trace) {
        List<TypeParameterDescriptorImpl> typeParameterDescriptors;
        LexicalScope scopeWithTypeParameters;
        if (!(containingDeclaration2 instanceof PackageFragmentDescriptor) && !(containingDeclaration2 instanceof ScriptDescriptor)) {
            trace.report(Errors.TOPLEVEL_TYPEALIASES_ONLY.on(typeAlias2));
        }
        KtModifierList modifierList = typeAlias2.getModifierList();
        Visibility visibility = ModifiersChecker.resolveVisibilityFromModifiers(typeAlias2, DescriptorResolver.getDefaultVisibility(typeAlias2, containingDeclaration2));
        Annotations allAnnotations = this.annotationResolver.resolveAnnotationsWithArguments(scope2, modifierList, trace);
        Name name2 = KtPsiUtil.safeName(typeAlias2.getName());
        SourceElement sourceElement = KotlinSourceElementKt.toSourceElement(typeAlias2);
        LazyTypeAliasDescriptor typeAliasDescriptor = LazyTypeAliasDescriptor.create(this.storageManager, trace, containingDeclaration2, allAnnotations, name2, sourceElement, visibility);
        List<KtTypeParameter> typeParameters = typeAlias2.getTypeParameters();
        if (typeParameters.isEmpty()) {
            scopeWithTypeParameters = scope2;
            typeParameterDescriptors = Collections.emptyList();
        } else {
            LexicalWritableScope writableScope = new LexicalWritableScope(scope2, containingDeclaration2, false, new TraceBasedLocalRedeclarationChecker(trace, this.overloadChecker), LexicalScopeKind.TYPE_ALIAS_HEADER);
            typeParameterDescriptors = this.resolveTypeParametersForDescriptor(typeAliasDescriptor, writableScope, scope2, typeParameters, trace);
            writableScope.freeze();
            DescriptorResolver.checkNoGenericBoundsOnTypeAliasParameters(typeAlias2, trace);
            this.resolveGenericBounds(typeAlias2, typeAliasDescriptor, writableScope, typeParameterDescriptors, trace);
            scopeWithTypeParameters = writableScope;
        }
        KtTypeReference typeReference = typeAlias2.getTypeReference();
        if (typeReference == null) {
            typeAliasDescriptor.initialize(typeParameterDescriptors, ErrorUtils.createErrorType(name2.asString()), ErrorUtils.createErrorType(name2.asString()));
        } else if (!this.languageVersionSettings.supportsFeature(LanguageFeature.TypeAliases)) {
            this.typeResolver.resolveAbbreviatedType(scopeWithTypeParameters, typeReference, trace);
            PsiElement typeAliasKeyword = typeAlias2.getTypeAliasKeyword();
            trace.report(Errors.UNSUPPORTED_FEATURE.on((PsiElement)(typeAliasKeyword != null ? typeAliasKeyword : typeAlias2), (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.TypeAliases), (Object)this.languageVersionSettings)));
            typeAliasDescriptor.initialize(typeParameterDescriptors, ErrorUtils.createErrorType(name2.asString()), ErrorUtils.createErrorType(name2.asString()));
        } else {
            typeAliasDescriptor.initialize(typeParameterDescriptors, this.storageManager.createRecursionTolerantLazyValue(() -> this.typeResolver.resolveAbbreviatedType(scopeWithTypeParameters, typeReference, trace), ErrorUtils.createErrorType("Recursive type alias expansion for " + typeAliasDescriptor.getName().asString())), this.storageManager.createRecursionTolerantLazyValue(() -> this.typeResolver.resolveExpandedTypeForTypeAlias(typeAliasDescriptor), ErrorUtils.createErrorType("Recursive type alias expansion for " + typeAliasDescriptor.getName().asString())));
        }
        trace.record(BindingContext.TYPE_ALIAS, typeAlias2, typeAliasDescriptor);
        return typeAliasDescriptor;
    }

    private static void checkNoGenericBoundsOnTypeAliasParameters(@NotNull KtTypeAlias typeAlias2, @NotNull BindingTrace trace) {
        for (KtTypeParameter typeParameter : typeAlias2.getTypeParameters()) {
            KtTypeReference bound = typeParameter.getExtendsBound();
            if (bound == null) continue;
            trace.report(Errors.BOUND_ON_TYPE_ALIAS_PARAMETER_NOT_ALLOWED.on(bound));
        }
    }

    @NotNull
    public PropertyDescriptor resolveDestructuringDeclarationEntryAsProperty(@NotNull DeclarationDescriptor containingDeclaration2, @NotNull LexicalScope scopeForDeclarationResolution, @NotNull LexicalScope scopeForInitializerResolution2, @NotNull KtDestructuringDeclarationEntry entry, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo) {
        KtDestructuringDeclaration destructuringDeclaration = (KtDestructuringDeclaration)entry.getParent();
        KtExpression initializer2 = destructuringDeclaration.getInitializer();
        ExpressionTypingContext context2 = ExpressionTypingContext.newContext(trace, scopeForDeclarationResolution, dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE, this.languageVersionSettings, this.dataFlowValueFactory);
        ExpressionReceiver receiver = this.createReceiverForDestructuringDeclaration(destructuringDeclaration, context2);
        int componentIndex = destructuringDeclaration.getEntries().indexOf(entry);
        KotlinType componentType = this.destructuringDeclarationResolver.resolveInitializer(entry, receiver, initializer2, context2, componentIndex);
        return this.resolveAsPropertyDescriptor(containingDeclaration2, scopeForDeclarationResolution, scopeForInitializerResolution2, entry, trace, dataFlowInfo, VariableAsPropertyInfo.Companion.createFromDestructuringDeclarationEntry(componentType));
    }

    private ExpressionReceiver createReceiverForDestructuringDeclaration(@NotNull KtDestructuringDeclaration destructuringDeclaration, @NotNull ExpressionTypingContext context2) {
        KtExpression initializer2 = destructuringDeclaration.getInitializer();
        if (initializer2 == null) {
            return null;
        }
        KotlinType initializerType = this.expressionTypingServices.getTypeInfo(initializer2, context2).getType();
        if (initializerType == null) {
            return null;
        }
        return ExpressionReceiver.Companion.create(initializer2, initializerType, context2.trace.getBindingContext());
    }

    @NotNull
    public PropertyDescriptor resolvePropertyDescriptor(@NotNull DeclarationDescriptor containingDeclaration2, @NotNull LexicalScope scopeForDeclarationResolution, @NotNull LexicalScope scopeForInitializerResolution2, @NotNull KtProperty property, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo) {
        return this.resolveAsPropertyDescriptor(containingDeclaration2, scopeForDeclarationResolution, scopeForInitializerResolution2, property, trace, dataFlowInfo, VariableAsPropertyInfo.Companion.createFromProperty(property));
    }

    @NotNull
    private PropertyDescriptor resolveAsPropertyDescriptor(@NotNull DeclarationDescriptor container2, @NotNull LexicalScope scopeForDeclarationResolution, @NotNull LexicalScope scopeForInitializerResolution2, @NotNull KtVariableDeclaration variableDeclaration, @NotNull BindingTrace trace, @NotNull DataFlowInfo dataFlowInfo, @NotNull VariableAsPropertyInfo propertyInfo) {
        KotlinType type2;
        List<Object> typeParameterDescriptors;
        LexicalScope scopeForInitializerResolutionWithTypeParameters;
        LexicalScope scopeForDeclarationResolutionWithTypeParameters;
        KtModifierList modifierList = variableDeclaration.getModifierList();
        boolean isVar = variableDeclaration.isVar();
        Visibility visibility = ModifiersChecker.resolveVisibilityFromModifiers(variableDeclaration, DescriptorResolver.getDefaultVisibility(variableDeclaration, container2));
        Modality modality = container2 instanceof ClassDescriptor ? ModifiersChecker.resolveMemberModalityFromModifiers(variableDeclaration, DescriptorResolver.getDefaultModality(container2, visibility, propertyInfo.getHasBody()), trace.getBindingContext(), container2) : Modality.FINAL;
        AnnotationSplitter.PropertyWrapper wrapper = new AnnotationSplitter.PropertyWrapper(variableDeclaration);
        Annotations allAnnotations = this.annotationResolver.resolveAnnotationsWithoutArguments(scopeForDeclarationResolution, modifierList, trace);
        AnnotationSplitter annotationSplitter = new AnnotationSplitter(this.storageManager, allAnnotations, (Function0<? extends Set<? extends AnnotationUseSiteTarget>>)((Function0)() -> AnnotationSplitter.getTargetSet(false, trace.getBindingContext(), wrapper)));
        CompositeAnnotations propertyAnnotations = new CompositeAnnotations(CollectionsKt.listOf((Object[])new Annotations[]{annotationSplitter.getAnnotationsForTargets(AnnotationUseSiteTarget.PROPERTY, AnnotationUseSiteTarget.FIELD, AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD), annotationSplitter.getOtherAnnotations()}));
        PropertyDescriptorImpl propertyDescriptor = PropertyDescriptorImpl.create(container2, propertyAnnotations, modality, visibility, isVar, KtPsiUtil.safeName(variableDeclaration.getName()), CallableMemberDescriptor.Kind.DECLARATION, KotlinSourceElementKt.toSourceElement(variableDeclaration), modifierList != null && modifierList.hasModifier(KtTokens.LATEINIT_KEYWORD), modifierList != null && modifierList.hasModifier(KtTokens.CONST_KEYWORD), modifierList != null && PsiUtilsKt.hasExpectModifier(modifierList) && container2 instanceof PackageFragmentDescriptor || container2 instanceof ClassDescriptor && ((ClassDescriptor)container2).isExpect(), modifierList != null && PsiUtilsKt.hasActualModifier(modifierList), modifierList != null && modifierList.hasModifier(KtTokens.EXTERNAL_KEYWORD), propertyInfo.getHasDelegate());
        wrapper.setDescriptor(propertyDescriptor);
        KotlinType receiverType2 = null;
        List typeParameters = variableDeclaration.getTypeParameters();
        if (typeParameters.isEmpty()) {
            scopeForDeclarationResolutionWithTypeParameters = scopeForDeclarationResolution;
            scopeForInitializerResolutionWithTypeParameters = scopeForInitializerResolution2;
            typeParameterDescriptors = Collections.emptyList();
        } else {
            LexicalWritableScope writableScopeForDeclarationResolution = new LexicalWritableScope(scopeForDeclarationResolution, container2, false, new TraceBasedLocalRedeclarationChecker(trace, this.overloadChecker), LexicalScopeKind.PROPERTY_HEADER);
            LexicalWritableScope writableScopeForInitializerResolution = new LexicalWritableScope(scopeForInitializerResolution2, container2, false, LocalRedeclarationChecker.DO_NOTHING.INSTANCE, LexicalScopeKind.PROPERTY_HEADER);
            typeParameterDescriptors = this.resolveTypeParametersForDescriptor(propertyDescriptor, scopeForDeclarationResolution, typeParameters, trace);
            for (TypeParameterDescriptor typeParameterDescriptor : typeParameterDescriptors) {
                writableScopeForDeclarationResolution.addClassifierDescriptor(typeParameterDescriptor);
                writableScopeForInitializerResolution.addClassifierDescriptor(typeParameterDescriptor);
            }
            writableScopeForDeclarationResolution.freeze();
            writableScopeForInitializerResolution.freeze();
            this.resolveGenericBounds(variableDeclaration, propertyDescriptor, writableScopeForDeclarationResolution, typeParameterDescriptors, trace);
            scopeForDeclarationResolutionWithTypeParameters = writableScopeForDeclarationResolution;
            scopeForInitializerResolutionWithTypeParameters = writableScopeForInitializerResolution;
        }
        KtTypeReference receiverTypeRef = variableDeclaration.getReceiverTypeReference();
        if (receiverTypeRef != null) {
            receiverType2 = this.typeResolver.resolveType(scopeForDeclarationResolutionWithTypeParameters, receiverTypeRef, trace, true);
        }
        ReceiverParameterDescriptor receiverDescriptor = DescriptorFactory.createExtensionReceiverParameterForCallable(propertyDescriptor, receiverType2);
        LexicalScope scopeForInitializer = ScopeUtils.makeScopeForPropertyInitializer(scopeForInitializerResolutionWithTypeParameters, propertyDescriptor);
        KotlinType propertyType = propertyInfo.getVariableType();
        KotlinType typeIfKnown = propertyType != null ? propertyType : this.variableTypeAndInitializerResolver.resolveTypeNullable(propertyDescriptor, scopeForInitializer, variableDeclaration, dataFlowInfo, trace, false);
        PropertyGetterDescriptorImpl propertyGetterDescriptorImpl = this.resolvePropertyGetterDescriptor(scopeForDeclarationResolutionWithTypeParameters, variableDeclaration, propertyDescriptor, annotationSplitter, trace, typeIfKnown, propertyInfo.getPropertyGetter(), propertyInfo.getHasDelegate());
        KotlinType kotlinType = type2 = typeIfKnown != null ? typeIfKnown : propertyGetterDescriptorImpl.getReturnType();
        assert (type2 != null) : "At least getter type must be initialized via resolvePropertyGetterDescriptor";
        this.variableTypeAndInitializerResolver.setConstantForVariableIfNeeded(propertyDescriptor, scopeForInitializer, variableDeclaration, dataFlowInfo, type2, trace);
        propertyDescriptor.setType(type2, typeParameterDescriptors, DescriptorUtils.getDispatchReceiverParameterIfNeeded(container2), receiverDescriptor);
        PropertySetterDescriptor setter = this.resolvePropertySetterDescriptor(scopeForDeclarationResolutionWithTypeParameters, variableDeclaration, propertyDescriptor, annotationSplitter, trace, propertyInfo.getPropertySetter(), propertyInfo.getHasDelegate());
        propertyDescriptor.initialize(propertyGetterDescriptorImpl, setter);
        trace.record(BindingContext.VARIABLE, variableDeclaration, propertyDescriptor);
        return propertyDescriptor;
    }

    @NotNull
    static KotlinType transformAnonymousTypeIfNeeded(@NotNull DeclarationDescriptorWithVisibility descriptor2, @NotNull KtDeclaration declaration2, @NotNull KotlinType type2, @NotNull BindingTrace trace) {
        ClassifierDescriptor classifier = type2.getConstructor().getDeclarationDescriptor();
        if (classifier == null || !DescriptorUtils.isAnonymousObject(classifier) || DescriptorUtils.isLocal(descriptor2)) {
            return type2;
        }
        if (!Visibilities.isPrivate(descriptor2.getVisibility())) {
            if (type2.getConstructor().getSupertypes().size() == 1) {
                return type2.getConstructor().getSupertypes().iterator().next();
            }
            trace.report(Errors.AMBIGUOUS_ANONYMOUS_TYPE_INFERRED.on(declaration2, type2.getConstructor().getSupertypes()));
        }
        return type2;
    }

    @Nullable
    private PropertySetterDescriptor resolvePropertySetterDescriptor(@NotNull LexicalScope scopeWithTypeParameters, @NotNull KtVariableDeclaration property, @NotNull PropertyDescriptor propertyDescriptor, @NotNull AnnotationSplitter annotationSplitter, @NotNull BindingTrace trace, @Nullable KtPropertyAccessor setter, boolean hasDelegate) {
        PropertySetterDescriptorImpl setterDescriptor = null;
        if (setter != null) {
            KotlinType returnType2;
            CompositeAnnotations annotations2 = new CompositeAnnotations(CollectionsKt.listOf((Object[])new Annotations[]{annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_SETTER), this.annotationResolver.resolveAnnotationsWithoutArguments(scopeWithTypeParameters, setter.getModifierList(), trace)}));
            KtParameter parameter = setter.getParameter();
            setterDescriptor = new PropertySetterDescriptorImpl(propertyDescriptor, annotations2, ModifiersChecker.resolveMemberModalityFromModifiers(setter, propertyDescriptor.getModality(), trace.getBindingContext(), propertyDescriptor.getContainingDeclaration()), ModifiersChecker.resolveVisibilityFromModifiers(setter, propertyDescriptor.getVisibility()), false, setter.hasModifier(KtTokens.EXTERNAL_KEYWORD), property.hasModifier(KtTokens.INLINE_KEYWORD) || setter.hasModifier(KtTokens.INLINE_KEYWORD), CallableMemberDescriptor.Kind.DECLARATION, null, KotlinSourceElementKt.toSourceElement(setter));
            KtTypeReference returnTypeReference = setter.getReturnTypeReference();
            if (returnTypeReference != null && !KotlinBuiltIns.isUnit(returnType2 = this.typeResolver.resolveType(scopeWithTypeParameters, returnTypeReference, trace, true))) {
                trace.report(Errors.WRONG_SETTER_RETURN_TYPE.on(returnTypeReference));
            }
            if (parameter != null) {
                KotlinType type2;
                KtTypeReference typeReference;
                if (parameter.hasDefaultValue()) {
                    trace.report(Errors.SETTER_PARAMETER_WITH_DEFAULT_VALUE.on(parameter.getDefaultValue()));
                }
                if ((typeReference = parameter.getTypeReference()) == null) {
                    type2 = propertyDescriptor.getType();
                } else {
                    KotlinType inType;
                    type2 = this.typeResolver.resolveType(scopeWithTypeParameters, typeReference, trace, true);
                    if (!TypeUtils.equalTypes(type2, inType = propertyDescriptor.getType())) {
                        trace.report(Errors.WRONG_SETTER_PARAMETER_TYPE.on(typeReference, inType, type2));
                    }
                }
                ValueParameterDescriptorImpl valueParameterDescriptor = this.resolveValueParameterDescriptor(scopeWithTypeParameters, setterDescriptor, parameter, 0, type2, trace);
                setterDescriptor.initialize(valueParameterDescriptor);
            } else {
                setterDescriptor.initializeDefault();
            }
            trace.record(BindingContext.PROPERTY_ACCESSOR, setter, setterDescriptor);
        } else if (property.isVar()) {
            Annotations setterAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_SETTER);
            setterDescriptor = DescriptorFactory.createSetter(propertyDescriptor, setterAnnotations, !hasDelegate, false, property.hasModifier(KtTokens.INLINE_KEYWORD), propertyDescriptor.getSource());
        }
        if (!property.isVar() && setter != null) {
            trace.report(Errors.VAL_WITH_SETTER.on(setter));
        }
        return setterDescriptor;
    }

    @NotNull
    private PropertyGetterDescriptorImpl resolvePropertyGetterDescriptor(@NotNull LexicalScope scopeForDeclarationResolution, @NotNull KtVariableDeclaration property, @NotNull PropertyDescriptor propertyDescriptor, @NotNull AnnotationSplitter annotationSplitter, @NotNull BindingTrace trace, @Nullable KotlinType propertyTypeIfKnown, @Nullable KtPropertyAccessor getter, boolean hasDelegate) {
        KotlinType getterType;
        PropertyGetterDescriptorImpl getterDescriptor;
        if (getter != null) {
            CompositeAnnotations getterAnnotations = new CompositeAnnotations(CollectionsKt.listOf((Object[])new Annotations[]{annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_GETTER), this.annotationResolver.resolveAnnotationsWithoutArguments(scopeForDeclarationResolution, getter.getModifierList(), trace)}));
            getterDescriptor = new PropertyGetterDescriptorImpl(propertyDescriptor, getterAnnotations, ModifiersChecker.resolveMemberModalityFromModifiers(getter, propertyDescriptor.getModality(), trace.getBindingContext(), propertyDescriptor.getContainingDeclaration()), ModifiersChecker.resolveVisibilityFromModifiers(getter, propertyDescriptor.getVisibility()), false, getter.hasModifier(KtTokens.EXTERNAL_KEYWORD), property.hasModifier(KtTokens.INLINE_KEYWORD) || getter.hasModifier(KtTokens.INLINE_KEYWORD), CallableMemberDescriptor.Kind.DECLARATION, null, KotlinSourceElementKt.toSourceElement(getter));
            getterType = this.determineGetterReturnType(scopeForDeclarationResolution, trace, getterDescriptor, getter, propertyTypeIfKnown);
            trace.record(BindingContext.PROPERTY_ACCESSOR, getter, getterDescriptor);
        } else {
            Annotations getterAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_GETTER);
            getterDescriptor = DescriptorFactory.createGetter(propertyDescriptor, getterAnnotations, !hasDelegate, false, property.hasModifier(KtTokens.INLINE_KEYWORD));
            getterType = propertyTypeIfKnown;
        }
        getterDescriptor.initialize(getterType != null ? getterType : VariableTypeAndInitializerResolver.STUB_FOR_PROPERTY_WITHOUT_TYPE);
        return getterDescriptor;
    }

    @Nullable
    private KotlinType determineGetterReturnType(@NotNull LexicalScope scope2, @NotNull BindingTrace trace, @NotNull PropertyGetterDescriptor getterDescriptor, @NotNull KtPropertyAccessor getter, @Nullable KotlinType propertyTypeIfKnown) {
        KtTypeReference returnTypeReference = getter.getReturnTypeReference();
        if (returnTypeReference != null) {
            KotlinType explicitReturnType = this.typeResolver.resolveType(scope2, returnTypeReference, trace, true);
            if (propertyTypeIfKnown != null && !TypeUtils.equalTypes(explicitReturnType, propertyTypeIfKnown)) {
                trace.report(Errors.WRONG_GETTER_RETURN_TYPE.on(returnTypeReference, propertyTypeIfKnown, explicitReturnType));
            }
            return explicitReturnType;
        }
        KtProperty property = getter.getProperty();
        if (!property.hasDelegateExpressionOrInitializer() && property.getTypeReference() == null && getter.hasBody() && !getter.hasBlockBody()) {
            return this.inferReturnTypeFromExpressionBody(trace, scope2, DataFlowInfoFactory.EMPTY, getter, getterDescriptor);
        }
        return propertyTypeIfKnown;
    }

    @NotNull
    KotlinType inferReturnTypeFromExpressionBody(@NotNull BindingTrace trace, @NotNull LexicalScope scope2, @NotNull DataFlowInfo dataFlowInfo, @NotNull KtDeclarationWithBody function2, @NotNull FunctionDescriptor functionDescriptor2) {
        return this.wrappedTypeFactory.createRecursionIntolerantDeferredType(trace, (Function0<? extends KotlinType>)((Function0)() -> {
            PreliminaryDeclarationVisitor.Companion.createForDeclaration(function2, trace, this.languageVersionSettings);
            KotlinType type2 = this.expressionTypingServices.getBodyExpressionType(trace, scope2, dataFlowInfo, function2, functionDescriptor2);
            KotlinType publicType = DescriptorResolver.transformAnonymousTypeIfNeeded(functionDescriptor2, function2, type2, trace);
            UnwrappedType approximatedType = this.typeApproximator.approximateDeclarationType(publicType, false, this.languageVersionSettings);
            UnwrappedType sanitizedType = this.declarationReturnTypeSanitizer.sanitizeReturnType(approximatedType, this.wrappedTypeFactory, trace, this.languageVersionSettings);
            this.functionsTypingVisitor.checkTypesForReturnStatements(function2, trace, sanitizedType);
            return sanitizedType;
        }));
    }

    @NotNull
    public PropertyDescriptor resolvePrimaryConstructorParameterToAProperty(@NotNull ClassDescriptor classDescriptor, @NotNull ValueParameterDescriptor valueParameter, @NotNull LexicalScope scope2, @NotNull KtParameter parameter, BindingTrace trace) {
        KotlinType type2 = this.resolveParameterType(scope2, parameter, trace);
        Name name2 = parameter.getNameAsSafeName();
        boolean isMutable = parameter.isMutable();
        KtModifierList modifierList = parameter.getModifierList();
        if (modifierList != null && modifierList.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
            trace.report(Errors.ABSTRACT_PROPERTY_IN_PRIMARY_CONSTRUCTOR_PARAMETERS.on(parameter));
        }
        AnnotationSplitter.PropertyWrapper propertyWrapper = new AnnotationSplitter.PropertyWrapper(parameter);
        Annotations allAnnotations = this.annotationResolver.resolveAnnotationsWithoutArguments(scope2, parameter.getModifierList(), trace);
        AnnotationSplitter annotationSplitter = new AnnotationSplitter(this.storageManager, allAnnotations, (Function0<? extends Set<? extends AnnotationUseSiteTarget>>)((Function0)() -> AnnotationSplitter.getTargetSet(true, trace.getBindingContext(), propertyWrapper)));
        CompositeAnnotations propertyAnnotations = new CompositeAnnotations(annotationSplitter.getAnnotationsForTargets(AnnotationUseSiteTarget.PROPERTY, AnnotationUseSiteTarget.FIELD), annotationSplitter.getOtherAnnotations());
        PropertyDescriptorImpl propertyDescriptor = PropertyDescriptorImpl.create(classDescriptor, propertyAnnotations, ModifiersChecker.resolveMemberModalityFromModifiers(parameter, Modality.FINAL, trace.getBindingContext(), classDescriptor), ModifiersChecker.resolveVisibilityFromModifiers(parameter, DescriptorResolver.getDefaultVisibility(parameter, classDescriptor)), isMutable, name2, CallableMemberDescriptor.Kind.DECLARATION, KotlinSourceElementKt.toSourceElement(parameter), false, false, classDescriptor.isExpect(), modifierList != null && PsiUtilsKt.hasActualModifier(modifierList), false, false);
        propertyWrapper.setDescriptor(propertyDescriptor);
        propertyDescriptor.setType(type2, Collections.emptyList(), DescriptorUtils.getDispatchReceiverParameterIfNeeded(classDescriptor), (ReceiverParameterDescriptor)null);
        Annotations setterAnnotations = annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_SETTER);
        CompositeAnnotations getterAnnotations = new CompositeAnnotations(CollectionsKt.listOf((Object)annotationSplitter.getAnnotationsForTarget(AnnotationUseSiteTarget.PROPERTY_GETTER)));
        PropertyGetterDescriptorImpl getter = DescriptorFactory.createDefaultGetter(propertyDescriptor, getterAnnotations);
        PropertySetterDescriptorImpl setter = propertyDescriptor.isVar() ? DescriptorFactory.createDefaultSetter(propertyDescriptor, setterAnnotations) : null;
        propertyDescriptor.initialize(getter, setter);
        getter.initialize(propertyDescriptor.getType());
        trace.record(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter, propertyDescriptor);
        trace.record(BindingContext.VALUE_PARAMETER_AS_PROPERTY, valueParameter, propertyDescriptor);
        return propertyDescriptor;
    }

    public static void checkBounds(@NotNull KtTypeReference typeReference, @NotNull KotlinType type2, @NotNull BindingTrace trace) {
        if (KotlinTypeKt.isError(type2)) {
            return;
        }
        KtTypeElement typeElement = typeReference.getTypeElement();
        if (typeElement == null) {
            return;
        }
        List<TypeParameterDescriptor> parameters2 = type2.getConstructor().getParameters();
        List<TypeProjection> arguments2 = type2.getArguments();
        assert (parameters2.size() == arguments2.size());
        List<KtTypeReference> ktTypeArguments = typeElement.getTypeArgumentsAsTypes();
        if (FlexibleTypesKt.isFlexible(type2) && !DynamicTypesKt.isDynamic(type2)) {
            assert (ktTypeArguments.size() == 2) : "Flexible type cannot be denoted in Kotlin otherwise than as ft<T1, T2>, but was: " + PsiUtilsKt.getElementTextWithContext(typeReference);
            FlexibleType flexibleType = FlexibleTypesKt.asFlexibleType(type2);
            DescriptorResolver.checkBounds(ktTypeArguments.get(0), flexibleType.getLowerBound(), trace);
            DescriptorResolver.checkBounds(ktTypeArguments.get(1), flexibleType.getUpperBound(), trace);
            return;
        }
        if (ktTypeArguments.size() != arguments2.size()) {
            return;
        }
        TypeSubstitutor substitutor3 = TypeSubstitutor.create(type2);
        for (int i = 0; i < ktTypeArguments.size(); ++i) {
            KtTypeReference ktTypeArgument = ktTypeArguments.get(i);
            if (ktTypeArgument == null) continue;
            KotlinType typeArgument = arguments2.get(i).getType();
            DescriptorResolver.checkBounds(ktTypeArgument, typeArgument, trace);
            TypeParameterDescriptor typeParameterDescriptor = parameters2.get(i);
            DescriptorResolver.checkBounds(ktTypeArgument, typeArgument, typeParameterDescriptor, substitutor3, trace);
        }
    }

    public static void checkBounds(@NotNull KtTypeReference jetTypeArgument, @NotNull KotlinType typeArgument, @NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull TypeSubstitutor substitutor3, @NotNull BindingTrace trace) {
        for (KotlinType bound : typeParameterDescriptor.getUpperBounds()) {
            KotlinType substitutedBound = substitutor3.safeSubstitute(bound, Variance.INVARIANT);
            if (KotlinTypeChecker.DEFAULT.isSubtypeOf(typeArgument, substitutedBound)) continue;
            trace.report(Errors.UPPER_BOUND_VIOLATED.on(jetTypeArgument, substitutedBound, typeArgument));
        }
    }

    public static void checkBoundsInTypeAlias(@NotNull TypeAliasExpansionReportStrategy reportStrategy, @NotNull KotlinType unsubstitutedArgument, @NotNull KotlinType typeArgument, @NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull TypeSubstitutor substitutor3) {
        for (KotlinType bound : typeParameterDescriptor.getUpperBounds()) {
            KotlinType substitutedBound = substitutor3.safeSubstitute(bound, Variance.INVARIANT);
            if (KotlinTypeChecker.DEFAULT.isSubtypeOf(typeArgument, substitutedBound)) continue;
            reportStrategy.boundsViolationInSubstitution(substitutedBound, unsubstitutedArgument, typeArgument, typeParameterDescriptor);
        }
    }

    public static boolean checkHasOuterClassInstance(@NotNull LexicalScope scope2, @NotNull BindingTrace trace, @NotNull PsiElement reportErrorsOn, @NotNull ClassDescriptor target) {
        ClassDescriptor classDescriptor = DescriptorResolver.getContainingClass(scope2);
        if (!DescriptorResolver.isInsideOuterClassOrItsSubclass(classDescriptor, target)) {
            return true;
        }
        while (classDescriptor != null) {
            if (DescriptorUtils.isSubclass(classDescriptor, target)) {
                return true;
            }
            if (DescriptorUtils.isStaticNestedClass(classDescriptor)) {
                trace.report(Errors.INACCESSIBLE_OUTER_CLASS_EXPRESSION.on(reportErrorsOn, classDescriptor));
                return false;
            }
            classDescriptor = DescriptorUtils.getParentOfType(classDescriptor, ClassDescriptor.class, true);
        }
        return true;
    }

    private static boolean isInsideOuterClassOrItsSubclass(@Nullable DeclarationDescriptor nested, @NotNull ClassDescriptor outer) {
        if (nested == null) {
            return false;
        }
        if (nested instanceof ClassDescriptor && DescriptorUtils.isSubclass((ClassDescriptor)nested, outer)) {
            return true;
        }
        return DescriptorResolver.isInsideOuterClassOrItsSubclass(nested.getContainingDeclaration(), outer);
    }

    @Nullable
    public static ClassDescriptor getContainingClass(@NotNull LexicalScope scope2) {
        return DescriptorUtils.getParentOfType(scope2.getOwnerDescriptor(), ClassDescriptor.class, false);
    }

    static final class UpperBoundCheckRequest {
        public final Name typeParameterName;
        public final KtTypeReference upperBound;
        public final KotlinType upperBoundType;

        UpperBoundCheckRequest(Name typeParameterName, KtTypeReference upperBound, KotlinType upperBoundType) {
            this.typeParameterName = typeParameterName;
            this.upperBound = upperBound;
            this.upperBoundType = upperBoundType;
        }
    }
}

