/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.FilePreprocessorExtension;
import org.jetbrains.kotlin.resolve.FilePreprocessorKt;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/FilePreprocessor;", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "extensions", "", "Lorg/jetbrains/kotlin/resolve/FilePreprocessorExtension;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Ljava/lang/Iterable;)V", "preprocessFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "registerFileByPackage", "frontend"})
public final class FilePreprocessor {
    private final BindingTrace trace;
    private final Iterable<FilePreprocessorExtension> extensions;

    public final void preprocessFile(@NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.registerFileByPackage(file);
        for (FilePreprocessorExtension extension : this.extensions) {
            extension.preprocessFile(file);
        }
    }

    private final void registerFileByPackage(KtFile file) {
        WritableSlice<FqName, Collection<KtFile>> writableSlice = BindingContext.PACKAGE_TO_FILES;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, (String)"PACKAGE_TO_FILES");
        FilePreprocessorKt.addElementToSlice(this.trace, writableSlice, file.getPackageFqName(), file);
    }

    public FilePreprocessor(@NotNull BindingTrace trace, @NotNull Iterable<? extends FilePreprocessorExtension> extensions) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull(extensions, (String)"extensions");
        this.trace = trace;
        this.extensions = extensions;
    }
}

