/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderImplKt;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.FunctionPlaceholders;
import org.jetbrains.kotlin.types.FunctionPlaceholdersKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.DoubleColonExpressionResolver;
import org.jetbrains.kotlin.types.expressions.DoubleColonLHS;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

public class ArgumentTypeResolver {
    @NotNull
    private final TypeResolver typeResolver;
    @NotNull
    private final DoubleColonExpressionResolver doubleColonExpressionResolver;
    @NotNull
    private final KotlinBuiltIns builtIns;
    @NotNull
    private final ReflectionTypes reflectionTypes;
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    @NotNull
    private final FunctionPlaceholders functionPlaceholders;
    private ExpressionTypingServices expressionTypingServices;

    public ArgumentTypeResolver(@NotNull TypeResolver typeResolver, @NotNull DoubleColonExpressionResolver doubleColonExpressionResolver, @NotNull KotlinBuiltIns builtIns, @NotNull ReflectionTypes reflectionTypes2, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull FunctionPlaceholders functionPlaceholders) {
        this.typeResolver = typeResolver;
        this.doubleColonExpressionResolver = doubleColonExpressionResolver;
        this.builtIns = builtIns;
        this.reflectionTypes = reflectionTypes2;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.functionPlaceholders = functionPlaceholders;
    }

    @Inject
    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        this.expressionTypingServices = expressionTypingServices;
    }

    public static boolean isSubtypeOfForArgumentType(@NotNull KotlinType actualType, @NotNull KotlinType expectedType) {
        if (FunctionPlaceholdersKt.isFunctionPlaceholder(actualType)) {
            KotlinType functionType2 = ConstraintSystemBuilderImplKt.createTypeForFunctionPlaceholder(actualType, expectedType);
            return KotlinTypeChecker.DEFAULT.isSubtypeOf(functionType2, expectedType);
        }
        return KotlinTypeChecker.DEFAULT.isSubtypeOf(actualType, expectedType);
    }

    public void checkTypesWithNoCallee(@NotNull CallResolutionContext<?> context2) {
        if (context2.checkArguments != CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS) {
            return;
        }
        for (ValueArgument valueArgument : context2.call.getValueArguments()) {
            KtExpression argumentExpression2 = valueArgument.getArgumentExpression();
            if (argumentExpression2 == null || argumentExpression2 instanceof KtLambdaExpression) continue;
            this.checkArgumentTypeWithNoCallee(context2, argumentExpression2);
        }
        this.checkTypesForFunctionArgumentsWithNoCallee(context2);
        for (KtTypeProjection ktTypeProjection : context2.call.getTypeArguments()) {
            KtTypeReference typeReference = ktTypeProjection.getTypeReference();
            if (typeReference == null) {
                context2.trace.report(Errors.PROJECTION_ON_NON_CLASS_TYPE_ARGUMENT.on(ktTypeProjection));
                continue;
            }
            this.typeResolver.resolveType(context2.scope, typeReference, context2.trace, true);
        }
    }

    private void checkTypesForFunctionArgumentsWithNoCallee(@NotNull CallResolutionContext<?> context2) {
        if (context2.checkArguments != CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS) {
            return;
        }
        for (ValueArgument valueArgument : context2.call.getValueArguments()) {
            KtExpression argumentExpression2 = valueArgument.getArgumentExpression();
            if (argumentExpression2 == null || !ArgumentTypeResolver.isFunctionLiteralArgument(argumentExpression2, context2)) continue;
            this.checkArgumentTypeWithNoCallee(context2, argumentExpression2);
        }
    }

    private void checkArgumentTypeWithNoCallee(CallResolutionContext<?> context2, KtExpression argumentExpression2) {
        this.expressionTypingServices.getTypeInfo(argumentExpression2, (ResolutionContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE));
        this.updateResultArgumentTypeIfNotDenotable(context2, argumentExpression2);
    }

    public static boolean isFunctionLiteralArgument(@NotNull KtExpression expression2, @NotNull ResolutionContext context2) {
        return ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression2, context2) != null;
    }

    public static boolean isCallableReferenceArgument(@NotNull KtExpression expression2, @NotNull ResolutionContext context2) {
        return ArgumentTypeResolver.getCallableReferenceExpressionIfAny(expression2, context2) != null;
    }

    public static boolean isFunctionLiteralOrCallableReference(@NotNull KtExpression expression2, @NotNull ResolutionContext context2) {
        return ArgumentTypeResolver.isFunctionLiteralArgument(expression2, context2) || ArgumentTypeResolver.isCallableReferenceArgument(expression2, context2);
    }

    @Nullable
    public static KtFunction getFunctionLiteralArgumentIfAny(@NotNull KtExpression expression2, @NotNull ResolutionContext context2) {
        KtExpression deparenthesizedExpression = KtPsiUtil.getLastElementDeparenthesized(expression2, context2.statementFilter);
        if (deparenthesizedExpression instanceof KtLambdaExpression) {
            return ((KtLambdaExpression)deparenthesizedExpression).getFunctionLiteral();
        }
        if (deparenthesizedExpression instanceof KtFunction) {
            return (KtFunction)deparenthesizedExpression;
        }
        return null;
    }

    @Nullable
    public static KtCallableReferenceExpression getCallableReferenceExpressionIfAny(@NotNull KtExpression expression2, @NotNull ResolutionContext context2) {
        KtExpression deparenthesizedExpression = KtPsiUtil.getLastElementDeparenthesized(expression2, context2.statementFilter);
        if (deparenthesizedExpression instanceof KtCallableReferenceExpression) {
            return (KtCallableReferenceExpression)deparenthesizedExpression;
        }
        return null;
    }

    @NotNull
    public KotlinTypeInfo getArgumentTypeInfo(@Nullable KtExpression expression2, @NotNull CallResolutionContext<?> context2, @NotNull ResolveArgumentsMode resolveArgumentsMode) {
        if (expression2 == null) {
            return TypeInfoFactoryKt.noTypeInfo(context2);
        }
        KtFunction functionLiteralArgument = ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression2, context2);
        if (functionLiteralArgument != null) {
            return this.getFunctionLiteralTypeInfo(expression2, functionLiteralArgument, context2, resolveArgumentsMode);
        }
        KtCallableReferenceExpression callableReferenceExpression = ArgumentTypeResolver.getCallableReferenceExpressionIfAny(expression2, context2);
        if (callableReferenceExpression != null) {
            return this.getCallableReferenceTypeInfo(expression2, callableReferenceExpression, context2, resolveArgumentsMode);
        }
        if (ArgumentTypeResolver.isCollectionLiteralInsideAnnotation(expression2, context2)) {
            Object newContext = context2.replaceContextDependency(ContextDependency.INDEPENDENT);
            return this.expressionTypingServices.getTypeInfo(expression2, (ResolutionContext)newContext);
        }
        KotlinTypeInfo recordedTypeInfo = BindingContextUtils.getRecordedTypeInfo(expression2, context2.trace.getBindingContext());
        if (recordedTypeInfo != null) {
            return recordedTypeInfo;
        }
        Object newContext = ((CallResolutionContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.DEPENDENT);
        return this.expressionTypingServices.getTypeInfo(expression2, (ResolutionContext)newContext);
    }

    @NotNull
    public KotlinTypeInfo getCallableReferenceTypeInfo(@NotNull KtExpression expression2, @NotNull KtCallableReferenceExpression callableReferenceExpression, @NotNull CallResolutionContext<?> context2, @NotNull ResolveArgumentsMode resolveArgumentsMode) {
        if (resolveArgumentsMode == ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS) {
            KotlinType type2 = this.getShapeTypeOfCallableReference(callableReferenceExpression, context2, true);
            return TypeInfoFactoryKt.createTypeInfo(type2);
        }
        return this.expressionTypingServices.getTypeInfo(expression2, (ResolutionContext)context2.replaceContextDependency(ContextDependency.INDEPENDENT));
    }

    @Nullable
    public KotlinType getShapeTypeOfCallableReference(@NotNull KtCallableReferenceExpression callableReferenceExpression, @NotNull CallResolutionContext<?> context2, boolean expectedTypeIsUnknown) {
        Pair<DoubleColonLHS, OverloadResolutionResults<?>> pair2 = this.doubleColonExpressionResolver.resolveCallableReference(callableReferenceExpression, ExpressionTypingContext.newContext(context2), ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS);
        DoubleColonLHS lhs = (DoubleColonLHS)pair2.getFirst();
        OverloadResolutionResults overloadResolutionResults = (OverloadResolutionResults)pair2.getSecond();
        if (overloadResolutionResults == null) {
            return null;
        }
        if (ArgumentTypeResolver.isSingleAndPossibleTransformToSuccess(overloadResolutionResults)) {
            ResolvedCall resolvedCall2 = OverloadResolutionResultsUtil.getResultingCall(overloadResolutionResults, context2);
            if (resolvedCall2 == null) {
                return null;
            }
            return DoubleColonExpressionResolver.Companion.createKCallableTypeForReference((CallableDescriptor)resolvedCall2.getResultingDescriptor(), lhs, this.reflectionTypes, context2.scope.getOwnerDescriptor());
        }
        if (expectedTypeIsUnknown) {
            return this.functionPlaceholders.createFunctionPlaceholderType(Collections.emptyList(), false);
        }
        return FunctionTypesKt.createFunctionType(this.builtIns, Annotations.Companion.getEMPTY(), null, Collections.emptyList(), null, TypeUtils.DONT_CARE);
    }

    private static boolean isSingleAndPossibleTransformToSuccess(@NotNull OverloadResolutionResults<?> overloadResolutionResults) {
        if (!overloadResolutionResults.isSingleResult()) {
            return false;
        }
        ResolvedCall call2 = (ResolvedCall)CollectionsKt.singleOrNull(overloadResolutionResults.getResultingCalls());
        return call2 != null && call2.getStatus().possibleTransformToSuccess();
    }

    @NotNull
    public KotlinTypeInfo getFunctionLiteralTypeInfo(@NotNull KtExpression expression2, @NotNull KtFunction functionLiteral, @NotNull CallResolutionContext<?> context2, @NotNull ResolveArgumentsMode resolveArgumentsMode) {
        if (resolveArgumentsMode == ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS) {
            KotlinType type2 = this.getShapeTypeOfFunctionLiteral(functionLiteral, context2.scope, context2.trace, true);
            return TypeInfoFactoryKt.createTypeInfo(type2, context2);
        }
        return this.expressionTypingServices.getTypeInfo(expression2, (ResolutionContext)context2.replaceContextDependency(ContextDependency.INDEPENDENT));
    }

    @Nullable
    public KotlinType getShapeTypeOfFunctionLiteral(@NotNull KtFunction function2, @NotNull LexicalScope scope2, @NotNull BindingTrace trace, boolean expectedTypeIsUnknown) {
        boolean isFunctionLiteral = function2 instanceof KtFunctionLiteral;
        if (function2.getValueParameterList() == null && isFunctionLiteral) {
            return expectedTypeIsUnknown ? this.functionPlaceholders.createFunctionPlaceholderType(Collections.emptyList(), false) : FunctionTypesKt.createFunctionType(this.builtIns, Annotations.Companion.getEMPTY(), null, Collections.emptyList(), null, TypeUtils.DONT_CARE);
        }
        List<KtParameter> valueParameters = function2.getValueParameters();
        TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(trace, "trace to resolve function literal parameter types");
        ArrayList<KotlinType> parameterTypes2 = new ArrayList<KotlinType>(valueParameters.size());
        ArrayList<Name> parameterNames = new ArrayList<Name>(valueParameters.size());
        for (KtParameter parameter : valueParameters) {
            parameterTypes2.add(this.resolveTypeRefWithDefault(parameter.getTypeReference(), scope2, temporaryTrace, TypeUtils.DONT_CARE));
            Name name2 = parameter.getNameAsName();
            if (name2 == null) {
                name2 = SpecialNames.NO_NAME_PROVIDED;
            }
            parameterNames.add(name2);
        }
        KotlinType returnType2 = this.resolveTypeRefWithDefault(function2.getTypeReference(), scope2, temporaryTrace, TypeUtils.DONT_CARE);
        assert (returnType2 != null);
        KotlinType receiverType2 = this.resolveTypeRefWithDefault(function2.getReceiverTypeReference(), scope2, temporaryTrace, null);
        return expectedTypeIsUnknown && isFunctionLiteral ? this.functionPlaceholders.createFunctionPlaceholderType(parameterTypes2, true) : FunctionTypesKt.createFunctionType(this.builtIns, Annotations.Companion.getEMPTY(), receiverType2, parameterTypes2, parameterNames, returnType2);
    }

    @Nullable
    public KotlinType resolveTypeRefWithDefault(@Nullable KtTypeReference returnTypeRef, @NotNull LexicalScope scope2, @NotNull BindingTrace trace, @Nullable KotlinType defaultValue) {
        if (returnTypeRef != null) {
            return this.typeResolver.resolveType(scope2, returnTypeRef, trace, true);
        }
        return defaultValue;
    }

    public void analyzeArgumentsAndRecordTypes(@NotNull CallResolutionContext<?> context2, @NotNull ResolveArgumentsMode resolveArgumentsMode) {
        MutableDataFlowInfoForArguments infoForArguments = context2.dataFlowInfoForArguments;
        Call call2 = context2.call;
        for (ValueArgument valueArgument : call2.getValueArguments()) {
            KtExpression expression2 = valueArgument.getArgumentExpression();
            if (expression2 == null || ArgumentTypeResolver.isCollectionLiteralInsideAnnotation(expression2, context2)) continue;
            CallResolutionContext newContext = (CallResolutionContext)context2.replaceDataFlowInfo(infoForArguments.getInfo(valueArgument));
            KotlinTypeInfo typeInfoForCall = this.getArgumentTypeInfo(expression2, newContext, resolveArgumentsMode);
            infoForArguments.updateInfo(valueArgument, typeInfoForCall.getDataFlowInfo());
        }
    }

    @Nullable
    public KotlinType updateResultArgumentTypeIfNotDenotable(@NotNull ResolutionContext context2, @NotNull KtExpression expression2) {
        return this.updateResultArgumentTypeIfNotDenotable(context2.trace, context2.statementFilter, context2.expectedType, expression2);
    }

    @Nullable
    public KotlinType updateResultArgumentTypeIfNotDenotable(@NotNull BindingTrace trace, @NotNull StatementFilter statementFilter, @NotNull KotlinType expectedType, @NotNull KtExpression expression2) {
        KotlinType type2 = trace.getType(expression2);
        if (type2 != null && !type2.getConstructor().isDenotable() && type2.getConstructor() instanceof IntegerValueTypeConstructor) {
            IntegerValueTypeConstructor constructor2 = (IntegerValueTypeConstructor)type2.getConstructor();
            KotlinType primitiveType = TypeUtils.getPrimitiveNumberType(constructor2, expectedType);
            this.constantExpressionEvaluator.updateNumberType(primitiveType, expression2, statementFilter, trace);
            return primitiveType;
        }
        return null;
    }

    private static boolean isCollectionLiteralInsideAnnotation(KtExpression expression2, CallResolutionContext<?> context2) {
        return expression2 instanceof KtCollectionLiteralExpression && context2.call.getCallElement() instanceof KtAnnotationEntry;
    }
}

