/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtElementImpl;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BindingTraceFilter;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallCompleter;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.GenericCandidateResolver;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.CoroutineInferenceUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategyForImplicitConstructorDelegationCall;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategyForInvoke;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategyImpl;
import org.jetbrains.kotlin.resolve.calls.tower.NewResolutionOldInference;
import org.jetbrains.kotlin.resolve.calls.tower.PSICallResolver;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.SyntheticScopes;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitorDispatcher;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.PerformanceCounter;

public class CallResolver {
    private ExpressionTypingServices expressionTypingServices;
    private TypeResolver typeResolver;
    private ArgumentTypeResolver argumentTypeResolver;
    private GenericCandidateResolver genericCandidateResolver;
    private CallCompleter callCompleter;
    private SyntheticScopes syntheticScopes;
    private NewResolutionOldInference newResolutionOldInference;
    private PSICallResolver PSICallResolver;
    private final DataFlowValueFactory dataFlowValueFactory;
    private final KotlinBuiltIns builtIns;
    private final LanguageVersionSettings languageVersionSettings;
    private static final PerformanceCounter callResolvePerfCounter = PerformanceCounter.Companion.create("Call resolve", ExpressionTypingVisitorDispatcher.typeInfoPerfCounter);

    public CallResolver(@NotNull KotlinBuiltIns builtIns, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull DataFlowValueFactory dataFlowValueFactory) {
        this.builtIns = builtIns;
        this.languageVersionSettings = languageVersionSettings;
        this.dataFlowValueFactory = dataFlowValueFactory;
    }

    @Inject
    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        this.expressionTypingServices = expressionTypingServices;
    }

    @Inject
    public void setTypeResolver(@NotNull TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    @Inject
    public void setArgumentTypeResolver(@NotNull ArgumentTypeResolver argumentTypeResolver) {
        this.argumentTypeResolver = argumentTypeResolver;
    }

    @Inject
    public void setGenericCandidateResolver(GenericCandidateResolver genericCandidateResolver) {
        this.genericCandidateResolver = genericCandidateResolver;
    }

    @Inject
    public void setCallCompleter(@NotNull CallCompleter callCompleter) {
        this.callCompleter = callCompleter;
    }

    @Inject
    public void setResolutionOldInference(@NotNull NewResolutionOldInference newResolutionOldInference) {
        this.newResolutionOldInference = newResolutionOldInference;
    }

    @Inject
    public void setPSICallResolver(@NotNull PSICallResolver PSICallResolver2) {
        this.PSICallResolver = PSICallResolver2;
    }

    @Inject
    public void setSyntheticScopes(@NotNull SyntheticScopes syntheticScopes) {
        this.syntheticScopes = syntheticScopes;
    }

    @NotNull
    public OverloadResolutionResults<VariableDescriptor> resolveSimpleProperty(@NotNull BasicCallResolutionContext context2) {
        KtExpression calleeExpression2 = context2.call.getCalleeExpression();
        assert (calleeExpression2 instanceof KtSimpleNameExpression);
        KtSimpleNameExpression nameExpression2 = (KtSimpleNameExpression)calleeExpression2;
        Name referencedName = nameExpression2.getReferencedNameAsName();
        return this.computeTasksAndResolveCall(context2, referencedName, nameExpression2, (NewResolutionOldInference.ResolutionKind)NewResolutionOldInference.ResolutionKind.Variable.INSTANCE);
    }

    @NotNull
    public OverloadResolutionResults<CallableDescriptor> resolveCallForMember(@NotNull KtSimpleNameExpression nameExpression2, @NotNull BasicCallResolutionContext context2) {
        return this.computeTasksAndResolveCall(context2, nameExpression2.getReferencedNameAsName(), nameExpression2, (NewResolutionOldInference.ResolutionKind)NewResolutionOldInference.ResolutionKind.CallableReference.INSTANCE);
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithGivenName(@NotNull ResolutionContext<?> context2, @NotNull Call call2, @NotNull KtReferenceExpression functionReference, @NotNull Name name2) {
        BasicCallResolutionContext callResolutionContext = BasicCallResolutionContext.create(context2, call2, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        return this.computeTasksAndResolveCall(callResolutionContext, name2, functionReference, (NewResolutionOldInference.ResolutionKind)NewResolutionOldInference.ResolutionKind.Function.INSTANCE);
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithGivenName(@NotNull ResolutionContext<?> context2, @NotNull Call call2, @NotNull Name name2, @NotNull TracingStrategy tracing) {
        BasicCallResolutionContext callResolutionContext = BasicCallResolutionContext.create(context2, call2, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        return this.computeTasksAndResolveCall(callResolutionContext, name2, tracing, (NewResolutionOldInference.ResolutionKind)NewResolutionOldInference.ResolutionKind.Function.INSTANCE);
    }

    @NotNull
    private OverloadResolutionResults<FunctionDescriptor> resolveCallForInvoke(@NotNull BasicCallResolutionContext context2, @NotNull TracingStrategy tracing) {
        return this.computeTasksAndResolveCall(context2, OperatorNameConventions.INVOKE, tracing, (NewResolutionOldInference.ResolutionKind)NewResolutionOldInference.ResolutionKind.Invoke.INSTANCE);
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResults<D> computeTasksAndResolveCall(@NotNull BasicCallResolutionContext context2, @NotNull Name name2, @NotNull KtReferenceExpression referenceExpression, @NotNull NewResolutionOldInference.ResolutionKind kind) {
        TracingStrategy tracing = TracingStrategyImpl.create(referenceExpression, context2.call);
        return this.computeTasksAndResolveCall(context2, name2, tracing, kind);
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResults<D> computeTasksAndResolveCall(@NotNull BasicCallResolutionContext context2, @NotNull Name name2, @NotNull TracingStrategy tracing, @NotNull NewResolutionOldInference.ResolutionKind kind) {
        return (OverloadResolutionResults)callResolvePerfCounter.time(() -> {
            ResolutionTask resolutionTask = new ResolutionTask(kind, name2, null);
            return this.doResolveCallOrGetCachedResults(context2, resolutionTask, tracing);
        });
    }

    @NotNull
    private <D extends FunctionDescriptor> OverloadResolutionResults<D> computeTasksFromCandidatesAndResolvedCall(@NotNull BasicCallResolutionContext context2, @NotNull KtReferenceExpression referenceExpression, @NotNull Collection<ResolutionCandidate<D>> candidates2) {
        return this.computeTasksFromCandidatesAndResolvedCall(context2, candidates2, TracingStrategyImpl.create(referenceExpression, context2.call));
    }

    @NotNull
    private <D extends FunctionDescriptor> OverloadResolutionResults<D> computeTasksFromCandidatesAndResolvedCall(@NotNull BasicCallResolutionContext context2, @NotNull Collection<ResolutionCandidate<D>> candidates2, @NotNull TracingStrategy tracing) {
        return (OverloadResolutionResults)callResolvePerfCounter.time(() -> {
            ResolutionTask resolutionTask = new ResolutionTask(new NewResolutionOldInference.ResolutionKind.GivenCandidates(), null, candidates2);
            return this.doResolveCallOrGetCachedResults(context2, resolutionTask, tracing);
        });
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveBinaryCall(ExpressionTypingContext context2, ExpressionReceiver receiver, KtBinaryExpression binaryExpression, Name name2) {
        return this.resolveCallWithGivenName(context2, CallMaker.makeCall((ReceiverValue)receiver, binaryExpression), binaryExpression.getOperationReference(), name2);
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCollectionLiteralCallWithGivenDescriptor(@NotNull ExpressionTypingContext context2, @NotNull KtCollectionLiteralExpression expression2, @NotNull Call call2, @NotNull Collection<FunctionDescriptor> functionDescriptors2) {
        BasicCallResolutionContext callResolutionContext = BasicCallResolutionContext.create(context2, call2, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        List candidates2 = CollectionsKt.map(functionDescriptors2, descriptor2 -> ResolutionCandidate.create(call2, descriptor2, null, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, null));
        return this.computeTasksFromCandidatesAndResolvedCall(callResolutionContext, candidates2, TracingStrategyImpl.create(expression2, call2));
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveEqualsCallWithGivenDescriptors(@NotNull ExpressionTypingContext context2, @NotNull KtReferenceExpression expression2, @NotNull ExpressionReceiver receiver, @NotNull Call call2, @NotNull Collection<FunctionDescriptor> functionDescriptors2) {
        BasicCallResolutionContext callResolutionContext = BasicCallResolutionContext.create(context2, call2, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        List resolutionCandidates = CollectionsKt.map(functionDescriptors2, descriptor2 -> ResolutionCandidate.create(call2, descriptor2, receiver, ExplicitReceiverKind.DISPATCH_RECEIVER, null));
        return this.computeTasksFromCandidatesAndResolvedCall(callResolutionContext, resolutionCandidates, TracingStrategyImpl.create(expression2, call2));
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveFunctionCall(@NotNull BindingTrace trace, @NotNull LexicalScope scope2, @NotNull Call call2, @NotNull KotlinType expectedType, @NotNull DataFlowInfo dataFlowInfo, boolean isAnnotationContext) {
        return this.resolveFunctionCall(BasicCallResolutionContext.create(trace, scope2, call2, expectedType, dataFlowInfo, ContextDependency.INDEPENDENT, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, isAnnotationContext, this.languageVersionSettings, this.dataFlowValueFactory, InferenceSession.Companion.getDefault()));
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveFunctionCall(@NotNull BasicCallResolutionContext context2) {
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        Call.CallType callType = context2.call.getCallType();
        if (callType == Call.CallType.ARRAY_GET_METHOD || callType == Call.CallType.ARRAY_SET_METHOD) {
            Name name2 = callType == Call.CallType.ARRAY_GET_METHOD ? OperatorNameConventions.GET : OperatorNameConventions.SET;
            KtArrayAccessExpression arrayAccessExpression2 = (KtArrayAccessExpression)context2.call.getCallElement();
            return this.computeTasksAndResolveCall(context2, name2, arrayAccessExpression2, (NewResolutionOldInference.ResolutionKind)NewResolutionOldInference.ResolutionKind.Function.INSTANCE);
        }
        KtExpression calleeExpression2 = context2.call.getCalleeExpression();
        if (calleeExpression2 instanceof KtSimpleNameExpression) {
            KtSimpleNameExpression expression2 = (KtSimpleNameExpression)calleeExpression2;
            return this.computeTasksAndResolveCall(context2, expression2.getReferencedNameAsName(), expression2, (NewResolutionOldInference.ResolutionKind)NewResolutionOldInference.ResolutionKind.Function.INSTANCE);
        }
        if (calleeExpression2 instanceof KtConstructorCalleeExpression) {
            return this.resolveCallForConstructor(context2, (KtConstructorCalleeExpression)calleeExpression2);
        }
        if (calleeExpression2 instanceof KtConstructorDelegationReferenceExpression) {
            KtConstructorDelegationCall delegationCall = (KtConstructorDelegationCall)context2.call.getCallElement();
            DeclarationDescriptor container2 = context2.scope.getOwnerDescriptor();
            assert (container2 instanceof ConstructorDescriptor) : "Trying to resolve JetConstructorDelegationCall not in constructor. scope.ownerDescriptor = " + container2;
            return this.resolveConstructorDelegationCall(context2, delegationCall, (KtConstructorDelegationReferenceExpression)calleeExpression2, (ClassConstructorDescriptor)container2);
        }
        if (calleeExpression2 == null) {
            return this.checkArgumentTypesAndFail(context2);
        }
        SimpleType expectedType = TypeUtils.NO_EXPECTED_TYPE;
        if (calleeExpression2 instanceof KtLambdaExpression) {
            int parameterNumber = ((KtLambdaExpression)calleeExpression2).getValueParameters().size();
            ArrayList<SimpleType> parameterTypes2 = new ArrayList<SimpleType>(parameterNumber);
            for (int i = 0; i < parameterNumber; ++i) {
                parameterTypes2.add(TypeUtils.NO_EXPECTED_TYPE);
            }
            expectedType = FunctionTypesKt.createFunctionType(this.builtIns, Annotations.Companion.getEMPTY(), null, parameterTypes2, null, context2.expectedType);
        }
        KotlinType calleeType = this.expressionTypingServices.safeGetType(context2.scope, calleeExpression2, expectedType, context2.dataFlowInfo, context2.trace);
        ExpressionReceiver expressionReceiver = ExpressionReceiver.Companion.create(calleeExpression2, calleeType, context2.trace.getBindingContext());
        CallTransformer.CallForImplicitInvoke call2 = new CallTransformer.CallForImplicitInvoke(context2.call.getExplicitReceiver(), expressionReceiver, context2.call, false);
        TracingStrategyForInvoke tracingForInvoke = new TracingStrategyForInvoke(calleeExpression2, call2, calleeType);
        return this.resolveCallForInvoke(context2.replaceCall(call2), tracingForInvoke);
    }

    private OverloadResolutionResults<ConstructorDescriptor> resolveCallForConstructor(@NotNull BasicCallResolutionContext context2, @NotNull KtConstructorCalleeExpression expression2) {
        assert (context2.call.getExplicitReceiver() == null) : "Constructor can't be invoked with explicit receiver: " + context2.call.getCallElement().getText();
        context2.trace.record(BindingContext.LEXICAL_SCOPE, context2.call.getCallElement(), context2.scope);
        KtSimpleNameExpression functionReference = expression2.getConstructorReferenceExpression();
        KtTypeReference typeReference = expression2.getTypeReference();
        if (functionReference == null || typeReference == null) {
            return this.checkArgumentTypesAndFail(context2);
        }
        KotlinType constructedType = this.typeResolver.resolveType(context2.scope, typeReference, context2.trace, true);
        if (KotlinTypeKt.isError(constructedType)) {
            return this.checkArgumentTypesAndFail(context2);
        }
        ClassifierDescriptor declarationDescriptor = constructedType.getConstructor().getDeclarationDescriptor();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            context2.trace.report(Errors.NOT_A_CLASS.on(expression2));
            return this.checkArgumentTypesAndFail(context2);
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        Collection<ClassConstructorDescriptor> constructors2 = classDescriptor.getConstructors();
        if (constructors2.isEmpty()) {
            context2.trace.report(Errors.NO_CONSTRUCTOR.on((PsiElement)CallUtilKt.getValueArgumentListOrElement(context2.call)));
            return this.checkArgumentTypesAndFail(context2);
        }
        return this.resolveConstructorCall(context2, functionReference, constructedType);
    }

    @NotNull
    public OverloadResolutionResults<ConstructorDescriptor> resolveConstructorCall(@NotNull BasicCallResolutionContext context2, @NotNull KtReferenceExpression functionReference, @NotNull KotlinType constructedType) {
        Pair<Collection<ResolutionCandidate<ConstructorDescriptor>>, BasicCallResolutionContext> candidatesAndContext = CallResolver.prepareCandidatesAndContextForConstructorCall(constructedType, context2, this.syntheticScopes);
        Collection candidates2 = (Collection)candidatesAndContext.getFirst();
        context2 = (BasicCallResolutionContext)candidatesAndContext.getSecond();
        return this.computeTasksFromCandidatesAndResolvedCall(context2, functionReference, candidates2);
    }

    @Nullable
    public OverloadResolutionResults<ConstructorDescriptor> resolveConstructorDelegationCall(@NotNull BindingTrace trace, @NotNull LexicalScope scope2, @NotNull DataFlowInfo dataFlowInfo, @NotNull ClassConstructorDescriptor constructorDescriptor, @NotNull KtConstructorDelegationCall call2) {
        BasicCallResolutionContext context2 = BasicCallResolutionContext.create(trace, scope2, CallMaker.makeCall(null, null, call2), TypeUtils.NO_EXPECTED_TYPE, dataFlowInfo, ContextDependency.INDEPENDENT, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, false, this.languageVersionSettings, this.dataFlowValueFactory, InferenceSession.Companion.getDefault());
        if (call2.getCalleeExpression() == null) {
            return this.checkArgumentTypesAndFail(context2);
        }
        if (constructorDescriptor.getConstructedClass().getKind() == ClassKind.ENUM_CLASS && call2.isImplicit()) {
            return null;
        }
        return this.resolveConstructorDelegationCall(context2, call2, call2.getCalleeExpression(), constructorDescriptor);
    }

    @NotNull
    private OverloadResolutionResults<ConstructorDescriptor> resolveConstructorDelegationCall(@NotNull BasicCallResolutionContext context2, @NotNull KtConstructorDelegationCall call2, @NotNull KtConstructorDelegationReferenceExpression calleeExpression2, @NotNull ClassConstructorDescriptor calleeConstructor) {
        KtElementImpl reportOn;
        context2.trace.record(BindingContext.LEXICAL_SCOPE, call2, context2.scope);
        ClassDescriptor currentClassDescriptor = calleeConstructor.getContainingDeclaration();
        boolean isThisCall = calleeExpression2.isThis();
        if (currentClassDescriptor.getKind() == ClassKind.ENUM_CLASS && !isThisCall) {
            context2.trace.report(Errors.DELEGATION_SUPER_CALL_IN_ENUM_CONSTRUCTOR.on(calleeExpression2));
            return this.checkArgumentTypesAndFail(context2);
        }
        ClassDescriptor delegateClassDescriptor = isThisCall ? currentClassDescriptor : DescriptorUtilsKt.getSuperClassOrAny(currentClassDescriptor);
        Collection<ClassConstructorDescriptor> constructors2 = delegateClassDescriptor.getConstructors();
        if (!isThisCall && currentClassDescriptor.getUnsubstitutedPrimaryConstructor() != null) {
            if (DescriptorUtils.canHaveDeclaredConstructors(currentClassDescriptor)) {
                context2.trace.report(Errors.PRIMARY_CONSTRUCTOR_DELEGATION_CALL_EXPECTED.on((KtConstructorDelegationCall)calleeExpression2.getParent()));
            }
            if (call2.isImplicit()) {
                return OverloadResolutionResultsImpl.nameNotFound();
            }
        }
        if (constructors2.isEmpty()) {
            context2.trace.report(Errors.NO_CONSTRUCTOR.on((PsiElement)CallUtilKt.getValueArgumentListOrElement(context2.call)));
            return this.checkArgumentTypesAndFail(context2);
        }
        KotlinType superType = isThisCall ? calleeConstructor.getContainingDeclaration().getDefaultType() : DescriptorUtils.getSuperClassType(currentClassDescriptor);
        Pair<Collection<ResolutionCandidate<ConstructorDescriptor>>, BasicCallResolutionContext> candidatesAndContext = CallResolver.prepareCandidatesAndContextForConstructorCall(superType, context2, this.syntheticScopes);
        Collection candidates2 = (Collection)candidatesAndContext.getFirst();
        context2 = (BasicCallResolutionContext)candidatesAndContext.getSecond();
        TracingStrategy tracing = call2.isImplicit() ? new TracingStrategyForImplicitConstructorDelegationCall(call2, context2.call) : TracingStrategyImpl.create(calleeExpression2, context2.call);
        KtElementImpl ktElementImpl = reportOn = call2.isImplicit() ? call2 : calleeExpression2;
        if (delegateClassDescriptor.isInner() && !DescriptorResolver.checkHasOuterClassInstance(context2.scope, context2.trace, (PsiElement)reportOn, (ClassDescriptor)delegateClassDescriptor.getContainingDeclaration())) {
            return this.checkArgumentTypesAndFail(context2);
        }
        return this.computeTasksFromCandidatesAndResolvedCall(context2, candidates2, tracing);
    }

    @NotNull
    private static Pair<Collection<ResolutionCandidate<ConstructorDescriptor>>, BasicCallResolutionContext> prepareCandidatesAndContextForConstructorCall(@NotNull KotlinType superType, @NotNull BasicCallResolutionContext context2, @NotNull SyntheticScopes syntheticScopes) {
        if (!(superType.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor)) {
            return new Pair(Collections.emptyList(), (Object)context2);
        }
        boolean anyConstructorHasDeclaredTypeParameters = CallResolver.anyConstructorHasDeclaredTypeParameters(superType.getConstructor().getDeclarationDescriptor());
        if (anyConstructorHasDeclaredTypeParameters) {
            context2 = (BasicCallResolutionContext)context2.replaceExpectedType(superType);
        }
        List<ResolutionCandidate<ConstructorDescriptor>> candidates2 = CallResolverUtilKt.createResolutionCandidatesForConstructors(context2.scope, context2.call, superType, !anyConstructorHasDeclaredTypeParameters, syntheticScopes);
        return new Pair(candidates2, (Object)context2);
    }

    private static boolean anyConstructorHasDeclaredTypeParameters(@Nullable ClassifierDescriptor classDescriptor) {
        if (!(classDescriptor instanceof ClassDescriptor)) {
            return false;
        }
        for (ConstructorDescriptor constructorDescriptor : ((ClassDescriptor)classDescriptor).getConstructors()) {
            if (constructorDescriptor.getTypeParameters().size() <= constructorDescriptor.getContainingDeclaration().getDeclaredTypeParameters().size()) continue;
            return true;
        }
        return false;
    }

    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithKnownCandidate(@NotNull Call call2, @NotNull TracingStrategy tracing, @NotNull ResolutionContext<?> context2, @NotNull ResolutionCandidate<FunctionDescriptor> candidate, @Nullable MutableDataFlowInfoForArguments dataFlowInfoForArguments) {
        return (OverloadResolutionResults)callResolvePerfCounter.time(() -> {
            BasicCallResolutionContext basicCallResolutionContext = BasicCallResolutionContext.create(context2, call2, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, dataFlowInfoForArguments);
            Set<ResolutionCandidate> candidates2 = Collections.singleton(candidate);
            ResolutionTask resolutionTask = new ResolutionTask(new NewResolutionOldInference.ResolutionKind.GivenCandidates(), null, candidates2);
            return this.doResolveCallOrGetCachedResults(basicCallResolutionContext, resolutionTask, tracing);
        });
    }

    private <D extends CallableDescriptor> OverloadResolutionResults<D> doResolveCallOrGetCachedResults(@NotNull BasicCallResolutionContext context2, @NotNull ResolutionTask<D> resolutionTask, @NotNull TracingStrategy tracing) {
        Call call2 = context2.call;
        tracing.bindCall(context2.trace, call2);
        boolean newInferenceEnabled = this.languageVersionSettings.supportsFeature(LanguageFeature.NewInference);
        NewResolutionOldInference.ResolutionKind resolutionKind = resolutionTask.resolutionKind;
        if (newInferenceEnabled && this.PSICallResolver.getDefaultResolutionKinds().contains(resolutionKind)) {
            assert (resolutionTask.name != null);
            return this.PSICallResolver.runResolutionAndInference(context2, resolutionTask.name, resolutionKind, tracing);
        }
        if (newInferenceEnabled && resolutionKind instanceof NewResolutionOldInference.ResolutionKind.GivenCandidates) {
            assert (resolutionTask.givenCandidates != null);
            return this.PSICallResolver.runResolutionAndInferenceForGivenCandidates(context2, resolutionTask.givenCandidates, tracing);
        }
        TemporaryBindingTrace traceToResolveCall = TemporaryBindingTrace.create(context2.trace, "trace to resolve call", call2);
        BasicCallResolutionContext newContext = (BasicCallResolutionContext)context2.replaceBindingTrace(traceToResolveCall);
        BindingContextUtilsKt.recordScope(newContext.trace, newContext.scope, newContext.call.getCalleeExpression());
        BindingContextUtilsKt.recordDataFlowInfo(newContext, newContext.call.getCalleeExpression());
        OverloadResolutionResultsImpl<D> results2 = this.doResolveCall(newContext, resolutionTask, tracing);
        if (CoroutineInferenceUtilKt.isResultWithCoroutineInference(results2)) {
            traceToResolveCall.commit();
            return results2;
        }
        DelegatingBindingTrace deltasTraceForTypeInference = results2.getTrace();
        if (deltasTraceForTypeInference != null) {
            deltasTraceForTypeInference.addOwnDataTo(traceToResolveCall);
        }
        this.completeTypeInferenceDependentOnFunctionLiterals(newContext, results2, tracing);
        if (context2.contextDependency == ContextDependency.DEPENDENT) {
            CallResolver.cacheResults(context2, results2, traceToResolveCall, tracing);
        }
        traceToResolveCall.commit();
        if (context2.contextDependency == ContextDependency.INDEPENDENT) {
            results2 = this.callCompleter.completeCall(context2, results2, tracing);
        }
        return results2;
    }

    private <D extends CallableDescriptor> void completeTypeInferenceDependentOnFunctionLiterals(@NotNull BasicCallResolutionContext context2, @NotNull OverloadResolutionResultsImpl<D> results2, @NotNull TracingStrategy tracing) {
        if (CallResolverUtilKt.isInvokeCallOnVariable(context2.call)) {
            return;
        }
        if (!results2.isSingleResult()) {
            if (results2.getResultCode() == OverloadResolutionResults.Code.INCOMPLETE_TYPE_INFERENCE) {
                this.argumentTypeResolver.checkTypesWithNoCallee(context2);
            }
            return;
        }
        CallCandidateResolutionContext candidateContext = CallCandidateResolutionContext.createForCallBeingAnalyzed(results2.getResultingCall(), context2, tracing);
        this.genericCandidateResolver.completeTypeInferenceDependentOnFunctionArgumentsForCall(candidateContext);
    }

    private static <F extends CallableDescriptor> void cacheResults(@NotNull BasicCallResolutionContext context2, @NotNull OverloadResolutionResultsImpl<F> results2, @NotNull DelegatingBindingTrace traceToResolveCall, @NotNull TracingStrategy tracing) {
        Call call2 = context2.call;
        if (CallResolverUtilKt.isInvokeCallOnVariable(call2)) {
            return;
        }
        DelegatingBindingTrace deltasTraceToCacheResolve = new DelegatingBindingTrace(BindingContext.EMPTY, "delta trace for caching resolve of", context2.call, BindingTraceFilter.Companion.getACCEPT_ALL(), false);
        traceToResolveCall.addOwnDataTo(deltasTraceToCacheResolve);
        context2.resolutionResultsCache.record(call2, results2, context2, tracing, deltasTraceToCacheResolve);
    }

    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> checkArgumentTypesAndFail(BasicCallResolutionContext context2) {
        this.argumentTypeResolver.checkTypesWithNoCallee(context2);
        return OverloadResolutionResultsImpl.nameNotFound();
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> doResolveCall(@NotNull BasicCallResolutionContext context2, @NotNull ResolutionTask<D> resolutionTask, @NotNull TracingStrategy tracing) {
        DeclarationDescriptor declaration2;
        Object descriptor2;
        OverloadResolutionResultsImpl result2;
        DataFlowInfo initialInfo = context2.dataFlowInfoForArguments.getResultInfo();
        if (context2.checkArguments == CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS) {
            this.argumentTypeResolver.analyzeArgumentsAndRecordTypes(context2, ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS);
        }
        List<KtTypeProjection> typeArguments2 = context2.call.getTypeArguments();
        for (KtTypeProjection projection : typeArguments2) {
            KotlinType type2;
            if (projection.getProjectionKind() != KtProjectionKind.NONE) {
                context2.trace.report(Errors.PROJECTION_ON_NON_CLASS_TYPE_ARGUMENT.on(projection));
                ModifierCheckerCore.INSTANCE.check(projection, context2.trace, null, this.languageVersionSettings);
            }
            if ((type2 = this.argumentTypeResolver.resolveTypeRefWithDefault(projection.getTypeReference(), context2.scope, context2.trace, null)) == null) continue;
            ForceResolveUtil.forceResolveAllContents(type2);
        }
        if (!(resolutionTask.resolutionKind instanceof NewResolutionOldInference.ResolutionKind.GivenCandidates)) {
            assert (resolutionTask.name != null);
            result2 = this.newResolutionOldInference.runResolution(context2, resolutionTask.name, resolutionTask.resolutionKind, tracing);
        } else {
            assert (resolutionTask.givenCandidates != null);
            result2 = this.newResolutionOldInference.runResolutionForGivenCandidates(context2, tracing, resolutionTask.givenCandidates);
        }
        if (this.languageVersionSettings.getFlag(AnalysisFlag.getIgnoreDataFlowInAssert()).booleanValue() && result2.isSingleResult() && (descriptor2 = result2.getResultingDescriptor()).getName().equals(Name.identifier("assert")) && (declaration2 = descriptor2.getContainingDeclaration()) instanceof PackageFragmentDescriptor && ((PackageFragmentDescriptor)declaration2).getFqName().asString().equals("kotlin")) {
            context2.dataFlowInfoForArguments.updateInfo(context2.call.getValueArguments().get(0), initialInfo);
        }
        return result2;
    }

    private static class ResolutionTask<D extends CallableDescriptor> {
        @Nullable
        final Name name;
        @Nullable
        final Collection<ResolutionCandidate<D>> givenCandidates;
        @NotNull
        final NewResolutionOldInference.ResolutionKind resolutionKind;

        private ResolutionTask(@NotNull NewResolutionOldInference.ResolutionKind kind, @Nullable Name name2, @Nullable Collection<ResolutionCandidate<D>> candidates2) {
            this.name = name2;
            this.givenCandidates = candidates2;
            this.resolutionKind = kind;
        }
    }
}

