/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBounds;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariableKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

public class ConstraintsUtil {
    @Nullable
    public static TypeVariable getFirstConflictingVariable(@NotNull ConstraintSystem constraintSystem) {
        for (TypeVariable typeVariable2 : constraintSystem.getTypeVariables()) {
            TypeBounds constraints = constraintSystem.getTypeBounds(typeVariable2);
            if (constraints.getValues().size() <= 1) continue;
            return typeVariable2;
        }
        return null;
    }

    @NotNull
    public static Collection<TypeSubstitutor> getSubstitutorsForConflictingParameters(@NotNull ConstraintSystem constraintSystem) {
        TypeVariable firstConflictingVariable = ConstraintsUtil.getFirstConflictingVariable(constraintSystem);
        if (firstConflictingVariable == null) {
            return Collections.emptyList();
        }
        TypeParameterDescriptor firstConflictingParameter = firstConflictingVariable.getOriginalTypeParameter();
        Collection<KotlinType> conflictingTypes = constraintSystem.getTypeBounds(firstConflictingVariable).getValues();
        ArrayList substitutionContexts = Lists.newArrayList();
        for (KotlinType type2 : conflictingTypes) {
            Map context2 = Maps.newLinkedHashMap();
            context2.put(firstConflictingParameter.getTypeConstructor(), new TypeProjectionImpl(type2));
            substitutionContexts.add(context2);
        }
        for (TypeVariable typeVariable2 : constraintSystem.getTypeVariables()) {
            if (typeVariable2 == firstConflictingVariable) continue;
            KotlinType safeType = ConstraintsUtil.getSafeValue(constraintSystem, typeVariable2);
            for (Map context3 : substitutionContexts) {
                TypeProjectionImpl typeProjection = new TypeProjectionImpl(safeType);
                context3.put(typeVariable2.getOriginalTypeParameter().getTypeConstructor(), typeProjection);
            }
        }
        ArrayList<TypeSubstitutor> typeSubstitutors = new ArrayList<TypeSubstitutor>(substitutionContexts.size());
        for (Map context2 : substitutionContexts) {
            typeSubstitutors.add(TypeSubstitutor.create(context2));
        }
        return typeSubstitutors;
    }

    @NotNull
    private static KotlinType getSafeValue(@NotNull ConstraintSystem constraintSystem, @NotNull TypeVariable typeVariable2) {
        KotlinType type2 = constraintSystem.getTypeBounds(typeVariable2).getValue();
        if (type2 != null) {
            return type2;
        }
        return TypeIntersector.getUpperBoundsAsType(typeVariable2.getOriginalTypeParameter());
    }

    public static boolean checkUpperBoundIsSatisfied(@NotNull ConstraintSystem constraintSystem, @NotNull TypeParameterDescriptor typeParameter, @NotNull Call call2, boolean substituteOtherTypeParametersInBound) {
        TypeVariable typeVariable2 = ConstraintSystemUtilsKt.descriptorToVariable(constraintSystem, TypeVariableKt.toHandle(call2), typeParameter);
        KotlinType type2 = constraintSystem.getTypeBounds(typeVariable2).getValue();
        if (type2 == null) {
            return true;
        }
        List typeParametersUsedInSystem = CollectionsKt.map(constraintSystem.getTypeVariables(), TypeVariable::getOriginalTypeParameter);
        for (KotlinType upperBound : typeParameter.getUpperBounds()) {
            if (!substituteOtherTypeParametersInBound && TypeUtils.dependsOnTypeParameters(upperBound, typeParametersUsedInSystem)) continue;
            KotlinType substitutedUpperBound = constraintSystem.getResultingSubstitutor().substitute(upperBound, Variance.INVARIANT);
            assert (substitutedUpperBound != null) : "We wanted to substitute projections as a result for " + typeParameter;
            if (KotlinTypeChecker.DEFAULT.isSubtypeOf(type2, substitutedUpperBound)) continue;
            return false;
        }
        return true;
    }

    public static String getDebugMessageForStatus(@NotNull ConstraintSystemStatus status2) {
        StringBuilder sb = new StringBuilder();
        ArrayList interestingMethods = Lists.newArrayList();
        for (Method method : status2.getClass().getMethods()) {
            boolean isInteresting;
            String name2 = method.getName();
            boolean bl = isInteresting = name2.startsWith("is") || name2.startsWith("has") && !name2.equals("hashCode");
            if (method.getParameterTypes().length != 0 || !isInteresting) continue;
            interestingMethods.add(method);
        }
        interestingMethods.sort(Comparator.comparing(Method::getName));
        Iterator iterator2 = interestingMethods.iterator();
        while (iterator2.hasNext()) {
            Method method = (Method)iterator2.next();
            try {
                sb.append("-").append(method.getName()).append(": ").append(method.invoke((Object)status2, new Object[0]));
                if (!iterator2.hasNext()) continue;
                sb.append("\n");
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                sb.append(e.getMessage());
            }
        }
        return sb.toString();
    }
}

