/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.results;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.tower.KotlinToResolvedCallTransformerKt;
import org.jetbrains.kotlin.types.KotlinType;

public class OverloadResolutionResultsUtil {
    @NotNull
    public static <D extends CallableDescriptor> OverloadResolutionResults<D> ambiguity(OverloadResolutionResults<D> results1, OverloadResolutionResults<D> results2) {
        ArrayList resultingCalls = Lists.newArrayList();
        resultingCalls.addAll(results1.getResultingCalls());
        resultingCalls.addAll(results2.getResultingCalls());
        return OverloadResolutionResultsImpl.ambiguity(resultingCalls);
    }

    @Nullable
    public static <D extends CallableDescriptor> KotlinType getResultingType(@NotNull OverloadResolutionResults<D> results2, @NotNull ResolutionContext<?> context2) {
        ResolvedCall<D> resultingCall = OverloadResolutionResultsUtil.getResultingCall(results2, context2);
        return resultingCall != null ? resultingCall.getResultingDescriptor().getReturnType() : null;
    }

    @Nullable
    public static <D extends CallableDescriptor> ResolvedCall<D> getResultingCall(@NotNull OverloadResolutionResults<D> results2, @NotNull ResolutionContext<?> context2) {
        if (results2.isSingleResult() && context2.contextDependency == ContextDependency.INDEPENDENT) {
            ResolvedCall<D> resultingCall = results2.getResultingCall();
            if (!context2.languageVersionSettings.supportsFeature(LanguageFeature.NewInference) ? !((MutableResolvedCall)resultingCall).hasInferredReturnType() : KotlinToResolvedCallTransformerKt.isNewNotCompleted(resultingCall)) {
                return null;
            }
        }
        return results2.isSingleResult() ? results2.getResultingCall() : null;
    }
}

