/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.smartcasts;

import com.intellij.lang.ASTNode;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueKindUtilsKt;
import org.jetbrains.kotlin.resolve.calls.smartcasts.IdentifierInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.IdentifierInfoKt;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J*\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactoryImpl;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "createDataFlowValue", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "containingDeclarationOrModule", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "resolutionContext", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "receiverValue", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "createDataFlowValueForProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "usageContainingModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "createDataFlowValueForStableReceiver", "receiver", "isComplexExpression", "", "frontend"})
public final class DataFlowValueFactoryImpl
implements DataFlowValueFactory {
    private final LanguageVersionSettings languageVersionSettings;

    @Override
    @NotNull
    public DataFlowValue createDataFlowValue(@NotNull ReceiverValue receiverValue, @NotNull ResolutionContext<?> resolutionContext) {
        Intrinsics.checkParameterIsNotNull((Object)receiverValue, (String)"receiverValue");
        Intrinsics.checkParameterIsNotNull(resolutionContext, (String)"resolutionContext");
        BindingTrace bindingTrace = resolutionContext.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"resolutionContext.trace");
        BindingContext bindingContext2 = bindingTrace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"resolutionContext.trace.bindingContext");
        return this.createDataFlowValue(receiverValue, bindingContext2, resolutionContext.scope.getOwnerDescriptor());
    }

    @Override
    @NotNull
    public DataFlowValue createDataFlowValue(@NotNull ReceiverValue receiverValue, @NotNull BindingContext bindingContext2, @NotNull DeclarationDescriptor containingDeclarationOrModule) {
        DataFlowValue dataFlowValue2;
        Intrinsics.checkParameterIsNotNull((Object)receiverValue, (String)"receiverValue");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)containingDeclarationOrModule, (String)"containingDeclarationOrModule");
        ReceiverValue receiverValue2 = receiverValue;
        if (receiverValue2 instanceof TransientReceiver || receiverValue2 instanceof ImplicitReceiver) {
            dataFlowValue2 = this.createDataFlowValueForStableReceiver(receiverValue);
        } else if (receiverValue2 instanceof ExpressionReceiver) {
            KtExpression ktExpression = ((ExpressionReceiver)receiverValue).getExpression();
            KotlinType kotlinType = receiverValue.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"receiverValue.getType()");
            dataFlowValue2 = this.createDataFlowValue(ktExpression, kotlinType, bindingContext2, containingDeclarationOrModule);
        } else {
            throw (Throwable)new UnsupportedOperationException("Unsupported receiver value: " + receiverValue.getClass().getName());
        }
        return dataFlowValue2;
    }

    @Override
    @NotNull
    public DataFlowValue createDataFlowValueForStableReceiver(@NotNull ReceiverValue receiver) {
        Intrinsics.checkParameterIsNotNull((Object)receiver, (String)"receiver");
        IdentifierInfo identifierInfo = new IdentifierInfo.Receiver(receiver);
        KotlinType kotlinType = receiver.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"receiver.type");
        return new DataFlowValue(identifierInfo, kotlinType, null, 4, null);
    }

    @Override
    @NotNull
    public DataFlowValue createDataFlowValueForProperty(@NotNull KtProperty property, @NotNull VariableDescriptor variableDescriptor, @NotNull BindingContext bindingContext2, @Nullable ModuleDescriptor usageContainingModule) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)variableDescriptor, (String)"variableDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        IdentifierInfo.Variable identifierInfo = new IdentifierInfo.Variable(variableDescriptor, DataFlowValueKindUtilsKt.variableKind(variableDescriptor, usageContainingModule, bindingContext2, property, this.languageVersionSettings), (DataFlowValue)bindingContext2.get(BindingContext.BOUND_INITIALIZER_VALUE, variableDescriptor));
        IdentifierInfo identifierInfo2 = identifierInfo;
        KotlinType kotlinType = variableDescriptor.getType();
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"variableDescriptor.type");
        return new DataFlowValue(identifierInfo2, kotlinType, null, 4, null);
    }

    @Override
    @NotNull
    public DataFlowValue createDataFlowValue(@NotNull KtExpression expression2, @NotNull KotlinType type2, @NotNull ResolutionContext<?> resolutionContext) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        Intrinsics.checkParameterIsNotNull(resolutionContext, (String)"resolutionContext");
        BindingTrace bindingTrace = resolutionContext.trace;
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"resolutionContext.trace");
        BindingContext bindingContext2 = bindingTrace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"resolutionContext.trace.bindingContext");
        return this.createDataFlowValue(expression2, type2, bindingContext2, resolutionContext.scope.getOwnerDescriptor());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public DataFlowValue createDataFlowValue(@NotNull KtExpression expression2, @NotNull KotlinType type2, @NotNull BindingContext bindingContext2, @NotNull DeclarationDescriptor containingDeclarationOrModule) {
        DataFlowValue dataFlowValue2;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)containingDeclarationOrModule, (String)"containingDeclarationOrModule");
        if (expression2 instanceof KtConstantExpression) {
            ASTNode aSTNode = ((KtConstantExpression)expression2).getNode();
            Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"expression.node");
            if (aSTNode.getElementType() == KtNodeTypes.NULL) {
                dataFlowValue2 = DataFlowValue.Companion.nullValue(DescriptorUtilsKt.getBuiltIns(containingDeclarationOrModule));
                return dataFlowValue2;
            }
        }
        if (KotlinTypeKt.isError(type2)) {
            dataFlowValue2 = DataFlowValue.ERROR;
            return dataFlowValue2;
        }
        if (KotlinBuiltIns.isNullableNothing(type2)) {
            dataFlowValue2 = DataFlowValue.Companion.nullValue(DescriptorUtilsKt.getBuiltIns(containingDeclarationOrModule));
            return dataFlowValue2;
        }
        if (ExpressionTypingUtils.isExclExclExpression(KtPsiUtil.deparenthesize(expression2))) {
            dataFlowValue2 = new DataFlowValue(new IdentifierInfo.Expression(expression2, false, 2, null), type2, Nullability.NOT_NULL);
            return dataFlowValue2;
        }
        if (this.isComplexExpression(expression2)) {
            dataFlowValue2 = new DataFlowValue(new IdentifierInfo.Expression(expression2, true), type2, null, 4, null);
            return dataFlowValue2;
        }
        IdentifierInfo result2 = IdentifierInfoKt.getIdForStableIdentifier(expression2, bindingContext2, containingDeclarationOrModule, this.languageVersionSettings);
        dataFlowValue2 = new DataFlowValue(result2 == IdentifierInfo.NO.INSTANCE ? (IdentifierInfo)new IdentifierInfo.Expression(expression2, false, 2, null) : result2, type2, null, 4, null);
        return dataFlowValue2;
    }

    private final boolean isComplexExpression(KtExpression expression2) {
        KtExpression deparenthesized;
        KtExpression ktExpression = expression2;
        boolean bl = ktExpression instanceof KtBlockExpression || ktExpression instanceof KtIfExpression || ktExpression instanceof KtWhenExpression ? true : (ktExpression instanceof KtBinaryExpression ? ((KtBinaryExpression)expression2).getOperationToken() == KtTokens.ELVIS : (ktExpression instanceof KtParenthesizedExpression ? (deparenthesized = KtPsiUtil.deparenthesize(expression2)) != null && this.isComplexExpression(deparenthesized) : false));
        return bl;
    }

    @Deprecated(message="Please, avoid to use that implementation explicitly. If you need DataFlowValueFactory, use injection")
    public DataFlowValueFactoryImpl(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.languageVersionSettings = languageVersionSettings;
    }
}

