/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.smartcasts;

import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueKindUtilsKt;
import org.jetbrains.kotlin.resolve.calls.smartcasts.IdentifierInfo;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u001e\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002\u001a(\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a*\u0010\u000f\u001a\u00020\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u0012\u0010\u0010\u001a\u00020\u00012\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a*\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00012\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a8\u0006\u001d"}, d2={"getIdForImplicitReceiver", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/IdentifierInfo;", "receiverValue", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getIdForSimpleNameExpression", "simpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "containingDeclarationOrModule", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getIdForStableIdentifier", "getIdForThisReceiver", "descriptorOfThisReceiver", "postfix", "argumentInfo", "op", "Lorg/jetbrains/kotlin/lexer/KtToken;", "qualified", "receiverInfo", "receiverType", "Lorg/jetbrains/kotlin/types/KotlinType;", "selectorInfo", "safe", "", "frontend"})
public final class IdentifierInfoKt {
    @NotNull
    public static final IdentifierInfo getIdForStableIdentifier(@Nullable KtExpression expression2, @NotNull BindingContext bindingContext2, @NotNull DeclarationDescriptor containingDeclarationOrModule, @NotNull LanguageVersionSettings languageVersionSettings) {
        IdentifierInfo identifierInfo;
        KtExpression deparenthesized;
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)containingDeclarationOrModule, (String)"containingDeclarationOrModule");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        if (expression2 != null && expression2 != (deparenthesized = KtPsiUtil.deparenthesize(expression2))) {
            return IdentifierInfoKt.getIdForStableIdentifier(deparenthesized, bindingContext2, containingDeclarationOrModule, languageVersionSettings);
        }
        KtExpression ktExpression = expression2;
        if (ktExpression instanceof KtQualifiedExpression) {
            KtExpression receiverExpression = ((KtQualifiedExpression)expression2).getReceiverExpression();
            KtExpression selectorExpression = ((KtQualifiedExpression)expression2).getSelectorExpression();
            IdentifierInfo receiverInfo = IdentifierInfoKt.getIdForStableIdentifier(receiverExpression, bindingContext2, containingDeclarationOrModule, languageVersionSettings);
            IdentifierInfo selectorInfo = IdentifierInfoKt.getIdForStableIdentifier(selectorExpression, bindingContext2, containingDeclarationOrModule, languageVersionSettings);
            identifierInfo = IdentifierInfoKt.qualified(receiverInfo, bindingContext2.getType(receiverExpression), selectorInfo, ((KtQualifiedExpression)expression2).getOperationSign() == KtTokens.SAFE_ACCESS);
        } else if (ktExpression instanceof KtBinaryExpressionWithTypeRHS) {
            KtExpression subjectExpression = ((KtBinaryExpressionWithTypeRHS)expression2).getLeft();
            KtTypeReference targetTypeReference = ((KtBinaryExpressionWithTypeRHS)expression2).getRight();
            IElementType operationToken = ((KtBinaryExpressionWithTypeRHS)expression2).getOperationReference().getReferencedNameElementType();
            identifierInfo = Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.IS_KEYWORD)) || Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.AS_KEYWORD)) ? (IdentifierInfo)IdentifierInfo.NO.INSTANCE : (IdentifierInfo)new IdentifierInfo.SafeCast(IdentifierInfoKt.getIdForStableIdentifier(subjectExpression, bindingContext2, containingDeclarationOrModule, languageVersionSettings), bindingContext2.getType(subjectExpression), (KotlinType)bindingContext2.get(BindingContext.TYPE, targetTypeReference));
        } else if (ktExpression instanceof KtSimpleNameExpression) {
            identifierInfo = IdentifierInfoKt.getIdForSimpleNameExpression((KtSimpleNameExpression)expression2, bindingContext2, containingDeclarationOrModule, languageVersionSettings);
        } else if (ktExpression instanceof KtThisExpression) {
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)bindingContext2.get(BindingContext.REFERENCE_TARGET, ((KtThisExpression)expression2).getInstanceReference());
            identifierInfo = IdentifierInfoKt.getIdForThisReceiver(declarationDescriptor);
        } else {
            IElementType operationType;
            identifierInfo = ktExpression instanceof KtPostfixExpression ? ((operationType = ((KtPostfixExpression)expression2).getOperationReference().getReferencedNameElementType()) == KtTokens.PLUSPLUS || operationType == KtTokens.MINUSMINUS ? IdentifierInfoKt.postfix(IdentifierInfoKt.getIdForStableIdentifier(((KtPostfixExpression)expression2).getBaseExpression(), bindingContext2, containingDeclarationOrModule, languageVersionSettings), (KtToken)operationType) : (IdentifierInfo)IdentifierInfo.NO.INSTANCE) : (IdentifierInfo)IdentifierInfo.NO.INSTANCE;
        }
        return identifierInfo;
    }

    private static final IdentifierInfo getIdForSimpleNameExpression(KtSimpleNameExpression simpleNameExpression, BindingContext bindingContext2, DeclarationDescriptor containingDeclarationOrModule, LanguageVersionSettings languageVersionSettings) {
        IdentifierInfo identifierInfo;
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)bindingContext2.get(BindingContext.REFERENCE_TARGET, simpleNameExpression);
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
        if (declarationDescriptor2 instanceof VariableDescriptor) {
            ReceiverValue implicitReceiver;
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(simpleNameExpression, bindingContext2);
            ModuleDescriptor usageModuleDescriptor = DescriptorUtils.getContainingModuleOrNull(containingDeclarationOrModule);
            IdentifierInfo.Variable selectorInfo = new IdentifierInfo.Variable((VariableDescriptor)declarationDescriptor, DataFlowValueKindUtilsKt.variableKind((VariableDescriptor)declarationDescriptor, usageModuleDescriptor, bindingContext2, simpleNameExpression, languageVersionSettings), (DataFlowValue)bindingContext2.get(BindingContext.BOUND_INITIALIZER_VALUE, declarationDescriptor));
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
            ReceiverValue receiverValue = implicitReceiver = resolvedCall3 != null ? resolvedCall3.getDispatchReceiver() : null;
            if (implicitReceiver == null) {
                identifierInfo = selectorInfo;
            } else {
                IdentifierInfo receiverInfo = IdentifierInfoKt.getIdForImplicitReceiver(implicitReceiver, simpleNameExpression);
                if (receiverInfo == null) {
                    identifierInfo = selectorInfo;
                } else {
                    KotlinType kotlinType = implicitReceiver.getType();
                    IdentifierInfo identifierInfo2 = selectorInfo;
                    ResolvedCall<? extends CallableDescriptor> resolvedCall4 = resolvedCall2;
                    Intrinsics.checkExpressionValueIsNotNull(resolvedCall4, (String)"resolvedCall");
                    Call call2 = resolvedCall4.getCall();
                    Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
                    identifierInfo = IdentifierInfoKt.qualified(receiverInfo, kotlinType, identifierInfo2, CallUtilKt.isSafeCall(call2));
                }
            }
        } else {
            identifierInfo = declarationDescriptor2 instanceof PackageViewDescriptor || declarationDescriptor2 instanceof ClassDescriptor ? (IdentifierInfo)new IdentifierInfo.PackageOrClass(declarationDescriptor) : (IdentifierInfo)IdentifierInfo.NO.INSTANCE;
        }
        return identifierInfo;
    }

    private static final IdentifierInfo getIdForImplicitReceiver(ReceiverValue receiverValue, KtExpression expression2) {
        IdentifierInfo identifierInfo;
        ReceiverValue receiverValue2 = receiverValue;
        if (receiverValue2 instanceof ImplicitReceiver) {
            identifierInfo = IdentifierInfoKt.getIdForThisReceiver(((ImplicitReceiver)receiverValue).getDeclarationDescriptor());
        } else {
            if (receiverValue2 instanceof TransientReceiver) {
                throw (Throwable)((Object)new AssertionError((Object)("Transient receiver is implicit for an explicit expression: " + expression2 + ". Receiver: " + receiverValue)));
            }
            identifierInfo = null;
        }
        return identifierInfo;
    }

    private static final IdentifierInfo getIdForThisReceiver(DeclarationDescriptor descriptorOfThisReceiver) {
        IdentifierInfo identifierInfo;
        DeclarationDescriptor declarationDescriptor = descriptorOfThisReceiver;
        if (declarationDescriptor instanceof CallableDescriptor) {
            ReceiverParameterDescriptor receiverParameter;
            ReceiverParameterDescriptor receiverParameterDescriptor = ((CallableDescriptor)descriptorOfThisReceiver).getExtensionReceiverParameter();
            if (receiverParameterDescriptor == null) {
                String string = "'This' refers to the callable member without a receiver parameter: " + descriptorOfThisReceiver;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            ReceiverParameterDescriptor receiverParameterDescriptor2 = receiverParameter = receiverParameterDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)receiverParameterDescriptor2, (String)"receiverParameter");
            ReceiverValue receiverValue = receiverParameterDescriptor2.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)receiverValue, (String)"receiverParameter.value");
            identifierInfo = new IdentifierInfo.Receiver(receiverValue);
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            ReceiverParameterDescriptor receiverParameterDescriptor = ((ClassDescriptor)descriptorOfThisReceiver).getThisAsReceiverParameter();
            Intrinsics.checkExpressionValueIsNotNull((Object)receiverParameterDescriptor, (String)"descriptorOfThisReceiver.thisAsReceiverParameter");
            ReceiverValue receiverValue = receiverParameterDescriptor.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)receiverValue, (String)"descriptorOfThisReceiver\u2026AsReceiverParameter.value");
            identifierInfo = new IdentifierInfo.Receiver(receiverValue);
        } else {
            identifierInfo = IdentifierInfo.NO.INSTANCE;
        }
        return identifierInfo;
    }

    private static final IdentifierInfo postfix(IdentifierInfo argumentInfo, KtToken op) {
        return Intrinsics.areEqual((Object)argumentInfo, (Object)IdentifierInfo.NO.INSTANCE) ? (IdentifierInfo)IdentifierInfo.NO.INSTANCE : (IdentifierInfo)new IdentifierInfo.PostfixIdentifierInfo(argumentInfo, op);
    }

    private static final IdentifierInfo qualified(IdentifierInfo receiverInfo, KotlinType receiverType2, IdentifierInfo selectorInfo, boolean safe) {
        IdentifierInfo identifierInfo = receiverInfo;
        return Intrinsics.areEqual((Object)identifierInfo, (Object)IdentifierInfo.NO.INSTANCE) ? (IdentifierInfo)IdentifierInfo.NO.INSTANCE : (identifierInfo instanceof IdentifierInfo.PackageOrClass ? selectorInfo : (IdentifierInfo)new IdentifierInfo.Qualified(receiverInfo, selectorInfo, safe, receiverType2));
    }
}

