/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"createValueParametersForInvokeInFunctionType", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "parameterTypes", "Lorg/jetbrains/kotlin/types/TypeProjection;", "getValueParametersCountFromFunctionType", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "resolution"})
public final class FunctionTypeResolveUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ValueParameterDescriptor> createValueParametersForInvokeInFunctionType(@NotNull FunctionDescriptor functionDescriptor2, @NotNull List<? extends TypeProjection> parameterTypes2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)functionDescriptor2, (String)"functionDescriptor");
        Intrinsics.checkParameterIsNotNull(parameterTypes2, (String)"parameterTypes");
        Iterable iterable = $receiver$iv = (Iterable)parameterTypes2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            void typeProjection;
            void i;
            int n = index$iv$iv++;
            TypeProjection typeProjection2 = (TypeProjection)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            CallableDescriptor callableDescriptor = functionDescriptor2;
            Annotations annotations2 = Annotations.Companion.getEMPTY();
            Name name2 = Name.identifier("" + 'p' + (int)(i + true));
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(\"p${i + 1}\")");
            KotlinType kotlinType = typeProjection.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"typeProjection.type");
            SourceElement sourceElement = SourceElement.NO_SOURCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"SourceElement.NO_SOURCE");
            ValueParameterDescriptorImpl valueParameterDescriptorImpl = new ValueParameterDescriptorImpl(callableDescriptor, null, (int)i, annotations2, name2, kotlinType, false, false, false, null, sourceElement);
            collection.add(valueParameterDescriptorImpl);
        }
        return (List)destination$iv$iv;
    }

    public static final int getValueParametersCountFromFunctionType(@NotNull KotlinType type2) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalType(type2);
        if (_Assertions.ENABLED && !bl) {
            String string = "Not a function type: " + type2;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return type2.getArguments().size() - (FunctionTypesKt.isBuiltinExtensionFunctionalType(type2) ? 1 : 0) - 1;
    }
}

