/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.inline;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineStrategy;

public class InlineUtil {
    public static boolean isInlineParameterExceptNullability(@NotNull ParameterDescriptor valueParameterOrReceiver) {
        return (!(valueParameterOrReceiver instanceof ValueParameterDescriptor) || !((ValueParameterDescriptor)valueParameterOrReceiver).isNoinline()) && FunctionTypesKt.isBuiltinFunctionalType(valueParameterOrReceiver.getOriginal().getType());
    }

    public static boolean isInlineParameter(@NotNull ParameterDescriptor valueParameterOrReceiver) {
        return InlineUtil.isInlineParameterExceptNullability(valueParameterOrReceiver) && !valueParameterOrReceiver.getOriginal().getType().isMarkedNullable();
    }

    public static boolean isInline(@Nullable DeclarationDescriptor descriptor2) {
        return descriptor2 instanceof FunctionDescriptor && InlineUtil.getInlineStrategy((FunctionDescriptor)descriptor2).isInline();
    }

    public static boolean hasInlineAccessors(@NotNull PropertyDescriptor propertyDescriptor) {
        PropertyGetterDescriptor getter = propertyDescriptor.getGetter();
        PropertySetterDescriptor setter = propertyDescriptor.getSetter();
        return getter != null && getter.isInline() || setter != null && setter.isInline();
    }

    public static boolean isPropertyWithAllAccessorsAreInline(@NotNull DeclarationDescriptor descriptor2) {
        if (!(descriptor2 instanceof PropertyDescriptor)) {
            return false;
        }
        PropertyGetterDescriptor getter = ((PropertyDescriptor)descriptor2).getGetter();
        if (getter == null || !getter.isInline()) {
            return false;
        }
        if (((PropertyDescriptor)descriptor2).isVar()) {
            PropertySetterDescriptor setter = ((PropertyDescriptor)descriptor2).getSetter();
            return setter != null && setter.isInline();
        }
        return true;
    }

    public static boolean isInlineOrContainingInline(@Nullable DeclarationDescriptor descriptor2) {
        if (InlineUtil.isInline(descriptor2)) {
            return true;
        }
        if (descriptor2 == null) {
            return false;
        }
        return InlineUtil.isInlineOrContainingInline(descriptor2.getContainingDeclaration());
    }

    @NotNull
    private static InlineStrategy getInlineStrategy(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2.isInline()) {
            return InlineStrategy.AS_FUNCTION;
        }
        return InlineStrategy.NOT_INLINE;
    }

    public static boolean checkNonLocalReturnUsage(@NotNull DeclarationDescriptor fromFunction, @NotNull KtExpression startExpression, @NotNull ResolutionContext<?> context2) {
        Object containingFunction = context2.getContextParentOfType(startExpression, KtClassOrObject.class, KtDeclarationWithBody.class);
        if (containingFunction == null) {
            return false;
        }
        return InlineUtil.checkNonLocalReturnUsage(fromFunction, context2.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, containingFunction), containingFunction, context2.trace.getBindingContext());
    }

    public static boolean checkNonLocalReturnUsage(@NotNull DeclarationDescriptor fromFunction, @Nullable DeclarationDescriptor containingFunctionDescriptor, @Nullable PsiElement containingFunction, @NotNull BindingContext bindingContext2) {
        if (containingFunctionDescriptor == null) {
            return false;
        }
        while (InlineUtil.canBeInlineArgument(containingFunction) && fromFunction != containingFunctionDescriptor) {
            if (!InlineUtil.isInlinedArgument((KtFunction)containingFunction, bindingContext2, true)) {
                return false;
            }
            containingFunction = (containingFunctionDescriptor = InlineUtil.getContainingClassOrFunctionDescriptor(containingFunctionDescriptor, true)) != null ? DescriptorToSourceUtils.descriptorToDeclaration(containingFunctionDescriptor) : null;
        }
        return fromFunction == containingFunctionDescriptor;
    }

    public static boolean isInlinedArgument(@NotNull KtFunction argument2, @NotNull BindingContext bindingContext2, boolean checkNonLocalReturn) {
        ValueParameterDescriptor descriptor2 = InlineUtil.getInlineArgumentDescriptor(argument2, bindingContext2);
        if (descriptor2 != null) {
            return !checkNonLocalReturn || InlineUtil.allowsNonLocalReturns(descriptor2);
        }
        return false;
    }

    @Nullable
    public static ValueParameterDescriptor getInlineArgumentDescriptor(@NotNull KtFunction argument2, @NotNull BindingContext bindingContext2) {
        if (!InlineUtil.canBeInlineArgument(argument2)) {
            return null;
        }
        KtExpression call2 = KtPsiUtil.getParentCallIfPresent(argument2);
        if (call2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(call2, bindingContext2);
        if (resolvedCall2 == null) {
            return null;
        }
        CallableDescriptor descriptor2 = resolvedCall2.getResultingDescriptor();
        if (!InlineUtil.isInline(descriptor2) && !InlineUtil.isArrayConstructorWithLambda(descriptor2)) {
            return null;
        }
        ValueArgument valueArgument = CallUtilKt.getValueArgumentForExpression(resolvedCall2.getCall(), argument2);
        if (valueArgument == null) {
            return null;
        }
        ArgumentMapping mapping2 = resolvedCall2.getArgumentMapping(valueArgument);
        if (!(mapping2 instanceof ArgumentMatch)) {
            return null;
        }
        ValueParameterDescriptor parameter = ((ArgumentMatch)mapping2).getValueParameter();
        return InlineUtil.isInlineParameter(parameter) ? parameter : null;
    }

    public static boolean canBeInlineArgument(@Nullable PsiElement functionalExpression) {
        return functionalExpression instanceof KtFunctionLiteral || functionalExpression instanceof KtNamedFunction;
    }

    public static boolean isArrayConstructorWithLambda(@NotNull CallableDescriptor descriptor2) {
        return descriptor2.getValueParameters().size() == 2 && descriptor2 instanceof ConstructorDescriptor && KotlinBuiltIns.isArrayOrPrimitiveArray(((ConstructorDescriptor)descriptor2).getConstructedClass());
    }

    @Nullable
    public static DeclarationDescriptor getContainingClassOrFunctionDescriptor(@NotNull DeclarationDescriptor descriptor2, boolean strict) {
        DeclarationDescriptor current;
        DeclarationDescriptor declarationDescriptor = current = strict ? descriptor2.getContainingDeclaration() : descriptor2;
        while (current != null) {
            if (current instanceof FunctionDescriptor || current instanceof ClassDescriptor) {
                return current;
            }
            current = current.getContainingDeclaration();
        }
        return null;
    }

    public static boolean allowsNonLocalReturns(@NotNull CallableDescriptor lambda2) {
        return !(lambda2 instanceof ValueParameterDescriptor) || !((ValueParameterDescriptor)lambda2).isCrossinline();
    }

    public static boolean containsReifiedTypeParameters(@NotNull CallableDescriptor descriptor2) {
        for (TypeParameterDescriptor typeParameterDescriptor : descriptor2.getTypeParameters()) {
            if (!typeParameterDescriptor.isReified()) continue;
            return true;
        }
        return false;
    }

    public static boolean isInlinableParameterExpression(@Nullable KtExpression deparenthesized) {
        return deparenthesized instanceof KtLambdaExpression || deparenthesized instanceof KtNamedFunction || deparenthesized instanceof KtCallableReferenceExpression;
    }
}

