/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

public class ResolveSessionUtils {
    private ResolveSessionUtils() {
    }

    @NotNull
    public static Collection<ClassDescriptor> getClassDescriptorsByFqName(@NotNull ModuleDescriptor module, @NotNull FqName fqName2) {
        return ResolveSessionUtils.getClassOrObjectDescriptorsByFqName(module, fqName2, descriptor2 -> true);
    }

    @NotNull
    private static Collection<ClassDescriptor> getClassOrObjectDescriptorsByFqName(@NotNull ModuleDescriptor module, @NotNull FqName fqName2, @NotNull Predicate<ClassDescriptor> filter2) {
        if (fqName2.isRoot()) {
            return Collections.emptyList();
        }
        ArrayList<ClassDescriptor> result2 = new ArrayList<ClassDescriptor>(1);
        FqName packageFqName = fqName2.parent();
        while (true) {
            PackageViewDescriptor packageDescriptor;
            if (!(packageDescriptor = module.getPackage(packageFqName)).isEmpty()) {
                FqName relativeClassFqName = FqNamesUtilKt.tail(fqName2, packageFqName);
                ClassDescriptor classDescriptor = ResolveSessionUtils.findClassByRelativePath(packageDescriptor.getMemberScope(), relativeClassFqName);
                if (classDescriptor != null && filter2.test(classDescriptor)) {
                    result2.add(classDescriptor);
                }
            }
            if (packageFqName.isRoot()) break;
            packageFqName = packageFqName.parent();
        }
        return result2;
    }

    @Nullable
    public static ClassDescriptor findClassByRelativePath(@NotNull MemberScope packageScope, @NotNull FqName path) {
        if (path.isRoot()) {
            return null;
        }
        MemberScope scope2 = packageScope;
        ClassifierDescriptor classifier = null;
        for (Name name2 : path.pathSegments()) {
            classifier = scope2.getContributedClassifier(name2, NoLookupLocation.WHEN_FIND_BY_FQNAME);
            if (!(classifier instanceof ClassDescriptor)) {
                return null;
            }
            scope2 = ((ClassDescriptor)classifier).getUnsubstitutedInnerClassesScope();
        }
        return (ClassDescriptor)classifier;
    }
}

