/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.checker;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.SpecialTypesKt;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeCheckerKt;
import org.jetbrains.kotlin.types.checker.TypeCheckerContext;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010J\u001c\u0010\u0011\u001a\u00020\u0004*\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001c\u0010\u0003\u001a\u00020\u0004*\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\u0014\u001a\u00020\u0004*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/types/checker/NullabilityChecker;", "", "()V", "hasPathByNotMarkedNullableNodes", "", "start", "Lorg/jetbrains/kotlin/types/SimpleType;", "end", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "isPossibleSubtype", "context", "Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext;", "subType", "superType", "isSubtypeOfAny", "type", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "hasNotNullSupertype", "supertypesPolicy", "Lorg/jetbrains/kotlin/types/checker/TypeCheckerContext$SupertypesPolicy;", "runIsPossibleSubtype", "descriptors"})
public final class NullabilityChecker {
    public static final NullabilityChecker INSTANCE;

    public final boolean isPossibleSubtype(@NotNull TypeCheckerContext context2, @NotNull SimpleType subType, @NotNull SimpleType superType) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)subType, (String)"subType");
        Intrinsics.checkParameterIsNotNull((Object)superType, (String)"superType");
        return this.runIsPossibleSubtype(context2, subType, superType);
    }

    public final boolean isSubtypeOfAny(@NotNull UnwrappedType type2) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        return this.hasNotNullSupertype(new TypeCheckerContext(false, false, 2, null), FlexibleTypesKt.lowerIfFlexible(type2), TypeCheckerContext.SupertypesPolicy.LowerIfFlexible.INSTANCE);
    }

    public final boolean hasPathByNotMarkedNullableNodes(@NotNull SimpleType start, @NotNull TypeConstructor end) {
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
        return this.hasPathByNotMarkedNullableNodes(new TypeCheckerContext(false, false, 2, null), start, end);
    }

    private final boolean runIsPossibleSubtype(@NotNull TypeCheckerContext $receiver, SimpleType subType, SimpleType superType) {
        boolean bl;
        boolean bl2 = bl = NewKotlinTypeCheckerKt.isIntersectionType(subType) || NewKotlinTypeCheckerKt.isSingleClassifierType(subType) || $receiver.isAllowedTypeVariable(subType);
        if (_Assertions.ENABLED && !bl) {
            String string = "Not singleClassifierType superType: " + superType;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        boolean bl3 = bl = NewKotlinTypeCheckerKt.isSingleClassifierType(superType) || $receiver.isAllowedTypeVariable(superType);
        if (_Assertions.ENABLED && !bl) {
            String string = "Not singleClassifierType superType: " + superType;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (superType.isMarkedNullable()) {
            return true;
        }
        if (SpecialTypesKt.isDefinitelyNotNullType(subType)) {
            return true;
        }
        if (this.hasNotNullSupertype($receiver, subType, TypeCheckerContext.SupertypesPolicy.LowerIfFlexible.INSTANCE)) {
            return true;
        }
        if (SpecialTypesKt.isDefinitelyNotNullType(superType)) {
            return false;
        }
        if (this.hasNotNullSupertype($receiver, superType, TypeCheckerContext.SupertypesPolicy.UpperIfFlexible.INSTANCE)) {
            return false;
        }
        if (NewKotlinTypeCheckerKt.isClassType(subType)) {
            return false;
        }
        return this.hasPathByNotMarkedNullableNodes($receiver, subType, superType.getConstructor());
    }

    private final boolean hasNotNullSupertype(@NotNull TypeCheckerContext $receiver, SimpleType type2, TypeCheckerContext.SupertypesPolicy supertypesPolicy) {
        boolean bl;
        block9: {
            TypeCheckerContext this_$iv = $receiver;
            SimpleType it = type2;
            if (NewKotlinTypeCheckerKt.isClassType(it) && !it.isMarkedNullable() || SpecialTypesKt.isDefinitelyNotNullType(it)) {
                bl = true;
            } else {
                Object object;
                TypeCheckerContext.access$initialize(this_$iv);
                ArrayDeque arrayDeque = TypeCheckerContext.access$getSupertypesDeque$p(this_$iv);
                if (arrayDeque == null) {
                    Intrinsics.throwNpe();
                }
                ArrayDeque deque$iv = arrayDeque;
                Set set2 = TypeCheckerContext.access$getSupertypesSet$p(this_$iv);
                if (set2 == null) {
                    Intrinsics.throwNpe();
                }
                Set visitedSupertypes$iv = set2;
                deque$iv.push(type2);
                while (!(object = (Collection)deque$iv).isEmpty()) {
                    TypeCheckerContext.SupertypesPolicy policy$iv;
                    SimpleType current$iv;
                    if (visitedSupertypes$iv.size() > 1000) {
                        object = "Too many supertypes for type: " + type2 + ". Supertypes = " + CollectionsKt.joinToString$default((Iterable)visitedSupertypes$iv, null, null, null, (int)0, null, null, (int)63, null);
                        throw (Throwable)new IllegalStateException(object.toString());
                    }
                    SimpleType simpleType2 = current$iv = (SimpleType)deque$iv.pop();
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"current");
                    if (!visitedSupertypes$iv.add(simpleType2)) continue;
                    it = current$iv;
                    TypeCheckerContext.SupertypesPolicy supertypesPolicy2 = it.isMarkedNullable() ? (TypeCheckerContext.SupertypesPolicy)TypeCheckerContext.SupertypesPolicy.None.INSTANCE : supertypesPolicy;
                    TypeCheckerContext.SupertypesPolicy it$iv = supertypesPolicy2;
                    if ((Intrinsics.areEqual((Object)it$iv, (Object)TypeCheckerContext.SupertypesPolicy.None.INSTANCE) ^ true ? supertypesPolicy2 : null) == null) {
                        continue;
                    }
                    policy$iv = policy$iv;
                    Iterator<KotlinType> iterator2 = current$iv.getConstructor().getSupertypes().iterator();
                    while (iterator2.hasNext()) {
                        SimpleType newType$iv;
                        KotlinType supertype$iv;
                        KotlinType kotlinType = supertype$iv = iterator2.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"supertype");
                        it = newType$iv = policy$iv.transformType(kotlinType);
                        if (NewKotlinTypeCheckerKt.isClassType(it) && !it.isMarkedNullable() || SpecialTypesKt.isDefinitelyNotNullType(it)) {
                            TypeCheckerContext.access$clear(this_$iv);
                            bl = true;
                            break block9;
                        }
                        deque$iv.add(newType$iv);
                    }
                }
                TypeCheckerContext.access$clear(this_$iv);
                bl = false;
            }
        }
        return bl;
    }

    private final boolean hasPathByNotMarkedNullableNodes(@NotNull TypeCheckerContext $receiver, SimpleType start, TypeConstructor end) {
        boolean bl;
        block9: {
            TypeCheckerContext this_$iv = $receiver;
            SimpleType it = start;
            if (!it.isMarkedNullable() && Intrinsics.areEqual((Object)it.getConstructor(), (Object)end)) {
                bl = true;
            } else {
                Object object;
                TypeCheckerContext.access$initialize(this_$iv);
                ArrayDeque arrayDeque = TypeCheckerContext.access$getSupertypesDeque$p(this_$iv);
                if (arrayDeque == null) {
                    Intrinsics.throwNpe();
                }
                ArrayDeque deque$iv = arrayDeque;
                Set set2 = TypeCheckerContext.access$getSupertypesSet$p(this_$iv);
                if (set2 == null) {
                    Intrinsics.throwNpe();
                }
                Set visitedSupertypes$iv = set2;
                deque$iv.push(start);
                while (!(object = (Collection)deque$iv).isEmpty()) {
                    TypeCheckerContext.SupertypesPolicy policy$iv;
                    SimpleType current$iv;
                    if (visitedSupertypes$iv.size() > 1000) {
                        object = "Too many supertypes for type: " + start + ". Supertypes = " + CollectionsKt.joinToString$default((Iterable)visitedSupertypes$iv, null, null, null, (int)0, null, null, (int)63, null);
                        throw (Throwable)new IllegalStateException(object.toString());
                    }
                    SimpleType simpleType2 = current$iv = (SimpleType)deque$iv.pop();
                    Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"current");
                    if (!visitedSupertypes$iv.add(simpleType2)) continue;
                    it = current$iv;
                    TypeCheckerContext.SupertypesPolicy supertypesPolicy = it.isMarkedNullable() ? (TypeCheckerContext.SupertypesPolicy)TypeCheckerContext.SupertypesPolicy.None.INSTANCE : (TypeCheckerContext.SupertypesPolicy)TypeCheckerContext.SupertypesPolicy.LowerIfFlexible.INSTANCE;
                    TypeCheckerContext.SupertypesPolicy it$iv = supertypesPolicy;
                    if ((Intrinsics.areEqual((Object)it$iv, (Object)TypeCheckerContext.SupertypesPolicy.None.INSTANCE) ^ true ? supertypesPolicy : null) == null) {
                        continue;
                    }
                    policy$iv = policy$iv;
                    Iterator<KotlinType> iterator2 = current$iv.getConstructor().getSupertypes().iterator();
                    while (iterator2.hasNext()) {
                        SimpleType newType$iv;
                        KotlinType supertype$iv;
                        KotlinType kotlinType = supertype$iv = iterator2.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"supertype");
                        it = newType$iv = policy$iv.transformType(kotlinType);
                        if (!it.isMarkedNullable() && Intrinsics.areEqual((Object)it.getConstructor(), (Object)end)) {
                            TypeCheckerContext.access$clear(this_$iv);
                            bl = true;
                            break block9;
                        }
                        deque$iv.add(newType$iv);
                    }
                }
                TypeCheckerContext.access$clear(this_$iv);
                bl = false;
            }
        }
        return bl;
    }

    private NullabilityChecker() {
    }

    static {
        NullabilityChecker nullabilityChecker;
        INSTANCE = nullabilityChecker = new NullabilityChecker();
    }
}

