/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtInstanceExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.psiUtil.ReservedCheckingKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.ObservableBindingTrace;
import org.jetbrains.kotlin.resolve.PossiblyBareType;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TypeResolutionContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallExpressionResolver;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.RttiExpressionChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.RttiExpressionInformation;
import org.jetbrains.kotlin.resolve.calls.checkers.RttiOperation;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.DataFlowInfoForArgumentsImpl;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.checkers.UnderscoreChecker;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.UnsignedErrorValueTypeConstant;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.CastDiagnosticsUtil;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.LabelResolver;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.expressions.SenselessComparisonChecker;
import org.jetbrains.kotlin.types.expressions.TypeReconstructionUtil;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.types.expressions.unqualifiedSuper.UnqualifiedSuperKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public class BasicExpressionTypingVisitor
extends ExpressionTypingVisitor {
    private static final TokenSet BARE_TYPES_ALLOWED = TokenSet.create((IElementType[])new IElementType[]{KtTokens.AS_KEYWORD, KtTokens.AS_SAFE});
    private static final Pattern FP_LITERAL_PARTS = Pattern.compile("(?:([_\\d]*)\\.?([_\\d]*)e?[+-]?([_\\d]*))[f]?");

    protected BasicExpressionTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        super(facade);
    }

    private static boolean isLValueOrUnsafeReceiver(@NotNull KtSimpleNameExpression expression2) {
        PsiElement parent2 = PsiTreeUtil.skipParentsOfType((PsiElement)expression2, (Class[])new Class[]{KtParenthesizedExpression.class});
        if (parent2 instanceof KtQualifiedExpression) {
            KtQualifiedExpression qualifiedExpression = (KtQualifiedExpression)parent2;
            return qualifiedExpression.getOperationSign() == KtTokens.DOT && qualifiedExpression.getReceiverExpression() == KtPsiUtil.deparenthesize(expression2);
        }
        if (parent2 instanceof KtBinaryExpression) {
            KtBinaryExpression binaryExpression = (KtBinaryExpression)parent2;
            if (!OperatorConventions.BINARY_OPERATION_NAMES.containsKey((Object)binaryExpression.getOperationToken()) && !KtTokens.ALL_ASSIGNMENTS.contains(binaryExpression.getOperationToken())) {
                return false;
            }
            return PsiTreeUtil.isAncestor((PsiElement)binaryExpression.getLeft(), (PsiElement)expression2, (boolean)false);
        }
        return false;
    }

    private static boolean isDangerousWithNull(@NotNull KtSimpleNameExpression expression2, @NotNull ExpressionTypingContext context2) {
        PsiElement parent2 = PsiTreeUtil.skipParentsOfType((PsiElement)expression2, (Class[])new Class[]{KtParenthesizedExpression.class});
        if (parent2 instanceof KtUnaryExpression) {
            KtUnaryExpression unaryExpression = (KtUnaryExpression)parent2;
            return unaryExpression.getOperationToken() == KtTokens.EXCLEXCL;
        }
        if (parent2 instanceof KtBinaryExpressionWithTypeRHS) {
            KtBinaryExpressionWithTypeRHS binaryExpression = (KtBinaryExpressionWithTypeRHS)parent2;
            KotlinType type2 = context2.trace.get(BindingContext.TYPE, binaryExpression.getRight());
            return type2 != null && !type2.isMarkedNullable() && binaryExpression.getOperationReference().getReferencedNameElementType() == KtTokens.AS_KEYWORD;
        }
        return false;
    }

    private void checkNull(@NotNull KtSimpleNameExpression expression2, @NotNull ExpressionTypingContext context2, @Nullable KotlinType type2) {
        DataFlowValue dataFlowValue2;
        Nullability nullability;
        if (type2 != null && !KotlinTypeKt.isError(type2) && !BasicExpressionTypingVisitor.isLValueOrUnsafeReceiver(expression2) && !(nullability = context2.dataFlowInfo.getStableNullability(dataFlowValue2 = this.components.dataFlowValueFactory.createDataFlowValue(expression2, type2, context2))).canBeNonNull() && nullability.canBeNull()) {
            if (BasicExpressionTypingVisitor.isDangerousWithNull(expression2, context2)) {
                context2.trace.report(Errors.ALWAYS_NULL.on(expression2));
            } else {
                context2.trace.record(BindingContext.SMARTCAST_NULL, expression2);
            }
        }
    }

    @Override
    public KotlinTypeInfo visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2, ExpressionTypingContext context2) {
        ReservedCheckingKt.checkReservedYield(expression2, context2.trace);
        CallExpressionResolver callExpressionResolver = this.components.callExpressionResolver;
        KotlinTypeInfo typeInfo = callExpressionResolver.getSimpleNameExpressionTypeInfo(expression2, null, null, context2);
        this.checkNull(expression2, context2, typeInfo.getType());
        this.components.constantExpressionEvaluator.evaluateExpression(expression2, context2.trace, context2.expectedType);
        return this.components.dataFlowAnalyzer.checkType(typeInfo, (KtExpression)expression2, (ResolutionContext)context2);
    }

    @Override
    public KotlinTypeInfo visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression2, ExpressionTypingContext context2) {
        KtExpression innerExpression = expression2.getExpression();
        if (innerExpression == null) {
            return TypeInfoFactoryKt.noTypeInfo(context2);
        }
        KotlinTypeInfo result2 = this.facade.getTypeInfo(innerExpression, context2);
        KotlinType resultType = result2.getType();
        if (resultType != null) {
            DataFlowValue innerValue = this.components.dataFlowValueFactory.createDataFlowValue(innerExpression, resultType, context2);
            DataFlowValue resultValue = this.components.dataFlowValueFactory.createDataFlowValue(expression2, resultType, context2);
            result2 = result2.replaceDataFlowInfo(result2.getDataFlowInfo().assign(resultValue, innerValue, this.components.languageVersionSettings));
        }
        return result2;
    }

    @Override
    public KotlinTypeInfo visitConstantExpression(@NotNull KtConstantExpression expression2, ExpressionTypingContext context2) {
        ConstantValue constantValue;
        CompileTimeConstantChecker constantChecker;
        boolean hasError;
        CompileTimeConstant<?> compileTimeConstant;
        IElementType elementType = expression2.getNode().getElementType();
        if (elementType == KtNodeTypes.CHARACTER_CONSTANT || elementType == KtNodeTypes.INTEGER_CONSTANT || elementType == KtNodeTypes.FLOAT_CONSTANT) {
            BasicExpressionTypingVisitor.checkLiteralPrefixAndSuffix((PsiElement)expression2, context2);
        }
        if (elementType == KtNodeTypes.INTEGER_CONSTANT || elementType == KtNodeTypes.FLOAT_CONSTANT) {
            this.checkUnderscores(expression2, elementType, context2);
        }
        if ((compileTimeConstant = this.components.constantExpressionEvaluator.evaluateExpression(expression2, context2.trace, context2.expectedType)) instanceof UnsignedErrorValueTypeConstant) {
            ErrorValue.ErrorValueWithMessage value = ((UnsignedErrorValueTypeConstant)compileTimeConstant).getErrorValue();
            context2.trace.report(Errors.UNSIGNED_LITERAL_WITHOUT_DECLARATIONS_ON_CLASSPATH.on(expression2));
            return TypeInfoFactoryKt.createTypeInfo((KotlinType)value.getType(this.components.moduleDescriptor), context2);
        }
        if (!(compileTimeConstant instanceof IntegerValueTypeConstant) && (hasError = (constantChecker = new CompileTimeConstantChecker(context2, this.components.moduleDescriptor, false)).checkConstantExpressionType(constantValue = compileTimeConstant != null ? ((TypedCompileTimeConstant)compileTimeConstant).getConstantValue() : null, expression2, context2.expectedType))) {
            return TypeInfoFactoryKt.createTypeInfo(constantValue != null ? constantValue.getType(this.components.moduleDescriptor) : this.getDefaultType(elementType), context2);
        }
        assert (compileTimeConstant != null) : "CompileTimeConstant should be evaluated for constant expression or an error should be recorded " + expression2.getText();
        return this.components.dataFlowAnalyzer.createCompileTimeConstantTypeInfo(compileTimeConstant, expression2, context2);
    }

    private void checkUnderscores(@NotNull KtConstantExpression expression2, @NotNull IElementType elementType, @NotNull ExpressionTypingContext context2) {
        List<String> parts;
        String text2 = expression2.getText().toLowerCase();
        if (!text2.contains("_")) {
            return;
        }
        if (!this.components.languageVersionSettings.supportsFeature(LanguageFeature.UnderscoresInNumericLiterals)) {
            context2.trace.report(Errors.UNSUPPORTED_FEATURE.on((PsiElement)expression2, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.UnderscoresInNumericLiterals), (Object)this.components.languageVersionSettings)));
            return;
        }
        if (elementType == KtNodeTypes.INTEGER_CONSTANT) {
            int start = 0;
            int end = expression2.getText().length();
            if (text2.startsWith("0x") || text2.startsWith("0b")) {
                start += 2;
            }
            if (StringUtil.endsWithChar((CharSequence)text2, (char)'l')) {
                --end;
            }
            parts = Collections.singletonList(text2.substring(start, end));
        } else {
            Matcher matcher2 = FP_LITERAL_PARTS.matcher(text2);
            parts = new ArrayList<String>();
            if (matcher2.matches()) {
                for (int i = 0; i < matcher2.groupCount(); ++i) {
                    parts.add(matcher2.group(i + 1));
                }
            }
        }
        for (String part : parts) {
            if (part == null || !part.startsWith("_") && !part.endsWith("_")) continue;
            context2.trace.report(Errors.ILLEGAL_UNDERSCORE.on(expression2));
            return;
        }
    }

    @NotNull
    public KotlinType getDefaultType(IElementType constantType) {
        KotlinBuiltIns builtIns = this.components.builtIns;
        if (constantType == KtNodeTypes.INTEGER_CONSTANT) {
            return builtIns.getIntType();
        }
        if (constantType == KtNodeTypes.FLOAT_CONSTANT) {
            return builtIns.getDoubleType();
        }
        if (constantType == KtNodeTypes.BOOLEAN_CONSTANT) {
            return builtIns.getBooleanType();
        }
        if (constantType == KtNodeTypes.CHARACTER_CONSTANT) {
            return builtIns.getCharType();
        }
        if (constantType == KtNodeTypes.NULL) {
            return builtIns.getNullableNothingType();
        }
        throw new IllegalArgumentException("Unsupported constant type: " + constantType);
    }

    @Override
    public KotlinTypeInfo visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2, ExpressionTypingContext context2) {
        ExpressionTypingContext contextWithNoExpectedType = (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        KtExpression left = expression2.getLeft();
        KtTypeReference right = expression2.getRight();
        if (right == null) {
            return this.facade.getTypeInfo(left, contextWithNoExpectedType).clearType();
        }
        IElementType operationType = expression2.getOperationReference().getReferencedNameElementType();
        boolean allowBareTypes = BARE_TYPES_ALLOWED.contains(operationType);
        TypeResolutionContext typeResolutionContext = new TypeResolutionContext(context2.scope, context2.trace, true, allowBareTypes, context2.isDebuggerContext);
        PossiblyBareType possiblyBareTarget = this.components.typeResolver.resolvePossiblyBareType(typeResolutionContext, right);
        KotlinTypeInfo typeInfo = this.facade.getTypeInfo(left, contextWithNoExpectedType);
        KotlinType subjectType = typeInfo.getType();
        KotlinType targetType = TypeReconstructionUtil.reconstructBareType(right, possiblyBareTarget, subjectType, context2.trace, this.components.builtIns);
        if (subjectType != null) {
            this.checkBinaryWithTypeRHS(expression2, context2, targetType, subjectType);
            DataFlowInfo dataFlowInfo = typeInfo.getDataFlowInfo();
            if (operationType == KtTokens.AS_KEYWORD) {
                DataFlowValue value = this.components.dataFlowValueFactory.createDataFlowValue(left, subjectType, context2);
                typeInfo = typeInfo.replaceDataFlowInfo(dataFlowInfo.establishSubtyping(value, targetType, this.components.languageVersionSettings));
            }
        }
        KotlinType result2 = operationType == KtTokens.AS_SAFE ? TypeUtils.makeNullable(targetType) : targetType;
        KotlinTypeInfo resultTypeInfo = this.components.dataFlowAnalyzer.checkType(typeInfo.replaceType(result2), (KtExpression)expression2, (ResolutionContext)context2);
        RttiExpressionInformation rttiInformation = new RttiExpressionInformation(expression2.getLeft(), subjectType, result2, operationType == KtTokens.AS_SAFE ? RttiOperation.SAFE_AS : RttiOperation.AS);
        for (RttiExpressionChecker checker : this.components.rttiExpressionCheckers) {
            checker.check(rttiInformation, (PsiElement)expression2, context2.trace);
        }
        return resultTypeInfo;
    }

    private void checkBinaryWithTypeRHS(@NotNull KtBinaryExpressionWithTypeRHS expression2, @NotNull ExpressionTypingContext context2, @NotNull KotlinType targetType, @Nullable KotlinType actualType) {
        if (actualType == null) {
            return;
        }
        KtSimpleNameExpression operationSign = expression2.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType != KtTokens.AS_KEYWORD && operationType != KtTokens.AS_SAFE) {
            context2.trace.report(Errors.UNSUPPORTED.on((PsiElement)operationSign, "binary operation with type RHS"));
            return;
        }
        this.checkForCastImpossibilityOrRedundancy(expression2, actualType, targetType, context2);
    }

    private void checkForCastImpossibilityOrRedundancy(KtBinaryExpressionWithTypeRHS expression2, KotlinType actualType, KotlinType targetType, ExpressionTypingContext context2) {
        if (actualType == null || TypeUtils.noExpectedType(targetType) || KotlinTypeKt.isError(targetType)) {
            return;
        }
        if (Boolean.TRUE.equals(context2.trace.get(BindingContext.CAST_TYPE_USED_AS_EXPECTED_TYPE, expression2))) {
            return;
        }
        if (DynamicTypesKt.isDynamic(targetType)) {
            KtTypeReference right = expression2.getRight();
            assert (right != null) : "We know target is dynamic, but RHS is missing";
            context2.trace.report(Errors.DYNAMIC_NOT_ALLOWED.on(right));
            return;
        }
        if (!CastDiagnosticsUtil.isCastPossible(actualType, targetType, this.components.platformToKotlinClassMap)) {
            context2.trace.report(Errors.CAST_NEVER_SUCCEEDS.on(expression2.getOperationReference()));
            return;
        }
        if (CastDiagnosticsUtil.INSTANCE.castIsUseless(expression2, context2, targetType, actualType)) {
            context2.trace.report(Errors.USELESS_CAST.on(expression2));
            return;
        }
        if (CastDiagnosticsUtil.isCastErased(actualType, targetType, KotlinTypeChecker.DEFAULT)) {
            context2.trace.report(Errors.UNCHECKED_CAST.on(expression2, actualType, targetType));
        }
    }

    @Override
    public KotlinTypeInfo visitThisExpression(@NotNull KtThisExpression expression2, ExpressionTypingContext context2) {
        KotlinType result2 = null;
        LabelResolver.LabeledReceiverResolutionResult resolutionResult = this.resolveToReceiver(expression2, context2, false);
        switch (resolutionResult.getCode()) {
            case LABEL_RESOLUTION_ERROR: {
                break;
            }
            case NO_THIS: {
                context2.trace.report(Errors.NO_THIS.on(expression2));
                break;
            }
            case SUCCESS: {
                result2 = resolutionResult.getReceiverParameterDescriptor().getType();
                context2.trace.recordType(expression2.getInstanceReference(), result2);
            }
        }
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(result2, context2, expression2);
    }

    @Override
    public KotlinTypeInfo visitSuperExpression(@NotNull KtSuperExpression expression2, ExpressionTypingContext context2) {
        LabelResolver.LabeledReceiverResolutionResult resolutionResult = this.resolveToReceiver(expression2, context2, true);
        if (!KtPsiUtil.isLHSOfDot(expression2)) {
            context2.trace.report(Errors.SUPER_IS_NOT_AN_EXPRESSION.on(expression2, expression2.getText()));
            return this.errorInSuper(expression2, context2);
        }
        switch (resolutionResult.getCode()) {
            case LABEL_RESOLUTION_ERROR: {
                return this.errorInSuper(expression2, context2);
            }
            case NO_THIS: {
                context2.trace.report(Errors.SUPER_NOT_AVAILABLE.on(expression2));
                return this.errorInSuper(expression2, context2);
            }
            case SUCCESS: {
                KotlinType result2 = this.checkPossiblyQualifiedSuper(expression2, context2, resolutionResult.getReceiverParameterDescriptor());
                if (result2 != null) {
                    context2.trace.recordType(expression2.getInstanceReference(), result2);
                }
                return this.components.dataFlowAnalyzer.createCheckedTypeInfo(result2, context2, expression2);
            }
        }
        throw new IllegalStateException("Unknown code: " + (Object)((Object)resolutionResult.getCode()));
    }

    private KotlinTypeInfo errorInSuper(KtSuperExpression expression2, ExpressionTypingContext context2) {
        KtTypeReference superTypeQualifier = expression2.getSuperTypeQualifier();
        if (superTypeQualifier != null) {
            this.components.typeResolver.resolveType(context2.scope, superTypeQualifier, context2.trace, true);
        }
        return TypeInfoFactoryKt.noTypeInfo(context2);
    }

    private KotlinType checkPossiblyQualifiedSuper(KtSuperExpression expression2, ExpressionTypingContext context2, ReceiverParameterDescriptor thisReceiver) {
        KtTypeReference superTypeQualifier;
        KotlinType thisType;
        KotlinType result2;
        block22: {
            TypeSubstitutor substitutor3;
            Collection<KotlinType> supertypes2;
            block19: {
                boolean validType;
                KtTypeArgumentList redundantTypeArguments;
                KotlinType supertype;
                ClassifierDescriptor classifierCandidate;
                block21: {
                    block20: {
                        result2 = null;
                        thisType = thisReceiver.getType();
                        supertypes2 = thisType.getConstructor().getSupertypes();
                        substitutor3 = TypeSubstitutor.create(thisType);
                        superTypeQualifier = expression2.getSuperTypeQualifier();
                        if (superTypeQualifier == null) break block19;
                        KtTypeElement typeElement = superTypeQualifier.getTypeElement();
                        classifierCandidate = null;
                        supertype = null;
                        redundantTypeArguments = null;
                        if (typeElement instanceof KtUserType) {
                            KtUserType userType2 = (KtUserType)typeElement;
                            if (userType2.getTypeArguments().isEmpty()) {
                                classifierCandidate = this.components.typeResolver.resolveClass(context2.scope, userType2, context2.trace, context2.isDebuggerContext);
                            } else {
                                supertype = this.components.typeResolver.resolveType(context2.scope, superTypeQualifier, context2.trace, true);
                                redundantTypeArguments = userType2.getTypeArgumentList();
                            }
                        } else {
                            supertype = this.components.typeResolver.resolveType(context2.scope, superTypeQualifier, context2.trace, true);
                        }
                        if (classifierCandidate instanceof TypeAliasDescriptor) {
                            classifierCandidate = ((TypeAliasDescriptor)classifierCandidate).getClassDescriptor();
                        }
                        if (supertype == null) break block20;
                        if (!supertypes2.contains(supertype)) break block21;
                        result2 = supertype;
                        break block21;
                    }
                    if (classifierCandidate instanceof ClassDescriptor) {
                        ClassifierDescriptor superclass = classifierCandidate;
                        for (KotlinType declaredSupertype : supertypes2) {
                            if (!declaredSupertype.getConstructor().equals(superclass.getTypeConstructor())) continue;
                            result2 = substitutor3.safeSubstitute(declaredSupertype, Variance.INVARIANT);
                            break;
                        }
                    }
                }
                boolean validClassifier = classifierCandidate != null && !ErrorUtils.isError(classifierCandidate);
                boolean bl = validType = supertype != null && !KotlinTypeKt.isError(supertype);
                if (result2 == null && (validClassifier || validType)) {
                    context2.trace.report(Errors.NOT_A_SUPERTYPE.on(superTypeQualifier));
                } else if (redundantTypeArguments != null) {
                    context2.trace.report(Errors.TYPE_ARGUMENTS_REDUNDANT_IN_SUPER_QUALIFIER.on((PsiElement)redundantTypeArguments));
                }
                if (result2 != null && (validClassifier || validType)) {
                    BasicExpressionTypingVisitor.checkResolvedExplicitlyQualifiedSupertype(context2.trace, result2, supertypes2, superTypeQualifier);
                }
                break block22;
            }
            if (UnqualifiedSuperKt.isPossiblyAmbiguousUnqualifiedSuper(expression2, supertypes2)) {
                Collection<KotlinType> supertypesResolvedFromContext = UnqualifiedSuperKt.resolveUnqualifiedSuperFromExpressionContext(expression2, supertypes2, this.components.builtIns.getAnyType());
                if (supertypesResolvedFromContext.size() == 1) {
                    KotlinType singleResolvedType = supertypesResolvedFromContext.iterator().next();
                    result2 = substitutor3.substitute(singleResolvedType, Variance.INVARIANT);
                } else if (supertypesResolvedFromContext.isEmpty()) {
                    result2 = this.components.builtIns.getAnyType();
                } else {
                    context2.trace.report(Errors.AMBIGUOUS_SUPER.on(expression2));
                }
            } else {
                KotlinType type2 = supertypes2.isEmpty() ? this.components.builtIns.getAnyType() : supertypes2.iterator().next();
                result2 = substitutor3.substitute(type2, Variance.INVARIANT);
            }
        }
        if (result2 != null) {
            if (DescriptorUtils.isInterface(thisType.getConstructor().getDeclarationDescriptor()) && DescriptorUtils.isClass(result2.getConstructor().getDeclarationDescriptor())) {
                context2.trace.report(Errors.SUPERCLASS_NOT_ACCESSIBLE_FROM_INTERFACE.on(expression2));
            }
            context2.trace.recordType(expression2.getInstanceReference(), result2);
            context2.trace.record(BindingContext.REFERENCE_TARGET, expression2.getInstanceReference(), result2.getConstructor().getDeclarationDescriptor());
            context2.trace.record(BindingContext.THIS_TYPE_FOR_SUPER_EXPRESSION, expression2, thisType);
        }
        BindingContextUtilsKt.recordScope(context2.trace, context2.scope, superTypeQualifier);
        return result2;
    }

    private static void checkResolvedExplicitlyQualifiedSupertype(@NotNull BindingTrace trace, @NotNull KotlinType result2, @NotNull Collection<KotlinType> supertypes2, @NotNull KtTypeReference superTypeQualifier) {
        if (supertypes2.size() > 1) {
            ClassifierDescriptor resultClassifierDescriptor = result2.getConstructor().getDeclarationDescriptor();
            for (KotlinType otherSupertype : supertypes2) {
                ClassifierDescriptor otherSupertypeClassifierDescriptor = otherSupertype.getConstructor().getDeclarationDescriptor();
                if (otherSupertypeClassifierDescriptor == resultClassifierDescriptor || !KotlinTypeChecker.DEFAULT.isSubtypeOf(otherSupertype, result2)) continue;
                trace.report(Errors.QUALIFIED_SUPERTYPE_EXTENDED_BY_OTHER_SUPERTYPE.on(superTypeQualifier, otherSupertype));
                break;
            }
        }
    }

    @NotNull
    private LabelResolver.LabeledReceiverResolutionResult resolveToReceiver(KtInstanceExpressionWithLabel expression2, ExpressionTypingContext context2, boolean onlyClassReceivers) {
        Name labelName2 = expression2.getLabelNameAsName();
        if (labelName2 != null) {
            LabelResolver.LabeledReceiverResolutionResult resolutionResult = LabelResolver.INSTANCE.resolveThisOrSuperLabel(expression2, context2, labelName2);
            if (resolutionResult.success()) {
                ReceiverParameterDescriptor receiverParameterDescriptor = resolutionResult.getReceiverParameterDescriptor();
                this.recordThisOrSuperCallInTraceAndCallExtension(context2, receiverParameterDescriptor, expression2);
                if (onlyClassReceivers && !BasicExpressionTypingVisitor.isDeclaredInClass(receiverParameterDescriptor)) {
                    return LabelResolver.LabeledReceiverResolutionResult.Companion.labelResolutionSuccess(null);
                }
            }
            return resolutionResult;
        }
        ReceiverParameterDescriptor result2 = null;
        List<ReceiverParameterDescriptor> receivers = ScopeUtilsKt.getImplicitReceiversHierarchy(context2.scope);
        if (onlyClassReceivers) {
            for (ReceiverParameterDescriptor receiver : receivers) {
                if (!BasicExpressionTypingVisitor.isDeclaredInClass(receiver)) continue;
                result2 = receiver;
                break;
            }
        } else if (!receivers.isEmpty()) {
            result2 = receivers.get(0);
        }
        if (result2 != null) {
            context2.trace.record(BindingContext.REFERENCE_TARGET, expression2.getInstanceReference(), result2.getContainingDeclaration());
            this.recordThisOrSuperCallInTraceAndCallExtension(context2, result2, expression2);
        }
        return LabelResolver.LabeledReceiverResolutionResult.Companion.labelResolutionSuccess(result2);
    }

    private void recordThisOrSuperCallInTraceAndCallExtension(ExpressionTypingContext context2, ReceiverParameterDescriptor descriptor2, KtExpression expression2) {
        BindingTrace trace = context2.trace;
        Call call2 = CallMaker.makeCall(expression2, null, null, expression2, Collections.emptyList());
        ResolutionCandidate<ReceiverParameterDescriptor> resolutionCandidate = ResolutionCandidate.create(call2, descriptor2, null, ExplicitReceiverKind.NO_EXPLICIT_RECEIVER, null);
        ResolvedCallImpl<ReceiverParameterDescriptor> resolvedCall2 = ResolvedCallImpl.create(resolutionCandidate, TemporaryBindingTrace.create(trace, "Fake trace for fake 'this' or 'super' resolved call"), TracingStrategy.EMPTY, new DataFlowInfoForArgumentsImpl(context2.dataFlowInfo, call2));
        resolvedCall2.markCallAsCompleted();
        trace.record(BindingContext.RESOLVED_CALL, call2, resolvedCall2);
        trace.record(BindingContext.CALL, expression2, call2);
        if (context2.trace.wantsDiagnostics()) {
            CallCheckerContext callCheckerContext = this.createCallCheckerContext(context2);
            for (CallChecker checker : this.components.callCheckers) {
                checker.check(resolvedCall2, (PsiElement)expression2, callCheckerContext);
            }
        }
    }

    private static boolean isDeclaredInClass(ReceiverParameterDescriptor receiver) {
        return receiver.getContainingDeclaration() instanceof ClassDescriptor;
    }

    @Override
    public KotlinTypeInfo visitBlockExpression(@NotNull KtBlockExpression expression2, ExpressionTypingContext context2) {
        return this.components.expressionTypingServices.getBlockReturnedType(expression2, context2, false);
    }

    @Override
    public KotlinTypeInfo visitClassLiteralExpression(@NotNull KtClassLiteralExpression expression2, ExpressionTypingContext c) {
        return this.components.doubleColonExpressionResolver.visitClassLiteralExpression(expression2, c);
    }

    @Override
    public KotlinTypeInfo visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression2, ExpressionTypingContext c) {
        return this.components.doubleColonExpressionResolver.visitCallableReferenceExpression(expression2, c);
    }

    @Override
    public KotlinTypeInfo visitObjectLiteralExpression(@NotNull KtObjectLiteralExpression expression2, ExpressionTypingContext context2) {
        KotlinType[] result2 = new KotlinType[1];
        TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(context2.trace, "trace to resolve object literal expression", expression2);
        ObservableBindingTrace traceAdapter = new ObservableBindingTrace(temporaryTrace);
        traceAdapter.addHandler(BindingContext.CLASS, (slice, declaration2, descriptor2) -> {
            if (slice == BindingContext.CLASS && declaration2 == expression2.getObjectDeclaration()) {
                result2[0] = this.components.wrappedTypeFactory.createRecursionIntolerantDeferredType(context2.trace, (Function0<? extends KotlinType>)((Function0)descriptor2::getDefaultType));
            }
        });
        this.components.localClassifierAnalyzer.processClassOrObject(null, (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceBindingTrace(traceAdapter)).replaceContextDependency(ContextDependency.INDEPENDENT), context2.scope.getOwnerDescriptor(), expression2.getObjectDeclaration());
        temporaryTrace.commit();
        DataFlowInfo resultFlowInfo = context2.dataFlowInfo;
        for (KtSuperTypeListEntry specifier : expression2.getObjectDeclaration().getSuperTypeListEntries()) {
            KtSuperTypeCallEntry delegator;
            KotlinTypeInfo delegatorTypeInfo;
            if (!(specifier instanceof KtSuperTypeCallEntry) || (delegatorTypeInfo = context2.trace.get(BindingContext.EXPRESSION_TYPE_INFO, (delegator = (KtSuperTypeCallEntry)specifier).getCalleeExpression())) == null) continue;
            resultFlowInfo = resultFlowInfo.and(delegatorTypeInfo.getDataFlowInfo());
        }
        KotlinTypeInfo resultTypeInfo = this.components.dataFlowAnalyzer.checkType(TypeInfoFactoryKt.createTypeInfo(result2[0], resultFlowInfo), (KtExpression)expression2, (ResolutionContext)context2);
        context2.trace.record(BindingContext.EXPRESSION_TYPE_INFO, expression2, resultTypeInfo);
        context2.trace.record(BindingContext.PROCESSED, expression2);
        return resultTypeInfo;
    }

    @Override
    public KotlinTypeInfo visitQualifiedExpression(@NotNull KtQualifiedExpression expression2, ExpressionTypingContext context2) {
        CallExpressionResolver callExpressionResolver = this.components.callExpressionResolver;
        return callExpressionResolver.getQualifiedExpressionTypeInfo(expression2, context2);
    }

    @Override
    public KotlinTypeInfo visitCallExpression(@NotNull KtCallExpression expression2, ExpressionTypingContext context2) {
        CallExpressionResolver callExpressionResolver = this.components.callExpressionResolver;
        return callExpressionResolver.getCallExpressionTypeInfo(expression2, context2);
    }

    @Override
    public KotlinTypeInfo visitUnaryExpression(@NotNull KtUnaryExpression expression2, ExpressionTypingContext contextWithExpectedType) {
        KotlinType result2;
        OverloadResolutionResults<FunctionDescriptor> resolutionResults;
        ExpressionTypingContext context2 = ExpressionTypingUtils.isUnaryExpressionDependentOnExpectedType(expression2) ? contextWithExpectedType : (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        KtExpression baseExpression = expression2.getBaseExpression();
        if (baseExpression == null) {
            return TypeInfoFactoryKt.noTypeInfo(context2);
        }
        KtSimpleNameExpression operationSign = expression2.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType == KtTokens.EXCLEXCL) {
            return this.visitExclExclExpression(expression2, context2);
        }
        KotlinTypeInfo typeInfo = this.facade.safeGetTypeInfo(baseExpression, context2);
        KotlinType type2 = ExpressionTypingUtils.safeGetType(typeInfo);
        ExpressionReceiver receiver = ExpressionReceiver.Companion.create(baseExpression, type2, context2.trace.getBindingContext());
        Call call2 = CallMaker.makeCall((ReceiverValue)receiver, expression2);
        Name name2 = (Name)OperatorConventions.UNARY_OPERATION_NAMES.get((Object)operationType);
        if (name2 == null) {
            context2.trace.report(Errors.UNSUPPORTED.on((PsiElement)operationSign, "visitUnaryExpression"));
            return typeInfo.clearType();
        }
        if ((operationType == KtTokens.PLUSPLUS || operationType == KtTokens.MINUSMINUS) && baseExpression instanceof KtArrayAccessExpression) {
            KtExpression stubExpression = ExpressionTypingUtils.createFakeExpressionOfType(baseExpression.getProject(), context2.trace, "e", type2);
            TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(context2.trace, "trace to resolve array access set method for unary expression", expression2);
            ExpressionTypingContext newContext = (ExpressionTypingContext)context2.replaceBindingTrace(temporaryBindingTrace);
            this.resolveImplicitArrayAccessSetMethod((KtArrayAccessExpression)baseExpression, stubExpression, newContext, context2.trace);
        }
        if (!(resolutionResults = this.components.callResolver.resolveCallWithGivenName(context2, call2, expression2.getOperationReference(), name2)).isSuccess()) {
            return typeInfo.clearType();
        }
        KotlinType returnType2 = resolutionResults.getResultingDescriptor().getReturnType();
        if (operationType == KtTokens.PLUSPLUS || operationType == KtTokens.MINUSMINUS) {
            assert (returnType2 != null) : "returnType is null for " + resolutionResults.getResultingDescriptor();
            if (KotlinBuiltIns.isUnit(returnType2)) {
                result2 = ErrorUtils.createErrorType(this.components.builtIns.getUnit().getName().asString());
                context2.trace.report(Errors.INC_DEC_SHOULD_NOT_RETURN_UNIT.on(operationSign));
            } else {
                KotlinType receiverType2 = receiver.getType();
                if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(returnType2, receiverType2)) {
                    context2.trace.report(Errors.RESULT_TYPE_MISMATCH.on(operationSign, name2.asString(), receiverType2, returnType2));
                } else {
                    context2.trace.record(BindingContext.VARIABLE_REASSIGNMENT, expression2);
                    KtExpression stubExpression = ExpressionTypingUtils.createFakeExpressionOfType(baseExpression.getProject(), context2.trace, "e", type2);
                    this.checkLValue(context2.trace, context2, baseExpression, stubExpression, expression2);
                }
                DataFlowValue receiverValue = this.components.dataFlowValueFactory.createDataFlowValue((ReceiverValue)call2.getExplicitReceiver(), contextWithExpectedType);
                if (expression2 instanceof KtPrefixExpression) {
                    result2 = returnType2;
                } else {
                    result2 = receiverType2;
                    DataFlowValue returnValue = this.components.dataFlowValueFactory.createDataFlowValue(expression2, receiverType2, contextWithExpectedType);
                    typeInfo = typeInfo.replaceDataFlowInfo(typeInfo.getDataFlowInfo().assign(returnValue, receiverValue, this.components.languageVersionSettings));
                }
            }
        } else {
            result2 = returnType2;
        }
        CompileTimeConstant<?> value = this.components.constantExpressionEvaluator.evaluateExpression(expression2, contextWithExpectedType.trace, contextWithExpectedType.expectedType);
        if (value != null) {
            return this.components.dataFlowAnalyzer.createCompileTimeConstantTypeInfo(value, expression2, contextWithExpectedType);
        }
        return this.components.dataFlowAnalyzer.checkType(typeInfo.replaceType(result2), (KtExpression)expression2, (ResolutionContext)contextWithExpectedType.replaceDataFlowInfo(typeInfo.getDataFlowInfo()));
    }

    private KotlinTypeInfo visitExclExclExpression(@NotNull KtUnaryExpression expression2, @NotNull ExpressionTypingContext context2) {
        KotlinType resultingType;
        KtExpression baseExpression = expression2.getBaseExpression();
        assert (baseExpression != null);
        KtSimpleNameExpression operationSign = expression2.getOperationReference();
        assert (operationSign.getReferencedNameElementType() == KtTokens.EXCLEXCL);
        Call call2 = ControlStructureTypingUtils.createCallForSpecialConstruction(expression2, expression2.getOperationReference(), Collections.singletonList(baseExpression));
        ResolvedCall<FunctionDescriptor> resolvedCall2 = this.components.controlStructureTypingUtils.resolveSpecialConstructionAsCall(call2, ControlStructureTypingUtils.ResolveConstruct.EXCL_EXCL, Collections.singletonList("baseExpr"), Collections.singletonList(true), context2, null);
        KotlinTypeInfo baseTypeInfo = BindingContextUtils.getRecordedTypeInfo(baseExpression, context2.trace.getBindingContext());
        boolean isFunctionLiteral = ArgumentTypeResolver.isFunctionLiteralArgument(baseExpression, context2);
        boolean isCallableReference2 = ArgumentTypeResolver.isCallableReferenceArgument(baseExpression, context2);
        if (isFunctionLiteral || isCallableReference2) {
            DiagnosticFactory0<PsiElement> diagnosticFactory = isFunctionLiteral ? Errors.NOT_NULL_ASSERTION_ON_LAMBDA_EXPRESSION : Errors.NOT_NULL_ASSERTION_ON_CALLABLE_REFERENCE;
            context2.trace.report(diagnosticFactory.on((PsiElement)operationSign));
            if (baseTypeInfo == null) {
                return TypeInfoFactoryKt.createTypeInfo((KotlinType)ErrorUtils.createErrorType("Unresolved lambda expression"), context2);
            }
            return baseTypeInfo;
        }
        assert (baseTypeInfo != null) : "Base expression was not processed: " + expression2;
        KotlinType baseType = baseTypeInfo.getType();
        if (baseType == null) {
            return baseTypeInfo;
        }
        DataFlowInfo dataFlowInfo = baseTypeInfo.getDataFlowInfo();
        if (this.isKnownToBeNotNull(baseExpression, baseType, context2)) {
            context2.trace.report(Errors.UNNECESSARY_NOT_NULL_ASSERTION.on((PsiElement)operationSign, TypeUtils.makeNotNullable(baseType)));
        } else {
            DataFlowValue value = this.components.dataFlowValueFactory.createDataFlowValue(baseExpression, baseType, context2);
            baseTypeInfo = baseTypeInfo.replaceDataFlowInfo(dataFlowInfo.disequate(value, DataFlowValue.nullValue(this.components.builtIns), this.components.languageVersionSettings));
        }
        KotlinType kotlinType = resultingType = this.components.languageVersionSettings.supportsFeature(LanguageFeature.NewInference) ? resolvedCall2.getResultingDescriptor().getReturnType() : TypeUtils.makeNotNullable(baseType);
        if (context2.contextDependency == ContextDependency.DEPENDENT) {
            return baseTypeInfo.replaceType(resultingType);
        }
        return this.components.dataFlowAnalyzer.checkType(baseTypeInfo.replaceType(resultingType), (KtExpression)expression2, (ResolutionContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE));
    }

    @Override
    public KotlinTypeInfo visitLabeledExpression(@NotNull KtLabeledExpression expression2, ExpressionTypingContext context2) {
        return this.visitLabeledExpression(expression2, context2, false);
    }

    @NotNull
    public KotlinTypeInfo visitLabeledExpression(@NotNull KtLabeledExpression expression2, @NotNull ExpressionTypingContext context2, boolean isStatement) {
        KtExpression baseExpression;
        KtSimpleNameExpression labelExpression = expression2.getTargetLabel();
        ReservedCheckingKt.checkReservedYield(labelExpression, context2.trace);
        if (labelExpression != null) {
            PsiElement labelIdentifier = labelExpression.getIdentifier();
            UnderscoreChecker.INSTANCE.checkIdentifier(labelIdentifier, context2.trace, this.components.languageVersionSettings);
        }
        if ((baseExpression = expression2.getBaseExpression()) == null) {
            return TypeInfoFactoryKt.noTypeInfo(context2);
        }
        return this.facade.getTypeInfo(baseExpression, context2, isStatement);
    }

    private boolean isKnownToBeNotNull(@NotNull KtExpression expression2, @Nullable KotlinType ktType, @NotNull ExpressionTypingContext context2) {
        if (ktType == null) {
            return false;
        }
        if (KotlinTypeKt.isError(ktType) && !ErrorUtils.isUninferredParameter(ktType)) {
            return false;
        }
        if (!TypeUtils.isNullableType(ktType)) {
            return true;
        }
        DataFlowValue dataFlowValue2 = this.components.dataFlowValueFactory.createDataFlowValue(expression2, ktType, context2);
        return context2.dataFlowInfo.getStableNullability(dataFlowValue2) == Nullability.NOT_NULL;
    }

    public boolean checkLValue(@NotNull BindingTrace trace, @NotNull ExpressionTypingContext context2, @NotNull KtExpression expressionWithParenthesis, @Nullable KtExpression rightHandSide, @NotNull KtOperationExpression operationExpression) {
        KtExpression selector;
        KtExpression reportOn;
        KtExpression expression2 = KtPsiUtil.deparenthesize(expressionWithParenthesis);
        if (expression2 instanceof KtArrayAccessExpression) {
            ResolvedCall<FunctionDescriptor> resolvedCall2;
            KtArrayAccessExpression arrayAccessExpression2 = (KtArrayAccessExpression)expression2;
            KtExpression arrayExpression = arrayAccessExpression2.getArrayExpression();
            if (arrayExpression == null || rightHandSide == null) {
                return false;
            }
            TemporaryBindingTrace ignoreReportsTrace = TemporaryBindingTrace.create(trace, "Trace for checking set function");
            ExpressionTypingContext findSetterContext = (ExpressionTypingContext)context2.replaceBindingTrace(ignoreReportsTrace);
            KotlinTypeInfo info = this.resolveArrayAccessSetMethod(arrayAccessExpression2, rightHandSide, findSetterContext, ignoreReportsTrace);
            IElementType operationType = operationExpression.getOperationReference().getReferencedNameElementType();
            if ((KtTokens.AUGMENTED_ASSIGNMENTS.contains(operationType) || operationType == KtTokens.PLUSPLUS || operationType == KtTokens.MINUSMINUS) && (resolvedCall2 = ignoreReportsTrace.get(BindingContext.INDEXED_LVALUE_SET, expression2)) != null && trace.wantsDiagnostics()) {
                CallCheckerContext callCheckerContext = new CallCheckerContext(context2, this.components.deprecationResolver, this.components.moduleDescriptor, trace);
                for (CallChecker checker : this.components.callCheckers) {
                    checker.check(resolvedCall2, (PsiElement)expression2, callCheckerContext);
                }
            }
            return info.getType() != null;
        }
        VariableDescriptor variable2 = BindingContextUtils.extractVariableDescriptorFromReference(trace.getBindingContext(), expression2);
        boolean result2 = true;
        KtExpression ktExpression = reportOn = expression2 != null ? expression2 : expressionWithParenthesis;
        if (reportOn instanceof KtQualifiedExpression && (selector = ((KtQualifiedExpression)reportOn).getSelectorExpression()) != null) {
            reportOn = selector;
        }
        if (variable2 instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)variable2;
            PropertySetterDescriptor setter = propertyDescriptor.getSetter();
            if (propertyDescriptor.isSetterProjectedOut()) {
                trace.report(Errors.SETTER_PROJECTED_OUT.on(reportOn, propertyDescriptor));
                result2 = false;
            } else if (setter != null) {
                ResolvedCall<? extends CallableDescriptor> resolvedCall3 = CallUtilKt.getResolvedCall(expressionWithParenthesis, context2.trace.getBindingContext());
                assert (resolvedCall3 != null) : "Call is not resolved for property setter: " + PsiUtilsKt.getElementTextWithContext((PsiElement)expressionWithParenthesis);
                this.checkPropertySetterCall((ExpressionTypingContext)context2.replaceBindingTrace(trace), setter, resolvedCall3, reportOn);
            }
        }
        if (variable2 == null) {
            trace.report(Errors.VARIABLE_EXPECTED.on(reportOn));
            result2 = false;
        } else if (!variable2.isVar()) {
            result2 = false;
        }
        return result2;
    }

    private void checkPropertySetterCall(@NotNull ExpressionTypingContext context2, @NotNull PropertySetterDescriptor descriptor2, @NotNull ResolvedCall<?> propertyResolvedCall, @NotNull KtExpression expression2) {
        Call call2 = propertyResolvedCall.getCall();
        ResolutionCandidate<PropertySetterDescriptor> resolutionCandidate = ResolutionCandidate.create(call2, descriptor2, propertyResolvedCall.getDispatchReceiver(), propertyResolvedCall.getExplicitReceiverKind(), null);
        ResolvedCallImpl<PropertySetterDescriptor> resolvedCall2 = ResolvedCallImpl.create(resolutionCandidate, TemporaryBindingTrace.create(context2.trace, "Trace for fake property setter resolved call"), TracingStrategy.EMPTY, new DataFlowInfoForArgumentsImpl(propertyResolvedCall.getDataFlowInfoForArguments().getResultInfo(), call2));
        resolvedCall2.markCallAsCompleted();
        if (context2.trace.wantsDiagnostics()) {
            CallCheckerContext callCheckerContext = this.createCallCheckerContext(context2);
            for (CallChecker checker : this.components.callCheckers) {
                checker.check(resolvedCall2, (PsiElement)expression2, callCheckerContext);
            }
        }
    }

    @NotNull
    private CallCheckerContext createCallCheckerContext(@NotNull ExpressionTypingContext context2) {
        return new CallCheckerContext(context2, this.components.deprecationResolver, this.components.moduleDescriptor);
    }

    @Override
    public KotlinTypeInfo visitBinaryExpression(@NotNull KtBinaryExpression expression2, ExpressionTypingContext contextWithExpectedType) {
        KotlinTypeInfo result2;
        Name referencedName;
        ExpressionTypingContext context2 = ExpressionTypingUtils.isBinaryExpressionDependentOnExpectedType(expression2) ? contextWithExpectedType : (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        KtOperationReferenceExpression operationSign = expression2.getOperationReference();
        KtExpression left = expression2.getLeft();
        KtExpression right = expression2.getRight();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType == KtTokens.IDENTIFIER) {
            referencedName = operationSign.getReferencedNameAsName();
            result2 = this.getTypeInfoForBinaryCall(referencedName, context2, expression2);
        } else if (OperatorConventions.BINARY_OPERATION_NAMES.containsKey((Object)operationType)) {
            referencedName = (Name)OperatorConventions.BINARY_OPERATION_NAMES.get((Object)operationType);
            result2 = this.getTypeInfoForBinaryCall(referencedName, context2, expression2);
        } else {
            if (operationType == KtTokens.ELVIS) {
                return this.visitElvisExpression(expression2, context2);
            }
            if (operationType == KtTokens.EQ) {
                result2 = this.visitAssignment(expression2, context2);
            } else if (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey((Object)operationType)) {
                result2 = this.visitAssignmentOperation(expression2, context2);
            } else if (OperatorConventions.COMPARISON_OPERATIONS.contains((Object)operationType)) {
                result2 = this.visitComparison(expression2, context2, operationSign);
            } else if (OperatorConventions.EQUALS_OPERATIONS.contains((Object)operationType)) {
                result2 = this.visitEquality(expression2, context2, operationSign, left, right);
            } else if (OperatorConventions.IDENTITY_EQUALS_OPERATIONS.contains((Object)operationType)) {
                this.ensureNonemptyIntersectionOfOperandTypes(expression2, context2);
                result2 = TypeInfoFactoryKt.createTypeInfo((KotlinType)this.components.builtIns.getBooleanType(), context2);
                BasicExpressionTypingVisitor.checkIdentityOnPrimitiveOrInlineClassTypes(expression2, context2);
            } else if (OperatorConventions.IN_OPERATIONS.contains((Object)operationType)) {
                ValueArgument leftArgument = CallMaker.makeValueArgument(left, left != null ? left : operationSign);
                result2 = this.checkInExpression(expression2, operationSign, leftArgument, right, context2);
            } else if (OperatorConventions.BOOLEAN_OPERATIONS.containsKey((Object)operationType)) {
                result2 = this.visitBooleanOperationExpression(operationType, left, right, context2);
            } else {
                context2.trace.report(Errors.UNSUPPORTED.on((PsiElement)operationSign, "Unknown operation"));
                result2 = TypeInfoFactoryKt.noTypeInfo(context2);
            }
        }
        CompileTimeConstant<?> value = this.components.constantExpressionEvaluator.evaluateExpression(expression2, contextWithExpectedType.trace, contextWithExpectedType.expectedType);
        if (value != null) {
            return this.components.dataFlowAnalyzer.createCompileTimeConstantTypeInfo(value, expression2, contextWithExpectedType);
        }
        return this.components.dataFlowAnalyzer.checkType(result2, (KtExpression)expression2, (ResolutionContext)contextWithExpectedType);
    }

    private static void checkIdentityOnPrimitiveOrInlineClassTypes(@NotNull KtBinaryExpression expression2, @NotNull ExpressionTypingContext context2) {
        if (expression2.getLeft() == null || expression2.getRight() == null) {
            return;
        }
        KotlinType leftType = context2.trace.getType(expression2.getLeft());
        KotlinType rightType = context2.trace.getType(expression2.getRight());
        if (leftType == null || rightType == null) {
            return;
        }
        if (KotlinTypeChecker.DEFAULT.equalTypes(leftType, rightType)) {
            if (KotlinBuiltIns.isPrimitiveType(leftType)) {
                context2.trace.report(Errors.DEPRECATED_IDENTITY_EQUALS.on(expression2, leftType, rightType));
            } else if (InlineClassesUtilsKt.isInlineClassType(leftType)) {
                context2.trace.report(Errors.FORBIDDEN_IDENTITY_EQUALS.on(expression2, leftType, rightType));
            }
        } else if (BasicExpressionTypingVisitor.isIdentityComparedWithImplicitBoxing(leftType, rightType) || BasicExpressionTypingVisitor.isIdentityComparedWithImplicitBoxing(rightType, leftType)) {
            context2.trace.report(Errors.IMPLICIT_BOXING_IN_IDENTITY_EQUALS.on(expression2, leftType, rightType));
        }
    }

    private static boolean isIdentityComparedWithImplicitBoxing(KotlinType leftType, KotlinType rightType) {
        return KotlinBuiltIns.isPrimitiveType(leftType) && !KotlinBuiltIns.isPrimitiveType(rightType) && KotlinTypeChecker.DEFAULT.isSubtypeOf(leftType, rightType);
    }

    private KotlinTypeInfo visitEquality(KtBinaryExpression expression2, ExpressionTypingContext context2, KtSimpleNameExpression operationSign, KtExpression left, KtExpression right) {
        if (right == null || left == null) {
            ExpressionTypingUtils.getTypeInfoOrNullType(right, context2, this.facade);
            ExpressionTypingUtils.getTypeInfoOrNullType(left, context2, this.facade);
            return TypeInfoFactoryKt.createTypeInfo((KotlinType)this.components.builtIns.getBooleanType(), context2);
        }
        KotlinTypeInfo leftTypeInfo = ExpressionTypingUtils.getTypeInfoOrNullType(left, context2, this.facade);
        DataFlowInfo dataFlowInfo = leftTypeInfo.getDataFlowInfo();
        ExpressionTypingContext contextWithDataFlow = (ExpressionTypingContext)context2.replaceDataFlowInfo(dataFlowInfo);
        ExpressionReceiver receiver = this.createReceiverForEquals(left, contextWithDataFlow);
        List<FunctionDescriptor> equalsFunctions = this.findEqualsWithNullableAnyParameter(receiver, expression2);
        Call call2 = CallMaker.makeCallWithExpressions(expression2, receiver, null, operationSign, Collections.singletonList(right), Call.CallType.DEFAULT, true);
        OverloadResolutionResults<FunctionDescriptor> resolutionResults = this.components.callResolver.resolveEqualsCallWithGivenDescriptors(contextWithDataFlow, operationSign, receiver, call2, equalsFunctions);
        if (resolutionResults.isSuccess()) {
            FunctionDescriptor equals = resolutionResults.getResultingCall().getResultingDescriptor();
            if (this.ensureBooleanResult(operationSign, OperatorNameConventions.EQUALS, equals.getReturnType(), contextWithDataFlow)) {
                this.ensureNonemptyIntersectionOfOperandTypes(expression2, contextWithDataFlow);
            }
        } else if (resolutionResults.isAmbiguity()) {
            context2.trace.report(Errors.OVERLOAD_RESOLUTION_AMBIGUITY.on((PsiElement)operationSign, resolutionResults.getResultingCalls()));
        } else {
            context2.trace.report(Errors.EQUALS_MISSING.on(operationSign));
        }
        KotlinTypeInfo rightTypeInfo = this.facade.getTypeInfo(right, contextWithDataFlow);
        return rightTypeInfo.replaceType(this.components.builtIns.getBooleanType());
    }

    private ExpressionReceiver createReceiverForEquals(KtExpression left, ExpressionTypingContext context2) {
        KotlinType leftType = ExpressionTypingUtils.safeGetType(this.facade.safeGetTypeInfo(left, context2));
        KotlinType receiverType2 = KotlinBuiltIns.isNothingOrNullableNothing(leftType) ? this.components.builtIns.getNullableAnyType() : leftType;
        return ExpressionReceiver.Companion.create(left, receiverType2, context2.trace.getBindingContext());
    }

    private List<FunctionDescriptor> findEqualsWithNullableAnyParameter(@NotNull ExpressionReceiver receiver, @NotNull KtBinaryExpression expression2) {
        KotlinType refinedType = KotlinBuiltIns.isNothingOrNullableNothing(receiver.getType()) ? this.components.builtIns.getNullableAnyType() : receiver.getType();
        Collection<SimpleFunctionDescriptor> equalsMembers = refinedType.getMemberScope().getContributedFunctions(OperatorNameConventions.EQUALS, new KotlinLookupLocation(expression2.getOperationReference()));
        return CollectionsKt.filter(equalsMembers, descriptor2 -> {
            if (ErrorUtils.isError(descriptor2)) {
                return true;
            }
            if (descriptor2.getValueParameters().size() != 1) {
                return false;
            }
            ValueParameterDescriptor valueParameter = descriptor2.getValueParameters().get(0);
            return KotlinBuiltIns.isNullableAny(valueParameter.getType());
        });
    }

    @NotNull
    private KotlinTypeInfo visitComparison(@NotNull KtBinaryExpression expression2, @NotNull ExpressionTypingContext context2, @NotNull KtSimpleNameExpression operationSign) {
        KotlinTypeInfo typeInfo = this.getTypeInfoForBinaryCall(OperatorNameConventions.COMPARE_TO, context2, expression2);
        KotlinType compareToReturnType = typeInfo.getType();
        SimpleType type2 = null;
        if (compareToReturnType != null && !KotlinTypeKt.isError(compareToReturnType)) {
            if (KotlinTypeChecker.DEFAULT.equalTypes(this.components.builtIns.getIntType(), compareToReturnType)) {
                type2 = this.components.builtIns.getBooleanType();
            } else {
                context2.trace.report(Errors.COMPARE_TO_TYPE_MISMATCH.on(operationSign, compareToReturnType));
            }
        }
        return typeInfo.replaceType(type2);
    }

    @NotNull
    private KotlinTypeInfo visitBooleanOperationExpression(@Nullable IElementType operationType, @Nullable KtExpression left, @Nullable KtExpression right, @NotNull ExpressionTypingContext context2) {
        SimpleType booleanType = this.components.builtIns.getBooleanType();
        KotlinTypeInfo leftTypeInfo = ExpressionTypingUtils.getTypeInfoOrNullType(left, (ExpressionTypingContext)context2.replaceExpectedType(booleanType), this.facade);
        DataFlowInfo dataFlowInfo = leftTypeInfo.getDataFlowInfo();
        LexicalWritableScope leftScope = ExpressionTypingUtils.newWritableScopeImpl(context2, LexicalScopeKind.LEFT_BOOLEAN_EXPRESSION, this.facade.getComponents().overloadChecker);
        boolean isAnd = operationType == KtTokens.ANDAND;
        DataFlowInfo flowInfoLeft = this.components.dataFlowAnalyzer.extractDataFlowInfoFromCondition(left, isAnd, context2).and(dataFlowInfo);
        LexicalWritableScope rightScope = isAnd ? leftScope : ExpressionTypingUtils.newWritableScopeImpl(context2, LexicalScopeKind.RIGHT_BOOLEAN_EXPRESSION, this.facade.getComponents().overloadChecker);
        ExpressionTypingContext contextForRightExpr = (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context2.replaceDataFlowInfo(flowInfoLeft)).replaceScope(rightScope)).replaceExpectedType(booleanType);
        if (right != null) {
            this.facade.getTypeInfo(right, contextForRightExpr);
        }
        return leftTypeInfo.replaceType(booleanType);
    }

    @NotNull
    private KotlinTypeInfo visitElvisExpression(@NotNull KtBinaryExpression expression2, @NotNull ExpressionTypingContext contextWithExpectedType) {
        ExpressionTypingContext context2 = (ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        KtExpression left = expression2.getLeft();
        KtExpression right = expression2.getRight();
        if (left == null || right == null) {
            ExpressionTypingUtils.getTypeInfoOrNullType(left, context2, this.facade);
            return TypeInfoFactoryKt.noTypeInfo(context2);
        }
        Call call2 = ControlStructureTypingUtils.createCallForSpecialConstruction(expression2, expression2.getOperationReference(), Lists.newArrayList((Object[])new KtExpression[]{left, right}));
        ResolvedCall<FunctionDescriptor> resolvedCall2 = this.components.controlStructureTypingUtils.resolveSpecialConstructionAsCall(call2, ControlStructureTypingUtils.ResolveConstruct.ELVIS, Lists.newArrayList((Object[])new String[]{"left", "right"}), Lists.newArrayList((Object[])new Boolean[]{true, false}), contextWithExpectedType, null);
        KotlinTypeInfo leftTypeInfo = BindingContextUtils.getRecordedTypeInfo(left, context2.trace.getBindingContext());
        boolean isLeftFunctionLiteral = ArgumentTypeResolver.isFunctionLiteralArgument(left, context2);
        boolean isLeftCallableReference = ArgumentTypeResolver.isCallableReferenceArgument(left, context2);
        if (leftTypeInfo == null && (isLeftFunctionLiteral || isLeftCallableReference)) {
            return TypeInfoFactoryKt.noTypeInfo(context2);
        }
        assert (leftTypeInfo != null) : "Left expression was not processed: " + expression2;
        KotlinType leftType = leftTypeInfo.getType();
        KotlinTypeInfo rightTypeInfo = BindingContextUtils.getRecordedTypeInfo(right, context2.trace.getBindingContext());
        if (rightTypeInfo == null && ArgumentTypeResolver.isFunctionLiteralOrCallableReference(right, context2)) {
            return TypeInfoFactoryKt.noTypeInfo(context2);
        }
        assert (rightTypeInfo != null) : "Right expression was not processed: " + expression2;
        boolean loopBreakContinuePossible = leftTypeInfo.getJumpOutPossible() || rightTypeInfo.getJumpOutPossible();
        KotlinType rightType = rightTypeInfo.getType();
        DataFlowInfo dataFlowInfo = resolvedCall2.getDataFlowInfoForArguments().getInfo(call2.getValueArguments().get(1));
        KotlinType type2 = resolvedCall2.getResultingDescriptor().getReturnType();
        if (type2 == null || rightType == null || leftType == null && KotlinBuiltIns.isNothing(rightType)) {
            return TypeInfoFactoryKt.noTypeInfo(dataFlowInfo);
        }
        if (leftType != null) {
            DataFlowValue leftValue = this.components.dataFlowValueFactory.createDataFlowValue(left, leftType, context2);
            DataFlowInfo rightDataFlowInfo = resolvedCall2.getDataFlowInfoForArguments().getResultInfo();
            boolean jumpInRight = KotlinBuiltIns.isNothing(rightType);
            DataFlowValue nullValue = DataFlowValue.nullValue(this.components.builtIns);
            if (jumpInRight || !rightDataFlowInfo.getStableNullability(leftValue).canBeNull()) {
                dataFlowInfo = dataFlowInfo.disequate(leftValue, nullValue, this.components.languageVersionSettings);
                if (left instanceof KtBinaryExpressionWithTypeRHS) {
                    dataFlowInfo = this.establishSubtypingForTypeRHS((KtBinaryExpressionWithTypeRHS)left, dataFlowInfo, context2, this.components.languageVersionSettings);
                }
            }
            DataFlowValue resultValue = this.components.dataFlowValueFactory.createDataFlowValue(expression2, type2, context2);
            dataFlowInfo = dataFlowInfo.assign(resultValue, leftValue, this.components.languageVersionSettings).disequate(resultValue, nullValue, this.components.languageVersionSettings);
            if (!jumpInRight) {
                DataFlowValue rightValue = this.components.dataFlowValueFactory.createDataFlowValue(right, rightType, context2);
                rightDataFlowInfo = rightDataFlowInfo.assign(resultValue, rightValue, this.components.languageVersionSettings);
                dataFlowInfo = dataFlowInfo.or(rightDataFlowInfo);
            }
        }
        if (!TypeUtils.isNullableType(rightType) && TypeUtils.isNullableType(type2)) {
            type2 = TypeUtils.makeNotNullable(type2);
        }
        if (context2.contextDependency == ContextDependency.DEPENDENT) {
            return TypeInfoFactoryKt.createTypeInfo(type2, dataFlowInfo);
        }
        return TypeInfoFactoryKt.createTypeInfo(this.components.dataFlowAnalyzer.checkType(type2, (KtExpression)expression2, (ResolutionContext)contextWithExpectedType), dataFlowInfo, loopBreakContinuePossible, context2.dataFlowInfo);
    }

    @NotNull
    private DataFlowInfo establishSubtypingForTypeRHS(@NotNull KtBinaryExpressionWithTypeRHS left, @NotNull DataFlowInfo dataFlowInfo, @NotNull ExpressionTypingContext context2, @NotNull LanguageVersionSettings languageVersionSettings) {
        KtExpression underSafeAs;
        KotlinType underSafeAsType;
        IElementType operationType = left.getOperationReference().getReferencedNameElementType();
        if (operationType == KtTokens.AS_SAFE && (underSafeAsType = context2.trace.getType(underSafeAs = left.getLeft())) != null) {
            DataFlowValue underSafeAsValue = this.components.dataFlowValueFactory.createDataFlowValue(underSafeAs, underSafeAsType, context2);
            KotlinType targetType = context2.trace.get(BindingContext.TYPE, left.getRight());
            if (targetType != null) {
                return dataFlowInfo.establishSubtyping(underSafeAsValue, targetType, languageVersionSettings);
            }
        }
        return dataFlowInfo;
    }

    @NotNull
    public KotlinTypeInfo checkInExpression(@NotNull KtElement callElement2, @NotNull KtSimpleNameExpression operationSign, @NotNull ValueArgument leftArgument, @Nullable KtExpression right, @NotNull ExpressionTypingContext context2) {
        KtExpression left = leftArgument.getArgumentExpression();
        ExpressionTypingContext contextWithNoExpectedType = (ExpressionTypingContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        if (right == null) {
            if (left != null) {
                this.facade.getTypeInfo(left, contextWithNoExpectedType);
            }
            return TypeInfoFactoryKt.noTypeInfo(context2);
        }
        KotlinTypeInfo rightTypeInfo = this.facade.getTypeInfo(right, contextWithNoExpectedType);
        DataFlowInfo dataFlowInfo = rightTypeInfo.getDataFlowInfo();
        ExpressionReceiver receiver = ExpressionTypingUtils.safeGetExpressionReceiver(this.facade, right, contextWithNoExpectedType);
        ExpressionTypingContext contextWithDataFlow = (ExpressionTypingContext)context2.replaceDataFlowInfo(dataFlowInfo);
        OverloadResolutionResults<FunctionDescriptor> resolutionResult = this.components.callResolver.resolveCallWithGivenName(contextWithDataFlow, CallMaker.makeCall(callElement2, receiver, null, operationSign, Collections.singletonList(leftArgument)), operationSign, OperatorNameConventions.CONTAINS);
        KotlinType containsType = OverloadResolutionResultsUtil.getResultingType(resolutionResult, context2);
        this.ensureBooleanResult(operationSign, OperatorNameConventions.CONTAINS, containsType, context2);
        if (left != null) {
            dataFlowInfo = this.facade.getTypeInfo(left, contextWithDataFlow).getDataFlowInfo().and(dataFlowInfo);
            rightTypeInfo = rightTypeInfo.replaceDataFlowInfo(dataFlowInfo);
        }
        if (resolutionResult.isSuccess()) {
            return rightTypeInfo.replaceType(this.components.builtIns.getBooleanType());
        }
        return rightTypeInfo.clearType();
    }

    private boolean ensureBooleanResult(KtExpression operationSign, Name name2, KotlinType resultType, ExpressionTypingContext context2) {
        return this.ensureBooleanResultWithCustomSubject(operationSign, resultType, "'" + name2 + "'", context2);
    }

    private boolean ensureBooleanResultWithCustomSubject(KtExpression operationSign, KotlinType resultType, String subjectName, ExpressionTypingContext context2) {
        if (resultType != null && !this.components.builtIns.isBooleanOrSubtype(resultType)) {
            context2.trace.report(Errors.RESULT_TYPE_MISMATCH.on(operationSign, subjectName, this.components.builtIns.getBooleanType(), resultType));
            return false;
        }
        return true;
    }

    private void ensureNonemptyIntersectionOfOperandTypes(KtBinaryExpression expression2, ExpressionTypingContext context2) {
        KotlinType rightType;
        KtExpression left = expression2.getLeft();
        if (left == null) {
            return;
        }
        KtExpression right = expression2.getRight();
        KotlinType leftType = this.facade.getTypeInfo(left, context2).getType();
        if (leftType != null && right != null && (rightType = this.facade.getTypeInfo(right, context2).getType()) != null) {
            if (TypeIntersector.isIntersectionEmpty(leftType, rightType)) {
                context2.trace.report(Errors.EQUALITY_NOT_APPLICABLE.on(expression2, expression2.getOperationReference(), leftType, rightType));
            }
            SenselessComparisonChecker.checkSenselessComparisonWithNull(expression2, left, right, context2, (Function1<? super KtExpression, ? extends KotlinType>)((Function1)expr2 -> this.facade.getTypeInfo((KtExpression)expr2, context2).getType()), (Function1<? super DataFlowValue, ? extends Nullability>)((Function1)context2.dataFlowInfo::getStableNullability));
        }
    }

    @NotNull
    private KotlinTypeInfo visitAssignmentOperation(KtBinaryExpression expression2, ExpressionTypingContext context2) {
        return this.assignmentIsNotAnExpressionError(expression2, context2);
    }

    @NotNull
    private KotlinTypeInfo visitAssignment(KtBinaryExpression expression2, ExpressionTypingContext context2) {
        return this.assignmentIsNotAnExpressionError(expression2, context2);
    }

    @NotNull
    private KotlinTypeInfo assignmentIsNotAnExpressionError(KtBinaryExpression expression2, ExpressionTypingContext context2) {
        this.facade.checkStatementType(expression2, context2);
        context2.trace.report(Errors.ASSIGNMENT_IN_EXPRESSION_CONTEXT.on(expression2));
        return TypeInfoFactoryKt.noTypeInfo(context2);
    }

    @Override
    public KotlinTypeInfo visitArrayAccessExpression(@NotNull KtArrayAccessExpression expression2, ExpressionTypingContext context2) {
        return this.components.dataFlowAnalyzer.checkType(this.resolveArrayAccessGetMethod(expression2, context2), (KtExpression)expression2, (ResolutionContext)context2);
    }

    @Override
    public KotlinTypeInfo visitCollectionLiteralExpression(@NotNull KtCollectionLiteralExpression expression2, ExpressionTypingContext context2) {
        return this.components.collectionLiteralResolver.resolveCollectionLiteral(expression2, context2);
    }

    @Override
    public KotlinTypeInfo visitClass(@NotNull KtClass klass2, ExpressionTypingContext context2) {
        this.components.localClassifierAnalyzer.processClassOrObject(null, (ExpressionTypingContext)context2.replaceContextDependency(ContextDependency.INDEPENDENT), context2.scope.getOwnerDescriptor(), klass2);
        return BasicExpressionTypingVisitor.declarationInIllegalContext(klass2, context2);
    }

    @NotNull
    private static KotlinTypeInfo declarationInIllegalContext(@NotNull KtDeclaration declaration2, @NotNull ExpressionTypingContext context2) {
        context2.trace.report(Errors.DECLARATION_IN_ILLEGAL_CONTEXT.on(declaration2));
        return TypeInfoFactoryKt.noTypeInfo(context2);
    }

    @Override
    public KotlinTypeInfo visitProperty(@NotNull KtProperty property, ExpressionTypingContext context2) {
        this.components.localVariableResolver.process(property, context2, context2.scope, this.facade);
        return BasicExpressionTypingVisitor.declarationInIllegalContext(property, context2);
    }

    @NotNull
    private KotlinTypeInfo getTypeInfoForBinaryCall(@NotNull Name name2, @NotNull ExpressionTypingContext context2, @NotNull KtBinaryExpression binaryExpression) {
        OverloadResolutionResults<Object> resolutionResults;
        KtExpression left = binaryExpression.getLeft();
        KotlinTypeInfo typeInfo = left != null ? this.facade.getTypeInfo(left, (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)) : TypeInfoFactoryKt.noTypeInfo(context2);
        ExpressionTypingContext contextWithDataFlow = (ExpressionTypingContext)context2.replaceDataFlowInfo(typeInfo.getDataFlowInfo());
        if (left != null) {
            ExpressionReceiver receiver = ExpressionTypingUtils.safeGetExpressionReceiver(this.facade, left, context2);
            resolutionResults = this.components.callResolver.resolveBinaryCall(contextWithDataFlow, receiver, binaryExpression, name2);
        } else {
            resolutionResults = OverloadResolutionResultsImpl.nameNotFound();
        }
        if (resolutionResults.isSingleResult()) {
            typeInfo = typeInfo.replaceDataFlowInfo(resolutionResults.getResultingCall().getDataFlowInfoForArguments().getResultInfo());
        }
        return typeInfo.replaceType(OverloadResolutionResultsUtil.getResultingType(resolutionResults, context2));
    }

    @Override
    public KotlinTypeInfo visitDeclaration(@NotNull KtDeclaration dcl, ExpressionTypingContext context2) {
        return BasicExpressionTypingVisitor.declarationInIllegalContext(dcl, context2);
    }

    @Override
    public KotlinTypeInfo visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2, ExpressionTypingContext contextWithExpectedType) {
        final ExpressionTypingContext context2 = (ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT);
        BasicExpressionTypingVisitor.checkLiteralPrefixAndSuffix((PsiElement)expression2, context2);
        class StringTemplateVisitor
        extends KtVisitorVoid {
            private KotlinTypeInfo typeInfo;

            StringTemplateVisitor() {
                this.typeInfo = TypeInfoFactoryKt.noTypeInfo(context2);
            }

            @Override
            public void visitStringTemplateEntryWithExpression(@NotNull KtStringTemplateEntryWithExpression entry) {
                KtExpression entryExpression = entry.getExpression();
                if (entryExpression != null) {
                    this.typeInfo = BasicExpressionTypingVisitor.this.facade.getTypeInfo(entryExpression, (ExpressionTypingContext)context2.replaceDataFlowInfo(this.typeInfo.getDataFlowInfo()));
                }
            }

            @Override
            public void visitEscapeStringTemplateEntry(@NotNull KtEscapeStringTemplateEntry entry) {
                CompileTimeConstantChecker.CharacterWithDiagnostic value = CompileTimeConstantChecker.escapedStringToCharacter(entry.getText(), entry);
                Diagnostic diagnostic = value.getDiagnostic();
                if (diagnostic != null) {
                    context2.trace.report(diagnostic);
                }
            }
        }
        StringTemplateVisitor visitor2 = new StringTemplateVisitor();
        for (KtStringTemplateEntry entry : expression2.getEntries()) {
            entry.accept(visitor2);
        }
        this.components.constantExpressionEvaluator.evaluateExpression(expression2, context2.trace, contextWithExpectedType.expectedType);
        return this.components.dataFlowAnalyzer.checkType(visitor2.typeInfo.replaceType(this.components.builtIns.getStringType()), (KtExpression)expression2, (ResolutionContext)contextWithExpectedType);
    }

    private static void checkLiteralPrefixAndSuffix(@NotNull PsiElement expression2, ExpressionTypingContext context2) {
        BasicExpressionTypingVisitor.checkLiteralPrefixOrSuffix(PsiTreeUtil.prevLeaf((PsiElement)expression2), context2);
        BasicExpressionTypingVisitor.checkLiteralPrefixOrSuffix(PsiTreeUtil.nextLeaf((PsiElement)expression2), context2);
    }

    private static void checkLiteralPrefixOrSuffix(PsiElement prefixOrSuffix, ExpressionTypingContext context2) {
        if (BasicExpressionTypingVisitor.illegalLiteralPrefixOrSuffix(prefixOrSuffix)) {
            context2.trace.report(Errors.UNSUPPORTED.on(prefixOrSuffix, "literal prefixes and suffixes"));
        }
    }

    private static boolean illegalLiteralPrefixOrSuffix(@Nullable PsiElement element3) {
        if (element3 == null) {
            return false;
        }
        IElementType elementType = element3.getNode().getElementType();
        return elementType == KtTokens.IDENTIFIER || elementType == KtTokens.INTEGER_LITERAL || elementType == KtTokens.FLOAT_LITERAL || elementType instanceof KtKeywordToken;
    }

    @Override
    public KotlinTypeInfo visitAnnotatedExpression(@NotNull KtAnnotatedExpression expression2, ExpressionTypingContext context2) {
        return this.visitAnnotatedExpression(expression2, context2, false);
    }

    public KotlinTypeInfo visitAnnotatedExpression(KtAnnotatedExpression expression2, ExpressionTypingContext context2, boolean isStatement) {
        this.resolveAnnotationsOnExpression(expression2, context2);
        KtExpression baseExpression = expression2.getBaseExpression();
        if (baseExpression == null) {
            return TypeInfoFactoryKt.noTypeInfo(context2);
        }
        return this.facade.getTypeInfo(baseExpression, context2, isStatement);
    }

    protected void resolveAnnotationsOnExpression(KtAnnotatedExpression expression2, ExpressionTypingContext context2) {
        if (BasicExpressionTypingVisitor.isAnnotatedExpressionInBlockLevelBinary(expression2)) {
            context2.trace.report(Errors.ANNOTATIONS_ON_BLOCK_LEVEL_EXPRESSION_ON_THE_SAME_LINE.on(expression2));
        }
        if (!(expression2.getBaseExpression() instanceof KtObjectLiteralExpression)) {
            this.components.annotationResolver.resolveAnnotationsWithArguments(context2.scope, expression2.getAnnotationEntries(), context2.trace);
        }
    }

    private static boolean isAnnotatedExpressionInBlockLevelBinary(KtAnnotatedExpression annotatedExpression) {
        KtAnnotatedExpression current = annotatedExpression;
        PsiElement parent2 = current.getParent();
        if (!(parent2 instanceof KtBinaryExpression)) {
            return false;
        }
        while (parent2 instanceof KtBinaryExpression) {
            if (((KtBinaryExpression)parent2).getLeft() != current) {
                return false;
            }
            current = parent2;
            parent2 = parent2.getParent();
        }
        return KtPsiUtil.isStatementContainer(parent2);
    }

    @Override
    public KotlinTypeInfo visitKtElement(@NotNull KtElement element3, ExpressionTypingContext context2) {
        context2.trace.report(Errors.UNSUPPORTED.on((PsiElement)element3, ((Object)((Object)this)).getClass().getCanonicalName()));
        return TypeInfoFactoryKt.noTypeInfo(context2);
    }

    @NotNull
    KotlinTypeInfo resolveArrayAccessSetMethod(@NotNull KtArrayAccessExpression arrayAccessExpression2, @NotNull KtExpression rightHandSide, @NotNull ExpressionTypingContext context2, @NotNull BindingTrace traceForResolveResult) {
        return this.resolveArrayAccessSpecialMethod(arrayAccessExpression2, rightHandSide, context2, traceForResolveResult, false, false);
    }

    @NotNull
    KotlinTypeInfo resolveImplicitArrayAccessSetMethod(@NotNull KtArrayAccessExpression arrayAccessExpression2, @NotNull KtExpression rightHandSide, @NotNull ExpressionTypingContext context2, @NotNull BindingTrace traceForResolveResult) {
        return this.resolveArrayAccessSpecialMethod(arrayAccessExpression2, rightHandSide, context2, traceForResolveResult, false, true);
    }

    @NotNull
    KotlinTypeInfo resolveArrayAccessGetMethod(@NotNull KtArrayAccessExpression arrayAccessExpression2, @NotNull ExpressionTypingContext context2) {
        return this.resolveArrayAccessSpecialMethod(arrayAccessExpression2, null, context2, context2.trace, true, false);
    }

    @NotNull
    private KotlinTypeInfo resolveArrayAccessSpecialMethod(@NotNull KtArrayAccessExpression arrayAccessExpression2, @Nullable KtExpression rightHandSide, @NotNull ExpressionTypingContext oldContext, @NotNull BindingTrace traceForResolveResult, boolean isGet, boolean isImplicit) {
        KtExpression arrayExpression = arrayAccessExpression2.getArrayExpression();
        if (arrayExpression == null) {
            return TypeInfoFactoryKt.noTypeInfo(oldContext);
        }
        KotlinTypeInfo arrayTypeInfo = this.facade.safeGetTypeInfo(arrayExpression, (ExpressionTypingContext)((ExpressionTypingContext)oldContext.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT));
        KotlinType arrayType = ExpressionTypingUtils.safeGetType(arrayTypeInfo);
        ExpressionTypingContext context2 = (ExpressionTypingContext)oldContext.replaceDataFlowInfo(arrayTypeInfo.getDataFlowInfo());
        ExpressionReceiver receiver = ExpressionReceiver.Companion.create(arrayExpression, arrayType, context2.trace.getBindingContext());
        if (!isGet) assert (rightHandSide != null);
        Call call2 = isGet ? CallMaker.makeArrayGetCall(receiver, arrayAccessExpression2, Call.CallType.ARRAY_GET_METHOD) : CallMaker.makeArraySetCall(receiver, arrayAccessExpression2, rightHandSide, Call.CallType.ARRAY_SET_METHOD);
        OverloadResolutionResults<FunctionDescriptor> functionResults = this.components.callResolver.resolveCallWithGivenName(context2, call2, arrayAccessExpression2, isGet ? OperatorNameConventions.GET : OperatorNameConventions.SET);
        List<KtExpression> indices = arrayAccessExpression2.getIndexExpressions();
        KotlinTypeInfo resultTypeInfo = arrayTypeInfo;
        if (!indices.isEmpty()) {
            resultTypeInfo = this.facade.getTypeInfo(indices.get(indices.size() - 1), context2);
        }
        if (!isGet) {
            resultTypeInfo = this.facade.getTypeInfo(rightHandSide, context2);
        }
        if (isImplicit && !functionResults.isSuccess() || !functionResults.isSingleResult()) {
            traceForResolveResult.report(isGet ? Errors.NO_GET_METHOD.on(arrayAccessExpression2) : Errors.NO_SET_METHOD.on(arrayAccessExpression2));
            return resultTypeInfo.clearType();
        }
        traceForResolveResult.record(isGet ? BindingContext.INDEXED_LVALUE_GET : BindingContext.INDEXED_LVALUE_SET, arrayAccessExpression2, functionResults.getResultingCall());
        return resultTypeInfo.replaceType(functionResults.getResultingDescriptor().getReturnType());
    }
}

