/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.Sets;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.contracts.EffectSystem;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastManager;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastResult;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingFacade;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public class DataFlowAnalyzer {
    private final Iterable<AdditionalTypeChecker> additionalTypeCheckers;
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    private final ModuleDescriptor module;
    private final KotlinBuiltIns builtIns;
    private final ExpressionTypingFacade facade;
    private final LanguageVersionSettings languageVersionSettings;
    private final EffectSystem effectSystem;
    private final DataFlowValueFactory dataFlowValueFactory;

    public DataFlowAnalyzer(@NotNull Iterable<AdditionalTypeChecker> additionalTypeCheckers, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull ModuleDescriptor module, @NotNull KotlinBuiltIns builtIns, @NotNull ExpressionTypingFacade facade, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull EffectSystem effectSystem, @NotNull DataFlowValueFactory factory2) {
        this.additionalTypeCheckers = additionalTypeCheckers;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.module = module;
        this.builtIns = builtIns;
        this.facade = facade;
        this.languageVersionSettings = languageVersionSettings;
        this.effectSystem = effectSystem;
        this.dataFlowValueFactory = factory2;
    }

    @Nullable
    private FunctionDescriptor getOverriddenDescriptorFromClass(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            return descriptor2;
        }
        Collection<? extends FunctionDescriptor> overriddenDescriptors = descriptor2.getOverriddenDescriptors();
        if (overriddenDescriptors.isEmpty()) {
            return descriptor2;
        }
        for (FunctionDescriptor functionDescriptor2 : overriddenDescriptors) {
            DeclarationDescriptor containingDeclaration2 = functionDescriptor2.getContainingDeclaration();
            if (!DescriptorUtils.isClass(containingDeclaration2) && !DescriptorUtils.isObject(containingDeclaration2)) continue;
            return this.getOverriddenDescriptorFromClass(functionDescriptor2);
        }
        return null;
    }

    private boolean typeHasOverriddenEquals(@NotNull KotlinType type2, @NotNull KtElement lookupElement2) {
        Collection<SimpleFunctionDescriptor> members = type2.getMemberScope().getContributedFunctions(OperatorNameConventions.EQUALS, new KotlinLookupLocation(lookupElement2));
        for (FunctionDescriptor functionDescriptor2 : members) {
            KotlinType parameterType;
            KotlinType returnType2 = functionDescriptor2.getReturnType();
            if (returnType2 == null || !KotlinBuiltIns.isBoolean(returnType2) || functionDescriptor2.getValueParameters().size() != 1 || !KotlinBuiltIns.isNullableAny(parameterType = functionDescriptor2.getValueParameters().iterator().next().getType())) continue;
            FunctionDescriptor fromSuperClass = this.getOverriddenDescriptorFromClass(functionDescriptor2);
            if (fromSuperClass == null) {
                return false;
            }
            ClassifierDescriptor superClassDescriptor = (ClassifierDescriptor)fromSuperClass.getContainingDeclaration();
            return !KotlinBuiltIns.isAnyOrNullableAny(superClassDescriptor.getDefaultType());
        }
        return false;
    }

    public boolean typeHasEqualsFromAny(@NotNull KotlinType type2, @NotNull KtElement lookupElement2) {
        TypeConstructor constructor2 = type2.getConstructor();
        if (!constructor2.isFinal()) {
            return false;
        }
        return !this.typeHasOverriddenEquals(type2, lookupElement2);
    }

    @NotNull
    public DataFlowInfo extractDataFlowInfoFromCondition(final @Nullable KtExpression condition2, final boolean conditionValue, final ExpressionTypingContext context2) {
        if (condition2 == null) {
            return context2.dataFlowInfo;
        }
        final Ref result2 = new Ref(null);
        condition2.accept(new KtVisitorVoid(){

            @Override
            public void visitIsExpression(@NotNull KtIsExpression expression2) {
                if (conditionValue && !expression2.isNegated() || !conditionValue && expression2.isNegated()) {
                    result2.set((Object)context2.trace.get(BindingContext.DATAFLOW_INFO_AFTER_CONDITION, expression2));
                }
            }

            @Override
            public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
                IElementType operationToken = expression2.getOperationToken();
                if (OperatorConventions.BOOLEAN_OPERATIONS.containsKey((Object)operationToken)) {
                    DataFlowInfo dataFlowInfo = DataFlowAnalyzer.this.extractDataFlowInfoFromCondition(expression2.getLeft(), conditionValue, context2);
                    KtExpression expressionRight = expression2.getRight();
                    if (expressionRight != null) {
                        boolean and = operationToken == KtTokens.ANDAND;
                        DataFlowInfo rightInfo = DataFlowAnalyzer.this.extractDataFlowInfoFromCondition(expressionRight, conditionValue, and == conditionValue ? (ExpressionTypingContext)context2.replaceDataFlowInfo(dataFlowInfo) : context2);
                        dataFlowInfo = and == conditionValue ? dataFlowInfo.and(rightInfo) : dataFlowInfo.or(rightInfo);
                    }
                    result2.set((Object)dataFlowInfo);
                } else {
                    DataFlowInfo expressionFlowInfo = DataFlowAnalyzer.this.facade.getTypeInfo(expression2, context2).getDataFlowInfo();
                    KtExpression left = expression2.getLeft();
                    if (left == null) {
                        return;
                    }
                    KtExpression right = expression2.getRight();
                    if (right == null) {
                        return;
                    }
                    KotlinType lhsType = context2.trace.getBindingContext().getType(left);
                    if (lhsType == null) {
                        return;
                    }
                    KotlinType rhsType = context2.trace.getBindingContext().getType(right);
                    if (rhsType == null) {
                        return;
                    }
                    DataFlowValue leftValue = DataFlowAnalyzer.this.dataFlowValueFactory.createDataFlowValue(left, lhsType, context2);
                    DataFlowValue rightValue = DataFlowAnalyzer.this.dataFlowValueFactory.createDataFlowValue(right, rhsType, context2);
                    Boolean equals = null;
                    if (operationToken == KtTokens.EQEQ || operationToken == KtTokens.EQEQEQ) {
                        equals = true;
                    } else if (operationToken == KtTokens.EXCLEQ || operationToken == KtTokens.EXCLEQEQEQ) {
                        equals = false;
                    } else if (operationToken == KtTokens.ELVIS && DataFlowAnalyzer.this.languageVersionSettings.supportsFeature(LanguageFeature.BooleanElvisBoundSmartCasts) && right instanceof KtConstantExpression && KotlinBuiltIns.isBoolean(rhsType)) {
                        equals = KtPsiUtil.isFalseConstant(right);
                    }
                    if (equals != null) {
                        if (equals == conditionValue) {
                            boolean identityEquals = operationToken == KtTokens.EQEQEQ || operationToken == KtTokens.EXCLEQEQEQ || DataFlowAnalyzer.this.typeHasEqualsFromAny(lhsType, condition2);
                            result2.set((Object)context2.dataFlowInfo.equate(leftValue, rightValue, identityEquals, DataFlowAnalyzer.this.languageVersionSettings).and(expressionFlowInfo));
                        } else {
                            result2.set((Object)context2.dataFlowInfo.disequate(leftValue, rightValue, DataFlowAnalyzer.this.languageVersionSettings).and(expressionFlowInfo));
                        }
                    } else {
                        result2.set((Object)expressionFlowInfo);
                    }
                }
            }

            @Override
            public void visitUnaryExpression(@NotNull KtUnaryExpression expression2) {
                IElementType operationTokenType = expression2.getOperationReference().getReferencedNameElementType();
                if (operationTokenType == KtTokens.EXCL) {
                    KtExpression baseExpression = expression2.getBaseExpression();
                    if (baseExpression != null) {
                        result2.set((Object)DataFlowAnalyzer.this.extractDataFlowInfoFromCondition(baseExpression, !conditionValue, context2));
                    }
                } else {
                    this.visitExpression(expression2);
                }
            }

            @Override
            public void visitExpression(@NotNull KtExpression expression2) {
                result2.set((Object)DataFlowAnalyzer.this.facade.getTypeInfo(expression2, context2).getDataFlowInfo());
            }

            @Override
            public void visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression2) {
                KtExpression body2 = expression2.getExpression();
                if (body2 != null) {
                    body2.accept(this);
                }
            }
        });
        DataFlowInfo infoFromEffectSystem = this.effectSystem.extractDataFlowInfoFromCondition(condition2, conditionValue, context2.trace, DescriptorUtils.getContainingModule(context2.scope.getOwnerDescriptor()));
        if (result2.get() == null) {
            return context2.dataFlowInfo.and(infoFromEffectSystem);
        }
        return context2.dataFlowInfo.and((DataFlowInfo)result2.get()).and(infoFromEffectSystem);
    }

    @Nullable
    public KotlinType checkType(@Nullable KotlinType expressionType, @NotNull KtExpression expression2, @NotNull ResolutionContext context2) {
        return this.checkType(expressionType, expression2, context2, null, true);
    }

    @Nullable
    public KotlinType checkType(@Nullable KotlinType expressionType, @NotNull KtExpression expression2, @NotNull ResolutionContext context2, boolean reportErrorForTypeMismatch) {
        return this.checkType(expressionType, expression2, context2, null, reportErrorForTypeMismatch);
    }

    @NotNull
    public KotlinTypeInfo checkType(@NotNull KotlinTypeInfo typeInfo, @NotNull KtExpression expression2, @NotNull ResolutionContext context2) {
        return typeInfo.replaceType(this.checkType(typeInfo.getType(), expression2, context2));
    }

    @NotNull
    private KotlinType checkTypeInternal(@NotNull KotlinType expressionType, @NotNull KtExpression expression2, @NotNull ResolutionContext c, @NotNull Ref<Boolean> hasError, boolean reportErrorForTypeMismatch) {
        if (TypeUtils.noExpectedType(c.expectedType) || !c.expectedType.getConstructor().isDenotable() || KotlinTypeChecker.DEFAULT.isSubtypeOf(expressionType, c.expectedType)) {
            return expressionType;
        }
        if (expression2 instanceof KtConstantExpression && reportErrorForTypeMismatch) {
            ConstantValue<?> constantValue = this.constantExpressionEvaluator.evaluateToConstantValue(expression2, c.trace, c.expectedType);
            boolean error = new CompileTimeConstantChecker(c, this.module, true).checkConstantExpressionType(constantValue, (KtConstantExpression)expression2, c.expectedType);
            hasError.set((Object)error);
            return expressionType;
        }
        if (expression2 instanceof KtWhenExpression) {
            return expressionType;
        }
        SmartCastResult castResult = this.checkPossibleCast(expressionType, expression2, c);
        if (castResult != null) {
            return castResult.getResultType();
        }
        if (reportErrorForTypeMismatch && !DiagnosticUtilsKt.reportTypeMismatchDueToTypeProjection(c, expression2, c.expectedType, expressionType) && !DiagnosticUtilsKt.reportTypeMismatchDueToScalaLikeNamedFunctionSyntax(c, expression2, c.expectedType, expressionType)) {
            c.trace.report(Errors.TYPE_MISMATCH.on(expression2, c.expectedType, expressionType));
        }
        hasError.set((Object)true);
        return expressionType;
    }

    @Nullable
    public KotlinType checkType(@Nullable KotlinType expressionType, @NotNull KtExpression expressionToCheck, @NotNull ResolutionContext c, @Nullable Ref<Boolean> hasError, boolean reportErrorForTypeMismatch) {
        if (hasError == null) {
            hasError = Ref.create((Object)false);
        } else {
            hasError.set((Object)false);
        }
        KtExpression expression2 = KtPsiUtil.safeDeparenthesize(expressionToCheck);
        this.recordExpectedType(c.trace, expression2, c.expectedType);
        if (expressionType == null) {
            return null;
        }
        KotlinType result2 = this.checkTypeInternal(expressionType, expression2, c, (Ref<Boolean>)hasError, reportErrorForTypeMismatch);
        if (Boolean.FALSE.equals(hasError.get())) {
            for (AdditionalTypeChecker checker : this.additionalTypeCheckers) {
                checker.checkType(expression2, expressionType, result2, c);
            }
        }
        return result2;
    }

    @Nullable
    public SmartCastResult checkPossibleCast(@NotNull KotlinType expressionType, @NotNull KtExpression expression2, @NotNull ResolutionContext c) {
        DataFlowValue dataFlowValue2 = this.dataFlowValueFactory.createDataFlowValue(expression2, expressionType, c);
        return SmartCastManager.Companion.checkAndRecordPossibleCast(dataFlowValue2, c.expectedType, expression2, c, null, false);
    }

    public void recordExpectedType(@NotNull BindingTrace trace, @NotNull KtExpression expression2, @NotNull KotlinType expectedType) {
        if (expectedType != TypeUtils.NO_EXPECTED_TYPE) {
            KotlinType normalizeExpectedType = expectedType == TypeUtils.UNIT_EXPECTED_TYPE ? this.builtIns.getUnitType() : expectedType;
            trace.record(BindingContext.EXPECTED_EXPRESSION_TYPE, expression2, normalizeExpectedType);
        }
    }

    @Nullable
    public KotlinType checkStatementType(@NotNull KtExpression expression2, @NotNull ResolutionContext context2) {
        if (!(TypeUtils.noExpectedType(context2.expectedType) || KotlinBuiltIns.isUnit(context2.expectedType) || KotlinTypeKt.isError(context2.expectedType))) {
            context2.trace.report(Errors.EXPECTED_TYPE_MISMATCH.on(expression2, context2.expectedType));
            return null;
        }
        return this.builtIns.getUnitType();
    }

    @NotNull
    public KotlinTypeInfo illegalStatementType(@NotNull KtExpression expression2, @NotNull ExpressionTypingContext context2, @NotNull ExpressionTypingInternals facade) {
        facade.checkStatementType(expression2, (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT));
        context2.trace.report(Errors.EXPRESSION_EXPECTED.on(expression2, expression2));
        return TypeInfoFactoryKt.noTypeInfo(context2);
    }

    @NotNull
    public static Collection<KotlinType> getAllPossibleTypes(@NotNull KtExpression expression2, @NotNull KotlinType type2, @NotNull ResolutionContext c) {
        DataFlowValue dataFlowValue2 = c.dataFlowValueFactory.createDataFlowValue(expression2, type2, c);
        return DataFlowAnalyzer.getAllPossibleTypes(type2, c, dataFlowValue2, c.languageVersionSettings);
    }

    @NotNull
    public static Collection<KotlinType> getAllPossibleTypes(@NotNull KotlinType type2, @NotNull ResolutionContext c, @NotNull DataFlowValue dataFlowValue2, @NotNull LanguageVersionSettings languageVersionSettings) {
        HashSet possibleTypes = Sets.newHashSet((Object[])new KotlinType[]{type2});
        possibleTypes.addAll(c.dataFlowInfo.getStableTypes(dataFlowValue2, languageVersionSettings));
        return possibleTypes;
    }

    @NotNull
    public KotlinTypeInfo createCheckedTypeInfo(@Nullable KotlinType type2, @NotNull ResolutionContext<?> context2, @NotNull KtExpression expression2) {
        return this.checkType(TypeInfoFactoryKt.createTypeInfo(type2, context2), expression2, context2);
    }

    @NotNull
    public KotlinTypeInfo createCompileTimeConstantTypeInfo(@NotNull CompileTimeConstant<?> value, @NotNull KtExpression expression2, @NotNull ExpressionTypingContext context2) {
        KotlinType expressionType;
        if (value instanceof IntegerValueTypeConstant) {
            IntegerValueTypeConstant integerValueTypeConstant = (IntegerValueTypeConstant)value;
            if (context2.contextDependency == ContextDependency.INDEPENDENT) {
                expressionType = integerValueTypeConstant.getType(context2.expectedType);
                this.constantExpressionEvaluator.updateNumberType(expressionType, expression2, context2.statementFilter, context2.trace);
            } else {
                expressionType = integerValueTypeConstant.getUnknownIntegerType();
            }
        } else {
            expressionType = ((TypedCompileTimeConstant)value).getType();
        }
        return this.createCheckedTypeInfo(expressionType, context2, expression2);
    }
}

