/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Iterator;
import java.util.List;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AbstractFilteringTrace;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.StatementFilterKt;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.tower.KotlinResolutionCallbacksImpl;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.TraceBasedLocalRedeclarationChecker;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingComponents;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingFacade;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitorDispatcher;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class ExpressionTypingServices {
    private final ExpressionTypingFacade expressionTypingFacade;
    private final ExpressionTypingComponents expressionTypingComponents;
    @NotNull
    private final AnnotationChecker annotationChecker;
    @NotNull
    private final StatementFilter statementFilter;

    public ExpressionTypingServices(@NotNull ExpressionTypingComponents components, @NotNull AnnotationChecker annotationChecker, @NotNull StatementFilter statementFilter, @NotNull ExpressionTypingVisitorDispatcher.ForDeclarations facade) {
        this.expressionTypingComponents = components;
        this.annotationChecker = annotationChecker;
        this.statementFilter = statementFilter;
        this.expressionTypingFacade = facade;
    }

    @NotNull
    public LanguageVersionSettings getLanguageVersionSettings() {
        return this.expressionTypingComponents.languageVersionSettings;
    }

    @NotNull
    public StatementFilter getStatementFilter() {
        return this.statementFilter;
    }

    @NotNull
    public KotlinType safeGetType(@NotNull LexicalScope scope2, @NotNull KtExpression expression2, @NotNull KotlinType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        KotlinType type2 = this.getType(scope2, expression2, expectedType, dataFlowInfo, trace);
        return type2 != null ? type2 : ErrorUtils.createErrorType("Type for " + expression2.getText());
    }

    @NotNull
    public KotlinTypeInfo getTypeInfo(@NotNull LexicalScope scope2, @NotNull KtExpression expression2, @NotNull KotlinType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace, boolean isStatement) {
        return this.getTypeInfo(scope2, expression2, expectedType, dataFlowInfo, trace, isStatement, expression2, ContextDependency.INDEPENDENT);
    }

    @NotNull
    public KotlinTypeInfo getTypeInfo(@NotNull LexicalScope scope2, @NotNull KtExpression expression2, @NotNull KotlinType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace, boolean isStatement, @NotNull KtExpression contextExpression, @NotNull ContextDependency contextDependency) {
        ExpressionTypingContext context2 = ExpressionTypingContext.newContext(trace, scope2, dataFlowInfo, expectedType, contextDependency, this.statementFilter, this.getLanguageVersionSettings(), this.expressionTypingComponents.dataFlowValueFactory);
        if (contextExpression != expression2) {
            context2 = (ExpressionTypingContext)context2.replaceExpressionContextProvider((Function1<KtExpression, KtExpression>)((Function1)arg -> arg == expression2 ? contextExpression : null));
        }
        return this.expressionTypingFacade.getTypeInfo(expression2, context2, isStatement);
    }

    @NotNull
    public KotlinTypeInfo getTypeInfo(@NotNull KtExpression expression2, @NotNull ResolutionContext resolutionContext) {
        return this.expressionTypingFacade.getTypeInfo(expression2, ExpressionTypingContext.newContext(resolutionContext));
    }

    @Nullable
    public KotlinType getType(@NotNull LexicalScope scope2, @NotNull KtExpression expression2, @NotNull KotlinType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        return this.getTypeInfo(scope2, expression2, expectedType, dataFlowInfo, trace, false).getType();
    }

    public void checkFunctionReturnType(@NotNull LexicalScope functionInnerScope, @NotNull KtDeclarationWithBody function2, @NotNull FunctionDescriptor functionDescriptor2, @NotNull DataFlowInfo dataFlowInfo, @Nullable KotlinType expectedReturnType, BindingTrace trace) {
        if (expectedReturnType == null) {
            expectedReturnType = functionDescriptor2.getReturnType();
            if (!function2.hasBlockBody() && !function2.hasDeclaredReturnType()) {
                expectedReturnType = TypeUtils.NO_EXPECTED_TYPE;
            }
        }
        this.checkFunctionReturnType(function2, ExpressionTypingContext.newContext(trace, functionInnerScope, dataFlowInfo, expectedReturnType != null ? expectedReturnType : TypeUtils.NO_EXPECTED_TYPE, this.getLanguageVersionSettings(), this.expressionTypingComponents.dataFlowValueFactory));
    }

    void checkFunctionReturnType(KtDeclarationWithBody function2, ExpressionTypingContext context2) {
        KtExpression bodyExpression = function2.getBodyExpression();
        if (bodyExpression == null) {
            return;
        }
        boolean blockBody = function2.hasBlockBody();
        ExpressionTypingContext newContext = blockBody ? (ExpressionTypingContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE) : context2;
        this.expressionTypingFacade.getTypeInfo(bodyExpression, newContext, blockBody);
    }

    @NotNull
    public KotlinTypeInfo getBlockReturnedType(KtBlockExpression expression2, ExpressionTypingContext context2, boolean isStatement) {
        return this.getBlockReturnedType(expression2, isStatement ? CoercionStrategy.COERCION_TO_UNIT : CoercionStrategy.NO_COERCION, context2);
    }

    @NotNull
    public KotlinTypeInfo getBlockReturnedType(@NotNull KtBlockExpression expression2, @NotNull CoercionStrategy coercionStrategyForLastExpression, @NotNull ExpressionTypingContext context2) {
        List<KtExpression> block = StatementFilterKt.filterStatements(this.statementFilter, expression2);
        DeclarationDescriptor containingDescriptor = context2.scope.getOwnerDescriptor();
        TraceBasedLocalRedeclarationChecker redeclarationChecker = new TraceBasedLocalRedeclarationChecker(context2.trace, this.expressionTypingComponents.overloadChecker);
        LexicalWritableScope scope2 = new LexicalWritableScope(context2.scope, containingDescriptor, false, redeclarationChecker, LexicalScopeKind.CODE_BLOCK);
        KotlinTypeInfo r = block.isEmpty() ? this.expressionTypingComponents.dataFlowAnalyzer.createCheckedTypeInfo(this.expressionTypingComponents.builtIns.getUnitType(), context2, expression2) : this.getBlockReturnedTypeWithWritableScope(scope2, block, coercionStrategyForLastExpression, (ExpressionTypingContext)context2.replaceStatementFilter(this.statementFilter));
        scope2.freeze();
        if (containingDescriptor instanceof ScriptDescriptor) {
            context2.trace.record(BindingContext.SCRIPT_SCOPE, (ScriptDescriptor)containingDescriptor, scope2);
        }
        return r;
    }

    @NotNull
    public KotlinType getBodyExpressionType(@NotNull BindingTrace trace, @NotNull LexicalScope outerScope, @NotNull DataFlowInfo dataFlowInfo, @NotNull KtDeclarationWithBody function2, @NotNull FunctionDescriptor functionDescriptor2) {
        KtExpression bodyExpression = function2.getBodyExpression();
        assert (bodyExpression != null);
        LexicalScope functionInnerScope = FunctionDescriptorUtil.getFunctionInnerScope(outerScope, functionDescriptor2, trace, this.expressionTypingComponents.overloadChecker);
        ExpressionTypingContext context2 = ExpressionTypingContext.newContext(trace, functionInnerScope, dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE, this.getLanguageVersionSettings(), this.expressionTypingComponents.dataFlowValueFactory);
        KotlinTypeInfo typeInfo = this.expressionTypingFacade.getTypeInfo(bodyExpression, context2, function2.hasBlockBody());
        KotlinType type2 = typeInfo.getType();
        if (type2 != null) {
            return type2;
        }
        return ErrorUtils.createErrorType("Error function type");
    }

    KotlinTypeInfo getBlockReturnedTypeWithWritableScope(@NotNull LexicalWritableScope scope2, @NotNull List<? extends KtElement> block, @NotNull CoercionStrategy coercionStrategyForLastExpression, @NotNull ExpressionTypingContext context2) {
        if (block.isEmpty()) {
            return TypeInfoFactoryKt.createTypeInfo((KotlinType)this.expressionTypingComponents.builtIns.getUnitType(), context2);
        }
        ExpressionTypingVisitorDispatcher.ForBlock blockLevelVisitor = new ExpressionTypingVisitorDispatcher.ForBlock(this.expressionTypingComponents, this.annotationChecker, scope2);
        ExpressionTypingContext newContext = (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceScope(scope2)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        KotlinTypeInfo result2 = TypeInfoFactoryKt.noTypeInfo(context2);
        DataFlowInfo beforeJumpInfo = newContext.dataFlowInfo;
        boolean jumpOutPossible = false;
        boolean isFirstStatement = true;
        Iterator<? extends KtElement> iterator2 = block.iterator();
        while (iterator2.hasNext()) {
            AbstractFilteringTrace traceForSingleStatement = new AbstractFilteringTrace(context2.trace, "trace for single statement"){

                @Override
                protected <K, V> boolean shouldBeHiddenFromParent(@NotNull WritableSlice<K, V> slice, K key) {
                    return slice == BindingContext.EXPRESSION_EFFECTS;
                }
            };
            newContext = (ExpressionTypingContext)newContext.replaceBindingTrace(traceForSingleStatement);
            KtElement statement2 = iterator2.next();
            if (!(statement2 instanceof KtExpression)) continue;
            KtExpression statementExpression = (KtExpression)statement2;
            if (!iterator2.hasNext()) {
                result2 = this.getTypeOfLastExpressionInBlock(statementExpression, (ExpressionTypingContext)newContext.replaceExpectedType(context2.expectedType), coercionStrategyForLastExpression, blockLevelVisitor);
                if (result2.getType() != null && statementExpression.getParent() instanceof KtBlockExpression) {
                    DataFlowValue lastExpressionValue = this.expressionTypingComponents.dataFlowValueFactory.createDataFlowValue(statementExpression, result2.getType(), context2);
                    DataFlowValue blockExpressionValue = this.expressionTypingComponents.dataFlowValueFactory.createDataFlowValue((KtBlockExpression)statementExpression.getParent(), result2.getType(), context2);
                    result2 = result2.replaceDataFlowInfo(result2.getDataFlowInfo().assign(blockExpressionValue, lastExpressionValue, this.expressionTypingComponents.languageVersionSettings));
                }
            } else {
                result2 = blockLevelVisitor.getTypeInfo(statementExpression, (ExpressionTypingContext)newContext.replaceContextDependency(ContextDependency.INDEPENDENT), true);
            }
            DataFlowInfo newDataFlowInfo = result2.getDataFlowInfo();
            if (!jumpOutPossible) {
                beforeJumpInfo = result2.getJumpFlowInfo();
                jumpOutPossible = result2.getJumpOutPossible();
            }
            if (newDataFlowInfo != context2.dataFlowInfo) {
                newContext = (ExpressionTypingContext)newContext.replaceDataFlowInfo(newDataFlowInfo);
            }
            blockLevelVisitor = new ExpressionTypingVisitorDispatcher.ForBlock(this.expressionTypingComponents, this.annotationChecker, scope2);
            this.expressionTypingComponents.contractParsingServices.checkContractAndRecordIfPresent(statementExpression, context2.trace, scope2, isFirstStatement);
            if (!isFirstStatement) continue;
            isFirstStatement = false;
        }
        return result2.replaceJumpOutPossible(jumpOutPossible).replaceJumpFlowInfo(beforeJumpInfo);
    }

    private KotlinTypeInfo getTypeOfLastExpressionInBlock(@NotNull KtExpression statementExpression, @NotNull ExpressionTypingContext context2, @NotNull CoercionStrategy coercionStrategyForLastExpression, @NotNull ExpressionTypingInternals blockLevelVisitor) {
        KtFunctionLiteral parent2;
        if (context2.expectedType != TypeUtils.NO_EXPECTED_TYPE) {
            KotlinType expectedType = context2.expectedType == TypeUtils.UNIT_EXPECTED_TYPE || coercionStrategyForLastExpression == CoercionStrategy.COERCION_TO_UNIT && KotlinBuiltIns.isUnit(context2.expectedType) ? TypeUtils.UNIT_EXPECTED_TYPE : context2.expectedType;
            ContextDependency dependency = context2.contextDependency;
            if (this.getLanguageVersionSettings().supportsFeature(LanguageFeature.NewInference)) {
                dependency = ContextDependency.INDEPENDENT;
            }
            return blockLevelVisitor.getTypeInfo(statementExpression, (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceExpectedType(expectedType)).replaceContextDependency(dependency), true);
        }
        if (context2.languageVersionSettings.supportsFeature(LanguageFeature.NewInference) && statementExpression instanceof KtLambdaExpression && (parent2 = PsiUtilsKt.getNonStrictParentOfType((PsiElement)statementExpression, KtFunctionLiteral.class)) != null) {
            KtFunctionLiteral functionLiteral = parent2;
            KotlinResolutionCallbacksImpl.LambdaInfo info = context2.trace.getBindingContext().get(BindingContext.NEW_INFERENCE_LAMBDA_INFO, functionLiteral);
            if (info != null) {
                info.getLastExpressionInfo().setLexicalScope(context2.scope);
                info.getLastExpressionInfo().setTrace(context2.trace);
                return new KotlinTypeInfo(TypeUtils.DONT_CARE, context2.dataFlowInfo);
            }
        }
        KotlinTypeInfo result2 = blockLevelVisitor.getTypeInfo(statementExpression, context2, true);
        if (coercionStrategyForLastExpression == CoercionStrategy.COERCION_TO_UNIT) {
            KtBinaryExpression binaryExpression;
            IElementType operationType;
            boolean mightBeUnit = false;
            if (statementExpression instanceof KtDeclaration && (!(statementExpression instanceof KtNamedFunction) || statementExpression.getName() != null)) {
                mightBeUnit = true;
            }
            if (statementExpression instanceof KtBinaryExpression && ((operationType = (binaryExpression = (KtBinaryExpression)statementExpression).getOperationToken()) == KtTokens.EQ || OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey((Object)operationType))) {
                mightBeUnit = true;
            }
            if (mightBeUnit) {
                assert (result2.getType() == null || KotlinBuiltIns.isUnit(result2.getType()));
                result2 = result2.replaceType(this.expressionTypingComponents.builtIns.getUnitType());
            }
        }
        return result2;
    }
}

