/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.HashSet;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.context.CallPosition;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.BasicExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingVisitor;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.FunctionsTypingVisitor;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.expressions.PatternMatchingTypingVisitor;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public class ExpressionTypingVisitorForStatements
extends ExpressionTypingVisitor {
    private final LexicalWritableScope scope;
    private final BasicExpressionTypingVisitor basic;
    private final ControlStructureTypingVisitor controlStructures;
    private final PatternMatchingTypingVisitor patterns;
    private final FunctionsTypingVisitor functions;

    public ExpressionTypingVisitorForStatements(@NotNull ExpressionTypingInternals facade, @NotNull LexicalWritableScope scope2, @NotNull BasicExpressionTypingVisitor basic, @NotNull ControlStructureTypingVisitor controlStructures, @NotNull PatternMatchingTypingVisitor patterns, @NotNull FunctionsTypingVisitor functions2) {
        super(facade);
        this.scope = scope2;
        this.basic = basic;
        this.controlStructures = controlStructures;
        this.patterns = patterns;
        this.functions = functions2;
    }

    @Nullable
    private KotlinType checkAssignmentType(@Nullable KotlinType assignmentType, @NotNull KtBinaryExpression expression2, @NotNull ExpressionTypingContext context2) {
        if (assignmentType != null && !KotlinBuiltIns.isUnit(assignmentType) && !TypeUtils.noExpectedType(context2.expectedType) && !KotlinTypeKt.isError(context2.expectedType) && TypeUtils.equalTypes(context2.expectedType, assignmentType)) {
            context2.trace.report(Errors.ASSIGNMENT_TYPE_MISMATCH.on(expression2, context2.expectedType));
            return null;
        }
        return this.components.dataFlowAnalyzer.checkStatementType(expression2, context2);
    }

    @Override
    public KotlinTypeInfo visitObjectDeclaration(@NotNull KtObjectDeclaration declaration2, ExpressionTypingContext context2) {
        this.components.localClassifierAnalyzer.processClassOrObject(this.scope, (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceScope(this.scope)).replaceContextDependency(ContextDependency.INDEPENDENT), this.scope.getOwnerDescriptor(), declaration2);
        return TypeInfoFactoryKt.createTypeInfo(this.components.dataFlowAnalyzer.checkStatementType(declaration2, context2), context2);
    }

    @Override
    public KotlinTypeInfo visitProperty(@NotNull KtProperty property, ExpressionTypingContext typingContext) {
        Pair<KotlinTypeInfo, VariableDescriptor> typeInfoAndVariableDescriptor = this.components.localVariableResolver.process(property, typingContext, this.scope, this.facade);
        this.scope.addVariableDescriptor((VariableDescriptor)typeInfoAndVariableDescriptor.getSecond());
        return (KotlinTypeInfo)typeInfoAndVariableDescriptor.getFirst();
    }

    @Override
    public KotlinTypeInfo visitTypeAlias(@NotNull KtTypeAlias typeAlias2, ExpressionTypingContext context2) {
        TypeAliasDescriptor typeAliasDescriptor = this.components.descriptorResolver.resolveTypeAliasDescriptor(context2.scope.getOwnerDescriptor(), context2.scope, typeAlias2, context2.trace);
        this.scope.addClassifierDescriptor(typeAliasDescriptor);
        ForceResolveUtil.forceResolveAllContents(typeAliasDescriptor);
        this.facade.getComponents().declarationsCheckerBuilder.withTrace(context2.trace).checkLocalTypeAliasDeclaration(typeAlias2, typeAliasDescriptor);
        return TypeInfoFactoryKt.createTypeInfo(this.components.dataFlowAnalyzer.checkStatementType(typeAlias2, context2), context2);
    }

    @Override
    public KotlinTypeInfo visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration multiDeclaration, ExpressionTypingContext context2) {
        this.components.annotationResolver.resolveAnnotationsWithArguments((LexicalScope)this.scope, multiDeclaration.getModifierList(), context2.trace);
        KtExpression initializer2 = multiDeclaration.getInitializer();
        if (initializer2 == null) {
            context2.trace.report(Errors.INITIALIZER_REQUIRED_FOR_DESTRUCTURING_DECLARATION.on(multiDeclaration));
        }
        ExpressionReceiver expressionReceiver = initializer2 != null ? ExpressionTypingUtils.getExpressionReceiver(this.facade, initializer2, (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT)) : null;
        this.components.destructuringDeclarationResolver.defineLocalVariablesFromDestructuringDeclaration(this.scope, multiDeclaration, expressionReceiver, initializer2, context2);
        this.components.modifiersChecker.withTrace(context2.trace).checkModifiersForDestructuringDeclaration(multiDeclaration);
        this.components.identifierChecker.checkDeclaration(multiDeclaration, context2.trace);
        if (expressionReceiver == null) {
            return TypeInfoFactoryKt.noTypeInfo(context2);
        }
        return this.facade.getTypeInfo(initializer2, context2).replaceType(this.components.dataFlowAnalyzer.checkStatementType(multiDeclaration, context2));
    }

    @Override
    public KotlinTypeInfo visitNamedFunction(@NotNull KtNamedFunction function2, ExpressionTypingContext context2) {
        return this.functions.visitNamedFunction(function2, context2, function2.getName() != null, this.scope);
    }

    @Override
    public KotlinTypeInfo visitClass(@NotNull KtClass klass2, ExpressionTypingContext context2) {
        this.components.localClassifierAnalyzer.processClassOrObject(this.scope, (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceScope(this.scope)).replaceContextDependency(ContextDependency.INDEPENDENT), this.scope.getOwnerDescriptor(), klass2);
        return TypeInfoFactoryKt.createTypeInfo(this.components.dataFlowAnalyzer.checkStatementType(klass2, context2), context2);
    }

    @Override
    public KotlinTypeInfo visitDeclaration(@NotNull KtDeclaration dcl, ExpressionTypingContext context2) {
        return TypeInfoFactoryKt.createTypeInfo(this.components.dataFlowAnalyzer.checkStatementType(dcl, context2), context2);
    }

    @Override
    public KotlinTypeInfo visitBinaryExpression(@NotNull KtBinaryExpression expression2, ExpressionTypingContext context2) {
        KotlinTypeInfo result2;
        KtOperationReferenceExpression operationSign = expression2.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        if (operationType == KtTokens.EQ) {
            result2 = this.visitAssignment(expression2, context2);
        } else if (OperatorConventions.ASSIGNMENT_OPERATIONS.containsKey((Object)operationType)) {
            result2 = this.visitAssignmentOperation(expression2, context2);
        } else {
            return this.facade.getTypeInfo(expression2, context2);
        }
        return this.components.dataFlowAnalyzer.checkType(result2, (KtExpression)expression2, (ResolutionContext)context2);
    }

    @NotNull
    protected KotlinTypeInfo visitAssignmentOperation(KtBinaryExpression expression2, ExpressionTypingContext contextWithExpectedType) {
        boolean oneTypeOfModRemOperations;
        KotlinType binaryOperationType;
        OverloadResolutionResults<Object> binaryOperationDescriptors;
        KtExpression left;
        TemporaryTraceAndCache temporary = TemporaryTraceAndCache.create(contextWithExpectedType, "trace to resolve array set method for binary expression", expression2);
        ExpressionTypingContext context2 = (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceTraceAndCache(temporary)).replaceContextDependency(ContextDependency.INDEPENDENT);
        KtOperationReferenceExpression operationSign = expression2.getOperationReference();
        IElementType operationType = operationSign.getReferencedNameElementType();
        KtExpression leftOperand = expression2.getLeft();
        KotlinTypeInfo leftInfo = ExpressionTypingUtils.getTypeInfoOrNullType(leftOperand, context2, this.facade);
        KotlinType leftType = leftInfo.getType();
        KtExpression right = expression2.getRight();
        KtExpression ktExpression = left = leftOperand == null ? null : KtPsiUtil.deparenthesize(leftOperand);
        if (right == null || left == null) {
            temporary.commit();
            return leftInfo.clearType();
        }
        if (leftType == null) {
            KotlinTypeInfo rightInfo = this.facade.getTypeInfo(right, (ExpressionTypingContext)context2.replaceDataFlowInfo(leftInfo.getDataFlowInfo()));
            context2.trace.report(Errors.UNRESOLVED_REFERENCE.on(operationSign, operationSign));
            temporary.commit();
            return rightInfo.clearType();
        }
        ExpressionReceiver receiver = ExpressionReceiver.Companion.create(left, leftType, context2.trace.getBindingContext());
        Name name2 = (Name)OperatorConventions.ASSIGNMENT_OPERATIONS.get((Object)operationType);
        TemporaryTraceAndCache temporaryForAssignmentOperation = TemporaryTraceAndCache.create(context2, "trace to check assignment operation like '+=' for", expression2);
        OverloadResolutionResults<FunctionDescriptor> assignmentOperationDescriptors = this.components.callResolver.resolveBinaryCall((ExpressionTypingContext)((ExpressionTypingContext)context2.replaceTraceAndCache(temporaryForAssignmentOperation)).replaceScope(this.scope), receiver, expression2, name2);
        KotlinType assignmentOperationType = OverloadResolutionResultsUtil.getResultingType(assignmentOperationDescriptors, context2);
        TemporaryTraceAndCache temporaryForBinaryOperation = TemporaryTraceAndCache.create(context2, "trace to check binary operation like '+' for", expression2);
        TemporaryBindingTrace ignoreReportsTrace = TemporaryBindingTrace.create(context2.trace, "Trace for checking assignability");
        boolean lhsAssignable = this.basic.checkLValue(ignoreReportsTrace, context2, left, right, expression2);
        if (assignmentOperationType == null || lhsAssignable) {
            Name counterpartName = (Name)OperatorConventions.BINARY_OPERATION_NAMES.get(OperatorConventions.ASSIGNMENT_OPERATION_COUNTERPARTS.get((Object)operationType));
            binaryOperationDescriptors = this.components.callResolver.resolveBinaryCall((ExpressionTypingContext)((ExpressionTypingContext)context2.replaceTraceAndCache(temporaryForBinaryOperation)).replaceScope(this.scope), receiver, expression2, counterpartName);
            binaryOperationType = OverloadResolutionResultsUtil.getResultingType(binaryOperationDescriptors, context2);
        } else {
            binaryOperationDescriptors = OverloadResolutionResultsImpl.nameNotFound();
            binaryOperationType = null;
        }
        KotlinType type2 = assignmentOperationType != null ? assignmentOperationType : binaryOperationType;
        KotlinTypeInfo rightInfo = leftInfo;
        boolean hasRemAssignOperation = ExpressionTypingVisitorForStatements.atLeastOneOperation(assignmentOperationDescriptors.getResultingCalls(), OperatorNameConventions.REM_ASSIGN);
        boolean hasRemBinaryOperation = ExpressionTypingVisitorForStatements.atLeastOneOperation(binaryOperationDescriptors.getResultingCalls(), OperatorNameConventions.REM);
        boolean bl = oneTypeOfModRemOperations = hasRemAssignOperation == hasRemBinaryOperation;
        if (assignmentOperationDescriptors.isSuccess() && binaryOperationDescriptors.isSuccess() && oneTypeOfModRemOperations) {
            OverloadResolutionResults<Object> ambiguityResolutionResults = OverloadResolutionResultsUtil.ambiguity(assignmentOperationDescriptors, binaryOperationDescriptors);
            context2.trace.report(Errors.ASSIGN_OPERATOR_AMBIGUITY.on((PsiElement)operationSign, ambiguityResolutionResults.getResultingCalls()));
            HashSet<Object> descriptors2 = new HashSet<Object>();
            for (ResolvedCall<Object> resolvedCall2 : ambiguityResolutionResults.getResultingCalls()) {
                descriptors2.add(resolvedCall2.getResultingDescriptor());
            }
            rightInfo = this.facade.getTypeInfo(right, (ExpressionTypingContext)context2.replaceDataFlowInfo(leftInfo.getDataFlowInfo()));
            context2.trace.record(BindingContext.AMBIGUOUS_REFERENCE_TARGET, operationSign, descriptors2);
        } else if (!(assignmentOperationType == null || !assignmentOperationDescriptors.isSuccess() && binaryOperationDescriptors.isSuccess() || hasRemBinaryOperation && binaryOperationDescriptors.isSuccess())) {
            temporaryForAssignmentOperation.commit();
            if (!KotlinTypeChecker.DEFAULT.equalTypes(this.components.builtIns.getUnitType(), assignmentOperationType)) {
                context2.trace.report(Errors.ASSIGNMENT_OPERATOR_SHOULD_RETURN_UNIT.on(operationSign, assignmentOperationDescriptors.getResultingDescriptor(), operationSign));
            }
        } else {
            temporaryForBinaryOperation.commit();
            context2.trace.record(BindingContext.VARIABLE_REASSIGNMENT, expression2);
            if (left instanceof KtArrayAccessExpression) {
                ExpressionTypingContext contextForResolve = (ExpressionTypingContext)((ExpressionTypingContext)context2.replaceScope(this.scope)).replaceBindingTrace(TemporaryBindingTrace.create(context2.trace, "trace to resolve array set method for assignment", expression2));
                this.basic.resolveImplicitArrayAccessSetMethod((KtArrayAccessExpression)left, right, contextForResolve, context2.trace);
            }
            rightInfo = this.facade.getTypeInfo(right, (ExpressionTypingContext)context2.replaceDataFlowInfo(leftInfo.getDataFlowInfo()));
            KotlinType expectedType = ExpressionTypingVisitorForStatements.refineTypeFromPropertySetterIfPossible(context2.trace.getBindingContext(), leftOperand, leftType);
            this.components.dataFlowAnalyzer.checkType(binaryOperationType, (KtExpression)expression2, (ResolutionContext)((ExpressionTypingContext)((ExpressionTypingContext)context2.replaceExpectedType(expectedType)).replaceDataFlowInfo(rightInfo.getDataFlowInfo())).replaceCallPosition(new CallPosition.PropertyAssignment(left)));
            this.basic.checkLValue(context2.trace, context2, leftOperand, right, expression2);
        }
        temporary.commit();
        return rightInfo.replaceType(this.checkAssignmentType(type2, expression2, contextWithExpectedType));
    }

    private static boolean atLeastOneOperation(Collection<? extends ResolvedCall<FunctionDescriptor>> calls, Name operationName) {
        for (ResolvedCall<FunctionDescriptor> resolvedCall2 : calls) {
            if (!resolvedCall2.getCandidateDescriptor().getName().equals(operationName)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static KotlinType refineTypeFromPropertySetterIfPossible(@NotNull BindingContext bindingContext2, @Nullable KtElement leftOperand, @Nullable KotlinType leftOperandType) {
        PropertySetterDescriptor setter;
        VariableDescriptor descriptor2 = BindingContextUtils.extractVariableFromResolvedCall(bindingContext2, leftOperand);
        if (descriptor2 instanceof PropertyDescriptor && (setter = ((PropertyDescriptor)descriptor2).getSetter()) != null) {
            return setter.getValueParameters().get(0).getType();
        }
        return leftOperandType;
    }

    @NotNull
    protected KotlinTypeInfo visitAssignment(KtBinaryExpression expression2, ExpressionTypingContext contextWithExpectedType) {
        KotlinTypeInfo resultInfo;
        ExpressionTypingContext context2 = (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceScope(this.scope)).replaceContextDependency(ContextDependency.INDEPENDENT);
        KtExpression leftOperand = expression2.getLeft();
        if (leftOperand instanceof KtAnnotatedExpression) {
            this.basic.resolveAnnotationsOnExpression((KtAnnotatedExpression)leftOperand, context2);
        }
        KtExpression left = KtPsiUtil.deparenthesize(leftOperand);
        KtExpression right = expression2.getRight();
        if (left instanceof KtArrayAccessExpression) {
            KtArrayAccessExpression arrayAccessExpression2 = (KtArrayAccessExpression)left;
            if (right == null) {
                return TypeInfoFactoryKt.noTypeInfo(context2);
            }
            KotlinTypeInfo typeInfo = this.basic.resolveArrayAccessSetMethod(arrayAccessExpression2, right, context2, context2.trace);
            this.basic.checkLValue(context2.trace, context2, arrayAccessExpression2, right, expression2);
            return typeInfo.replaceType(this.checkAssignmentType(typeInfo.getType(), expression2, contextWithExpectedType));
        }
        KotlinTypeInfo leftInfo = ExpressionTypingUtils.getTypeInfoOrNullType(left, context2, this.facade);
        KotlinType expectedType = ExpressionTypingVisitorForStatements.refineTypeFromPropertySetterIfPossible(context2.trace.getBindingContext(), leftOperand, leftInfo.getType());
        DataFlowInfo dataFlowInfo = leftInfo.getDataFlowInfo();
        if (right != null) {
            resultInfo = this.facade.getTypeInfo(right, (ExpressionTypingContext)((ExpressionTypingContext)((ExpressionTypingContext)context2.replaceDataFlowInfo(dataFlowInfo)).replaceExpectedType(expectedType)).replaceCallPosition(new CallPosition.PropertyAssignment(leftOperand)));
            dataFlowInfo = resultInfo.getDataFlowInfo();
            KotlinType rightType = resultInfo.getType();
            if (left != null && expectedType != null && rightType != null) {
                DataFlowValue leftValue = this.components.dataFlowValueFactory.createDataFlowValue(left, expectedType, context2);
                DataFlowValue rightValue = this.components.dataFlowValueFactory.createDataFlowValue(right, rightType, context2);
                resultInfo = resultInfo.replaceDataFlowInfo(dataFlowInfo.assign(leftValue, rightValue, this.components.languageVersionSettings));
            }
        } else {
            resultInfo = leftInfo;
        }
        if (expectedType != null && leftOperand != null) {
            this.basic.checkLValue(context2.trace, context2, leftOperand, right, expression2);
        }
        return resultInfo.replaceType(this.components.dataFlowAnalyzer.checkStatementType(expression2, contextWithExpectedType));
    }

    @Override
    public KotlinTypeInfo visitExpression(@NotNull KtExpression expression2, ExpressionTypingContext context2) {
        return this.facade.getTypeInfo(expression2, context2);
    }

    @Override
    public KotlinTypeInfo visitKtElement(@NotNull KtElement element3, ExpressionTypingContext context2) {
        context2.trace.report(Errors.UNSUPPORTED.on((PsiElement)element3, "in a block"));
        return TypeInfoFactoryKt.noTypeInfo(context2);
    }

    @Override
    public KotlinTypeInfo visitWhileExpression(@NotNull KtWhileExpression expression2, ExpressionTypingContext context2) {
        return this.controlStructures.visitWhileExpression(expression2, context2, true);
    }

    @Override
    public KotlinTypeInfo visitDoWhileExpression(@NotNull KtDoWhileExpression expression2, ExpressionTypingContext context2) {
        return this.controlStructures.visitDoWhileExpression(expression2, context2, true);
    }

    @Override
    public KotlinTypeInfo visitForExpression(@NotNull KtForExpression expression2, ExpressionTypingContext context2) {
        return this.controlStructures.visitForExpression(expression2, context2, true);
    }

    @Override
    public KotlinTypeInfo visitAnnotatedExpression(@NotNull KtAnnotatedExpression expression2, ExpressionTypingContext data) {
        return this.basic.visitAnnotatedExpression(expression2, data, true);
    }

    @Override
    public KotlinTypeInfo visitIfExpression(@NotNull KtIfExpression expression2, ExpressionTypingContext context2) {
        return this.controlStructures.visitIfExpression(expression2, context2, true);
    }

    @Override
    public KotlinTypeInfo visitWhenExpression(@NotNull KtWhenExpression expression2, ExpressionTypingContext context2) {
        return this.patterns.visitWhenExpression(expression2, context2, true);
    }

    @Override
    public KotlinTypeInfo visitBlockExpression(@NotNull KtBlockExpression expression2, ExpressionTypingContext context2) {
        return this.components.expressionTypingServices.getBlockReturnedType(expression2, context2, true);
    }

    @Override
    public KotlinTypeInfo visitLabeledExpression(@NotNull KtLabeledExpression expression2, ExpressionTypingContext context2) {
        return this.basic.visitLabeledExpression(expression2, context2, true);
    }
}

