/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/InnerClassConstructorCallsLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/BackendContext;", "(Lorg/jetbrains/kotlin/backend/common/BackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/BackendContext;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "backend-common"})
public final class InnerClassConstructorCallsLowering
implements BodyLoweringPass {
    @NotNull
    private final BackendContext context;

    @Override
    public void lower(@NotNull IrBody irBody) {
        Intrinsics.checkParameterIsNotNull((Object)irBody, (String)"irBody");
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new IrElementTransformerVoid(this){
            final /* synthetic */ InnerClassConstructorCallsLowering this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrExpression irExpression = expression2.getDispatchReceiver();
                if (irExpression == null) {
                    return expression2;
                }
                IrExpression dispatchReceiver = irExpression;
                FunctionDescriptor functionDescriptor = expression2.getDescriptor();
                if (!(functionDescriptor instanceof ClassConstructorDescriptor)) {
                    functionDescriptor = null;
                }
                ClassConstructorDescriptor classConstructorDescriptor = (ClassConstructorDescriptor)functionDescriptor;
                if (classConstructorDescriptor == null) {
                    return expression2;
                }
                ClassConstructorDescriptor callee = classConstructorDescriptor;
                ClassDescriptor classDescriptor = callee.getConstructedClass();
                Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor, (String)"callee.constructedClass");
                if (!classDescriptor.isInner()) {
                    return expression2;
                }
                IrConstructorSymbol newCallee = this.this$0.getContext().getDescriptorsFactory().getInnerClassConstructorWithOuterThisParameter(callee);
                IrCallImpl newCall = new IrCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), newCallee, newCallee.getDescriptor(), null, expression2.getOrigin(), null, 64, null);
                newCall.putValueArgument(0, dispatchReceiver);
                int n = 1;
                List<ValueParameterDescriptor> list2 = ((ClassConstructorDescriptor)newCallee.getDescriptor()).getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"newCallee.descriptor.valueParameters");
                int n2 = CollectionsKt.getLastIndex(list2);
                if (n <= n2) {
                    while (true) {
                        void i;
                        newCall.putValueArgument((int)i, expression2.getValueArgument((int)(i - true)));
                        if (i == n2) break;
                        ++i;
                    }
                }
                return newCall;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrExpression irExpression = expression2.getDispatchReceiver();
                if (irExpression == null) {
                    return expression2;
                }
                IrExpression dispatchReceiver = irExpression;
                ClassConstructorDescriptor callee = expression2.getDescriptor();
                ClassDescriptor classDescriptor = callee.getConstructedClass();
                Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor, (String)"callee.constructedClass");
                if (!classDescriptor.isInner()) {
                    return expression2;
                }
                IrConstructorSymbol newCallee = this.this$0.getContext().getDescriptorsFactory().getInnerClassConstructorWithOuterThisParameter(callee);
                IrDelegatingConstructorCallImpl newCall = new IrDelegatingConstructorCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), newCallee, (ClassConstructorDescriptor)newCallee.getDescriptor(), null);
                newCall.putValueArgument(0, dispatchReceiver);
                int n = 1;
                List<ValueParameterDescriptor> list2 = ((ClassConstructorDescriptor)newCallee.getDescriptor()).getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"newCallee.descriptor.valueParameters");
                int n2 = CollectionsKt.getLastIndex(list2);
                if (n <= n2) {
                    while (true) {
                        void i;
                        newCall.putValueArgument((int)i, expression2.getValueArgument((int)(i - true)));
                        if (i == n2) break;
                        ++i;
                    }
                }
                return newCall;
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    @NotNull
    public final BackendContext getContext() {
        return this.context;
    }

    public InnerClassConstructorCallsLowering(@NotNull BackendContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }
}

