/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.HasName;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDeclarationScope;
import org.jetbrains.kotlin.js.backend.ast.JsDynamicScope;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.CoroutineMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.clean.ResolveTemporaryNamesKt;
import org.jetbrains.kotlin.js.inline.clean.Scope;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\f\u0010\u0003\u001a\u00020\u0001*\u00020\u0001H\u0002\u001a\u0018\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u0002H\u0002\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0002\u00a8\u0006\t"}, d2={"computeScopes", "Lorg/jetbrains/kotlin/js/inline/clean/Scope;", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "liftUsedNames", "resolveNames", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "resolveTemporaryNames", "", "js.translator"})
public final class ResolveTemporaryNamesKt {
    public static final void resolveTemporaryNames(@NotNull JsNode $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Map<JsName, JsName> renamings = ResolveTemporaryNamesKt.resolveNames($receiver);
        $receiver.accept(new RecursiveJsVisitor(renamings){
            final /* synthetic */ Map $renamings;

            protected void visitElement(@NotNull JsNode node) {
                block1: {
                    JsName name;
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    super.visitElement(node);
                    if (!(node instanceof HasName) || (name = ((HasName)((Object)node)).getName()) == null) break block1;
                    JsName jsName = (JsName)this.$renamings.get(name);
                    if (jsName != null) {
                        JsName jsName2;
                        JsName it = jsName2 = jsName;
                        ((HasName)((Object)node)).setName(it);
                    }
                }
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                CoroutineMetadata coroutineMetadata = MetadataProperties.getCoroutineMetadata(x);
                if (coroutineMetadata != null) {
                    CoroutineMetadata coroutineMetadata2;
                    CoroutineMetadata $receiver = coroutineMetadata2 = coroutineMetadata;
                    this.accept((JsNode)$receiver.getSuspendObjectRef());
                    this.accept((JsNode)$receiver.getBaseClassRef());
                }
                super.visitFunction(x);
            }
            {
                this.$renamings = $captured_local_variable$0;
            }
        });
    }

    private static final Map<JsName, JsName> resolveNames(@NotNull JsNode $receiver) {
        Scope rootScope = ResolveTemporaryNamesKt.liftUsedNames(ResolveTemporaryNamesKt.computeScopes($receiver));
        Map replacements = new LinkedHashMap();
        Function1<Scope, Unit> traverse$ = new Function1<Scope, Unit>(replacements){
            final /* synthetic */ Map $replacements;

            public final void invoke(@NotNull Scope scope) {
                Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
                Set occupiedNames2 = SequencesKt.toMutableSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)scope.getDeclaredNames()), (Function1)resolveNames.occupiedNames.1.INSTANCE), (Function1)resolveNames.occupiedNames.2.INSTANCE));
                Collection collection = occupiedNames2;
                Sequence sequence2 = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)scope.getUsedNames()), (Function1)((Function1)new Function1<JsName, String>(this){
                    final /* synthetic */ resolveNames.1 this$0;

                    @Nullable
                    public final String invoke(@NotNull JsName it) {
                        String string;
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        if (!it.isTemporary()) {
                            string = it.getIdent();
                        } else {
                            JsName jsName = (JsName)this.this$0.$replacements.get(it);
                            string = jsName != null ? jsName.getIdent() : null;
                        }
                        return string;
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
                CollectionsKt.addAll((Collection)collection, (Sequence)sequence2);
                for (JsName temporaryName : SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)scope.getDeclaredNames()), (Function1)resolveNames.2.INSTANCE)) {
                    JsName jsName;
                    String resolvedName = temporaryName.getIdent();
                    int suffix = 0;
                    while (JsDeclarationScope.Companion.getRESERVED_WORDS().contains(resolvedName) || !occupiedNames2.add(resolvedName)) {
                        resolvedName = temporaryName.getIdent() + '_' + suffix++;
                    }
                    Object object = this.$replacements;
                    JsName $receiver = jsName = JsDynamicScope.INSTANCE.declareName(resolvedName);
                    $receiver.copyMetadataFrom(temporaryName);
                    JsName jsName2 = jsName;
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsName2, (String)"JsDynamicScope.declareNa\u2026dataFrom(temporaryName) }");
                    jsName = jsName2;
                    object.put(temporaryName, jsName);
                    object = occupiedNames2;
                    object.add(resolvedName);
                }
                Iterable $receiver$iv = scope.getChildren();
                for (E element$iv : $receiver$iv) {
                    Scope p1 = (Scope)element$iv;
                    this.invoke(p1);
                }
            }
            {
                this.$replacements = map2;
                super(1);
            }
        };
        traverse$.invoke(rootScope);
        $receiver.accept(new RecursiveJsVisitor(replacements){
            @NotNull
            private Set<String> labels;
            final /* synthetic */ Map $replacements;

            @NotNull
            public final Set<String> getLabels() {
                return this.labels;
            }

            public final void setLabels(@NotNull Set<String> set) {
                Intrinsics.checkParameterIsNotNull(set, (String)"<set-?>");
                this.labels = set;
            }

            public void visitLabel(@NotNull JsLabel x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Set addedNames = new LinkedHashSet<E>();
                JsName jsName = x.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"x.name");
                if (jsName.isTemporary()) {
                    JsName jsName2 = x.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsName2, (String)"x.name");
                    String resolvedName = jsName2.getIdent();
                    int suffix = 0;
                    while (true) {
                        String string = resolvedName;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resolvedName");
                        if (this.labels.add(string)) break;
                        StringBuilder stringBuilder = new StringBuilder();
                        JsName jsName3 = x.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsName3, (String)"x.name");
                        resolvedName = stringBuilder.append(jsName3.getIdent()).append('_').append(suffix++).toString();
                    }
                    Object object = this.$replacements;
                    JsName jsName4 = x.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsName4, (String)"x.name");
                    JsName jsName5 = jsName4;
                    JsName jsName6 = JsDynamicScope.INSTANCE.declareName(resolvedName);
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsName6, (String)"JsDynamicScope.declareName(resolvedName)");
                    JsName jsName7 = jsName6;
                    object.put(jsName5, jsName7);
                    object = addedNames;
                    object.add(resolvedName);
                }
                super.visitLabel(x);
                this.labels.removeAll(addedNames);
            }

            public void visitFunction(@NotNull JsFunction x) {
                Set set;
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Set<String> oldLabels = this.labels;
                resolveNames.2 var3_3 = this;
                var3_3.labels = set = (Set)new LinkedHashSet<E>();
                super.visitFunction(x);
                this.labels = oldLabels;
            }
            {
                Set set;
                this.$replacements = $captured_local_variable$0;
                resolveNames.2 var2_2 = this;
                var2_2.labels = set = (Set)new LinkedHashSet<E>();
            }
        });
        return replacements;
    }

    private static final Scope liftUsedNames(@NotNull Scope $receiver) {
        liftUsedNames.1 traverse$ = liftUsedNames.1.INSTANCE;
        traverse$.invoke($receiver);
        return $receiver;
    }

    private static final Scope computeScopes(@NotNull JsNode $receiver) {
        Scope rootScope = new Scope();
        $receiver.accept(new RecursiveJsVisitor(rootScope){
            @NotNull
            private Scope currentScope;
            final /* synthetic */ Scope $rootScope;

            @NotNull
            public final Scope getCurrentScope() {
                return this.currentScope;
            }

            public final void setCurrentScope(@NotNull Scope scope) {
                Intrinsics.checkParameterIsNotNull((Object)scope, (String)"<set-?>");
                this.currentScope = scope;
            }

            /*
             * WARNING - void declaration
             */
            public void visitFunction(@NotNull JsFunction x) {
                void $receiver$iv$iv;
                Iterable<E> iterable;
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                JsName jsName = x.getName();
                if (jsName != null) {
                    JsName jsName2;
                    JsName it = jsName2 = jsName;
                    iterable = this.currentScope.getDeclaredNames();
                    iterable.add(it);
                }
                Scope oldScope = this.currentScope;
                Object object = new Scope();
                Object object2 = this;
                Scope $receiver = object;
                $receiver.setParent(this.currentScope);
                Iterable<E> $i$a$1$let = this.currentScope.getChildren();
                $i$a$1$let.add($receiver);
                Object object3 = object;
                object2.currentScope = object3;
                object = this.currentScope.getDeclaredNames();
                List<JsParameter> list2 = x.getParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"x.parameters");
                Iterable $receiver$iv = list2;
                $i$a$1$let = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    JsParameter jsParameter = (JsParameter)item$iv$iv;
                    object2 = destination$iv$iv;
                    void v2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                    object3 = v2.getName();
                    object2.add(object3);
                }
                iterable = (List)destination$iv$iv;
                CollectionsKt.addAll((Collection)object, (Iterable)iterable);
                super.visitFunction(x);
                this.currentScope = oldScope;
            }

            public void visitCatch(@NotNull JsCatch x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Collection collection = this.currentScope.getDeclaredNames();
                JsParameter jsParameter = x.getParameter();
                Intrinsics.checkExpressionValueIsNotNull((Object)jsParameter, (String)"x.parameter");
                JsName jsName = jsParameter.getName();
                collection.add(jsName);
                super.visitCatch(x);
            }

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
                Collection collection = this.currentScope.getDeclaredNames();
                JsName jsName = x.getName();
                collection.add(jsName);
                super.visit(x);
            }

            public void visitNameRef(@NotNull JsNameRef nameRef) {
                Intrinsics.checkParameterIsNotNull((Object)nameRef, (String)"nameRef");
                if (nameRef.getQualifier() == null) {
                    JsName name = nameRef.getName();
                    Collection collection = this.currentScope.getUsedNames();
                    JsName jsName = name;
                    if (jsName == null) {
                        jsName = JsDynamicScope.INSTANCE.declareName(nameRef.getIdent());
                    }
                    JsName jsName2 = jsName;
                    collection.add(jsName2);
                }
                super.visitNameRef(nameRef);
            }

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
            }

            public void visitContinue(@NotNull JsContinue x) {
                Intrinsics.checkParameterIsNotNull((Object)x, (String)"x");
            }
            {
                this.$rootScope = $captured_local_variable$0;
                this.currentScope = $captured_local_variable$0;
            }
        });
        return rootScope;
    }
}

