/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J%\u0010\u000b\u001a\u00020\f\"\u0004\b\u0000\u0010\r*\b\u0012\u0004\u0012\u0002H\r0\u000e2\u0006\u0010\u000f\u001a\u0002H\rH\u0002\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/FiniteBoundRestrictionChecker;", "", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtClass;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "isInCycle", "", "T", "Lorg/jetbrains/kotlin/resolve/FiniteBoundRestrictionChecker$Graph;", "from", "(Lorg/jetbrains/kotlin/resolve/FiniteBoundRestrictionChecker$Graph;Ljava/lang/Object;)Z", "Graph", "GraphBuilder", "frontend"})
public final class FiniteBoundRestrictionChecker {
    public static final FiniteBoundRestrictionChecker INSTANCE;

    @JvmStatic
    public static final void check(@NotNull KtClass declaration, @NotNull ClassDescriptor classDescriptor, @NotNull DiagnosticSink diagnosticHolder) {
        Object object;
        DeclarationDescriptor it;
        Collection collection;
        Iterable $receiver$iv$iv;
        Object element$iv2;
        boolean bl;
        List problemNodes;
        block11: {
            Iterator<TypeParameterDescriptor> $receiver$iv$iv2;
            Iterable $receiver$iv;
            TypeConstructor typeConstructor2;
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            Intrinsics.checkParameterIsNotNull((Object)classDescriptor, (String)"classDescriptor");
            Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
            TypeConstructor typeConstructor3 = typeConstructor2 = classDescriptor.getTypeConstructor();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor3, (String)"typeConstructor");
            if (typeConstructor3.getParameters().isEmpty()) {
                return;
            }
            Graph<TypeParameterDescriptor> graph2 = new GraphBuilder(typeConstructor2).build();
            Iterable iterable = $receiver$iv = (Iterable)graph2.getNodes();
            Collection destination$iv$iv = new ArrayList();
            Iterator iterator2 = $receiver$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                TypeParameterDescriptor it2 = (TypeParameterDescriptor)element$iv$iv;
                if (!INSTANCE.isInCycle(graph2, it2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            problemNodes = (List)destination$iv$iv;
            if (problemNodes.isEmpty()) {
                return;
            }
            for (TypeParameterDescriptor typeParameter : typeConstructor2.getParameters()) {
                if (!problemNodes.contains(typeParameter)) continue;
                TypeParameterDescriptor typeParameterDescriptor = typeParameter;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor, (String)"typeParameter");
                PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(typeParameterDescriptor);
                if (psiElement == null) {
                    psiElement = declaration;
                }
                PsiElement element = psiElement;
                diagnosticHolder.report(Errors.FINITE_BOUNDS_VIOLATION.on(element));
                return;
            }
            $receiver$iv = problemNodes;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $receiver$iv) {
                    Object it3 = element$iv2;
                    if (!(Intrinsics.areEqual((Object)it3.getSource(), (Object)SourceElement.NO_SOURCE) ^ true)) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        Iterable $receiver$iv = problemNodes;
        element$iv2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            TypeParameterDescriptor $i$a$1$filter = (TypeParameterDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            object = it.getContainingDeclaration();
            collection.add(object);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (DeclarationDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            DeclarationDescriptor declarationDescriptor = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"it");
            object = DescriptorUtilsKt.getFqNameUnsafe(declarationDescriptor).asString();
            collection.add(object);
        }
        SortedSet typeFqNames = CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
        diagnosticHolder.report(Errors.FINITE_BOUNDS_VIOLATION_IN_JAVA.on(declaration, CollectionsKt.joinToString$default((Iterable)typeFqNames, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)));
    }

    /*
     * WARNING - void declaration
     */
    private final <T> boolean isInCycle(@NotNull Graph<T> $receiver, T from) {
        void result2;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        DFS.VisitedWithSet visited2 = new DFS.VisitedWithSet<T>(from, (Ref.BooleanRef)result2){
            final /* synthetic */ Object $from;
            final /* synthetic */ Ref.BooleanRef $result;

            public boolean checkAndMarkVisited(T current) {
                boolean added = super.checkAndMarkVisited(current);
                if (!added && Intrinsics.areEqual(current, (Object)this.$from)) {
                    this.$result.element = true;
                }
                return added;
            }
            {
                this.$from = $captured_local_variable$0;
                this.$result = $captured_local_variable$1;
            }
        };
        DFS.AbstractNodeHandler handler2 = new DFS.AbstractNodeHandler<T, Unit>(){

            public void result() {
            }
        };
        DFS.Neighbors neighbors2 = new DFS.Neighbors<T>($receiver){
            final /* synthetic */ Graph receiver$0;

            @NotNull
            public List<T> getNeighbors(T current) {
                return this.receiver$0.getNeighbors(current);
            }
            {
                this.receiver$0 = $receiver;
            }
        };
        DFS.dfs(CollectionsKt.listOf(from), neighbors2, visited2, handler2);
        return result2.element;
    }

    private FiniteBoundRestrictionChecker() {
    }

    static {
        FiniteBoundRestrictionChecker finiteBoundRestrictionChecker;
        INSTANCE = finiteBoundRestrictionChecker = new FiniteBoundRestrictionChecker();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R6\u0010\u0005\u001a*\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0006j\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u00030\rj\b\u0012\u0004\u0012\u00020\u0003`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/resolve/FiniteBoundRestrictionChecker$GraphBuilder;", "", "typeConstructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "(Lorg/jetbrains/kotlin/types/TypeConstructor;)V", "edgeLists", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "", "Lkotlin/collections/HashMap;", "nodes", "", "processedTypeConstructors", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getTypeConstructor", "()Lorg/jetbrains/kotlin/types/TypeConstructor;", "addEdge", "", "from", "to", "build", "Lorg/jetbrains/kotlin/resolve/FiniteBoundRestrictionChecker$Graph;", "buildGraph", "", "frontend"})
    private static final class GraphBuilder {
        private final Set<TypeParameterDescriptor> nodes;
        private final HashMap<TypeParameterDescriptor, List<TypeParameterDescriptor>> edgeLists;
        private final HashSet<TypeConstructor> processedTypeConstructors;
        @NotNull
        private final TypeConstructor typeConstructor;

        @NotNull
        public final Graph<TypeParameterDescriptor> build() {
            this.buildGraph(this.typeConstructor);
            return new Graph<TypeParameterDescriptor>(this){
                @NotNull
                private final Set<TypeParameterDescriptor> nodes;
                final /* synthetic */ GraphBuilder this$0;

                @NotNull
                public Set<TypeParameterDescriptor> getNodes() {
                    return this.nodes;
                }

                @NotNull
                public List<TypeParameterDescriptor> getNeighbors(@NotNull TypeParameterDescriptor node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    List list2 = (List)GraphBuilder.access$getEdgeLists$p(this.this$0).get(node);
                    if (list2 == null) {
                        list2 = CollectionsKt.emptyList();
                    }
                    return list2;
                }
                {
                    this.this$0 = $outer;
                    this.nodes = GraphBuilder.access$getNodes$p($outer);
                }
            };
        }

        private final boolean addEdge(TypeParameterDescriptor from, TypeParameterDescriptor to) {
            Object object;
            Map $receiver$iv = this.edgeLists;
            Object value$iv = $receiver$iv.get(from);
            if (value$iv == null) {
                List answer$iv = new ArrayList();
                $receiver$iv.put(from, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return ((List)object).add(to);
        }

        /*
         * WARNING - void declaration
         */
        private final void buildGraph(TypeConstructor typeConstructor2) {
            List<TypeParameterDescriptor> list2 = typeConstructor2.getParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"typeConstructor.parameters");
            Iterable $receiver$iv = list2;
            for (Object element$iv : $receiver$iv) {
                TypeParameterDescriptor typeParameter;
                TypeParameterDescriptor typeParameterDescriptor = typeParameter = (TypeParameterDescriptor)element$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor, (String)"typeParameter");
                List<KotlinType> list3 = typeParameterDescriptor.getUpperBounds();
                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"typeParameter.upperBounds");
                Collection<KotlinType> boundClosure2 = TypeUtilsKt.boundClosure((Collection<? extends KotlinType>)list3);
                Collection<KotlinType> constituentTypes = TypeUtilsKt.constituentTypes(boundClosure2);
                for (KotlinType constituentType : constituentTypes) {
                    TypeConstructor constituentTypeConstructor = constituentType.getConstructor();
                    if (!this.processedTypeConstructors.contains(constituentTypeConstructor)) {
                        this.processedTypeConstructors.add(constituentTypeConstructor);
                        this.buildGraph(constituentTypeConstructor);
                    }
                    if (constituentTypeConstructor.getParameters().size() != constituentType.getArguments().size()) continue;
                    Iterable $receiver$iv2 = constituentType.getArguments();
                    int index$iv = 0;
                    for (Object item$iv : $receiver$iv2) {
                        void typeProjection;
                        int n = index$iv++;
                        TypeProjection typeProjection2 = (TypeProjection)item$iv;
                        int i = n;
                        if (typeProjection.getProjectionKind() == Variance.INVARIANT) continue;
                        this.nodes.add(typeParameter);
                        TypeParameterDescriptor typeParameterDescriptor2 = constituentTypeConstructor.getParameters().get(i);
                        Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor2, (String)"constituentTypeConstructor.parameters[i]");
                        this.nodes.add(typeParameterDescriptor2);
                        TypeParameterDescriptor typeParameterDescriptor3 = constituentTypeConstructor.getParameters().get(i);
                        Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor3, (String)"constituentTypeConstructor.parameters[i]");
                        this.addEdge(typeParameter, typeParameterDescriptor3);
                    }
                }
            }
        }

        @NotNull
        public final TypeConstructor getTypeConstructor() {
            return this.typeConstructor;
        }

        public GraphBuilder(@NotNull TypeConstructor typeConstructor2) {
            Intrinsics.checkParameterIsNotNull((Object)typeConstructor2, (String)"typeConstructor");
            this.typeConstructor = typeConstructor2;
            GraphBuilder graphBuilder = this;
            Cloneable cloneable2 = new HashSet();
            graphBuilder.nodes = cloneable2;
            graphBuilder = this;
            cloneable2 = new HashMap();
            graphBuilder.edgeLists = cloneable2;
            graphBuilder = this;
            cloneable2 = new HashSet();
            graphBuilder.processedTypeConstructors = cloneable2;
        }

        @NotNull
        public static final /* synthetic */ HashMap access$getEdgeLists$p(GraphBuilder $this) {
            return $this.edgeLists;
        }

        @NotNull
        public static final /* synthetic */ Set access$getNodes$p(GraphBuilder $this) {
            return $this.nodes;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\bb\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J\u001b\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\u0006\u0010\t\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\nR\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/FiniteBoundRestrictionChecker$Graph;", "T", "", "nodes", "", "getNodes", "()Ljava/util/Set;", "getNeighbors", "", "node", "(Ljava/lang/Object;)Ljava/util/List;", "frontend"})
    private static interface Graph<T> {
        @NotNull
        public Set<T> getNodes();

        @NotNull
        public List<T> getNeighbors(T var1);
    }
}

