/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeImpl;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J:\u0010\u0013\u001a\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/types/expressions/ValueParameterResolver;", "", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "(Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;)V", "resolveDefaultValue", "", "valueParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "resolveValueParameters", "valueParameters", "", "valueParameterDescriptors", "declaringScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "frontend"})
public final class ValueParameterResolver {
    private final ExpressionTypingServices expressionTypingServices;
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    private final LanguageVersionSettings languageVersionSettings;
    private final DataFlowValueFactory dataFlowValueFactory;

    public final void resolveValueParameters(@NotNull List<? extends KtParameter> valueParameters, @NotNull List<? extends ValueParameterDescriptor> valueParameterDescriptors, @NotNull LexicalScope declaringScope, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull(valueParameters, (String)"valueParameters");
        Intrinsics.checkParameterIsNotNull(valueParameterDescriptors, (String)"valueParameterDescriptors");
        Intrinsics.checkParameterIsNotNull((Object)declaringScope, (String)"declaringScope");
        Intrinsics.checkParameterIsNotNull((Object)dataFlowInfo, (String)"dataFlowInfo");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        LexicalScopeImpl scopeForDefaultValue = new LexicalScopeImpl(declaringScope, declaringScope.getOwnerDescriptor(), false, null, LexicalScopeKind.DEFAULT_VALUE, null, null, 96, null);
        ExpressionTypingContext contextForDefaultValue = ExpressionTypingContext.newContext(trace, scopeForDefaultValue, dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE, this.languageVersionSettings, this.dataFlowValueFactory);
        for (Pair pair : CollectionsKt.zip((Iterable)valueParameterDescriptors, (Iterable)valueParameters)) {
            ValueParameterDescriptor descriptor2 = (ValueParameterDescriptor)pair.component1();
            KtParameter parameter = (KtParameter)pair.component2();
            ForceResolveUtil.forceResolveAllContents(descriptor2.getAnnotations());
            ExpressionTypingContext expressionTypingContext = contextForDefaultValue;
            Intrinsics.checkExpressionValueIsNotNull((Object)expressionTypingContext, (String)"contextForDefaultValue");
            this.resolveDefaultValue(descriptor2, parameter, expressionTypingContext);
        }
    }

    private final void resolveDefaultValue(ValueParameterDescriptor valueParameterDescriptor, KtParameter parameter, ExpressionTypingContext context) {
        if (!valueParameterDescriptor.declaresDefaultValue()) {
            return;
        }
        KtExpression ktExpression = parameter.getDefaultValue();
        if (ktExpression == null) {
            return;
        }
        KtExpression defaultValue = ktExpression;
        KotlinType type2 = valueParameterDescriptor.getType();
        this.expressionTypingServices.getTypeInfo(defaultValue, (ResolutionContext)context.replaceExpectedType(type2));
        if (DescriptorUtils.isAnnotationClass(DescriptorResolver.getContainingClass(context.scope))) {
            KtExpression ktExpression2 = defaultValue;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"defaultValue");
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
            CompileTimeConstant<?> constant = this.constantExpressionEvaluator.evaluateExpression(ktExpression2, bindingTrace, type2);
            if (constant == null || constant.getUsesNonConstValAsConstant()) {
                KotlinType kotlinType = type2;
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"type");
                if (!KotlinTypeKt.isError(kotlinType)) {
                    context.trace.report(Errors.ANNOTATION_PARAMETER_DEFAULT_VALUE_MUST_BE_CONSTANT.on((KtExpression)((PsiElement)defaultValue)));
                }
            }
        }
    }

    public ValueParameterResolver(@NotNull ExpressionTypingServices expressionTypingServices, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull DataFlowValueFactory dataFlowValueFactory) {
        Intrinsics.checkParameterIsNotNull((Object)expressionTypingServices, (String)"expressionTypingServices");
        Intrinsics.checkParameterIsNotNull((Object)constantExpressionEvaluator, (String)"constantExpressionEvaluator");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkParameterIsNotNull((Object)dataFlowValueFactory, (String)"dataFlowValueFactory");
        this.expressionTypingServices = expressionTypingServices;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.languageVersionSettings = languageVersionSettings;
        this.dataFlowValueFactory = dataFlowValueFactory;
    }
}

