/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.merge.MergeResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.BaseRepositoryManagerKt;
import org.jetbrains.settingsRepository.MutableUpdateResult;
import org.jetbrains.settingsRepository.git.GitExKt;
import org.jetbrains.settingsRepository.git.JGitMergeProvider;
import org.jetbrains.settingsRepository.git.JGitMergeProviderKt;
import org.jetbrains.settingsRepository.git.MergeResultEx;
import org.jetbrains.settingsRepository.git.PullKt;
import org.jetbrains.settingsRepository.git.PullKt$WhenMappings;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000P\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a,\u0010\u0010\u001a\u00020\u000f2\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\f\u0010\u0017\u001a\u00020\u0018*\u00020\nH\u0000\u00a8\u0006\u0019"}, d2={"resolveConflicts", "", "", "mergeProvider", "Lorg/jetbrains/settingsRepository/git/JGitMergeProvider;", "", "unresolvedFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "Lorg/jetbrains/settingsRepository/MutableUpdateResult;", "mergeResult", "Lorg/jetbrains/settingsRepository/git/MergeResultEx;", "resolveUnmergedConflicts", "", "updateHead", "refLogMessage", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "newHeadId", "Lorg/eclipse/jgit/lib/ObjectId;", "oldHeadID", "fixAndGetState", "Lorg/eclipse/jgit/lib/RepositoryState;", "intellij.settingsRepository"})
public final class PullKt {
    private static final void updateHead(StringBuilder refLogMessage, ObjectId newHeadId, ObjectId oldHeadID, Repository repository2) {
        RefUpdate.Result rc;
        RefUpdate refUpdate = repository2.updateRef("HEAD");
        refUpdate.setNewObjectId((AnyObjectId)newHeadId);
        refUpdate.setRefLogMessage(refLogMessage.toString(), false);
        refUpdate.setExpectedOldObjectId((AnyObjectId)oldHeadID);
        RefUpdate.Result result = rc = refUpdate.update();
        if (result != null) {
            switch (PullKt$WhenMappings.$EnumSwitchMapping$0[result.ordinal()]) {
                case 1: 
                case 2: {
                    return;
                }
                case 3: 
                case 4: {
                    String string = JGitText.get().couldNotLockHEAD;
                    RefUpdate refUpdate2 = refUpdate;
                    Intrinsics.checkExpressionValueIsNotNull((Object)refUpdate2, (String)"refUpdate");
                    throw (Throwable)new ConcurrentRefUpdateException(string, refUpdate2.getRef(), rc);
                }
            }
        }
        throw (Throwable)new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, "HEAD", newHeadId.toString(), rc));
    }

    private static final MutableUpdateResult resolveConflicts(MergeResultEx mergeResult, Repository repository2) {
        boolean bl;
        boolean bl2 = bl = ((Object[])mergeResult.getMergedCommits()).length == 2;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Map<String, MergeResult<? extends Sequence>> map = mergeResult.getConflicts();
        if (map == null) {
            Intrinsics.throwNpe();
        }
        Map<String, MergeResult<? extends Sequence>> conflicts = map;
        JGitMergeProvider<MergeResult<? extends Sequence>> mergeProvider2 = new JGitMergeProvider<MergeResult<? extends Sequence>>(repository2, conflicts, resolveConflicts.mergeProvider.1.INSTANCE);
        List<String> mergedFiles = PullKt.resolveConflicts(mergeProvider2, JGitMergeProviderKt.conflictsToVirtualFiles(conflicts), repository2);
        return mergeResult.getResult().toMutable().addChanged((Collection<String>)mergedFiles);
    }

    private static final List<String> resolveConflicts(JGitMergeProvider<? extends Object> mergeProvider2, List<VirtualFile> unresolvedFiles, Repository repository2) {
        SmartList mergedFiles = new SmartList();
        while (true) {
            List<VirtualFile> resolvedFiles = BaseRepositoryManagerKt.resolveConflicts(unresolvedFiles, mergeProvider2);
            for (VirtualFile file : resolvedFiles) {
                mergedFiles.add((Object)file.getPath());
            }
            if (resolvedFiles.size() == unresolvedFiles.size()) break;
            CollectionsKt.removeAll(unresolvedFiles, (Function1)((Function1)new Function1<VirtualFile, Boolean>(mergedFiles){
                final /* synthetic */ SmartList $mergedFiles;

                public final boolean invoke(@NotNull VirtualFile it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return this.$mergedFiles.contains((Object)it.getPath());
                }
                {
                    this.$mergedFiles = smartList;
                    super(1);
                }
            }));
        }
        GitExKt.commit$default(repository2, null, null, null, null, 15, null);
        return (List)mergedFiles;
    }

    @NotNull
    public static final RepositoryState fixAndGetState(@NotNull Repository $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        RepositoryState state = $receiver.getRepositoryState();
        if (Intrinsics.areEqual((Object)state, (Object)RepositoryState.MERGING)) {
            PullKt.resolveUnmergedConflicts($receiver);
            state = $receiver.getRepositoryState();
        }
        RepositoryState repositoryState = state;
        Intrinsics.checkExpressionValueIsNotNull((Object)repositoryState, (String)"state");
        return repositoryState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void resolveUnmergedConflicts(@NotNull Repository repository2) {
        Intrinsics.checkParameterIsNotNull((Object)repository2, (String)"repository");
        LinkedHashMap conflicts = new LinkedHashMap();
        AutoCloseable $receiver$iv = (AutoCloseable)repository2.newObjectReader();
        boolean closed$iv = false;
        try {
            ObjectReader reader = (ObjectReader)$receiver$iv;
            DirCache dirCache = repository2.readDirCache();
            int n = 0;
            DirCache dirCache2 = dirCache;
            Intrinsics.checkExpressionValueIsNotNull((Object)dirCache2, (String)"dirCache");
            int n2 = dirCache2.getEntryCount() - 1;
            if (n <= n2) {
                while (true) {
                    void i;
                    DirCacheEntry entry;
                    DirCacheEntry dirCacheEntry = entry = dirCache.getEntry((int)i);
                    Intrinsics.checkExpressionValueIsNotNull((Object)dirCacheEntry, (String)"entry");
                    if (!dirCacheEntry.isMerged()) {
                        Object object;
                        void $receiver$iv2;
                        Map map = (Map)conflicts;
                        String key$iv = entry.getPathString();
                        Object value$iv = $receiver$iv2.get(key$iv);
                        if (value$iv == null) {
                            byte[][] answer$iv = new byte[3][];
                            $receiver$iv2.put(key$iv, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        byte[][] byArray = (byte[][])object;
                        int n3 = entry.getStage() - 1;
                        ObjectLoader objectLoader = reader.open((AnyObjectId)entry.getObjectId(), 3);
                        Intrinsics.checkExpressionValueIsNotNull((Object)objectLoader, (String)"reader.open(entry.objectId, Constants.OBJ_BLOB)");
                        byArray[n3] = objectLoader.getCachedBytes();
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    $receiver$iv.close();
                }
                catch (Exception closeException$iv) {
                    Exception exception = e$iv;
                    if (exception == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
                    }
                    ((Throwable)exception).addSuppressed(closeException$iv);
                }
                throw (Throwable)e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    $receiver$iv.close();
                }
                throw throwable;
            }
        }
        $receiver$iv.close();
        PullKt.resolveConflicts(new JGitMergeProvider(repository2, (Map)conflicts, resolveUnmergedConflicts.2.INSTANCE), JGitMergeProviderKt.conflictsToVirtualFiles((Map)conflicts), repository2);
    }

    @NotNull
    public static final /* synthetic */ MutableUpdateResult access$resolveConflicts(@NotNull MergeResultEx mergeResult, @NotNull Repository repository2) {
        return PullKt.resolveConflicts(mergeResult, repository2);
    }

    public static final /* synthetic */ void access$updateHead(@NotNull StringBuilder refLogMessage, @NotNull ObjectId newHeadId, @NotNull ObjectId oldHeadID, @NotNull Repository repository2) {
        PullKt.updateHead(refLogMessage, newHeadId, oldHeadID, repository2);
    }
}

