/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.annotationprocessor;

import android.databinding.BindingBuildInfo;
import android.databinding.annotationprocessor.BuildInfoUtil;
import android.databinding.annotationprocessor.ProcessBindable;
import android.databinding.annotationprocessor.ProcessExpressions;
import android.databinding.annotationprocessor.ProcessMethodAdapters;
import android.databinding.tool.CompilerChef;
import android.databinding.tool.processing.Scope;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.writer.AnnotationJavaFileWriter;
import android.databinding.tool.writer.BRWriter;
import android.databinding.tool.writer.JavaFileWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.xml.bind.JAXBException;

@SupportedAnnotationTypes(value={"android.databinding.BindingAdapter", "android.databinding.Untaggable", "android.databinding.BindingMethods", "android.databinding.BindingConversion", "android.databinding.BindingBuildInfo"})
public class ProcessDataBinding
extends AbstractProcessor {
    private List<ProcessingStep> mProcessingSteps;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        BindingBuildInfo buildInfo;
        if (this.mProcessingSteps == null) {
            this.initProcessingSteps();
        }
        if ((buildInfo = BuildInfoUtil.load(roundEnv)) == null) {
            return false;
        }
        boolean done = true;
        for (ProcessingStep step : this.mProcessingSteps) {
            try {
                done = step.runStep(roundEnv, this.processingEnv, buildInfo) && done;
            }
            catch (JAXBException e) {
                L.e((Throwable)e, (String)"Exception while handling step %s", (Object[])new Object[]{step});
            }
        }
        if (roundEnv.processingOver()) {
            for (ProcessingStep step : this.mProcessingSteps) {
                step.onProcessingOver(roundEnv, this.processingEnv, buildInfo);
            }
        }
        Scope.assertNoError();
        return done;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private void initProcessingSteps() {
        final ProcessBindable processBindable = new ProcessBindable();
        this.mProcessingSteps = Arrays.asList(new ProcessMethodAdapters(), new ProcessExpressions(), processBindable);
        Callback dataBinderWriterCallback = new Callback(){
            CompilerChef mChef;
            BRWriter mBRWriter;
            boolean mLibraryProject;
            int mMinSdk;

            @Override
            public void onChefReady(CompilerChef chef, boolean libraryProject, int minSdk) {
                Preconditions.checkNull((Object)this.mChef, (String)"Cannot set compiler chef twice", (Object[])new Object[0]);
                chef.addBRVariables(processBindable);
                this.mChef = chef;
                this.mLibraryProject = libraryProject;
                this.mMinSdk = minSdk;
                this.considerWritingMapper();
                this.mChef.writeDynamicUtil();
            }

            private void considerWritingMapper() {
                if (this.mLibraryProject || this.mChef == null || this.mBRWriter == null) {
                    return;
                }
                this.mChef.writeDataBinderMapper(this.mMinSdk, this.mBRWriter);
            }

            @Override
            public void onBrWriterReady(BRWriter brWriter) {
                Preconditions.checkNull((Object)this.mBRWriter, (String)"Cannot set br writer twice", (Object[])new Object[0]);
                this.mBRWriter = brWriter;
                this.considerWritingMapper();
            }
        };
        AnnotationJavaFileWriter javaFileWriter = new AnnotationJavaFileWriter(this.processingEnv);
        for (ProcessingStep step : this.mProcessingSteps) {
            step.mJavaFileWriter = javaFileWriter;
            step.mCallback = dataBinderWriterCallback;
        }
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        ModelAnalyzer.setProcessingEnvironment(processingEnv);
    }

    static interface Callback {
        public void onChefReady(CompilerChef var1, boolean var2, int var3);

        public void onBrWriterReady(BRWriter var1);
    }

    public static abstract class ProcessingStep {
        private boolean mDone;
        private JavaFileWriter mJavaFileWriter;
        protected Callback mCallback;

        protected JavaFileWriter getWriter() {
            return this.mJavaFileWriter;
        }

        private boolean runStep(RoundEnvironment roundEnvironment, ProcessingEnvironment processingEnvironment, BindingBuildInfo buildInfo) throws JAXBException {
            if (this.mDone) {
                return true;
            }
            this.mDone = this.onHandleStep(roundEnvironment, processingEnvironment, buildInfo);
            return this.mDone;
        }

        public abstract boolean onHandleStep(RoundEnvironment var1, ProcessingEnvironment var2, BindingBuildInfo var3) throws JAXBException;

        public abstract void onProcessingOver(RoundEnvironment var1, ProcessingEnvironment var2, BindingBuildInfo var3);
    }
}

