/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.annotationprocessor;

import android.databinding.BindingAdapter;
import android.databinding.BindingBuildInfo;
import android.databinding.BindingConversion;
import android.databinding.BindingMethod;
import android.databinding.BindingMethods;
import android.databinding.InverseBindingAdapter;
import android.databinding.InverseBindingMethod;
import android.databinding.InverseBindingMethods;
import android.databinding.Untaggable;
import android.databinding.annotationprocessor.AnnotationUtil;
import android.databinding.annotationprocessor.ProcessDataBinding;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.store.SetterStore;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class ProcessMethodAdapters
extends ProcessDataBinding.ProcessingStep {
    private static final String INVERSE_BINDING_EVENT_ATTR_SUFFIX = "AttrChanged";

    @Override
    public boolean onHandleStep(RoundEnvironment roundEnv, ProcessingEnvironment processingEnvironment, BindingBuildInfo buildInfo) {
        L.d((String)"processing adapters", (Object[])new Object[0]);
        ModelAnalyzer modelAnalyzer = ModelAnalyzer.getInstance();
        Preconditions.checkNotNull((Object)modelAnalyzer, (String)"Model analyzer should be initialized first", (Object[])new Object[0]);
        SetterStore store = SetterStore.get(modelAnalyzer);
        this.clearIncrementalClasses(roundEnv, store);
        this.addBindingAdapters(roundEnv, processingEnvironment, store);
        this.addRenamed(roundEnv, store);
        this.addConversions(roundEnv, store);
        this.addUntaggable(roundEnv, store);
        this.addInverseAdapters(roundEnv, processingEnvironment, store);
        this.addInverseMethods(roundEnv, store);
        try {
            store.write(buildInfo.modulePackage(), processingEnvironment);
        }
        catch (IOException e) {
            L.e((Throwable)e, (String)"Could not write BindingAdapter intermediate file.", (Object[])new Object[0]);
        }
        return true;
    }

    @Override
    public void onProcessingOver(RoundEnvironment roundEnvironment, ProcessingEnvironment processingEnvironment, BindingBuildInfo buildInfo) {
    }

    private void addBindingAdapters(RoundEnvironment roundEnv, ProcessingEnvironment processingEnv, SetterStore store) {
        for (Element element : AnnotationUtil.getElementsAnnotatedWith(roundEnv, BindingAdapter.class)) {
            if (element.getKind() != ElementKind.METHOD || !element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                L.e((Element)element, (String)"@BindingAdapter on invalid element: %s", (Object[])new Object[]{element});
                continue;
            }
            BindingAdapter bindingAdapter = element.getAnnotation(BindingAdapter.class);
            ExecutableElement executableElement = (ExecutableElement)element;
            List<? extends VariableElement> parameters = executableElement.getParameters();
            if (bindingAdapter.value().length == 0) {
                L.e((Element)element, (String)"@BindingAdapter requires at least one attribute. %s", (Object[])new Object[]{element});
                continue;
            }
            boolean takesComponent = ProcessMethodAdapters.takesComponent(executableElement, processingEnv);
            int startIndex = 1 + (takesComponent ? 1 : 0);
            int numAttributes = bindingAdapter.value().length;
            int numAdditionalArgs = parameters.size() - startIndex;
            if (numAdditionalArgs == 2 * numAttributes) {
                Types typeUtils = processingEnv.getTypeUtils();
                boolean hasParameterError = false;
                for (int i = startIndex; i < numAttributes + startIndex; ++i) {
                    if (typeUtils.isSameType(parameters.get(i).asType(), parameters.get(i + numAttributes).asType())) continue;
                    L.e((Element)executableElement, (String)"BindingAdapter %s: old values should be followed by new values. Parameter %d must be the same type as parameter %d.", (Object[])new Object[]{executableElement, i + 1, i + numAttributes + 1});
                    hasParameterError = true;
                    break;
                }
                if (hasParameterError) {
                    continue;
                }
            } else if (numAdditionalArgs != numAttributes) {
                L.e((Element)element, (String)"@BindingAdapter %s has %d attributes and %d value parameters. There should be %d or %d value parameters.", (Object[])new Object[]{executableElement, numAttributes, numAdditionalArgs, numAttributes, numAttributes * 2});
                continue;
            }
            ProcessMethodAdapters.warnAttributeNamespaces(element, bindingAdapter.value());
            try {
                if (numAttributes == 1) {
                    String attribute = bindingAdapter.value()[0];
                    store.addBindingAdapter(processingEnv, attribute, executableElement, takesComponent);
                    continue;
                }
                store.addBindingAdapter(processingEnv, bindingAdapter.value(), executableElement, takesComponent, bindingAdapter.requireAll());
            }
            catch (IllegalArgumentException e) {
                L.e((Element)element, (String)"@BindingAdapter for duplicate View and parameter type: %s", (Object[])new Object[]{element});
            }
        }
    }

    private static boolean takesComponent(ExecutableElement executableElement, ProcessingEnvironment processingEnvironment) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        Elements elementUtils = processingEnvironment.getElementUtils();
        TypeMirror viewElement = elementUtils.getTypeElement("android.view.View").asType();
        if (parameters.size() < 2) {
            return false;
        }
        TypeMirror parameter1 = parameters.get(0).asType();
        Types typeUtils = processingEnvironment.getTypeUtils();
        if (parameter1.getKind() == TypeKind.DECLARED && typeUtils.isAssignable(parameter1, viewElement)) {
            return false;
        }
        if (parameters.size() < 3) {
            TypeMirror viewStubProxy = elementUtils.getTypeElement("android.databinding.ViewStubProxy").asType();
            if (!typeUtils.isAssignable(parameter1, viewStubProxy)) {
                L.e((Element)executableElement, (String)"@BindingAdapter %s is applied to a method that has two parameters, the first must be a View type", (Object[])new Object[]{executableElement});
            }
            return false;
        }
        TypeMirror parameter2 = parameters.get(1).asType();
        if (typeUtils.isAssignable(parameter2, viewElement)) {
            return true;
        }
        L.e((Element)executableElement, (String)"@BindingAdapter %s is applied to a method that doesn't take a View subclass as the first or second parameter. When a BindingAdapter uses a DataBindingComponent, the component parameter is first and the View parameter is second, otherwise the View parameter is first.", (Object[])new Object[]{executableElement});
        return false;
    }

    private static void warnAttributeNamespace(Element element, String attribute) {
        if (attribute.contains(":") && !attribute.startsWith("android:")) {
            L.w((Element)element, (String)"Application namespace for attribute %s will be ignored.", (Object[])new Object[]{attribute});
        }
    }

    private static void warnAttributeNamespaces(Element element, String[] attributes) {
        for (String attribute : attributes) {
            ProcessMethodAdapters.warnAttributeNamespace(element, attribute);
        }
    }

    private void addRenamed(RoundEnvironment roundEnv, SetterStore store) {
        for (Element element : AnnotationUtil.getElementsAnnotatedWith(roundEnv, BindingMethods.class)) {
            BindingMethods bindingMethods = element.getAnnotation(BindingMethods.class);
            for (BindingMethod bindingMethod : bindingMethods.value()) {
                String type;
                String attribute = bindingMethod.attribute();
                String method = bindingMethod.method();
                ProcessMethodAdapters.warnAttributeNamespace(element, attribute);
                try {
                    type = bindingMethod.type().getCanonicalName();
                }
                catch (MirroredTypeException e) {
                    type = e.getTypeMirror().toString();
                }
                store.addRenamedMethod(attribute, type, method, (TypeElement)element);
            }
        }
    }

    private void addConversions(RoundEnvironment roundEnv, SetterStore store) {
        for (Element element : AnnotationUtil.getElementsAnnotatedWith(roundEnv, BindingConversion.class)) {
            if (element.getKind() != ElementKind.METHOD || !element.getModifiers().contains((Object)Modifier.STATIC) || !element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                L.e((Element)element, (String)"@BindingConversion is only allowed on public static methods %s", (Object[])new Object[]{element});
                continue;
            }
            ExecutableElement executableElement = (ExecutableElement)element;
            if (executableElement.getParameters().size() != 1) {
                L.e((Element)element, (String)"@BindingConversion method should have one parameter %s", (Object[])new Object[]{element});
                continue;
            }
            if (executableElement.getReturnType().getKind() == TypeKind.VOID) {
                L.e((Element)element, (String)"@BindingConversion method must return a value %s", (Object[])new Object[]{element});
                continue;
            }
            store.addConversionMethod(executableElement);
        }
    }

    private void addInverseAdapters(RoundEnvironment roundEnv, ProcessingEnvironment processingEnv, SetterStore store) {
        for (Element element : AnnotationUtil.getElementsAnnotatedWith(roundEnv, InverseBindingAdapter.class)) {
            if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                L.e((Element)element, (String)"@InverseBindingAdapter must be associated with a public method", (Object[])new Object[0]);
                continue;
            }
            ExecutableElement executableElement = (ExecutableElement)element;
            if (executableElement.getReturnType().getKind() == TypeKind.VOID) {
                L.e((Element)element, (String)"@InverseBindingAdapter must have a non-void return type", (Object[])new Object[0]);
                continue;
            }
            InverseBindingAdapter inverseBindingAdapter = executableElement.getAnnotation(InverseBindingAdapter.class);
            String attribute = inverseBindingAdapter.attribute();
            ProcessMethodAdapters.warnAttributeNamespace(element, attribute);
            String event = inverseBindingAdapter.event().isEmpty() ? inverseBindingAdapter.attribute() + INVERSE_BINDING_EVENT_ATTR_SUFFIX : inverseBindingAdapter.event();
            ProcessMethodAdapters.warnAttributeNamespace(element, event);
            boolean takesComponent = ProcessMethodAdapters.takesComponent(executableElement, processingEnv);
            int expectedArgs = takesComponent ? 2 : 1;
            int numParameters = executableElement.getParameters().size();
            if (numParameters != expectedArgs) {
                L.e((Element)element, (String)"@InverseBindingAdapter %s takes %s parameters, but %s parameters were expected", (Object[])new Object[]{element, numParameters, expectedArgs});
                continue;
            }
            try {
                store.addInverseAdapter(processingEnv, attribute, event, executableElement, takesComponent);
            }
            catch (IllegalArgumentException e) {
                L.e((Element)element, (String)"@InverseBindingAdapter for duplicate View and parameter type: %s", (Object[])new Object[]{element});
            }
        }
    }

    private void addInverseMethods(RoundEnvironment roundEnv, SetterStore store) {
        for (Element element : AnnotationUtil.getElementsAnnotatedWith(roundEnv, InverseBindingMethods.class)) {
            InverseBindingMethods bindingMethods = element.getAnnotation(InverseBindingMethods.class);
            for (InverseBindingMethod bindingMethod : bindingMethods.value()) {
                String type;
                String attribute = bindingMethod.attribute();
                String method = bindingMethod.method();
                String event = bindingMethod.event().isEmpty() ? bindingMethod.attribute() + INVERSE_BINDING_EVENT_ATTR_SUFFIX : bindingMethod.event();
                ProcessMethodAdapters.warnAttributeNamespace(element, attribute);
                ProcessMethodAdapters.warnAttributeNamespace(element, event);
                try {
                    type = bindingMethod.type().getCanonicalName();
                }
                catch (MirroredTypeException e) {
                    type = e.getTypeMirror().toString();
                }
                store.addInverseMethod(attribute, event, type, method, (TypeElement)element);
            }
        }
    }

    private void addUntaggable(RoundEnvironment roundEnv, SetterStore store) {
        for (Element element : AnnotationUtil.getElementsAnnotatedWith(roundEnv, Untaggable.class)) {
            Untaggable untaggable = element.getAnnotation(Untaggable.class);
            store.addUntaggableTypes(untaggable.value(), (TypeElement)element);
        }
    }

    private void clearIncrementalClasses(RoundEnvironment roundEnv, SetterStore store) {
        HashSet<String> classes = new HashSet<String>();
        for (Element element : AnnotationUtil.getElementsAnnotatedWith(roundEnv, BindingAdapter.class)) {
            TypeElement containingClass = (TypeElement)element.getEnclosingElement();
            classes.add(containingClass.getQualifiedName().toString());
        }
        for (Element element : AnnotationUtil.getElementsAnnotatedWith(roundEnv, BindingMethods.class)) {
            classes.add(((TypeElement)element).getQualifiedName().toString());
        }
        for (Element element : AnnotationUtil.getElementsAnnotatedWith(roundEnv, BindingConversion.class)) {
            classes.add(((TypeElement)element.getEnclosingElement()).getQualifiedName().toString());
        }
        for (Element element : AnnotationUtil.getElementsAnnotatedWith(roundEnv, Untaggable.class)) {
            classes.add(((TypeElement)element).getQualifiedName().toString());
        }
        store.clear(classes);
    }
}

