/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.annotationprocessor;

import android.databinding.annotationprocessor.AnnotationUtil;
import android.databinding.annotationprocessor.ProcessDataBinding;
import android.databinding.tool.BindingAdapterCompat;
import android.databinding.tool.BindingMethodsCompat;
import android.databinding.tool.CompilerArguments;
import android.databinding.tool.InverseBindingAdapterCompat;
import android.databinding.tool.InverseBindingMethodsCompat;
import android.databinding.tool.InverseMethodCompat;
import android.databinding.tool.LibTypes;
import android.databinding.tool.UntaggableCompat;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.store.SetterStore;
import android.databinding.tool.util.L;
import android.databinding.tool.util.LoggedErrorException;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.util.StringUtils;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class ProcessMethodAdapters
extends ProcessDataBinding.ProcessingStep {
    private static final String INVERSE_BINDING_EVENT_ATTR_SUFFIX = "AttrChanged";

    @Override
    public boolean onHandleStep(RoundEnvironment roundEnv, ProcessingEnvironment processingEnvironment, CompilerArguments args2) {
        L.d((String)"processing adapters", (Object[])new Object[0]);
        ModelAnalyzer modelAnalyzer = ModelAnalyzer.getInstance();
        Preconditions.checkNotNull((Object)modelAnalyzer, (String)"Model analyzer should be initialized first", (Object[])new Object[0]);
        SetterStore store = SetterStore.get();
        this.clearIncrementalClasses(roundEnv, store);
        this.addBindingAdapters(roundEnv, processingEnvironment, store);
        this.addRenamed(roundEnv, store);
        this.addConversions(roundEnv, store);
        this.addUntaggable(roundEnv, store);
        this.addInverseAdapters(roundEnv, processingEnvironment, store);
        this.addInverseBindingMethods(roundEnv, store);
        this.addInverseMethods(roundEnv, processingEnvironment, store);
        try {
            try {
                store.write(args2.getModulePackage(), processingEnvironment);
            }
            catch (IOException e) {
                L.e((Throwable)e, (String)"Could not write BindingAdapter intermediate file.", (Object[])new Object[0]);
            }
        }
        catch (LoggedErrorException loggedErrorException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public void onProcessingOver(RoundEnvironment roundEnvironment, ProcessingEnvironment processingEnvironment, CompilerArguments args2) {
    }

    private void addBindingAdapters(RoundEnvironment roundEnv, ProcessingEnvironment processingEnv, SetterStore store) {
        LibTypes libTypes = ModelAnalyzer.getInstance().libTypes;
        Class adapterAnnotation = libTypes.getBindingAdapterClass();
        for (Element element : AnnotationUtil.getElementsAnnotatedWith(roundEnv, adapterAnnotation)) {
            try {
                if (element.getKind() != ElementKind.METHOD || !element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    L.e((Element)element, (String)"@BindingAdapter on invalid element: %s", (Object[])new Object[]{element});
                    continue;
                }
                BindingAdapterCompat bindingAdapter = BindingAdapterCompat.create((Element)element);
                ExecutableElement executableElement = (ExecutableElement)element;
                List<? extends VariableElement> parameters = executableElement.getParameters();
                if (bindingAdapter.getAttributes().length == 0) {
                    L.e((Element)element, (String)"@BindingAdapter requires at least one attribute. %s", (Object[])new Object[]{element});
                    continue;
                }
                boolean takesComponent = ProcessMethodAdapters.takesComponent(executableElement, processingEnv);
                int startIndex = 1 + (takesComponent ? 1 : 0);
                int numAttributes = bindingAdapter.getAttributes().length;
                int numAdditionalArgs = parameters.size() - startIndex;
                if (numAdditionalArgs == 2 * numAttributes) {
                    Types typeUtils = processingEnv.getTypeUtils();
                    boolean hasParameterError = false;
                    for (int i = startIndex; i < numAttributes + startIndex; ++i) {
                        if (typeUtils.isSameType(parameters.get(i).asType(), parameters.get(i + numAttributes).asType())) continue;
                        L.e((Element)executableElement, (String)"BindingAdapter %s: old values should be followed by new values. Parameter %d must be the same type as parameter %d.", (Object[])new Object[]{executableElement, i + 1, i + numAttributes + 1});
                        hasParameterError = true;
                        break;
                    }
                    if (hasParameterError) {
                        continue;
                    }
                } else if (numAdditionalArgs != numAttributes) {
                    L.e((Element)element, (String)"@BindingAdapter %s has %d attributes and %d value parameters. There should be %d or %d value parameters.", (Object[])new Object[]{executableElement, numAttributes, numAdditionalArgs, numAttributes, numAttributes * 2});
                    continue;
                }
                ProcessMethodAdapters.warnAttributeNamespaces(element, bindingAdapter.getAttributes());
                try {
                    if (numAttributes == 1) {
                        String attribute = bindingAdapter.getAttributes()[0];
                        store.addBindingAdapter(processingEnv, attribute, executableElement, takesComponent);
                        continue;
                    }
                    store.addBindingAdapter(processingEnv, bindingAdapter.getAttributes(), executableElement, takesComponent, bindingAdapter.getRequireAll());
                }
                catch (IllegalArgumentException e) {
                    L.e((Element)element, (String)"@BindingAdapter for duplicate View and parameter type: %s", (Object[])new Object[]{element});
                }
            }
            catch (LoggedErrorException loggedErrorException) {}
        }
    }

    private static boolean takesComponent(ExecutableElement executableElement, ProcessingEnvironment processingEnvironment) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        Elements elementUtils = processingEnvironment.getElementUtils();
        TypeMirror viewElement = elementUtils.getTypeElement("android.view.View").asType();
        if (parameters.size() < 2) {
            return false;
        }
        TypeMirror parameter1 = parameters.get(0).asType();
        Types typeUtils = processingEnvironment.getTypeUtils();
        if (parameter1.getKind() == TypeKind.DECLARED && typeUtils.isAssignable(parameter1, viewElement)) {
            return false;
        }
        ModelAnalyzer analyzer = ModelAnalyzer.getInstance();
        if (parameters.size() < 3) {
            TypeMirror viewStubProxy = elementUtils.getTypeElement(analyzer.libTypes.getViewStubProxy()).asType();
            if (!typeUtils.isAssignable(parameter1, viewStubProxy)) {
                L.e((Element)executableElement, (String)"@BindingAdapter %s is applied to a method that has two parameters, the first must be a View type:", (Object[])new Object[]{executableElement});
            }
            return false;
        }
        TypeMirror parameter2 = parameters.get(1).asType();
        if (typeUtils.isAssignable(parameter2, viewElement)) {
            return true;
        }
        L.e((Element)executableElement, (String)"@BindingAdapter %s is applied to a method that doesn't take a View subclass as the first or second parameter. When a BindingAdapter uses a DataBindingComponent, the component parameter is first and the View parameter is second, otherwise the View parameter is first.", (Object[])new Object[]{executableElement});
        return false;
    }

    private static void warnAttributeNamespace(Element element, String attribute) {
        if (attribute.contains(":") && !attribute.startsWith("android:")) {
            L.w((Element)element, (String)"Application namespace for attribute %s will be ignored.", (Object[])new Object[]{attribute});
        }
    }

    private static void warnAttributeNamespaces(Element element, String[] attributes) {
        for (String attribute : attributes) {
            ProcessMethodAdapters.warnAttributeNamespace(element, attribute);
        }
    }

    private void addRenamed(RoundEnvironment roundEnv, SetterStore store) {
        LibTypes libTypes = ModelAnalyzer.getInstance().libTypes;
        Class bindingMethodsClass = libTypes.getBindingMethodsClass();
        for (Element element : AnnotationUtil.getElementsAnnotatedWith(roundEnv, bindingMethodsClass)) {
            BindingMethodsCompat bindingMethods = BindingMethodsCompat.create((Element)element);
            for (BindingMethodsCompat.BindingMethodCompat bindingMethod : bindingMethods.getMethods()) {
                try {
                    String attribute = bindingMethod.getAttribute();
                    String method = bindingMethod.getMethod();
                    ProcessMethodAdapters.warnAttributeNamespace(element, attribute);
                    String type = bindingMethod.getType();
                    store.addRenamedMethod(attribute, type, method, (TypeElement)element);
                }
                catch (LoggedErrorException loggedErrorException) {}
            }
        }
    }

    private void addConversions(RoundEnvironment roundEnv, SetterStore store) {
        Class bindingConversionClass = ModelAnalyzer.getInstance().libTypes.getBindingConversionClass();
        for (Element element : AnnotationUtil.getElementsAnnotatedWith(roundEnv, bindingConversionClass)) {
            try {
                if (element.getKind() != ElementKind.METHOD || !element.getModifiers().contains((Object)Modifier.STATIC) || !element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    L.e((Element)element, (String)"@BindingConversion is only allowed on public static methods %s", (Object[])new Object[]{element});
                    continue;
                }
                ExecutableElement executableElement = (ExecutableElement)element;
                if (executableElement.getParameters().size() != 1) {
                    L.e((Element)element, (String)"@BindingConversion method should have one parameter %s", (Object[])new Object[]{element});
                    continue;
                }
                if (executableElement.getReturnType().getKind() == TypeKind.VOID) {
                    L.e((Element)element, (String)"@BindingConversion method must return a value %s", (Object[])new Object[]{element});
                    continue;
                }
                store.addConversionMethod(executableElement);
            }
            catch (LoggedErrorException loggedErrorException) {}
        }
    }

    private void addInverseAdapters(RoundEnvironment roundEnv, ProcessingEnvironment processingEnv, SetterStore store) {
        LibTypes libTypes = ModelAnalyzer.getInstance().libTypes;
        Class inverseBindingAdapterClass = libTypes.getInverseBindingAdapterClass();
        for (Element element : AnnotationUtil.getElementsAnnotatedWith(roundEnv, inverseBindingAdapterClass)) {
            try {
                if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    L.e((Element)element, (String)"@InverseBindingAdapter must be associated with a public method", (Object[])new Object[0]);
                    continue;
                }
                ExecutableElement executableElement = (ExecutableElement)element;
                if (executableElement.getReturnType().getKind() == TypeKind.VOID) {
                    L.e((Element)element, (String)"@InverseBindingAdapter must have a non-void return type", (Object[])new Object[0]);
                    continue;
                }
                InverseBindingAdapterCompat inverseBindingAdapter = InverseBindingAdapterCompat.create((Element)executableElement);
                String attribute = inverseBindingAdapter.getAttribute();
                ProcessMethodAdapters.warnAttributeNamespace(element, attribute);
                String event = inverseBindingAdapter.getEvent().isEmpty() ? inverseBindingAdapter.getAttribute() + INVERSE_BINDING_EVENT_ATTR_SUFFIX : inverseBindingAdapter.getEvent();
                ProcessMethodAdapters.warnAttributeNamespace(element, event);
                boolean takesComponent = ProcessMethodAdapters.takesComponent(executableElement, processingEnv);
                int expectedArgs = takesComponent ? 2 : 1;
                int numParameters = executableElement.getParameters().size();
                if (numParameters != expectedArgs) {
                    L.e((Element)element, (String)"@InverseBindingAdapter %s takes %s parameters, but %s parameters were expected", (Object[])new Object[]{element, numParameters, expectedArgs});
                    continue;
                }
                try {
                    store.addInverseAdapter(processingEnv, attribute, event, executableElement, takesComponent);
                }
                catch (IllegalArgumentException e) {
                    L.e((Element)element, (String)"@InverseBindingAdapter for duplicate View and parameter type: %s", (Object[])new Object[]{element});
                }
            }
            catch (LoggedErrorException loggedErrorException) {}
        }
    }

    private void addInverseBindingMethods(RoundEnvironment roundEnv, SetterStore store) {
        LibTypes libTypes = ModelAnalyzer.getInstance().libTypes;
        Class inverseBindingMethodsClass = libTypes.getInverseBindingMethodsClass();
        for (Element element : AnnotationUtil.getElementsAnnotatedWith(roundEnv, inverseBindingMethodsClass)) {
            InverseBindingMethodsCompat bindingMethods = InverseBindingMethodsCompat.create((Element)element);
            for (InverseBindingMethodsCompat.InverseBindingMethodCompat bindingMethod : bindingMethods.getMethods()) {
                try {
                    String attribute = bindingMethod.getAttribute();
                    String method = bindingMethod.getMethod();
                    String event = bindingMethod.getEvent().isEmpty() ? bindingMethod.getAttribute() + INVERSE_BINDING_EVENT_ATTR_SUFFIX : bindingMethod.getEvent();
                    ProcessMethodAdapters.warnAttributeNamespace(element, attribute);
                    ProcessMethodAdapters.warnAttributeNamespace(element, event);
                    String type = bindingMethod.getType();
                    store.addInverseBindingMethod(attribute, event, type, method, (TypeElement)element);
                }
                catch (LoggedErrorException loggedErrorException) {}
            }
        }
    }

    private void addInverseMethods(RoundEnvironment roundEnv, ProcessingEnvironment processingEnv, SetterStore store) {
        LibTypes libTypes = ModelAnalyzer.getInstance().libTypes;
        Class inverseMethodClass = libTypes.getInverseMethodClass();
        for (Element element : AnnotationUtil.getElementsAnnotatedWith(roundEnv, inverseMethodClass)) {
            try {
                if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    L.e((Element)element, (String)"@InverseMethods must be associated with a public method", (Object[])new Object[0]);
                    continue;
                }
                ExecutableElement executableElement = (ExecutableElement)element;
                if (executableElement.getReturnType().getKind() == TypeKind.VOID) {
                    L.e((Element)element, (String)"@InverseMethods must have a non-void return type", (Object[])new Object[0]);
                    continue;
                }
                InverseMethodCompat inverseMethod = InverseMethodCompat.create((Element)executableElement);
                String target = inverseMethod.getValue();
                if (!StringUtils.isNotBlank((CharSequence)target)) {
                    L.e((Element)element, (String)"@InverseMethod must supply a value containing the name of the method to call when going from View value to bound value", (Object[])new Object[0]);
                    continue;
                }
                if (executableElement.getParameters().isEmpty()) {
                    L.e((Element)element, (String)"@InverseMethods must have at least one parameter.", (Object[])new Object[0]);
                    continue;
                }
                try {
                    ExecutableElement inverse = this.findInverseOf(processingEnv, executableElement, inverseMethod.getValue());
                    store.addInverseMethod(processingEnv, executableElement, inverse);
                }
                catch (IllegalArgumentException e) {
                    L.e((Element)element, (String)"%s", (Object[])new Object[]{e.getMessage()});
                }
            }
            catch (LoggedErrorException loggedErrorException) {}
        }
    }

    /*
     * WARNING - void declaration
     */
    private ExecutableElement findInverseOf(ProcessingEnvironment env, ExecutableElement method, String name) throws IllegalArgumentException {
        void var8_10;
        TypeElement enclosingType = (TypeElement)method.getEnclosingElement();
        List<? extends VariableElement> params = method.getParameters();
        Types typeUtil = env.getTypeUtils();
        for (Element element : env.getElementUtils().getAllMembers(enclosingType)) {
            TypeMirror foundType;
            ExecutableElement executableElement;
            if (element.getKind() != ElementKind.METHOD || !name.equals((executableElement = (ExecutableElement)element).getSimpleName().toString())) continue;
            List<? extends VariableElement> checkParams = executableElement.getParameters();
            boolean allTypesMatch = true;
            for (int i = 0; i < params.size() - 1; ++i) {
                TypeMirror foundType2;
                TypeMirror expectedType = typeUtil.erasure(params.get(i).asType());
                if (typeUtil.isSameType(expectedType, foundType2 = typeUtil.erasure(checkParams.get(i).asType()))) continue;
                allTypesMatch = false;
                break;
            }
            if (!allTypesMatch) continue;
            TypeMirror expectedType = typeUtil.erasure(method.getReturnType());
            allTypesMatch = typeUtil.isSameType(expectedType, foundType = typeUtil.erasure(checkParams.get(checkParams.size() - 1).asType()));
            if (allTypesMatch && !typeUtil.isSameType(expectedType = typeUtil.erasure(params.get(params.size() - 1).asType()), foundType = typeUtil.erasure(executableElement.getReturnType()))) {
                throw new IllegalArgumentException(String.format("Declared InverseMethod ('%s') does not have the correct return type. Expected '%s' but was '%s'", executableElement, expectedType, foundType));
            }
            if (method.getModifiers().contains((Object)Modifier.STATIC) != executableElement.getModifiers().contains((Object)Modifier.STATIC)) {
                throw new IllegalArgumentException(String.format("'%s' declared instance method is different from its InverseMethod '%s'. Make them both static or instance methods.", method, executableElement));
            }
            if (!executableElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
                throw new IllegalArgumentException(String.format("InverseMethod must be declared public '%s'", executableElement));
            }
            return executableElement;
        }
        StringBuilder paramStr = new StringBuilder();
        boolean bl = false;
        while (var8_10 < params.size() - 1) {
            if (var8_10 != false) {
                paramStr.append(", ");
            }
            paramStr.append(params.get((int)var8_10).asType());
            ++var8_10;
        }
        if (params.size() != 1) {
            paramStr.append(", ");
        }
        paramStr.append(method.getReturnType());
        String string = method.getModifiers().contains((Object)Modifier.STATIC) ? "static " : "";
        TypeMirror returnType = params.get(params.size() - 1).asType();
        throw new IllegalArgumentException(String.format("Could not find inverse method: public %s%s %s(%s)", string, returnType, name, paramStr));
    }

    private void addUntaggable(RoundEnvironment roundEnv, SetterStore store) {
        LibTypes libTypes = ModelAnalyzer.getInstance().libTypes;
        Class untaggableClass = libTypes.getUntaggableClass();
        for (Element element : AnnotationUtil.getElementsAnnotatedWith(roundEnv, untaggableClass)) {
            try {
                UntaggableCompat untaggable = UntaggableCompat.create((Element)element);
                store.addUntaggableTypes(untaggable.getValue(), (TypeElement)element);
            }
            catch (LoggedErrorException loggedErrorException) {}
        }
    }

    private void clearIncrementalClasses(RoundEnvironment roundEnv, SetterStore store) {
        HashSet<String> classes = new HashSet<String>();
        LibTypes libTypes = ModelAnalyzer.getInstance().libTypes;
        for (Element element : AnnotationUtil.getElementsAnnotatedWith(roundEnv, libTypes.getBindingAdapterClass())) {
            TypeElement containingClass = (TypeElement)element.getEnclosingElement();
            classes.add(containingClass.getQualifiedName().toString());
        }
        for (Element element : AnnotationUtil.getElementsAnnotatedWith(roundEnv, libTypes.getBindingMethodsClass())) {
            classes.add(((TypeElement)element).getQualifiedName().toString());
        }
        for (Element element : AnnotationUtil.getElementsAnnotatedWith(roundEnv, libTypes.getBindingConversionClass())) {
            classes.add(((TypeElement)element.getEnclosingElement()).getQualifiedName().toString());
        }
        for (Element element : AnnotationUtil.getElementsAnnotatedWith(roundEnv, libTypes.getUntaggableClass())) {
            classes.add(((TypeElement)element).getQualifiedName().toString());
        }
        store.clear(classes);
    }
}

