/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.reflection;

import android.databinding.tool.Context;
import android.databinding.tool.LibTypes;
import android.databinding.tool.reflection.InjectedClass;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.TypeUtil;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class ModelAnalyzer {
    public static final String GENERATED_ANNOTATION = "javax.annotation.Generated";
    private static final String MAP_CLASS_NAME = "java.util.Map";
    private static final String STRING_CLASS_NAME = "java.lang.String";
    private static final String OBJECT_CLASS_NAME = "java.lang.Object";
    private static final String VIEW_STUB_CLASS_NAME = "android.view.ViewStub";
    private List<ModelClass> mListTypes;
    private ModelClass mMapType;
    private ModelClass mStringType;
    private ModelClass mObjectType;
    private ModelClass mObservableType;
    private ModelClass mObservableListType;
    private ModelClass mObservableMapType;
    private ModelClass mLiveDataType;
    private ModelClass mMutableLiveDataType;
    private List<ModelClass> mObservableFieldTypes;
    private ModelClass mViewBindingType;
    private ModelClass mViewStubType;
    private ModelClass mViewStubProxyType;
    public final LibTypes libTypes;
    private Boolean mHasGeneratedAnnotation;
    private final Map<String, InjectedClass> mInjectedClasses = new HashMap<String, InjectedClass>();

    protected ModelAnalyzer(LibTypes libTypes) {
        this.libTypes = libTypes;
    }

    public ModelClass findCommonParentOf(ModelClass modelClass1, ModelClass modelClass2) {
        return this.findCommonParentOf(modelClass1, modelClass2, true);
    }

    public ModelClass findCommonParentOf(ModelClass modelClass1, ModelClass modelClass2, boolean failOnError) {
        ModelClass curr;
        for (curr = modelClass1; curr != null && !curr.isAssignableFrom(modelClass2); curr = curr.getSuperclass()) {
        }
        if (curr == null) {
            if (modelClass1.isObject() && modelClass2.isInterface()) {
                return modelClass1;
            }
            if (modelClass2.isObject() && modelClass1.isInterface()) {
                return modelClass2;
            }
            ModelClass primitive1 = modelClass1.unbox();
            ModelClass primitive2 = modelClass2.unbox();
            if (!modelClass1.equals(primitive1) || !modelClass2.equals(primitive2)) {
                return this.findCommonParentOf(primitive1, primitive2, failOnError);
            }
        }
        if (failOnError) {
            Preconditions.checkNotNull((Object)curr, (String)("must be able to find a common parent for " + modelClass1 + " and " + modelClass2), (Object[])new Object[0]);
        }
        return curr;
    }

    public abstract ModelClass loadPrimitive(String var1);

    public static ModelAnalyzer getInstance() {
        return Context.getModelAnalyzer();
    }

    public String applyImports(String className, Map<String, String> imports) {
        String rest;
        String qualifier;
        int dotIndex;
        className = className.trim();
        int numDimensions = 0;
        String generic = null;
        while (className.endsWith("[]")) {
            ++numDimensions;
            className = className.substring(0, className.length() - 2);
        }
        int lastCharIndex = className.length() - 1;
        if ('>' == className.charAt(lastCharIndex)) {
            int open = className.indexOf(60);
            if (open == -1) {
                L.e((String)"un-matching generic syntax for %s", (Object[])new Object[]{className});
                return className;
            }
            generic = this.applyImports(className.substring(open + 1, lastCharIndex), imports);
            className = className.substring(0, open);
        }
        if ((dotIndex = className.indexOf(46)) == -1) {
            qualifier = className;
            rest = null;
        } else {
            qualifier = className.substring(0, dotIndex);
            rest = className.substring(dotIndex);
        }
        String expandedQualifier = imports.get(qualifier);
        String result = expandedQualifier != null ? (rest == null ? expandedQualifier : expandedQualifier + rest) : className;
        if (generic != null) {
            result = result + "<" + this.applyImports(generic, imports) + ">";
        }
        while (numDimensions-- > 0) {
            result = result + "[]";
        }
        return result;
    }

    public String getDefaultValue(String className) {
        if ("int".equals(className)) {
            return "0";
        }
        if ("short".equals(className)) {
            return "0";
        }
        if ("long".equals(className)) {
            return "0L";
        }
        if ("float".equals(className)) {
            return "0f";
        }
        if ("double".equals(className)) {
            return "0.0";
        }
        if ("boolean".equals(className)) {
            return "false";
        }
        if ("char".equals(className)) {
            return "'\\u0000'";
        }
        if ("byte".equals(className)) {
            return "0";
        }
        return "null";
    }

    public final ModelClass findClass(String className, Map<String, String> imports) {
        if (this.mInjectedClasses.containsKey(className)) {
            return this.mInjectedClasses.get(className);
        }
        return this.findClassInternal(className, imports);
    }

    public abstract ModelClass findClassInternal(String var1, Map<String, String> var2);

    public abstract ModelClass findClass(Class var1);

    public abstract TypeUtil createTypeUtil();

    public ModelClass injectClass(InjectedClass injectedClass) {
        this.mInjectedClasses.put(injectedClass.getCanonicalName(), injectedClass);
        return injectedClass;
    }

    List<ModelClass> getListTypes() {
        if (this.mListTypes == null) {
            this.mListTypes = this.libTypes.getListClassNames().stream().map(this::loadClassErasure).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return this.mListTypes;
    }

    public ModelClass getMapType() {
        if (this.mMapType == null) {
            this.mMapType = this.loadClassErasure(MAP_CLASS_NAME);
        }
        return this.mMapType;
    }

    ModelClass getStringType() {
        if (this.mStringType == null) {
            this.mStringType = this.findClass(STRING_CLASS_NAME, null);
        }
        return this.mStringType;
    }

    ModelClass getObjectType() {
        if (this.mObjectType == null) {
            this.mObjectType = this.findClass(OBJECT_CLASS_NAME, null);
        }
        return this.mObjectType;
    }

    ModelClass getObservableType() {
        if (this.mObservableType == null) {
            this.mObservableType = this.findClass(this.libTypes.getObservable(), null);
        }
        return this.mObservableType;
    }

    ModelClass getObservableListType() {
        if (this.mObservableListType == null) {
            this.mObservableListType = this.loadClassErasure(this.libTypes.getObservableList());
        }
        return this.mObservableListType;
    }

    ModelClass getObservableMapType() {
        if (this.mObservableMapType == null) {
            this.mObservableMapType = this.loadClassErasure(this.libTypes.getObservableMap());
        }
        return this.mObservableMapType;
    }

    ModelClass getLiveDataType() {
        if (this.mLiveDataType == null) {
            this.mLiveDataType = this.loadClassErasure(this.libTypes.getLiveData());
        }
        return this.mLiveDataType;
    }

    ModelClass getMutableLiveDataType() {
        if (this.mMutableLiveDataType == null) {
            this.mMutableLiveDataType = this.loadClassErasure(this.libTypes.getMutableLiveData());
        }
        return this.mMutableLiveDataType;
    }

    ModelClass getViewDataBindingType() {
        if (this.mViewBindingType == null) {
            this.mViewBindingType = this.findClass(this.libTypes.getViewDataBinding(), null);
        }
        Preconditions.checkNotNull((Object)this.mViewBindingType, (String)"Cannot find %s class. Something is wrong in the classpath, please submit a bug report", (Object[])new Object[]{this.libTypes.getViewDataBinding()});
        return this.mViewBindingType;
    }

    public ModelClass getViewStubProxyType() {
        if (this.mViewStubProxyType == null) {
            this.mViewStubProxyType = this.findClass(this.libTypes.getViewStubProxy(), null);
        }
        return this.mViewStubProxyType;
    }

    protected List<ModelClass> getObservableFieldTypes() {
        if (this.mObservableFieldTypes == null) {
            this.mObservableFieldTypes = this.libTypes.getObservableFields().stream().map(this::loadClassErasure).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return this.mObservableFieldTypes;
    }

    ModelClass getViewStubType() {
        if (this.mViewStubType == null) {
            this.mViewStubType = this.findClass(VIEW_STUB_CLASS_NAME, null);
        }
        return this.mViewStubType;
    }

    private ModelClass loadClassErasure(String className) {
        ModelClass modelClass = this.findClass(className, null);
        if (modelClass == null) {
            return null;
        }
        return modelClass.erasure();
    }

    public final boolean hasGeneratedAnnotation() {
        if (this.mHasGeneratedAnnotation == null) {
            this.mHasGeneratedAnnotation = this.findGeneratedAnnotation();
        }
        return this.mHasGeneratedAnnotation;
    }

    protected abstract boolean findGeneratedAnnotation();
}

