/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.LintCliFlags;
import com.android.tools.lint.Main;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.Warning;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.SdkUtils;
import com.google.common.annotations.Beta;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

@Beta
public class TextReporter
extends Reporter {
    private final Writer mWriter;
    private final boolean mClose;
    private final LintCliFlags mFlags;

    public TextReporter(LintCliClient client, LintCliFlags flags, Writer writer, boolean close) {
        this(client, flags, null, writer, close);
    }

    public TextReporter(LintCliClient client, LintCliFlags flags, File file, Writer writer, boolean close) {
        super(client, file);
        this.mFlags = flags;
        this.mWriter = writer;
        this.mClose = close;
    }

    @Override
    public void write(int errorCount, int warningCount, List<Warning> issues) throws IOException {
        boolean abbreviate = !this.mFlags.isShowEverything();
        StringBuilder output = new StringBuilder(issues.size() * 200);
        if (issues.isEmpty()) {
            if (this.mDisplayEmpty) {
                this.mWriter.write("No issues found.");
                this.mWriter.write(10);
                this.mWriter.flush();
            }
        } else {
            Issue lastIssue = null;
            for (Warning warning : issues) {
                List<String> names;
                Severity severity;
                if (warning.issue != lastIssue) {
                    this.explainIssue(output, lastIssue);
                    lastIssue = warning.issue;
                }
                int startLength = output.length();
                if (warning.path != null) {
                    output.append(warning.path);
                    output.append(':');
                    if (warning.line >= 0) {
                        output.append(Integer.toString(warning.line + 1));
                        output.append(':');
                    }
                    if (startLength < output.length()) {
                        output.append(' ');
                    }
                }
                if ((severity = warning.severity) == Severity.FATAL) {
                    severity = Severity.ERROR;
                }
                output.append(severity.getDescription());
                output.append(':');
                output.append(' ');
                output.append(TextFormat.RAW.convertTo(warning.message, TextFormat.TEXT));
                if (warning.issue != null) {
                    output.append(' ').append('[');
                    output.append(warning.issue.getId());
                    output.append(']');
                }
                output.append('\n');
                if (warning.errorLine != null && !warning.errorLine.isEmpty()) {
                    output.append(warning.errorLine);
                }
                if (warning.location != null && warning.location.getSecondary() != null) {
                    Location location;
                    boolean omitted = false;
                    for (location = warning.location.getSecondary(); location != null; location = location.getSecondary()) {
                        if (location.getMessage() != null && !location.getMessage().isEmpty()) {
                            int line;
                            output.append("    ");
                            String path = this.mClient.getDisplayPath(warning.project, location.getFile());
                            output.append(path);
                            Position start = location.getStart();
                            if (start != null && (line = start.getLine()) >= 0) {
                                output.append(':');
                                output.append(Integer.toString(line + 1));
                            }
                            if (location.getMessage() != null && !location.getMessage().isEmpty()) {
                                output.append(':');
                                output.append(' ');
                                output.append(TextFormat.RAW.convertTo(location.getMessage(), TextFormat.TEXT));
                            }
                            output.append('\n');
                            continue;
                        }
                        omitted = true;
                    }
                    if (!abbreviate && omitted) {
                        StringBuilder sb = new StringBuilder(100);
                        sb.append("Also affects: ");
                        int begin = sb.length();
                        for (location = warning.location.getSecondary(); location != null; location = location.getSecondary()) {
                            int line;
                            if (location.getMessage() != null && !location.getMessage().isEmpty()) continue;
                            if (sb.length() > begin) {
                                sb.append(", ");
                            }
                            String path = this.mClient.getDisplayPath(warning.project, location.getFile());
                            sb.append(path);
                            Position start = location.getStart();
                            if (start == null || (line = start.getLine()) < 0) continue;
                            sb.append(':');
                            sb.append(Integer.toString(line + 1));
                        }
                        String wrapped = Main.wrap(sb.toString(), 78, "     ");
                        output.append(wrapped);
                    }
                }
                if (!warning.isVariantSpecific()) continue;
                if (warning.includesMoreThanExcludes()) {
                    output.append("Applies to variants: ");
                    names = warning.getIncludedVariantNames();
                } else {
                    output.append("Does not apply to variants: ");
                    names = warning.getExcludedVariantNames();
                }
                output.append(Joiner.on((String)", ").join(names));
                output.append('\n');
            }
            this.explainIssue(output, lastIssue);
            this.mWriter.write(output.toString());
            this.mWriter.write(String.format("%1$d errors, %2$d warnings", errorCount, warningCount));
            this.mWriter.write(10);
            this.mWriter.flush();
            if (this.mClose) {
                this.mWriter.close();
                if (!this.mClient.getFlags().isQuiet() && this.mOutput != null) {
                    String path = this.mOutput.getAbsolutePath();
                    System.out.println(String.format("Wrote text report to %1$s", path));
                }
            }
        }
    }

    private void explainIssue(StringBuilder output, Issue issue) throws IOException {
        if (issue == null || !this.mFlags.isExplainIssues() || issue == IssueRegistry.LINT_ERROR) {
            return;
        }
        String explanation = issue.getExplanation(TextFormat.TEXT);
        if (explanation.trim().isEmpty()) {
            return;
        }
        String indent = "   ";
        String formatted = SdkUtils.wrap((String)explanation, (int)(78 - indent.length()), null);
        output.append('\n');
        output.append(indent);
        output.append("Explanation for issues of type \"").append(issue.getId()).append("\":\n");
        for (String line : Splitter.on((char)'\n').split((CharSequence)formatted)) {
            if (!line.isEmpty()) {
                output.append(indent);
                output.append(line);
            }
            output.append('\n');
        }
        List moreInfo = issue.getMoreInfo();
        if (!moreInfo.isEmpty()) {
            for (String url : moreInfo) {
                if (formatted.contains(url)) continue;
                output.append(indent);
                output.append(url);
                output.append('\n');
            }
            output.append('\n');
        }
    }

    boolean isWriteToConsole() {
        return this.mOutput == null;
    }
}

