/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.psi;

import com.android.tools.lint.psi.EcjPsiManager;
import com.android.tools.lint.psi.EcjPsiSourceElement;
import com.google.common.collect.Lists;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;

class EcjPsiReferenceList
extends EcjPsiSourceElement
implements PsiReferenceList {
    private final TypeReference[] mReferences;
    private final PsiReferenceList.Role mRole;
    private PsiJavaCodeReferenceElement[] mElements;
    private PsiClassType[] mTypes;

    EcjPsiReferenceList(EcjPsiManager manager, TypeReference[] references, PsiReferenceList.Role role) {
        super(manager, null);
        this.mReferences = references;
        this.mRole = role;
    }

    @Override
    public void accept(PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceList((PsiReferenceList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    void setReferenceElements(PsiJavaCodeReferenceElement[] elements) {
        this.mElements = elements;
    }

    public PsiJavaCodeReferenceElement[] getReferenceElements() {
        return this.mElements;
    }

    public PsiClassType[] getReferencedTypes() {
        if (this.mReferences == null) {
            return PsiClassType.EMPTY_ARRAY;
        }
        if (this.mTypes == null) {
            ArrayList types = Lists.newArrayListWithCapacity((int)this.mReferences.length);
            for (TypeReference reference : this.mReferences) {
                PsiType type = this.mManager.findType(reference);
                if (!(type instanceof PsiClassType)) continue;
                types.add((PsiClassType)type);
            }
            this.mTypes = types.toArray(PsiClassType.EMPTY_ARRAY);
        }
        return this.mTypes;
    }

    public PsiReferenceList.Role getRole() {
        return this.mRole;
    }
}

