/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.login;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.services.oauth2.Oauth2;
import com.google.api.services.oauth2.model.Userinfoplus;
import com.google.gct.login.IUserPropertyCallback;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import java.awt.Image;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.NotNull;

public class GoogleLoginUtils {
    public static final Logger LOG = Logger.getInstance(GoogleLoginUtils.class);
    public static final int DEFAULT_PICTURE_SIZE = 96;

    public static void provideUserPicture(Userinfoplus userInfo, final Consumer<Image> pictureCallback) {
        String urlString = userInfo.getPicture() + "?sz=" + 96;
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            LOG.warn(String.format("The picture URL: %s,  is not a valid URL string.", urlString), (Throwable)e);
            return;
        }
        final URL newUrl = url;
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    pictureCallback.accept(ImageIO.read(newUrl));
                }
                catch (IOException exception) {
                    pictureCallback.accept(null);
                }
            }
        });
    }

    public static void getUserInfo(@NotNull Credential credential, final IUserPropertyCallback<Userinfoplus> callback) {
        if (credential == null) {
            GoogleLoginUtils.$$$reportNull$$$0(0);
        }
        final Oauth2 userInfoService = new Oauth2.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new JacksonFactory(), (HttpRequestInitializer)credential).setApplicationName("Android Studio").build();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                Userinfoplus userInfo = null;
                try {
                    userInfo = (Userinfoplus)userInfoService.userinfo().get().execute();
                }
                catch (IOException e) {
                    LOG.warn("Error retrieving user information.", (Throwable)e);
                }
                catch (Throwable e) {
                    LOG.warn("Error retrieving user information.", e);
                }
                if (userInfo != null && userInfo.getId() != null) {
                    callback.setProperty(userInfo);
                } else {
                    callback.setProperty(null);
                }
            }
        });
    }

    public static void showErrorDialog(final String message, final @NotNull String title) {
        if (title == null) {
            GoogleLoginUtils.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            Messages.showErrorDialog((String)message, (String)title);
        } else {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    Messages.showErrorDialog((String)message, (String)title);
                }
            }, ModalityState.defaultModalityState());
        }
    }

    @NotNull
    public static Credential makeFakeUserCredential() {
        String clientId = System.getenv().get("ANDROID_CLIENT_ID");
        String clientSecret = System.getenv().get("ANDROID_CLIENT_SECRET");
        String refreshToken = System.getenv().get("FAKE_USER_REFRESH_TOKEN");
        String accessToken = System.getenv().get("FAKE_USER_ACCESS_TOKEN");
        GoogleCredential cred = new GoogleCredential.Builder().setJsonFactory((JsonFactory)new JacksonFactory()).setTransport((HttpTransport)new NetHttpTransport()).setClientSecrets(clientId, clientSecret).build();
        cred.setAccessToken(accessToken);
        cred.setRefreshToken(refreshToken);
        GoogleCredential googleCredential = cred;
        if (googleCredential == null) {
            GoogleLoginUtils.$$$reportNull$$$0(2);
        }
        return googleCredential;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credential";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/gct/login/GoogleLoginUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/gct/login/GoogleLoginUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "makeFakeUserCredential";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUserInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "showErrorDialog";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

