/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant;

import com.google.urlassistant.AppLinkTableCell;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActivityData
implements AppLinkTableCell {
    private Module myModule;
    private String myActivityName;
    private XmlTag myIntentFilterTag;
    @Nullable
    private final PsiClass myActivityClass;

    public ActivityData(@NotNull Module module, @NotNull String activityName, @Nullable XmlTag intentFilterTag, @Nullable PsiClass activityClass) {
        if (module == null) {
            ActivityData.$$$reportNull$$$0(0);
        }
        if (activityName == null) {
            ActivityData.$$$reportNull$$$0(1);
        }
        this.myModule = module;
        this.myActivityName = activityName;
        this.myIntentFilterTag = intentFilterTag;
        this.myActivityClass = activityClass;
    }

    @Nullable
    public PsiClass getActivityClass() {
        return this.myActivityClass;
    }

    @Nullable
    public VirtualFile getActivityVirtualFile() {
        return this.myActivityClass == null ? null : this.myActivityClass.getContainingFile().getVirtualFile();
    }

    @NotNull
    public String getActivityName() {
        String string = this.myActivityName;
        if (string == null) {
            ActivityData.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getActivityAndModuleName() {
        String string = String.format("%s (%s)", this.myActivityName, this.getModuleName());
        if (string == null) {
            ActivityData.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getModuleName() {
        String string = this.myModule.getName();
        if (string == null) {
            ActivityData.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            ActivityData.$$$reportNull$$$0(5);
        }
        return module;
    }

    public void setModule(@NotNull Module module) {
        if (module == null) {
            ActivityData.$$$reportNull$$$0(6);
        }
        this.myModule = module;
    }

    @Nullable
    public XmlTag getIntentFilterTag() {
        return this.myIntentFilterTag;
    }

    public void setIntentFilterTag(@NotNull XmlTag intentFilterTag) {
        if (intentFilterTag == null) {
            ActivityData.$$$reportNull$$$0(7);
        }
        this.myIntentFilterTag = intentFilterTag;
    }

    @Override
    @NotNull
    public String getHtmlText(boolean isSelected) {
        String string = AppLinkTableCell.generateHtmlText(this.myActivityName, this.getModuleName(), isSelected);
        if (string == null) {
            ActivityData.$$$reportNull$$$0(8);
        }
        return string;
    }

    public String toString() {
        return AppLinkTableCell.generateRegularText(this.myActivityName, this.getModuleName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/urlassistant/ActivityData";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentFilterTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/urlassistant/ActivityData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActivityName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActivityAndModuleName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHtmlText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setModule";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setIntentFilterTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

