/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.assistant.datamodel.AnalyticsProvider;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectStructureUsageTracker;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.google.common.collect.ImmutableMap;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.AppLinksAssistantEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class AppLinksAnalyticsProvider
implements AnalyticsProvider {
    private static final Map<String, AppLinksAssistantEvent.EventSource> mySidePanelActionButtonMap = ImmutableMap.of((Object)"url_assistant.url_mapper", (Object)AppLinksAssistantEvent.EventSource.URL_MAPPING_PANEL, (Object)"url_assistant.dal_generator", (Object)AppLinksAssistantEvent.EventSource.DAL_PANEL, (Object)"url_assistant.insert_app_link_handling_code", (Object)AppLinksAssistantEvent.EventSource.CODE_INSERT_DIALOG, (Object)"url_assistant.launch_app_via_app_link", (Object)AppLinksAssistantEvent.EventSource.APP_LINKS_TEST_PANEL);

    public void trackPanelOpened(@NotNull Project project) {
        if (project == null) {
            AppLinksAnalyticsProvider.$$$reportNull$$$0(0);
        }
        AppLinksAnalyticsProvider.trackEvent(AppLinksAssistantEvent.EventSource.ASSISTANT_SIDE_PANEL, AppLinksAssistantEvent.EventState.OPENED, project);
    }

    public static void trackActionButtonClick(@NotNull String actionId, @NotNull Project project) {
        if (actionId == null) {
            AppLinksAnalyticsProvider.$$$reportNull$$$0(1);
        }
        if (project == null) {
            AppLinksAnalyticsProvider.$$$reportNull$$$0(2);
        }
        if (mySidePanelActionButtonMap.containsKey(actionId)) {
            AppLinksAnalyticsProvider.trackEvent(mySidePanelActionButtonMap.get(actionId), AppLinksAssistantEvent.EventState.OPENED, project);
        } else {
            Logger.getInstance(AppLinksAnalyticsProvider.class).warn("\"No metric event registry found for button: \\\"\" + actionId + \"\\\".\"");
        }
    }

    public static void trackEvent(@NotNull AppLinksAssistantEvent.EventSource source, @NotNull AppLinksAssistantEvent.EventState state, @NotNull Project project) {
        if (source == null) {
            AppLinksAnalyticsProvider.$$$reportNull$$$0(3);
        }
        if (state == null) {
            AppLinksAnalyticsProvider.$$$reportNull$$$0(4);
        }
        if (project == null) {
            AppLinksAnalyticsProvider.$$$reportNull$$$0(5);
        }
        AppLinksAssistantEvent.Builder eventDetails = AppLinksAssistantEvent.newBuilder().setEventSource(source).setEventState(state);
        String appId = ProjectStructureUsageTracker.getApplicationId((Project)project);
        if (appId != null) {
            eventDetails.setAppId(AnonymizerUtil.anonymizeUtf8((String)appId)).setRawProjectId(appId);
        }
        AndroidStudioEvent.Builder event = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.APP_LINKS_ASSISTANT_STATS).setAppLinksAssistantEvent(eventDetails);
        UsageTracker.getInstance().log(event);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/google/urlassistant/AppLinksAnalyticsProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "trackPanelOpened";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "trackActionButtonClick";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "trackEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

