/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant;

import com.google.common.collect.ImmutableList;
import com.google.urlassistant.ActivityData;
import com.google.urlassistant.FullUrl;
import com.google.urlassistant.Order;
import com.google.urlassistant.PathData;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DeepLinks {
    private List<DeepLink> myDeepLinkList = new ArrayList<DeepLink>();

    public int addLink(@NotNull Order order, @NotNull FullUrl url, @NotNull PathData pathData, @NotNull ActivityData activityData, boolean alwaysAddToEnd) {
        if (order == null) {
            DeepLinks.$$$reportNull$$$0(0);
        }
        if (url == null) {
            DeepLinks.$$$reportNull$$$0(1);
        }
        if (pathData == null) {
            DeepLinks.$$$reportNull$$$0(2);
        }
        if (activityData == null) {
            DeepLinks.$$$reportNull$$$0(3);
        }
        DeepLink newDeepLink = new DeepLink(order, activityData, url, pathData);
        if (!alwaysAddToEnd) {
            for (int i = 0; i < this.myDeepLinkList.size(); ++i) {
                DeepLink deepLink = this.myDeepLinkList.get(i);
                if (!deepLink.getActivityData().getModuleName().equals(activityData.getModuleName())) continue;
                if (deepLink.getOrder().getIntValue() > newDeepLink.getOrder().getIntValue()) {
                    this.myDeepLinkList.add(i, newDeepLink);
                    return i;
                }
                if (i != this.myDeepLinkList.size() - 1 && this.myDeepLinkList.get(i + 1).getActivityData().getModuleName().equals(activityData.getModuleName())) continue;
                this.myDeepLinkList.add(i + 1, newDeepLink);
                return i + 1;
            }
        }
        this.myDeepLinkList.add(newDeepLink);
        return this.myDeepLinkList.size() - 1;
    }

    public void clear() {
        this.myDeepLinkList.clear();
    }

    public void removeLinkAt(int index) {
        this.myDeepLinkList.remove(index);
    }

    public int updateLink(@NotNull Order order, @NotNull FullUrl url, @NotNull PathData pathData, @NotNull ActivityData activityData, boolean supportOrder, int index) {
        if (order == null) {
            DeepLinks.$$$reportNull$$$0(4);
        }
        if (url == null) {
            DeepLinks.$$$reportNull$$$0(5);
        }
        if (pathData == null) {
            DeepLinks.$$$reportNull$$$0(6);
        }
        if (activityData == null) {
            DeepLinks.$$$reportNull$$$0(7);
        }
        if (index < 0 || index >= this.myDeepLinkList.size()) {
            throw new ArrayIndexOutOfBoundsException("index:" + index + "is invalid.");
        }
        DeepLink deepLink = this.myDeepLinkList.get(index);
        if (!activityData.getModuleName().equals(deepLink.getActivityData().getModuleName()) || supportOrder && deepLink.getOrder().getIntValue() != order.getIntValue()) {
            this.myDeepLinkList.remove(index);
            return this.addLink(order, url, pathData, activityData, supportOrder);
        }
        deepLink.myFullUrl = url;
        deepLink.myPathData = pathData;
        deepLink.myActivityData = activityData;
        return index;
    }

    @NotNull
    public final ImmutableList<DeepLink> getDeepLinkList() {
        ImmutableList immutableList = ImmutableList.copyOf(this.myDeepLinkList);
        if (immutableList == null) {
            DeepLinks.$$$reportNull$$$0(8);
        }
        return immutableList;
    }

    public void addDeepLinks(@NotNull List<DeepLink> deepLinkList) {
        if (deepLinkList == null) {
            DeepLinks.$$$reportNull$$$0(9);
        }
        this.myDeepLinkList.addAll(deepLinkList);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathData";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityData";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/urlassistant/DeepLinks";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deepLinkList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/urlassistant/DeepLinks";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeepLinkList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addLink";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateLink";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addDeepLinks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DeepLink {
        private FullUrl myFullUrl;
        private ActivityData myActivityData;
        private PathData myPathData;
        private Order myOrder;

        public DeepLink(@NotNull Order order, @NotNull ActivityData data, @NotNull FullUrl url, @NotNull PathData path) {
            if (order == null) {
                DeepLink.$$$reportNull$$$0(0);
            }
            if (data == null) {
                DeepLink.$$$reportNull$$$0(1);
            }
            if (url == null) {
                DeepLink.$$$reportNull$$$0(2);
            }
            if (path == null) {
                DeepLink.$$$reportNull$$$0(3);
            }
            this.myActivityData = data;
            this.myFullUrl = url;
            this.myPathData = path;
            this.myOrder = order;
        }

        @NotNull
        public FullUrl getUrl() {
            FullUrl fullUrl = this.myFullUrl;
            if (fullUrl == null) {
                DeepLink.$$$reportNull$$$0(4);
            }
            return fullUrl;
        }

        @NotNull
        public PathData getPath() {
            PathData pathData = this.myPathData;
            if (pathData == null) {
                DeepLink.$$$reportNull$$$0(5);
            }
            return pathData;
        }

        @NotNull
        public ActivityData getActivityData() {
            ActivityData activityData = this.myActivityData;
            if (activityData == null) {
                DeepLink.$$$reportNull$$$0(6);
            }
            return activityData;
        }

        @NotNull
        public Order getOrder() {
            Order order = this.myOrder;
            if (order == null) {
                DeepLink.$$$reportNull$$$0(7);
            }
            return order;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "order";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/google/urlassistant/DeepLinks$DeepLink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/google/urlassistant/DeepLinks$DeepLink";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrl";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActivityData";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

