/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant;

import com.intellij.openapi.util.text.StringUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FullUrl {
    public static final String SCHEME_HTTP = "http";
    public static final String SCHEME_HTTPS = "https";
    public static final String PREFIX_HTTPS = "https://";
    private String myScheme = "";
    private String myHost = "";
    private String myMimeType;
    private int myPort = -1;
    private boolean isPortSet = false;

    public FullUrl() {
    }

    public FullUrl(String fullUrl) throws MalformedURLException {
        URL url = new URL(fullUrl);
        this.myScheme = url.getProtocol();
        this.myHost = url.getHost();
        this.myPort = url.getPort();
        this.isPortSet = this.myPort >= 0;
    }

    @NotNull
    public String getScheme() {
        String string = this.myScheme.toLowerCase(Locale.US);
        if (string == null) {
            FullUrl.$$$reportNull$$$0(0);
        }
        return string;
    }

    public FullUrl setScheme(@NotNull String scheme) {
        if (scheme == null) {
            FullUrl.$$$reportNull$$$0(1);
        }
        this.myScheme = scheme;
        return this;
    }

    @NotNull
    public String getHost() {
        String string = this.myHost;
        if (string == null) {
            FullUrl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public FullUrl setHost(@NotNull String host) {
        if (host == null) {
            FullUrl.$$$reportNull$$$0(3);
        }
        this.myHost = host;
        FullUrl fullUrl = this;
        if (fullUrl == null) {
            FullUrl.$$$reportNull$$$0(4);
        }
        return fullUrl;
    }

    public int getPort() {
        return this.myPort;
    }

    @NotNull
    public String getPortText() {
        if (this.myPort < 0) {
            if ("" == null) {
                FullUrl.$$$reportNull$$$0(5);
            }
            return "";
        }
        String string = String.valueOf(this.myPort);
        if (string == null) {
            FullUrl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public FullUrl setPort(@NotNull String port) {
        if (port == null) {
            FullUrl.$$$reportNull$$$0(7);
        }
        try {
            this.myPort = Integer.valueOf(port);
            this.isPortSet = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        FullUrl fullUrl = this;
        if (fullUrl == null) {
            FullUrl.$$$reportNull$$$0(8);
        }
        return fullUrl;
    }

    @NotNull
    public FullUrl setPort(int port) {
        this.myPort = port;
        this.isPortSet = true;
        FullUrl fullUrl = this;
        if (fullUrl == null) {
            FullUrl.$$$reportNull$$$0(9);
        }
        return fullUrl;
    }

    public boolean isPortSet() {
        return this.isPortSet;
    }

    @Nullable
    public String getMimeType() {
        return this.myMimeType;
    }

    @NotNull
    public FullUrl setMimeType(@Nullable String mimeType) {
        this.myMimeType = mimeType;
        FullUrl fullUrl = this;
        if (fullUrl == null) {
            FullUrl.$$$reportNull$$$0(10);
        }
        return fullUrl;
    }

    public String toString() {
        if (StringUtil.isNotEmpty((String)this.myScheme)) {
            return this.myScheme + "://" + this.myHost + (this.isPortSet ? ":" + this.myPort : "");
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/urlassistant/FullUrl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "port";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getScheme";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/urlassistant/FullUrl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHost";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "setHost";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPortText";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "setPort";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "setMimeType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setScheme";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setHost";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setPort";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

