/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.actions;

import com.google.common.collect.Lists;
import com.google.urlassistant.util.InsertCodeUtils;
import com.google.urlassistant.util.StatementFilter;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class InsertCodeHandler {
    private static final String ON_CREATE_METHOD = "onCreate";
    private static final List<String> PARAMETER_TYPE_ON_CREATE_METHOD = Lists.newArrayList((Object[])new String[]{"android.os.Bundle"});
    private static final List<String> COMMENT_IN_JAVA = Lists.newArrayList((Object[])new String[]{"// ATTENTION: This was auto-generated to handle app links."});
    private static final List<String> IMPORT_CLASSES_LIST = Lists.newArrayList((Object[])new String[]{"android.content.Intent", "android.net.Uri"});
    private static final List<String> STATEMENTS_LIST = Lists.newArrayList((Object[])new String[]{"Intent appLinkIntent = getIntent();", "String appLinkAction = appLinkIntent.getAction();", "Uri appLinkData = appLinkIntent.getData();"});
    private final PsiCodeBlock myActivityOnCreateMethod;
    private PsiClass myActivity;

    public InsertCodeHandler(@NotNull PsiClass activity) {
        if (activity == null) {
            InsertCodeHandler.$$$reportNull$$$0(0);
        }
        this.myActivity = activity;
        this.myActivityOnCreateMethod = InsertCodeUtils.getMethodBodyByName(ON_CREATE_METHOD, PARAMETER_TYPE_ON_CREATE_METHOD, this.myActivity);
    }

    public CodeInsertErrorCode shouldInvoke() {
        if (this.myActivityOnCreateMethod == null) {
            return CodeInsertErrorCode.NoOnCreateMethod;
        }
        for (String statement : STATEMENTS_LIST) {
            List<PsiStatement> statements = StatementFilter.filterCodeBlock(statement, this.myActivityOnCreateMethod);
            if (statements.isEmpty()) continue;
            return CodeInsertErrorCode.AppLinksCodeConflict;
        }
        return CodeInsertErrorCode.SUCCEED;
    }

    public void invoke(final @NotNull Project project) {
        if (project == null) {
            InsertCodeHandler.$$$reportNull$$$0(1);
        }
        if (this.shouldInvoke() != CodeInsertErrorCode.SUCCEED) {
            return;
        }
        final Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        assert (editor != null);
        new WriteCommandAction(project, new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                Pair<PsiElement, PsiElement> psiElementPair;
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((psiElementPair = InsertCodeUtils.maybeAddStatementsToMethod(STATEMENTS_LIST, InsertCodeHandler.this.myActivityOnCreateMethod, project)) == null) {
                    return;
                }
                InsertCodeUtils.maybeInsertImportList(IMPORT_CLASSES_LIST, InsertCodeHandler.this.myActivity, project);
                InsertCodeUtils.addCommentsBefore(COMMENT_IN_JAVA, InsertCodeHandler.this.myActivityOnCreateMethod, project, (PsiElement)psiElementPair.first);
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)InsertCodeHandler.this.myActivityOnCreateMethod);
                editor.getSelectionModel().setSelection(((PsiElement)psiElementPair.first).getTextOffset(), ((PsiElement)psiElementPair.second).getTextOffset() + ((PsiElement)psiElementPair.second).getTextLength());
                editor.getScrollingModel().scrollTo(editor.offsetToLogicalPosition(((PsiElement)psiElementPair.first).getTextOffset()), ScrollType.CENTER_UP);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/google/urlassistant/actions/InsertCodeHandler$1", "run"));
            }
        }.execute();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activity";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/google/urlassistant/actions/InsertCodeHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum CodeInsertErrorCode {
        SUCCEED(0, ""),
        NoOnCreateMethod(1, UrlAssistantBundle.message("insert.code.dialog.no.oncreate.error", new Object[0])),
        AppLinksCodeConflict(2, UrlAssistantBundle.message("insert.code.dialog.conflict.error", new Object[0]));

        private final int id;
        private final String message;

        private CodeInsertErrorCode(int id, String message) {
            this.id = id;
            this.message = message;
        }

        public int getId() {
            return this.id;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

