/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.logcat;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.google.urlassistant.ui.AppLinkTestingWindow;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppLinksLogLineListener
implements AndroidLogcatService.LogcatListener {
    static final String TARGETED_TAG = "ActivityManager";
    static final String RESOLVER_MESSAGE = "android/com.android.internal.app.ResolverActivity";
    static final String ACTIVITY_DISPLAY_MESSAGE = "Displayed";
    private AppLinkTestingWindow myUiWindow;
    private boolean listening;
    private Module myLaunchModule;
    private IDevice myDevice;
    private String myLaunchActivityName;

    public AppLinksLogLineListener(@NotNull AppLinkTestingWindow uiWindow) {
        if (uiWindow == null) {
            AppLinksLogLineListener.$$$reportNull$$$0(0);
        }
        this.listening = false;
        this.myLaunchActivityName = "";
        this.myUiWindow = uiWindow;
    }

    public void onLogLineReceived(@NotNull LogCatMessage line) {
        if (line == null) {
            AppLinksLogLineListener.$$$reportNull$$$0(1);
        }
        if (!this.listening) {
            return;
        }
        if (!TARGETED_TAG.contains(line.getTag())) {
            return;
        }
        String message = line.getMessage();
        if (message.contains(RESOLVER_MESSAGE)) {
            this.stopListening();
            ApplicationManager.getApplication().invokeLater(() -> this.myUiWindow.setShortResultLabel(UrlAssistantBundle.message("test.url.resolve.error", new Object[0]), false), ModalityState.any());
        }
        if (message.startsWith(ACTIVITY_DISPLAY_MESSAGE) && message.contains(this.myLaunchActivityName)) {
            String activityName = this.myLaunchActivityName;
            this.stopListening();
            ApplicationManager.getApplication().invokeLater(() -> this.myUiWindow.setShortResultLabel(UrlAssistantBundle.message("test.url.resolve.success", activityName), true), ModalityState.any());
        }
    }

    public boolean isListening() {
        return this.listening;
    }

    public void startListening(@NotNull Module module, @NotNull String activityName) {
        if (module == null) {
            AppLinksLogLineListener.$$$reportNull$$$0(2);
        }
        if (activityName == null) {
            AppLinksLogLineListener.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)activityName)) {
            return;
        }
        this.listening = true;
        this.myLaunchModule = module;
        this.myLaunchActivityName = activityName;
    }

    public void stopListening() {
        if (this.myDevice != null) {
            AndroidLogcatService.getInstance().removeListener(this.myDevice, (AndroidLogcatService.LogcatListener)this);
        }
        this.listening = false;
        this.myLaunchModule = null;
        this.myLaunchActivityName = "";
    }

    public void setDevice(@NotNull IDevice device) {
        if (device == null) {
            AppLinksLogLineListener.$$$reportNull$$$0(4);
        }
        this.myDevice = device;
    }

    @Nullable
    public Module getLaunchModule() {
        return this.myLaunchModule;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiWindow";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
        }
        objectArray2[1] = "com/google/urlassistant/logcat/AppLinksLogLineListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onLogLineReceived";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "startListening";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setDevice";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

