/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.util;

import com.android.builder.model.SigningConfig;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ValueXmlHelper;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.strings.StringsWriteUtils;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.instantapp.InstantApps;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.urlassistant.FullUrl;
import com.google.urlassistant.util.ManifestUtils;
import com.google.urlassistant.util.UrlAssistUtils;
import com.intellij.configurationStore.StorageUtilKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataListener;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.IntentFilter;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DalUtils {
    private static final String ASSET_STATEMENTS = "asset_statements";
    private static final String STRING_ASSET_STATEMENTS = "@string/asset_statements";
    private static final String RESOURCE = "resource";
    private static final String AUTO_VERIFY = "autoVerify";
    private static final String DAL_HANDLE_URL_STATEMENT = "{\n  \"relation\": [\"delegate_permission/common.handle_all_urls\"],\n  \"target\": {\n    \"namespace\": \"android_app\",\n    \"package_name\": \"%1$s\",\n    \"sha256_cert_fingerprints\":\n    [\"%2$s\"]\n  }\n}";
    private static final String DAL_SMART_LOCK_STATEMENT = ",\n{\n  \"relation\": [\"delegate_permission/common.get_login_creds\"],\n  \"target\": {\n    \"namespace\": \"web\",\n    \"site\": \"%1$s\"\n  }\n},\n{\n  \"relation\": [\"delegate_permission/common.get_login_creds\"],\n  \"target\": {\n    \"namespace\": \"android_app\",\n    \"package_name\": \"%2$s\",\n    \"sha256_cert_fingerprints\":\n    [\"%3$s\"]\n  }\n}";
    private static final String DAL_STRING_RES = "[{ \"include\": \"%1$s/.well-known/assetlinks.json\" }]";

    private static Logger getLog() {
        return Logger.getInstance(DalUtils.class);
    }

    @NotNull
    public static FullUrl getFullUrlWithHttps(@NotNull String domain) throws MalformedURLException {
        if (domain == null) {
            DalUtils.$$$reportNull$$$0(0);
        }
        FullUrl fullUrl = new FullUrl(domain.contains("://") ? domain : "https://" + domain);
        fullUrl.setScheme("https");
        FullUrl fullUrl2 = fullUrl;
        if (fullUrl2 == null) {
            DalUtils.$$$reportNull$$$0(1);
        }
        return fullUrl2;
    }

    @NotNull
    public static String getDalFileText(@NotNull String packageId, @NotNull String keystoreFingerprint, @Nullable String signInUrl) {
        if (packageId == null) {
            DalUtils.$$$reportNull$$$0(2);
        }
        if (keystoreFingerprint == null) {
            DalUtils.$$$reportNull$$$0(3);
        }
        String res = String.format(DAL_HANDLE_URL_STATEMENT, packageId, keystoreFingerprint);
        if (signInUrl != null) {
            res = res + String.format(DAL_SMART_LOCK_STATEMENT, signInUrl, packageId, keystoreFingerprint);
        }
        String string = "[" + res + "]";
        if (string == null) {
            DalUtils.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String getDalStringResText(@NotNull String domain) {
        if (domain == null) {
            DalUtils.$$$reportNull$$$0(5);
        }
        String string = String.format(DAL_STRING_RES, domain);
        if (string == null) {
            DalUtils.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public static VirtualFile addDalStringResource(@NotNull AndroidFacet facet, @NotNull String statementText) {
        if (facet == null) {
            DalUtils.$$$reportNull$$$0(7);
        }
        if (statementText == null) {
            DalUtils.$$$reportNull$$$0(8);
        }
        try {
            ResourceItem resourceItem;
            List itemList;
            Project project = facet.getModule().getProject();
            Module baseModule = InstantApps.findBaseFeature((Project)project);
            if (baseModule != null) {
                facet = AndroidFacet.getInstance((Module)baseModule);
            }
            if ((itemList = ResourceRepositoryManager.getAppResources((AndroidFacet)facet).getResourceItem(ResourceType.STRING, ASSET_STATEMENTS)) == null || itemList.isEmpty()) {
                resourceItem = StringsWriteUtils.createItem((AndroidFacet)facet, (VirtualFile)ResourceFolderManager.getInstance((AndroidFacet)facet).getPrimaryFolder(), null, (String)ASSET_STATEMENTS, (String)statementText, (boolean)false);
            } else {
                for (ResourceItem item : itemList) {
                    StringsWriteUtils.setItemText((Project)project, (ResourceItem)item, (String)statementText);
                }
                resourceItem = (ResourceItem)itemList.get(0);
            }
            if (resourceItem == null) {
                return null;
            }
            return StorageUtilKt.getOrCreateVirtualFile(null, (Path)resourceItem.getSource().toPath());
        }
        catch (Exception e) {
            DalUtils.getLog().warn("Couldn't find string res file when adding asset statements", (Throwable)e);
            return null;
        }
    }

    public static boolean checkDalStringResourceExists(@NotNull AndroidFacet facet, @NotNull String statementText) {
        List itemList;
        Project project;
        Module baseModule;
        if (facet == null) {
            DalUtils.$$$reportNull$$$0(9);
        }
        if (statementText == null) {
            DalUtils.$$$reportNull$$$0(10);
        }
        if ((baseModule = InstantApps.findBaseFeature((Project)(project = facet.getModule().getProject()))) != null) {
            facet = AndroidFacet.getInstance((Module)baseModule);
        }
        if ((itemList = ResourceRepositoryManager.getAppResources((AndroidFacet)facet).getResourceItem(ResourceType.STRING, ASSET_STATEMENTS)) != null && !itemList.isEmpty()) {
            for (ResourceItem item : itemList) {
                XmlTag tag = LocalResourceRepository.getItemTag((Project)project, (ResourceItem)item);
                if (tag == null || statementText.equals(ValueXmlHelper.unescapeResourceStringAsXml((String)tag.getValue().getText()))) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static String loadSigningConfigsFromGradle(@NotNull Module module, @NotNull List<SigningConfig> result) {
        AndroidModel androidModel;
        if (module == null) {
            DalUtils.$$$reportNull$$$0(11);
        }
        if (result == null) {
            DalUtils.$$$reportNull$$$0(12);
        }
        result.clear();
        String packageId = "";
        AndroidModuleModel androidModuleModel = AndroidModuleModel.get((Module)module);
        if (androidModuleModel == null) {
            String string = packageId;
            if (string == null) {
                DalUtils.$$$reportNull$$$0(13);
            }
            return string;
        }
        Collection signingConfigCollection = androidModuleModel.getAndroidProject().getSigningConfigs();
        result.addAll(signingConfigCollection);
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module);
        if (androidFacet != null && (androidModel = ((AndroidFacetConfiguration)androidFacet.getConfiguration()).getModel()) != null) {
            packageId = androidModel.getApplicationId();
        }
        String string = packageId;
        if (string == null) {
            DalUtils.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public static List<AndroidFacet> addMetaDataToAndroidManifest(@NotNull AndroidFacet facet) {
        if (facet == null) {
            DalUtils.$$$reportNull$$$0(15);
        }
        ArrayList<AndroidFacet> resultFacets = new ArrayList<AndroidFacet>();
        Project project = facet.getModule().getProject();
        Module baseModule = InstantApps.findBaseFeature((Project)project);
        List<Object> facetList = baseModule == null ? new ArrayList<AndroidFacet>(Arrays.asList(facet)) : UrlAssistUtils.getFacets(project);
        Map<AndroidFacet, Manifest> facetManifestMap = facetList.stream().filter(f -> f.getMainIdeaSourceProvider().getManifestFile() != null).collect(Collectors.toMap(f -> f, AndroidFacet::getManifest));
        facetList = facetList.stream().filter(facetManifestMap::containsKey).collect(Collectors.toList());
        for (AndroidFacet androidFacet : facetList) {
            List<XmlTag> applications = ManifestUtils.searchXmlTagsByName(facetManifestMap.get(androidFacet).getXmlTag(), "application");
            if (applications.isEmpty() || !DalUtils.setAttributeOnTag(applications.get(0))) continue;
            resultFacets.add(androidFacet);
        }
        ArrayList<AndroidFacet> arrayList = resultFacets;
        if (arrayList == null) {
            DalUtils.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    public static boolean checkMetaDataInAndroidManifestExists(@NotNull AndroidFacet facet) {
        Project project;
        Module baseModule;
        if (facet == null) {
            DalUtils.$$$reportNull$$$0(17);
        }
        List<Object> facetList = (baseModule = InstantApps.findBaseFeature((Project)(project = facet.getModule().getProject()))) == null ? new ArrayList<AndroidFacet>(Collections.singletonList(facet)) : UrlAssistUtils.getFacets(project);
        Map<AndroidFacet, Manifest> facetManifestMap = facetList.stream().filter(f -> f.getMainIdeaSourceProvider().getManifestFile() != null).collect(Collectors.toMap(f -> f, AndroidFacet::getManifest));
        facetList = facetList.stream().filter(facetManifestMap::containsKey).collect(Collectors.toList());
        for (AndroidFacet androidFacet : facetList) {
            List<XmlTag> applications = ManifestUtils.searchXmlTagsByName(facetManifestMap.get(androidFacet).getXmlTag(), "application");
            if (applications.isEmpty()) continue;
            XmlTag applicationTag = applications.get(0);
            List<XmlTag> metaDatas = ManifestUtils.searchXmlTagsByName(applicationTag, "meta-data");
            for (XmlTag subTag : metaDatas) {
                if (!"meta-data".equals(subTag.getName()) || !ASSET_STATEMENTS.equals(subTag.getAttributeValue("name", "http://schemas.android.com/apk/res/android")) || STRING_ASSET_STATEMENTS.equals(subTag.getAttributeValue(RESOURCE, "http://schemas.android.com/apk/res/android"))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean setAttributeOnTag(@NotNull XmlTag applicationTag) {
        if (applicationTag == null) {
            DalUtils.$$$reportNull$$$0(18);
        }
        List<XmlTag> metaDatas = ManifestUtils.searchXmlTagsByName(applicationTag, "meta-data");
        try {
            for (XmlTag subTag : metaDatas) {
                if (!"meta-data".equals(subTag.getName()) || !ASSET_STATEMENTS.equals(subTag.getAttributeValue("name", "http://schemas.android.com/apk/res/android"))) continue;
                subTag.setAttribute(RESOURCE, "http://schemas.android.com/apk/res/android", STRING_ASSET_STATEMENTS);
                return true;
            }
            String prefix = applicationTag.getPrefixByNamespace("http://schemas.android.com/apk/res/android");
            XmlTag metaData = applicationTag.createChildTag("meta-data", null, null, false);
            if (metaData == null) {
                return false;
            }
            metaData.setAttribute(prefix + ":" + "name", "http://schemas.android.com/apk/res/android", ASSET_STATEMENTS);
            metaData.setAttribute(prefix + ":" + RESOURCE, "http://schemas.android.com/apk/res/android", STRING_ASSET_STATEMENTS);
            applicationTag.addSubTag(metaData, true);
        }
        catch (IncorrectOperationException e) {
            return false;
        }
        return true;
    }

    public static boolean addAutoVerifyToAppLinks(@NotNull AndroidFacet facet) {
        Manifest manifest;
        if (facet == null) {
            DalUtils.$$$reportNull$$$0(19);
        }
        if ((manifest = facet.getManifest()) == null) {
            return false;
        }
        Application application = manifest.getApplication();
        if (application == null) {
            return false;
        }
        List activityList = application.getActivities();
        for (Activity activity : activityList) {
            for (IntentFilter intentFilter : activity.getIntentFilters()) {
                if (!ManifestUtils.isValidAppLink(intentFilter.getXmlTag())) continue;
                XmlTag xmlTag = intentFilter.getXmlTag();
                xmlTag.setAttribute(AUTO_VERIFY, "http://schemas.android.com/apk/res/android", "true");
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static String getDalJsonFileUrl(@NotNull String domain) {
        if (domain == null) {
            DalUtils.$$$reportNull$$$0(20);
        }
        String string = domain + "/.well-known/assetlinks.json";
        if (string == null) {
            DalUtils.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 13: 
            case 14: 
            case 16: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 13: 
            case 14: 
            case 16: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 13: 
            case 14: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/urlassistant/util/DalUtils";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keystoreFingerprint";
                break;
            }
            case 7: 
            case 9: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementText";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/urlassistant/util/DalUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullUrlWithHttps";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDalFileText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDalStringResText";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "loadSigningConfigsFromGradle";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "addMetaDataToAndroidManifest";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDalJsonFileUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFullUrlWithHttps";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 13: 
            case 14: 
            case 16: 
            case 21: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDalFileText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDalStringResText";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addDalStringResource";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkDalStringResourceExists";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadSigningConfigsFromGradle";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addMetaDataToAndroidManifest";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkMetaDataInAndroidManifestExists";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setAttributeOnTag";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addAutoVerifyToAppLinks";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDalJsonFileUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 13: 
            case 14: 
            case 16: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SigningConfigComboBoxModel
    implements ComboBoxModel<String> {
        private List<SigningConfig> configList;
        private int selectedIndex;

        public SigningConfigComboBoxModel(@NotNull List<SigningConfig> list) {
            if (list == null) {
                SigningConfigComboBoxModel.$$$reportNull$$$0(0);
            }
            this.selectedIndex = 0;
            this.configList = list;
        }

        @Nullable
        public SigningConfig getSelectedSigningConfig() {
            try {
                return this.configList.get(this.selectedIndex);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public void setSelectedItem(Object anItem) {
            for (int i = 0; i < this.configList.size(); ++i) {
                if (!this.configList.get(i).getName().equals(anItem)) continue;
                this.selectedIndex = i;
                break;
            }
        }

        @Override
        public Object getSelectedItem() {
            try {
                return this.configList.get(this.selectedIndex).getName();
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public int getSize() {
            return this.configList != null ? this.configList.size() : 0;
        }

        @Override
        public String getElementAt(int index) {
            try {
                return this.configList.get(index).getName();
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/google/urlassistant/util/DalUtils$SigningConfigComboBoxModel", "<init>"));
        }
    }
}

