/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.util;

import com.google.common.collect.Sets;
import com.google.urlassistant.ActivityData;
import com.google.urlassistant.DeepLinkInetAddress;
import com.google.urlassistant.DeepLinks;
import com.google.urlassistant.FullUrl;
import com.google.urlassistant.Order;
import com.google.urlassistant.PathData;
import com.google.urlassistant.PathType;
import com.google.urlassistant.ui.UrlAssistantWindow;
import com.google.urlassistant.util.ManifestUtils;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeepLinkUtils {
    public static void loadDeepLinks(final @Nullable Module module, @NotNull DeepLinks deepLinkList, @Nullable UrlAssistantWindow urlAssistantWindow) {
        if (deepLinkList == null) {
            DeepLinkUtils.$$$reportNull$$$0(0);
        }
        if (module == null) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        if (facet == null) {
            return;
        }
        final Manifest manifest = facet.getManifest();
        if (manifest == null || manifest.getXmlTag() == null) {
            return;
        }
        boolean refactorHappened = false;
        List<XmlTag> applications = ManifestUtils.searchXmlTagsByName(manifest.getXmlTag(), "application");
        if (applications.isEmpty()) {
            return;
        }
        boolean showOrder = Order.isSupportedFor(module.getProject());
        boolean isErrorDialogShown = false;
        ArrayList<DeepLinks.DeepLink> deepLinksInActivity = new ArrayList<DeepLinks.DeepLink>();
        List<XmlTag> activities = ManifestUtils.searchXmlTagsByName(applications.get(0), "activity");
        for (XmlTag activity : activities) {
            String activityName = activity.getAttributeValue("name", "http://schemas.android.com/apk/res/android");
            if (activityName == null) {
                if (isErrorDialogShown) continue;
                Messages.showMessageDialog((Project)module.getProject(), (String)UrlAssistantBundle.message("manifest.parsing.error", new Object[0]), (String)UrlAssistantBundle.message("dialog.error.title", new Object[0]), null);
                isErrorDialogShown = true;
                continue;
            }
            List<XmlTag> intentFilters = ManifestUtils.searchXmlTagsByName(activity, "intent-filter");
            for (final XmlTag intentFilter : intentFilters) {
                Integer orderInteger;
                if (!ManifestUtils.isValidDeepLink(intentFilter)) continue;
                LinkedHashSet schemes = Sets.newLinkedHashSet();
                LinkedHashSet hosts = Sets.newLinkedHashSet();
                LinkedHashSet mimeTypes = Sets.newLinkedHashSet();
                LinkedHashSet pathDataSet = Sets.newLinkedHashSet();
                String orderValue = intentFilter.getAttributeValue("order", "http://schemas.android.com/apk/res/android");
                try {
                    orderInteger = Integer.valueOf(orderValue);
                }
                catch (NullPointerException | NumberFormatException e) {
                    orderInteger = null;
                }
                Order order = new Order(orderInteger);
                List<XmlTag> dataList = ManifestUtils.searchXmlTagsByName(intentFilter, "data");
                for (XmlTag data : dataList) {
                    XmlAttribute[] xmlAttributes = data.getAttributes();
                    String host = null;
                    String port = null;
                    for (XmlAttribute xmlAttribute : xmlAttributes) {
                        if (!"http://schemas.android.com/apk/res/android".equals(xmlAttribute.getNamespace())) continue;
                        String attributeName = xmlAttribute.getLocalName();
                        String attributeValue = xmlAttribute.getValue();
                        if ("scheme".equals(attributeName)) {
                            schemes.add(attributeValue);
                            continue;
                        }
                        if ("host".equals(attributeName)) {
                            host = attributeValue;
                            continue;
                        }
                        if ("port".equals(attributeName)) {
                            port = attributeValue;
                            continue;
                        }
                        if ("mimeType".equals(attributeName)) {
                            mimeTypes.add(attributeValue);
                            continue;
                        }
                        if ("path".equals(attributeName)) {
                            pathDataSet.add(new PathData(PathType.Path, attributeValue));
                            continue;
                        }
                        if ("pathPrefix".equals(attributeName)) {
                            pathDataSet.add(new PathData(PathType.PathPrefix, attributeValue));
                            continue;
                        }
                        if (!"pathPattern".equals(attributeName)) continue;
                        pathDataSet.add(new PathData(PathType.PathPattern, attributeValue));
                    }
                    if (!StringUtil.isNotEmpty(host)) continue;
                    hosts.add(new DeepLinkInetAddress(host, port));
                }
                if (hosts.isEmpty() || !schemes.contains("http") && !schemes.contains("https")) continue;
                if (pathDataSet.isEmpty()) {
                    pathDataSet.add(new PathData(PathType.Path, ""));
                }
                List<FullUrl> urlList = DeepLinkUtils.buildUrlList(schemes, hosts, mimeTypes);
                if (urlAssistantWindow != null && (urlList.size() > 1 || pathDataSet.size() > 1)) {
                    if (!urlAssistantWindow.refactorIntentFilters(order, new ActivityData(module, activityName, null, null), activity, urlList, pathDataSet, deepLinksInActivity)) continue;
                    refactorHappened = true;
                    new WriteCommandAction<PsiClass>(module.getProject(), new PsiFile[0]){

                        protected void run(@NotNull Result<PsiClass> result) throws Throwable {
                            if (result == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            intentFilter.delete();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/google/urlassistant/util/DeepLinkUtils$1", "run"));
                        }
                    }.execute();
                    continue;
                }
                urlList.forEach(url -> pathDataSet.forEach(pathData -> deepLinksInActivity.add(new DeepLinks.DeepLink(order, new ActivityData(module, activityName, intentFilter, null), (FullUrl)url, (PathData)pathData))));
            }
        }
        if (showOrder) {
            deepLinksInActivity.sort(Comparator.comparingInt(o -> o.getOrder().getIntValue()));
        }
        deepLinkList.addDeepLinks(deepLinksInActivity);
        if (refactorHappened && manifest.getXmlElement() != null) {
            new WriteCommandAction<PsiClass>(module.getProject(), new PsiFile[0]){

                protected void run(@NotNull Result<PsiClass> result) throws Throwable {
                    if (result == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    CodeStyleManager.getInstance((Project)module.getProject()).reformat((PsiElement)manifest.getXmlElement());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/google/urlassistant/util/DeepLinkUtils$2", "run"));
                }
            }.execute();
        }
    }

    @NotNull
    private static List<FullUrl> buildUrlList(@NotNull Set<String> schemes, @NotNull Set<DeepLinkInetAddress> hosts, @NotNull Set<String> mimeTypes) {
        if (schemes == null) {
            DeepLinkUtils.$$$reportNull$$$0(1);
        }
        if (hosts == null) {
            DeepLinkUtils.$$$reportNull$$$0(2);
        }
        if (mimeTypes == null) {
            DeepLinkUtils.$$$reportNull$$$0(3);
        }
        if (mimeTypes.isEmpty()) {
            mimeTypes.add("");
        }
        ArrayList<FullUrl> list = new ArrayList<FullUrl>();
        schemes.forEach(scheme -> {
            if (hosts == null) {
                DeepLinkUtils.$$$reportNull$$$0(5);
            }
            if (mimeTypes == null) {
                DeepLinkUtils.$$$reportNull$$$0(6);
            }
            hosts.forEach(host -> {
                if (mimeTypes == null) {
                    DeepLinkUtils.$$$reportNull$$$0(7);
                }
                mimeTypes.forEach(mimeType -> list.add(new FullUrl().setScheme((String)scheme).setHost(host.getHost()).setPort(host.getPort()).setMimeType((String)mimeType)));
            });
        });
        ArrayList<FullUrl> arrayList = list;
        if (arrayList == null) {
            DeepLinkUtils.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deepLinkList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemes";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hosts";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mimeTypes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/urlassistant/util/DeepLinkUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/urlassistant/util/DeepLinkUtils";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildUrlList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadDeepLinks";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildUrlList";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildUrlList$5";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

