/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.util;

import com.google.urlassistant.util.StatementFilter;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.siyeh.ig.psiutils.ImportUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class InsertCodeUtils {
    public static void maybeInsertImportList(@NotNull List<String> importClassesList, @NotNull PsiClass activity, @NotNull Project project) {
        if (importClassesList == null) {
            InsertCodeUtils.$$$reportNull$$$0(0);
        }
        if (activity == null) {
            InsertCodeUtils.$$$reportNull$$$0(1);
        }
        if (project == null) {
            InsertCodeUtils.$$$reportNull$$$0(2);
        }
        for (String importClass : importClassesList) {
            InsertCodeUtils.maybeInsertImportStatement(importClass, activity, project);
        }
    }

    private static boolean maybeInsertImportStatement(@NotNull String className, @NotNull PsiClass activity, @NotNull Project project) {
        PsiImportList importList;
        if (className == null) {
            InsertCodeUtils.$$$reportNull$$$0(3);
        }
        if (activity == null) {
            InsertCodeUtils.$$$reportNull$$$0(4);
        }
        if (project == null) {
            InsertCodeUtils.$$$reportNull$$$0(5);
        }
        if ((importList = ((PsiJavaFile)activity.getContainingFile()).getImportList()) == null) {
            return false;
        }
        if (ImportUtils.hasOnDemandImportConflict((String)className, (PsiElement)activity) || !ImportUtils.nameCanBeImported((String)className, (PsiElement)activity) || InsertCodeUtils.hasImportStatement(importList, className)) {
            return false;
        }
        String dummyFileName = "_Dummy_" + className + "_." + JavaFileType.INSTANCE.getDefaultExtension();
        PsiJavaFile aFile = (PsiJavaFile)PsiFileFactory.getInstance((Project)project).createFileFromText(dummyFileName, (FileType)JavaFileType.INSTANCE, (CharSequence)("import " + className + ";"));
        PsiImportList dummyImportList = aFile.getImportList();
        if (dummyImportList != null) {
            PsiImportStatement[] statements = dummyImportList.getImportStatements();
            PsiImportStatement statement = (PsiImportStatement)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)statements[0]);
            importList.add((PsiElement)statement);
            return true;
        }
        return false;
    }

    public static Pair<PsiElement, PsiElement> maybeAddStatementsToMethod(@NotNull List<String> statementsList, @NotNull PsiCodeBlock method, @NotNull Project project) {
        if (statementsList == null) {
            InsertCodeUtils.$$$reportNull$$$0(6);
        }
        if (method == null) {
            InsertCodeUtils.$$$reportNull$$$0(7);
        }
        if (project == null) {
            InsertCodeUtils.$$$reportNull$$$0(8);
        }
        PsiElement beginElement = null;
        PsiElement endElement = null;
        JVMElementFactory elementFactory = JVMElementFactories.getFactory((Language)JavaLanguage.INSTANCE, (Project)project);
        if (elementFactory == null) {
            elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        }
        for (String statement : statementsList) {
            PsiElement element = InsertCodeUtils.maybeAddStatementToMethod(statement, method, (PsiElementFactory)elementFactory);
            if (element == null) continue;
            if (beginElement == null) {
                beginElement = element;
            }
            endElement = element;
        }
        return beginElement == null ? null : Pair.create(beginElement, endElement);
    }

    private static PsiElement maybeAddStatementToMethod(@NotNull String statement, @NotNull PsiCodeBlock body, @NotNull PsiElementFactory factory) {
        List<PsiStatement> myStatements;
        if (statement == null) {
            InsertCodeUtils.$$$reportNull$$$0(9);
        }
        if (body == null) {
            InsertCodeUtils.$$$reportNull$$$0(10);
        }
        if (factory == null) {
            InsertCodeUtils.$$$reportNull$$$0(11);
        }
        if ((myStatements = StatementFilter.filterCodeBlock(statement, body)).isEmpty()) {
            PsiStatement myStatement = factory.createStatementFromText(statement, null);
            return body.add((PsiElement)myStatement);
        }
        return null;
    }

    public static Pair<PsiElement, PsiElement> addCommentsBefore(@NotNull List<String> commentInJava, @NotNull PsiCodeBlock body, @NotNull Project project, PsiElement anchor) {
        if (commentInJava == null) {
            InsertCodeUtils.$$$reportNull$$$0(12);
        }
        if (body == null) {
            InsertCodeUtils.$$$reportNull$$$0(13);
        }
        if (project == null) {
            InsertCodeUtils.$$$reportNull$$$0(14);
        }
        PsiElement beginElement = null;
        PsiElement endElement = null;
        JVMElementFactory elementFactory = JVMElementFactories.getFactory((Language)JavaLanguage.INSTANCE, (Project)project);
        if (elementFactory == null) {
            elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        }
        for (String text : commentInJava) {
            PsiElement element = body.addBefore((PsiElement)((PsiElementFactory)elementFactory).createCommentFromText(text, null), anchor);
            if (element == null) continue;
            if (beginElement == null) {
                beginElement = element;
            }
            endElement = element;
        }
        return beginElement == null ? null : Pair.create(beginElement, endElement);
    }

    public static boolean hasImportStatement(@NotNull PsiImportList importList, @NotNull String className) {
        if (importList == null) {
            InsertCodeUtils.$$$reportNull$$$0(15);
        }
        if (className == null) {
            InsertCodeUtils.$$$reportNull$$$0(16);
        }
        String packageName = className.substring(0, className.lastIndexOf(46));
        PsiImportStatement singleImport = importList.findSingleClassImportStatement(className);
        PsiImportStatement onDemandImport = importList.findOnDemandImportStatement(packageName);
        return singleImport != null || onDemandImport != null;
    }

    public static PsiCodeBlock getMethodBodyByName(@NotNull String name, @NotNull List<String> parametersTypeName, @NotNull PsiClass psiClass) {
        PsiMethod[] psiMethods;
        if (name == null) {
            InsertCodeUtils.$$$reportNull$$$0(17);
        }
        if (parametersTypeName == null) {
            InsertCodeUtils.$$$reportNull$$$0(18);
        }
        if (psiClass == null) {
            InsertCodeUtils.$$$reportNull$$$0(19);
        }
        for (PsiMethod psiMethod : psiMethods = psiClass.findMethodsByName(name, false)) {
            PsiType[] types = psiMethod.getSignature(PsiSubstitutor.EMPTY).getParameterTypes();
            if (types.length != parametersTypeName.size()) continue;
            boolean correctSignature = true;
            for (int i = 0; i < types.length; ++i) {
                if (types[i].getCanonicalText().equals(parametersTypeName.get(i))) continue;
                correctSignature = false;
                break;
            }
            if (!correctSignature) continue;
            return psiMethod.getBody();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importClassesList";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activity";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementsList";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentInJava";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importList";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersTypeName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        objectArray2[1] = "com/google/urlassistant/util/InsertCodeUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "maybeInsertImportList";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "maybeInsertImportStatement";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "maybeAddStatementsToMethod";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "maybeAddStatementToMethod";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "addCommentsBefore";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "hasImportStatement";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "getMethodBodyByName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

