/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.util;

import com.google.common.collect.Lists;
import com.google.urlassistant.ActivityData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.IntentFilter;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManifestUtils {
    public static final String ACTION_VIEW = "android.intent.action.VIEW";
    public static final String CATEGORY_BROWSABLE = "android.intent.category.BROWSABLE";
    public static final String ORDER = "order";
    private static final String TAG_VALIDATION = "validation";
    private static final String ATTRIBUTE_TEST_URL = "testUrl";

    @NotNull
    public static List<ActivityData> getAllActivities(@NotNull Module[] modules, boolean supportsAppLinks, boolean mustHaveSourceFile) {
        if (modules == null) {
            ManifestUtils.$$$reportNull$$$0(0);
        }
        ArrayList<ActivityData> result = new ArrayList<ActivityData>();
        for (Module module : modules) {
            ManifestUtils.getAllActivitiesFromModule(module, result, supportsAppLinks, mustHaveSourceFile);
        }
        ArrayList<ActivityData> arrayList = result;
        if (arrayList == null) {
            ManifestUtils.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static void getAllActivitiesFromModule(@NotNull Module module, @NotNull List<ActivityData> resultList, boolean supportsAppLinks, boolean mustHaveSourceFile) {
        AndroidFacet facet;
        if (module == null) {
            ManifestUtils.$$$reportNull$$$0(2);
        }
        if (resultList == null) {
            ManifestUtils.$$$reportNull$$$0(3);
        }
        if ((facet = AndroidFacet.getInstance((Module)module)) == null) {
            return;
        }
        Manifest manifest = facet.getManifest();
        if (manifest == null || manifest.getModule() == null || manifest.getApplication() == null) {
            return;
        }
        List activityList = manifest.getApplication().getActivities();
        block0: for (Activity activity : activityList) {
            String activityName = activity.getActivityClass().getStringValue();
            if (activityName == null) continue;
            PsiClass activityClass = (PsiClass)activity.getActivityClass().getValue();
            if (mustHaveSourceFile && (activityClass == null || activityClass.getContainingFile().getVirtualFile() == null)) continue;
            if (!supportsAppLinks) {
                resultList.add(new ActivityData(module, activityName, null, activityClass));
                continue;
            }
            for (IntentFilter filter : activity.getIntentFilters()) {
                XmlTag intentFilter = filter.getXmlTag();
                if (!ManifestUtils.isValidAppLink(intentFilter)) continue;
                resultList.add(new ActivityData(module, activityName, intentFilter, activityClass));
                continue block0;
            }
        }
    }

    public static boolean isValidAppLink(@NotNull XmlTag intentFilter) {
        if (intentFilter == null) {
            ManifestUtils.$$$reportNull$$$0(4);
        }
        if (!ManifestUtils.isValidDeepLink(intentFilter)) {
            return false;
        }
        int hostCnt = 0;
        boolean hasScheme = false;
        List<XmlTag> dataList = ManifestUtils.searchXmlTagsByName(intentFilter, "data");
        for (XmlTag data : dataList) {
            String scheme = data.getAttributeValue("scheme", "http://schemas.android.com/apk/res/android");
            if ("http".equals(scheme) || "https".equals(scheme)) {
                hasScheme = true;
            }
            if (!StringUtil.isEmpty((String)data.getAttributeValue("host", "http://schemas.android.com/apk/res/android"))) {
                ++hostCnt;
            }
            if (hostCnt <= 0 || !hasScheme) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidDeepLink(@NotNull XmlTag intentFilter) {
        if (intentFilter == null) {
            ManifestUtils.$$$reportNull$$$0(5);
        }
        List<XmlTag> actions = ManifestUtils.searchXmlTagsByName(intentFilter, "action");
        boolean hasCorrectAction = false;
        for (XmlTag action : actions) {
            if (!ACTION_VIEW.equals(action.getAttributeValue("name", "http://schemas.android.com/apk/res/android"))) continue;
            hasCorrectAction = true;
            break;
        }
        if (!hasCorrectAction) {
            return false;
        }
        List<XmlTag> categories = ManifestUtils.searchXmlTagsByName(intentFilter, "category");
        boolean hasCategoryDefault = false;
        boolean hasCategoryBrowsable = false;
        for (XmlTag category : categories) {
            String name = category.getAttributeValue("name", "http://schemas.android.com/apk/res/android");
            if ("android.intent.category.DEFAULT".equals(name)) {
                hasCategoryDefault = true;
            }
            if (!CATEGORY_BROWSABLE.equals(name)) continue;
            hasCategoryBrowsable = true;
        }
        return hasCategoryDefault && hasCategoryBrowsable;
    }

    @Nullable
    public static VirtualFile getAndroidManiFest(@NotNull Module module) {
        AndroidFacet facet;
        if (module == null) {
            ManifestUtils.$$$reportNull$$$0(6);
        }
        return (facet = AndroidFacet.getInstance((Module)module)) == null ? null : ManifestUtils.getAndroidManiFest(facet);
    }

    @Nullable
    public static VirtualFile getAndroidManiFest(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ManifestUtils.$$$reportNull$$$0(7);
        }
        File file = facet.getMainSourceProvider().getManifestFile();
        return LocalFileSystem.getInstance().findFileByIoFile(file);
    }

    @Nullable
    public static XmlFile getAndroidManifestPsi(@NotNull Module module) {
        PsiFile psiFile;
        VirtualFile manifest;
        if (module == null) {
            ManifestUtils.$$$reportNull$$$0(8);
        }
        if ((manifest = ManifestUtils.getAndroidManiFest(module)) != null && (psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(manifest)) instanceof XmlFile) {
            return (XmlFile)psiFile;
        }
        return null;
    }

    @NotNull
    public static List<XmlTag> searchXmlTagsByName(@NotNull XmlTag root, @NotNull String tagName) {
        if (root == null) {
            ManifestUtils.$$$reportNull$$$0(9);
        }
        if (tagName == null) {
            ManifestUtils.$$$reportNull$$$0(10);
        }
        List<XmlTag> list = ManifestUtils.searchXmlTagsByName(root, tagName, null);
        if (list == null) {
            ManifestUtils.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public static List<XmlTag> searchXmlTagsByName(@NotNull XmlTag root, final @NotNull String tagName, final @Nullable String namespace) {
        if (root == null) {
            ManifestUtils.$$$reportNull$$$0(12);
        }
        if (tagName == null) {
            ManifestUtils.$$$reportNull$$$0(13);
        }
        final ArrayList tags = Lists.newArrayList();
        root.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                super.visitXmlTag(tag);
                if (namespace == null && tag.getName().equalsIgnoreCase(tagName) || tag.getLocalName().equalsIgnoreCase(tagName) && tag.getNamespace().equals(namespace)) {
                    tags.add(tag);
                }
            }
        });
        ArrayList arrayList = tags;
        if (arrayList == null) {
            ManifestUtils.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @Nullable
    public static XmlTag addTestUrl(@NotNull ActivityData activityData, @NotNull String testUrl) {
        if (activityData == null) {
            ManifestUtils.$$$reportNull$$$0(15);
        }
        if (testUrl == null) {
            ManifestUtils.$$$reportNull$$$0(16);
        }
        if (activityData.getIntentFilterTag() == null) {
            return null;
        }
        XmlTag activityTag = activityData.getIntentFilterTag().getParentTag();
        if (activityTag == null) {
            return null;
        }
        AndroidResourceUtil.ensureNamespaceImported((XmlFile)((XmlFile)activityTag.getContainingFile()), (String)"http://schemas.android.com/tools", (String)"tools");
        XmlTag validationTag = activityTag.createChildTag(TAG_VALIDATION, "http://schemas.android.com/tools", null, false);
        validationTag.setAttribute(ATTRIBUTE_TEST_URL, testUrl.trim());
        return activityTag.addSubTag(validationTag, true);
    }

    public static boolean isTestUrlAdded(@NotNull ActivityData activityData, @NotNull String testUrl) {
        if (activityData == null) {
            ManifestUtils.$$$reportNull$$$0(17);
        }
        if (testUrl == null) {
            ManifestUtils.$$$reportNull$$$0(18);
        }
        if (activityData.getIntentFilterTag() == null) {
            return false;
        }
        XmlTag activityTag = activityData.getIntentFilterTag().getParentTag();
        if (activityTag == null) {
            return false;
        }
        List<XmlTag> validationTags = ManifestUtils.searchXmlTagsByName(activityTag, TAG_VALIDATION, "http://schemas.android.com/tools");
        for (XmlTag xmlTag : validationTags) {
            if (!testUrl.trim().equalsIgnoreCase(xmlTag.getAttributeValue(ATTRIBUTE_TEST_URL))) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 1: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/urlassistant/util/ManifestUtils";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultList";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentFilter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityData";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_TEST_URL;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/urlassistant/util/ManifestUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllActivities";
                break;
            }
            case 11: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "searchXmlTagsByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllActivities";
                break;
            }
            case 1: 
            case 11: 
            case 14: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAllActivitiesFromModule";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isValidAppLink";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isValidDeepLink";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidManiFest";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidManifestPsi";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "searchXmlTagsByName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addTestUrl";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isTestUrlAdded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

