/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.util;

import com.google.urlassistant.util.UrlAssistantBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class Sha256FingerprintUtils {
    private static Logger getLog() {
        return Logger.getInstance(Sha256FingerprintUtils.class);
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static List<String> getAliases(String filePath) {
        ArrayList<String> arrayList;
        Throwable throwable;
        FileInputStream is;
        block18: {
            block19: {
                is = new FileInputStream(filePath);
                throwable = null;
                ArrayList<String> aliases = new ArrayList<String>();
                KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                keystore.load(is, null);
                Enumeration<String> e = keystore.aliases();
                while (e.hasMoreElements()) {
                    aliases.add(e.nextElement());
                }
                arrayList = aliases;
                if (is == null) break block18;
                if (throwable == null) break block19;
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block18;
            }
            is.close();
        }
        ArrayList<String> arrayList2 = arrayList;
        if (arrayList2 == null) {
            Sha256FingerprintUtils.$$$reportNull$$$0(0);
        }
        return arrayList2;
        {
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (is != null) {
                            if (throwable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                is.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (FileNotFoundException e) {
                    Sha256FingerprintUtils.getLog().warn("Cannot find the keystore file.");
                    Messages.showErrorDialog((String)UrlAssistantBundle.message("dal.keystore.not.found", new Object[0]), (String)UrlAssistantBundle.message("dialog.error.title", new Object[0]));
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    Sha256FingerprintUtils.getLog().warn("Error when generating keystore fingerprint: " + e.getMessage());
                    Messages.showErrorDialog((String)UrlAssistantBundle.message("dal.keystore.generate.fingerprint.fail", new Object[0]), (String)UrlAssistantBundle.message("dialog.error.title", new Object[0]));
                }
            }
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            Sha256FingerprintUtils.$$$reportNull$$$0(1);
        }
        return list;
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static String generateFingerprints(String filePath, String alias) {
        String string;
        Throwable throwable;
        FileInputStream is;
        block19: {
            block20: {
                Certificate certificate;
                is = new FileInputStream(filePath);
                throwable = null;
                KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                keystore.load(is, null);
                if (alias == null) {
                    alias = keystore.aliases().nextElement();
                }
                if ((certificate = keystore.getCertificate(alias)) == null) {
                    throw new KeyStoreException("No such alias in keystore");
                }
                byte[] encCertInfo = certificate.getEncoded();
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                byte[] digest = md.digest(encCertInfo);
                string = Sha256FingerprintUtils.toHexString(digest);
                if (is == null) break block19;
                if (throwable == null) break block20;
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                break block19;
            }
            is.close();
        }
        String string2 = string;
        if (string2 == null) {
            Sha256FingerprintUtils.$$$reportNull$$$0(2);
        }
        return string2;
        {
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (is != null) {
                            if (throwable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                is.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (FileNotFoundException e) {
                    Sha256FingerprintUtils.getLog().warn("Cannot find the keystore file.");
                    Messages.showErrorDialog((String)UrlAssistantBundle.message("dal.keystore.not.found", new Object[0]), (String)UrlAssistantBundle.message("dialog.error.title", new Object[0]));
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    Sha256FingerprintUtils.getLog().warn("Error when generating keystore fingerprint: " + e.getMessage());
                    Messages.showErrorDialog((String)UrlAssistantBundle.message("dal.keystore.generate.fingerprint.fail", new Object[0]), (String)UrlAssistantBundle.message("dialog.error.title", new Object[0]));
                }
            }
        }
        if ("" == null) {
            Sha256FingerprintUtils.$$$reportNull$$$0(3);
        }
        return "";
    }

    @NotNull
    public static String toHexString(@NotNull byte[] array) {
        if (array == null) {
            Sha256FingerprintUtils.$$$reportNull$$$0(4);
        }
        if (array.length == 0) {
            if ("" == null) {
                Sha256FingerprintUtils.$$$reportNull$$$0(5);
            }
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (byte b : array) {
            builder.append(String.format("%02x", b));
            builder.append(":");
        }
        String string = builder.deleteCharAt(builder.length() - 1).toString().toUpperCase(Locale.US);
        if (string == null) {
            Sha256FingerprintUtils.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/urlassistant/util/Sha256FingerprintUtils";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAliases";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "generateFingerprints";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/urlassistant/util/Sha256FingerprintUtils";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toHexString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toHexString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

