/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.util;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Lists;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiStatement;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class StatementFilter
extends JavaRecursiveElementVisitor {
    private String myFilterString;
    private List<PsiStatement> myStatements;

    public StatementFilter(@NotNull String filterString) {
        if (filterString == null) {
            StatementFilter.$$$reportNull$$$0(0);
        }
        this.myStatements = Lists.newArrayList();
        this.myFilterString = CharMatcher.WHITESPACE.removeFrom((CharSequence)filterString);
    }

    @NotNull
    public List<PsiStatement> getStatements() {
        List<PsiStatement> list = this.myStatements;
        if (list == null) {
            StatementFilter.$$$reportNull$$$0(1);
        }
        return list;
    }

    public void visitExpressionStatement(PsiExpressionStatement statement) {
        if (CharMatcher.WHITESPACE.removeFrom((CharSequence)statement.getText()).contains(this.myFilterString)) {
            this.myStatements.add((PsiStatement)statement);
        }
    }

    public void visitDeclarationStatement(PsiDeclarationStatement statement) {
        if (CharMatcher.WHITESPACE.removeFrom((CharSequence)statement.getText()).contains(this.myFilterString)) {
            this.myStatements.add((PsiStatement)statement);
        }
    }

    @NotNull
    public static List<PsiStatement> filterCodeBlock(@NotNull String filterString, @NotNull PsiCodeBlock codeBlock) {
        if (filterString == null) {
            StatementFilter.$$$reportNull$$$0(2);
        }
        if (codeBlock == null) {
            StatementFilter.$$$reportNull$$$0(3);
        }
        StatementFilter filter = new StatementFilter(filterString);
        codeBlock.accept((PsiElementVisitor)filter);
        List<PsiStatement> list = filter.getStatements();
        if (list == null) {
            StatementFilter.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public static List<PsiStatement> filterStatements(@NotNull String filterString, @NotNull List<PsiStatement> statements) {
        if (filterString == null) {
            StatementFilter.$$$reportNull$$$0(5);
        }
        if (statements == null) {
            StatementFilter.$$$reportNull$$$0(6);
        }
        StatementFilter filter = new StatementFilter(filterString);
        for (PsiStatement statement : statements) {
            statement.accept((PsiElementVisitor)filter);
        }
        List<PsiStatement> list = filter.getStatements();
        if (list == null) {
            StatementFilter.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterString";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/urlassistant/util/StatementFilter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeBlock";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/urlassistant/util/StatementFilter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "filterCodeBlock";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "filterStatements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "filterCodeBlock";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "filterStatements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

