/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.util;

import com.google.common.net.HostSpecifier;
import com.google.urlassistant.ActivityData;
import com.google.urlassistant.DeepLinks;
import com.google.urlassistant.FullUrl;
import com.google.urlassistant.Order;
import com.google.urlassistant.PathData;
import com.google.urlassistant.PathType;
import com.google.urlassistant.util.DeepLinkUtils;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.XmlUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlAssistUtils {
    @NotNull
    public static XmlTag createDeepLinkIntentFilter(@NotNull Order order, @NotNull XmlTag activityTag, @NotNull FullUrl fullUrl, @NotNull PathData pathData) {
        if (order == null) {
            UrlAssistUtils.$$$reportNull$$$0(0);
        }
        if (activityTag == null) {
            UrlAssistUtils.$$$reportNull$$$0(1);
        }
        if (fullUrl == null) {
            UrlAssistUtils.$$$reportNull$$$0(2);
        }
        if (pathData == null) {
            UrlAssistUtils.$$$reportNull$$$0(3);
        }
        String prefix = activityTag.getPrefixByNamespace("http://schemas.android.com/apk/res/android");
        XmlTag intentFilter = activityTag.createChildTag("intent-filter", null, "\n        <action " + prefix + ":name=\"android.intent.action.VIEW\" />\n        <category " + prefix + ":name=\"android.intent.category.DEFAULT\" />\n<category " + prefix + ":name=\"android.intent.category.BROWSABLE\" />\n        <data\n              " + prefix + ":scheme=\"" + fullUrl.getScheme() + "\"\n              " + prefix + ":host=\"" + fullUrl.getHost() + "\"\n" + (fullUrl.getPort() < 0 ? "" : "              " + prefix + ":port=\"" + fullUrl.getPortText() + "\"\n") + (StringUtil.isEmpty((String)fullUrl.getMimeType()) ? "" : "              " + prefix + ":mimeType=\"" + XmlUtil.escape((String)fullUrl.getMimeType()) + "\"\n") + (StringUtil.isEmpty((String)pathData.getPathValue()) ? "" : "              " + prefix + ":" + (Object)((Object)pathData.getPathType()) + "=\"" + XmlUtil.escape((String)pathData.getPathValue()) + "\"") + "/>\n", false);
        if (order.getInteger() != null) {
            intentFilter.setAttribute(prefix + ":" + "order", order.getInteger().toString());
        }
        XmlTag xmlTag = activityTag.addSubTag(intentFilter, false);
        if (xmlTag == null) {
            UrlAssistUtils.$$$reportNull$$$0(4);
        }
        return xmlTag;
    }

    public static void openActivityFile(@NotNull Project project, @NotNull ActivityData activityData) {
        AndroidFacet facet;
        if (project == null) {
            UrlAssistUtils.$$$reportNull$$$0(5);
        }
        if (activityData == null) {
            UrlAssistUtils.$$$reportNull$$$0(6);
        }
        if ((facet = AndroidFacet.getInstance((Module)activityData.getModule())) != null && facet.getManifest() != null) {
            List activityList = facet.getManifest().getApplication().getActivities();
            for (Activity activity : activityList) {
                if (!activityData.getActivityName().equals(activity.getActivityClass().getStringValue())) continue;
                PsiClass activityClass = (PsiClass)activity.getActivityClass().getValue();
                if (activityClass != null) {
                    UrlAssistUtils.openVirtualFile(project, activityClass.getContainingFile().getVirtualFile());
                    break;
                }
                Messages.showMessageDialog((Project)project, (String)UrlAssistantBundle.message("check.url.mapping.activity.file.not.found", new Object[0]), (String)UrlAssistantBundle.message("dialog.error.title", new Object[0]), null);
                break;
            }
        }
    }

    public static void openVirtualFile(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        if (project == null) {
            UrlAssistUtils.$$$reportNull$$$0(7);
        }
        if (virtualFile == null) {
            Messages.showMessageDialog((Project)project, (String)UrlAssistantBundle.message("check.url.mapping.open.fail", new Object[0]), (String)UrlAssistantBundle.message("dialog.error.title", new Object[0]), null);
            return;
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (project == null) {
                UrlAssistUtils.$$$reportNull$$$0(18);
            }
            FileEditorManager.getInstance((Project)project).openFile(virtualFile, true);
        }, ModalityState.any());
    }

    public static boolean matchesHost(@NotNull String actualHost, @NotNull String hostRegex) {
        if (actualHost == null) {
            UrlAssistUtils.$$$reportNull$$$0(8);
        }
        if (hostRegex == null) {
            UrlAssistUtils.$$$reportNull$$$0(9);
        }
        if (hostRegex.contains("*") && hostRegex.indexOf(42) != hostRegex.lastIndexOf(42)) {
            return false;
        }
        return actualHost.matches(hostRegex.replace(".", "\\.").replace("*", ".+"));
    }

    public static boolean matchGlobPattern(@NotNull String pattern, @NotNull String match) {
        int NP;
        if (pattern == null) {
            UrlAssistUtils.$$$reportNull$$$0(10);
        }
        if (match == null) {
            UrlAssistUtils.$$$reportNull$$$0(11);
        }
        if ((NP = pattern.length()) <= 0) {
            return match.length() <= 0;
        }
        int NM = match.length();
        int ip = 0;
        int im = 0;
        char nextChar = pattern.charAt(0);
        while (ip < NP && im < NM) {
            boolean escaped;
            char c = nextChar;
            nextChar = ++ip < NP ? pattern.charAt(ip) : (char)'\u0000';
            boolean bl = escaped = c == '\\';
            if (escaped) {
                c = nextChar;
                char c2 = nextChar = ++ip < NP ? pattern.charAt(ip) : (char)'\u0000';
            }
            if (nextChar == '*') {
                if (!escaped && c == '.') {
                    if (ip >= NP - 1) {
                        return true;
                    }
                    if ((nextChar = pattern.charAt(++ip)) == '\\') {
                        char c3 = nextChar = ++ip < NP ? pattern.charAt(ip) : (char)'\u0000';
                    }
                    while (match.charAt(im) != nextChar && ++im < NM) {
                    }
                    if (im == NM) {
                        return false;
                    }
                    nextChar = ++ip < NP ? pattern.charAt(ip) : (char)'\u0000';
                    ++im;
                    continue;
                }
                while (match.charAt(im) == c && ++im < NM) {
                }
                nextChar = ++ip < NP ? pattern.charAt(ip) : (char)'\u0000';
                continue;
            }
            if (c != '.' && match.charAt(im) != c) {
                return false;
            }
            ++im;
        }
        if (ip >= NP && im >= NM) {
            return true;
        }
        return ip == NP - 2 && pattern.charAt(ip) == '.' && pattern.charAt(ip + 1) == '*';
    }

    @NotNull
    public static String getFirstValidUrl(@NotNull Module module) {
        if (module == null) {
            UrlAssistUtils.$$$reportNull$$$0(12);
        }
        DeepLinks deepLinks = new DeepLinks();
        DeepLinkUtils.loadDeepLinks(module, deepLinks, null);
        String string = !deepLinks.getDeepLinkList().isEmpty() ? ((DeepLinks.DeepLink)deepLinks.getDeepLinkList().get(0)).getUrl().toString() : "";
        if (string == null) {
            UrlAssistUtils.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    public static ActivityData findAssociatedActivity(@NotNull List<DeepLinks.DeepLink> myDeepLinkList, @NotNull String urlString) throws MalformedURLException {
        if (myDeepLinkList == null) {
            UrlAssistUtils.$$$reportNull$$$0(14);
        }
        if (urlString == null) {
            UrlAssistUtils.$$$reportNull$$$0(15);
        }
        if (StringUtil.isEmpty((String)urlString)) {
            throw new MalformedURLException();
        }
        URL url = new URL(urlString);
        if (!HostSpecifier.isValid((String)url.getHost())) {
            throw new MalformedURLException();
        }
        for (DeepLinks.DeepLink link : myDeepLinkList) {
            FullUrl fullUrl = link.getUrl();
            PathData pathData = link.getPath();
            if (!url.getProtocol().equals(fullUrl.getScheme()) || !UrlAssistUtils.matchesHost(url.getHost(), fullUrl.getHost()) || url.getPort() != fullUrl.getPort()) continue;
            if (StringUtil.isEmpty((String)pathData.getPathValue())) {
                return link.getActivityData();
            }
            PathType pathType = pathData.getPathType();
            String wantedPath = url.getPath();
            String pathValue = pathData.getPathValue();
            if (!StringUtil.isNotEmpty((String)wantedPath) || !(pathType == PathType.Path && wantedPath.equals(pathValue) || pathType == PathType.PathPrefix && wantedPath.startsWith(pathValue)) && (pathType != PathType.PathPattern || !UrlAssistUtils.matchGlobPattern(pathValue, wantedPath))) continue;
            return link.getActivityData();
        }
        return null;
    }

    @NotNull
    public static List<AndroidFacet> getFacets(@NotNull Project project) {
        if (project == null) {
            UrlAssistUtils.$$$reportNull$$$0(16);
        }
        Module[] modules = ModuleManager.getInstance((Project)project).getModules();
        List<Module> moduleList = Arrays.asList(modules);
        List<AndroidFacet> list = moduleList.stream().map(AndroidFacet::getInstance).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            UrlAssistUtils.$$$reportNull$$$0(17);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 13: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 13: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityTag";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullUrl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathData";
                break;
            }
            case 4: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/google/urlassistant/util/UrlAssistUtils";
                break;
            }
            case 5: 
            case 7: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityData";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualHost";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostRegex";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myDeepLinkList";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/google/urlassistant/util/UrlAssistUtils";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDeepLinkIntentFilter";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstValidUrl";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDeepLinkIntentFilter";
                break;
            }
            case 4: 
            case 13: 
            case 17: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "openActivityFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "openVirtualFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "matchesHost";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "matchGlobPattern";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFirstValidUrl";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findAssociatedActivity";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFacets";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$openVirtualFile$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 13: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

