/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.xctest.tasks;

import java.io.File;
import java.util.List;
import org.gradle.api.Incubating;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.tasks.testing.TestExecuter;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.testing.AbstractTestTask;
import org.gradle.nativeplatform.test.xctest.internal.execution.XCTestExecuter;
import org.gradle.nativeplatform.test.xctest.internal.execution.XCTestSelection;
import org.gradle.nativeplatform.test.xctest.internal.execution.XCTestTestExecutionSpec;

@Incubating
public class XCTest
extends AbstractTestTask {
    private final DirectoryProperty workingDirectory = this.getProject().getLayout().directoryProperty();
    private final DirectoryProperty testInstallDirectory = this.newInputDirectory();
    private final RegularFileProperty runScriptFile = this.newInputFile();

    protected XCTestTestExecutionSpec createTestExecutionSpec() {
        DefaultTestFilter testFilter = (DefaultTestFilter)this.getFilter();
        return new XCTestTestExecutionSpec((File)this.workingDirectory.getAsFile().get(), (File)this.runScriptFile.getAsFile().get(), this.getPath(), new XCTestSelection(testFilter.getIncludePatterns(), testFilter.getCommandLineIncludePatterns()));
    }

    @InputDirectory
    public DirectoryProperty getTestInstallDirectory() {
        return this.testInstallDirectory;
    }

    @Internal(value="Covered by getRunScript")
    public RegularFileProperty getRunScriptFile() {
        return this.runScriptFile;
    }

    @Internal
    public DirectoryProperty getWorkingDirectory() {
        return this.workingDirectory;
    }

    protected TestExecuter<XCTestTestExecutionSpec> createTestExecuter() {
        return (TestExecuter)this.getProject().getObjects().newInstance(XCTestExecuter.class, new Object[0]);
    }

    @SkipWhenEmpty
    @Optional
    @InputFile
    protected File getRunScript() {
        RegularFile runScript = (RegularFile)this.getRunScriptFile().get();
        File runScriptFile = runScript.getAsFile();
        if (!runScriptFile.exists()) {
            return null;
        }
        return runScriptFile;
    }

    public XCTest setTestNameIncludePatterns(List<String> testNamePattern) {
        super.setTestNameIncludePatterns(testNamePattern);
        return this;
    }
}

